/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_categories_by_ids.h
 * @brief Lookup product categories by ID
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_LOOKUP_CATEGORIES_BY_IDS_H
#define PG_LOOKUP_CATEGORIES_BY_IDS_H

#include "taler_merchantdb_plugin.h"

/**
 * Lookup product categories by ID.
 *
 * @param cls closure
 * @param instance_id instance to lookup categories for
 * @param category_ids array of category IDs
 * @param num_category_ids length of @a category_ids
 * @param cb function to call on all categories found
 * @param cb_cls closure for @a cb
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_categories_by_ids (void *cls,
                                 const char *instance_id,
                                 const uint64_t *category_ids,
                                 size_t num_category_ids,
                                 TALER_MERCHANTDB_CategoriesCallback cb,
                                 void *cb_cls);

#endif
