// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_ext_autogen.cpp:
//   Capture functions for the OpenGL ES extension entry points.

#include "libANGLE/capture/capture_gles_ext_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationESEXT.h"

using namespace angle;

namespace gl
{
CallCapture CaptureBeginPerfMonitorAMD(const State &glState, bool isCallValid, GLuint monitor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("monitor", ParamType::TGLuint, monitor);

    return CallCapture(angle::EntryPoint::GLBeginPerfMonitorAMD, std::move(paramBuffer));
}

CallCapture CaptureDeletePerfMonitorsAMD(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         GLuint *monitors)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture monitorsParam("monitors", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, monitors, &monitorsParam.value);
        CaptureDeletePerfMonitorsAMD_monitors(glState, isCallValid, n, monitors, &monitorsParam);
        paramBuffer.addParam(std::move(monitorsParam));
    }
    else
    {
        ParamCapture monitorsParam("monitors", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &monitorsParam.value);
        paramBuffer.addParam(std::move(monitorsParam));
    }

    return CallCapture(angle::EntryPoint::GLDeletePerfMonitorsAMD, std::move(paramBuffer));
}

CallCapture CaptureEndPerfMonitorAMD(const State &glState, bool isCallValid, GLuint monitor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("monitor", ParamType::TGLuint, monitor);

    return CallCapture(angle::EntryPoint::GLEndPerfMonitorAMD, std::move(paramBuffer));
}

CallCapture CaptureGenPerfMonitorsAMD(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      GLuint *monitors)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture monitorsParam("monitors", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, monitors, &monitorsParam.value);
        CaptureGenPerfMonitorsAMD_monitors(glState, isCallValid, n, monitors, &monitorsParam);
        paramBuffer.addParam(std::move(monitorsParam));
    }
    else
    {
        ParamCapture monitorsParam("monitors", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &monitorsParam.value);
        paramBuffer.addParam(std::move(monitorsParam));
    }

    return CallCapture(angle::EntryPoint::GLGenPerfMonitorsAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorCounterDataAMD(const State &glState,
                                                bool isCallValid,
                                                GLuint monitor,
                                                GLenum pname,
                                                GLsizei dataSize,
                                                GLuint *data,
                                                GLint *bytesWritten)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("monitor", ParamType::TGLuint, monitor);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, data, &dataParam.value);
        CaptureGetPerfMonitorCounterDataAMD_data(glState, isCallValid, monitor, pname, dataSize,
                                                 data, bytesWritten, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    if (isCallValid)
    {
        ParamCapture bytesWrittenParam("bytesWritten", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, bytesWritten, &bytesWrittenParam.value);
        CaptureGetPerfMonitorCounterDataAMD_bytesWritten(
            glState, isCallValid, monitor, pname, dataSize, data, bytesWritten, &bytesWrittenParam);
        paramBuffer.addParam(std::move(bytesWrittenParam));
    }
    else
    {
        ParamCapture bytesWrittenParam("bytesWritten", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &bytesWrittenParam.value);
        paramBuffer.addParam(std::move(bytesWrittenParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorCounterDataAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorCounterInfoAMD(const State &glState,
                                                bool isCallValid,
                                                GLuint group,
                                                GLuint counter,
                                                GLenum pname,
                                                void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("group", ParamType::TGLuint, group);
    paramBuffer.addValueParam("counter", ParamType::TGLuint, counter);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureGetPerfMonitorCounterInfoAMD_data(glState, isCallValid, group, counter, pname, data,
                                                 &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorCounterInfoAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorCounterStringAMD(const State &glState,
                                                  bool isCallValid,
                                                  GLuint group,
                                                  GLuint counter,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *counterString)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("group", ParamType::TGLuint, group);
    paramBuffer.addValueParam("counter", ParamType::TGLuint, counter);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetPerfMonitorCounterStringAMD_length(glState, isCallValid, group, counter, bufSize,
                                                     length, counterString, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture counterStringParam("counterString", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, counterString, &counterStringParam.value);
        CaptureGetPerfMonitorCounterStringAMD_counterString(glState, isCallValid, group, counter,
                                                            bufSize, length, counterString,
                                                            &counterStringParam);
        paramBuffer.addParam(std::move(counterStringParam));
    }
    else
    {
        ParamCapture counterStringParam("counterString", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &counterStringParam.value);
        paramBuffer.addParam(std::move(counterStringParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorCounterStringAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorCountersAMD(const State &glState,
                                             bool isCallValid,
                                             GLuint group,
                                             GLint *numCounters,
                                             GLint *maxActiveCounters,
                                             GLsizei counterSize,
                                             GLuint *counters)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("group", ParamType::TGLuint, group);

    if (isCallValid)
    {
        ParamCapture numCountersParam("numCounters", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, numCounters, &numCountersParam.value);
        CaptureGetPerfMonitorCountersAMD_numCounters(glState, isCallValid, group, numCounters,
                                                     maxActiveCounters, counterSize, counters,
                                                     &numCountersParam);
        paramBuffer.addParam(std::move(numCountersParam));
    }
    else
    {
        ParamCapture numCountersParam("numCounters", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &numCountersParam.value);
        paramBuffer.addParam(std::move(numCountersParam));
    }

    if (isCallValid)
    {
        ParamCapture maxActiveCountersParam("maxActiveCounters", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, maxActiveCounters, &maxActiveCountersParam.value);
        CaptureGetPerfMonitorCountersAMD_maxActiveCounters(glState, isCallValid, group, numCounters,
                                                           maxActiveCounters, counterSize, counters,
                                                           &maxActiveCountersParam);
        paramBuffer.addParam(std::move(maxActiveCountersParam));
    }
    else
    {
        ParamCapture maxActiveCountersParam("maxActiveCounters", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &maxActiveCountersParam.value);
        paramBuffer.addParam(std::move(maxActiveCountersParam));
    }

    paramBuffer.addValueParam("counterSize", ParamType::TGLsizei, counterSize);

    if (isCallValid)
    {
        ParamCapture countersParam("counters", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, counters, &countersParam.value);
        CaptureGetPerfMonitorCountersAMD_counters(glState, isCallValid, group, numCounters,
                                                  maxActiveCounters, counterSize, counters,
                                                  &countersParam);
        paramBuffer.addParam(std::move(countersParam));
    }
    else
    {
        ParamCapture countersParam("counters", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &countersParam.value);
        paramBuffer.addParam(std::move(countersParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorCountersAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorGroupStringAMD(const State &glState,
                                                bool isCallValid,
                                                GLuint group,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLchar *groupString)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("group", ParamType::TGLuint, group);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetPerfMonitorGroupStringAMD_length(glState, isCallValid, group, bufSize, length,
                                                   groupString, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture groupStringParam("groupString", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, groupString, &groupStringParam.value);
        CaptureGetPerfMonitorGroupStringAMD_groupString(glState, isCallValid, group, bufSize,
                                                        length, groupString, &groupStringParam);
        paramBuffer.addParam(std::move(groupStringParam));
    }
    else
    {
        ParamCapture groupStringParam("groupString", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &groupStringParam.value);
        paramBuffer.addParam(std::move(groupStringParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorGroupStringAMD, std::move(paramBuffer));
}

CallCapture CaptureGetPerfMonitorGroupsAMD(const State &glState,
                                           bool isCallValid,
                                           GLint *numGroups,
                                           GLsizei groupsSize,
                                           GLuint *groups)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture numGroupsParam("numGroups", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, numGroups, &numGroupsParam.value);
        CaptureGetPerfMonitorGroupsAMD_numGroups(glState, isCallValid, numGroups, groupsSize,
                                                 groups, &numGroupsParam);
        paramBuffer.addParam(std::move(numGroupsParam));
    }
    else
    {
        ParamCapture numGroupsParam("numGroups", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &numGroupsParam.value);
        paramBuffer.addParam(std::move(numGroupsParam));
    }

    paramBuffer.addValueParam("groupsSize", ParamType::TGLsizei, groupsSize);

    if (isCallValid)
    {
        ParamCapture groupsParam("groups", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, groups, &groupsParam.value);
        CaptureGetPerfMonitorGroupsAMD_groups(glState, isCallValid, numGroups, groupsSize, groups,
                                              &groupsParam);
        paramBuffer.addParam(std::move(groupsParam));
    }
    else
    {
        ParamCapture groupsParam("groups", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &groupsParam.value);
        paramBuffer.addParam(std::move(groupsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPerfMonitorGroupsAMD, std::move(paramBuffer));
}

CallCapture CaptureSelectPerfMonitorCountersAMD(const State &glState,
                                                bool isCallValid,
                                                GLuint monitor,
                                                GLboolean enable,
                                                GLuint group,
                                                GLint numCounters,
                                                GLuint *counterList)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("monitor", ParamType::TGLuint, monitor);
    paramBuffer.addValueParam("enable", ParamType::TGLboolean, enable);
    paramBuffer.addValueParam("group", ParamType::TGLuint, group);
    paramBuffer.addValueParam("numCounters", ParamType::TGLint, numCounters);

    if (isCallValid)
    {
        ParamCapture counterListParam("counterList", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, counterList, &counterListParam.value);
        CaptureSelectPerfMonitorCountersAMD_counterList(glState, isCallValid, monitor, enable,
                                                        group, numCounters, counterList,
                                                        &counterListParam);
        paramBuffer.addParam(std::move(counterListParam));
    }
    else
    {
        ParamCapture counterListParam("counterList", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &counterListParam.value);
        paramBuffer.addParam(std::move(counterListParam));
    }

    return CallCapture(angle::EntryPoint::GLSelectPerfMonitorCountersAMD, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedBaseInstanceANGLE(const State &glState,
                                                        bool isCallValid,
                                                        PrimitiveMode modePacked,
                                                        GLint first,
                                                        GLsizei count,
                                                        GLsizei instanceCount,
                                                        GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instanceCount", ParamType::TGLsizei, instanceCount);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE(const State &glState,
                                                                    bool isCallValid,
                                                                    PrimitiveMode modePacked,
                                                                    GLsizei count,
                                                                    DrawElementsType typePacked,
                                                                    const void *indices,
                                                                    GLsizei instanceCount,
                                                                    GLint baseVertex,
                                                                    GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
            glState, isCallValid, modePacked, count, typePacked, indices, instanceCount, baseVertex,
            baseInstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instanceCount", ParamType::TGLsizei, instanceCount);
    paramBuffer.addValueParam("baseVertex", ParamType::TGLint, baseVertex);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedBaseInstanceANGLE(const State &glState,
                                                             bool isCallValid,
                                                             PrimitiveMode modePacked,
                                                             const GLint *firsts,
                                                             const GLsizei *counts,
                                                             const GLsizei *instanceCounts,
                                                             const GLuint *baseInstances,
                                                             GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_firsts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_counts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_instanceCounts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    if (isCallValid)
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_baseInstances(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &baseInstancesParam);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }
    else
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &baseInstancesParam.value);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
    const State &glState,
    bool isCallValid,
    PrimitiveMode modePacked,
    const GLsizei *counts,
    DrawElementsType typePacked,
    const void *const *indices,
    const GLsizei *instanceCounts,
    const GLint *baseVertices,
    const GLuint *baseInstances,
    GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_counts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_instanceCounts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    if (isCallValid)
    {
        ParamCapture baseVerticesParam("baseVertices", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, baseVertices, &baseVerticesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseVertices(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &baseVerticesParam);
        paramBuffer.addParam(std::move(baseVerticesParam));
    }
    else
    {
        ParamCapture baseVerticesParam("baseVertices", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &baseVerticesParam.value);
        paramBuffer.addParam(std::move(baseVerticesParam));
    }

    if (isCallValid)
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseInstances(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &baseInstancesParam);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }
    else
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &baseInstancesParam.value);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureBlobCacheCallbacksANGLE(const State &glState,
                                           bool isCallValid,
                                           GLSETBLOBPROCANGLE set,
                                           GLGETBLOBPROCANGLE get,
                                           const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("set", ParamType::TGLSETBLOBPROCANGLE, set);
    paramBuffer.addValueParam("get", ParamType::TGLGETBLOBPROCANGLE, get);

    if (isCallValid)
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
        CaptureBlobCacheCallbacksANGLE_userParam(glState, isCallValid, set, get, userParam,
                                                 &userParamParam);
        paramBuffer.addParam(std::move(userParamParam));
    }
    else
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &userParamParam.value);
        paramBuffer.addParam(std::move(userParamParam));
    }

    return CallCapture(angle::EntryPoint::GLBlobCacheCallbacksANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetPointervANGLE(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointervANGLE_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPointervANGLE, std::move(paramBuffer));
}

CallCapture CaptureCopyTexture3DANGLE(const State &glState,
                                      bool isCallValid,
                                      TextureID sourceIdPacked,
                                      GLint sourceLevel,
                                      TextureTarget destTargetPacked,
                                      TextureID destIdPacked,
                                      GLint destLevel,
                                      GLint internalFormat,
                                      GLenum destType,
                                      GLboolean unpackFlipY,
                                      GLboolean unpackPremultiplyAlpha,
                                      GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLESEnum::AllEnums, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(angle::EntryPoint::GLCopyTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureCopySubTexture3DANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureID sourceIdPacked,
                                         GLint sourceLevel,
                                         TextureTarget destTargetPacked,
                                         TextureID destIdPacked,
                                         GLint destLevel,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLint z,
                                         GLint width,
                                         GLint height,
                                         GLint depth,
                                         GLboolean unpackFlipY,
                                         GLboolean unpackPremultiplyAlpha,
                                         GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("depth", ParamType::TGLint, depth);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(angle::EntryPoint::GLCopySubTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureBlitFramebufferANGLE(const State &glState,
                                        bool isCallValid,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", GLESEnum::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", GLESEnum::BlitFramebufferFilter, ParamType::TGLenum, filter);

    return CallCapture(angle::EntryPoint::GLBlitFramebufferANGLE, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleANGLE(const State &glState,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLRenderbufferStorageMultisampleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetTexImageANGLE(const State &glState,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLenum format,
                                    GLenum type,
                                    void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetTexImageANGLE_pixels(glState, isCallValid, targetPacked, level, format, type,
                                       pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetCompressedTexImageANGLE(const State &glState,
                                              bool isCallValid,
                                              TextureTarget targetPacked,
                                              GLint level,
                                              void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetCompressedTexImageANGLE_pixels(glState, isCallValid, targetPacked, level, pixels,
                                                 &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetCompressedTexImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferImageANGLE(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum format,
                                             GLenum type,
                                             void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetRenderbufferImageANGLE_pixels(glState, isCallValid, target, format, type, pixels,
                                                &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetRenderbufferImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterivANGLE_params(glState, isCallValid, targetPacked, level, pname,
                                                  params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameterivANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterfvANGLE_params(glState, isCallValid, targetPacked, level, pname,
                                                  params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameterfvANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedANGLE(const State &glState,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLint first,
                                            GLsizei count,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedANGLE(const State &glState,
                                              bool isCallValid,
                                              PrimitiveMode modePacked,
                                              GLsizei count,
                                              DrawElementsType typePacked,
                                              const void *indices,
                                              GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedANGLE_indices(glState, isCallValid, modePacked, count,
                                                  typePacked, indices, primcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorANGLE(const State &glState,
                                            bool isCallValid,
                                            GLuint index,
                                            GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(angle::EntryPoint::GLVertexAttribDivisorANGLE, std::move(paramBuffer));
}

CallCapture CaptureLogicOpANGLE(const State &glState,
                                bool isCallValid,
                                LogicalOperation opcodePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("opcodePacked", ParamType::TLogicalOperation, opcodePacked);

    return CallCapture(angle::EntryPoint::GLLogicOpANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags2DANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             MemoryObjectID memoryPacked,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags,
                                             const void *imageCreateInfoPNext)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLESEnum::AllEnums, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLESEnum::AllEnums, ParamType::TGLbitfield, usageFlags);

    if (isCallValid)
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, imageCreateInfoPNext,
                       &imageCreateInfoPNextParam.value);
        CaptureTexStorageMemFlags2DANGLE_imageCreateInfoPNext(
            glState, isCallValid, targetPacked, levels, internalFormat, width, height, memoryPacked,
            offset, createFlags, usageFlags, imageCreateInfoPNext, &imageCreateInfoPNextParam);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }
    else
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &imageCreateInfoPNextParam.value);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageMemFlags2DANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags2DMultisampleANGLE(const State &glState,
                                                        bool isCallValid,
                                                        TextureType targetPacked,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLboolean fixedSampleLocations,
                                                        MemoryObjectID memoryPacked,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags,
                                                        const void *imageCreateInfoPNext)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLESEnum::AllEnums, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLESEnum::AllEnums, ParamType::TGLbitfield, usageFlags);

    if (isCallValid)
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, imageCreateInfoPNext,
                       &imageCreateInfoPNextParam.value);
        CaptureTexStorageMemFlags2DMultisampleANGLE_imageCreateInfoPNext(
            glState, isCallValid, targetPacked, samples, internalFormat, width, height,
            fixedSampleLocations, memoryPacked, offset, createFlags, usageFlags,
            imageCreateInfoPNext, &imageCreateInfoPNextParam);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }
    else
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &imageCreateInfoPNextParam.value);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageMemFlags2DMultisampleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags3DANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             MemoryObjectID memoryPacked,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags,
                                             const void *imageCreateInfoPNext)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLESEnum::AllEnums, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLESEnum::AllEnums, ParamType::TGLbitfield, usageFlags);

    if (isCallValid)
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, imageCreateInfoPNext,
                       &imageCreateInfoPNextParam.value);
        CaptureTexStorageMemFlags3DANGLE_imageCreateInfoPNext(
            glState, isCallValid, targetPacked, levels, internalFormat, width, height, depth,
            memoryPacked, offset, createFlags, usageFlags, imageCreateInfoPNext,
            &imageCreateInfoPNextParam);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }
    else
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &imageCreateInfoPNextParam.value);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageMemFlags3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags3DMultisampleANGLE(const State &glState,
                                                        bool isCallValid,
                                                        TextureType targetPacked,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLboolean fixedSampleLocations,
                                                        MemoryObjectID memoryPacked,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags,
                                                        const void *imageCreateInfoPNext)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLESEnum::AllEnums, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLESEnum::AllEnums, ParamType::TGLbitfield, usageFlags);

    if (isCallValid)
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, imageCreateInfoPNext,
                       &imageCreateInfoPNextParam.value);
        CaptureTexStorageMemFlags3DMultisampleANGLE_imageCreateInfoPNext(
            glState, isCallValid, targetPacked, samples, internalFormat, width, height, depth,
            fixedSampleLocations, memoryPacked, offset, createFlags, usageFlags,
            imageCreateInfoPNext, &imageCreateInfoPNextParam);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }
    else
    {
        ParamCapture imageCreateInfoPNextParam("imageCreateInfoPNext",
                                               ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &imageCreateInfoPNextParam.value);
        paramBuffer.addParam(std::move(imageCreateInfoPNextParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageMemFlags3DMultisampleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureImportMemoryZirconHandleANGLE(const State &glState,
                                                 bool isCallValid,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 size,
                                                 HandleType handleTypePacked,
                                                 GLuint handle)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("handle", ParamType::TGLuint, handle);

    return CallCapture(angle::EntryPoint::GLImportMemoryZirconHandleANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysANGLE(const State &glState,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        const GLint *firsts,
                                        const GLsizei *counts,
                                        GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysANGLE_firsts(glState, isCallValid, modePacked, firsts, counts,
                                           drawcount, &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysANGLE_counts(glState, isCallValid, modePacked, firsts, counts,
                                           drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedANGLE(const State &glState,
                                                 bool isCallValid,
                                                 PrimitiveMode modePacked,
                                                 const GLint *firsts,
                                                 const GLsizei *counts,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_firsts(glState, isCallValid, modePacked, firsts,
                                                    counts, instanceCounts, drawcount,
                                                    &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_counts(glState, isCallValid, modePacked, firsts,
                                                    counts, instanceCounts, drawcount,
                                                    &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_instanceCounts(glState, isCallValid, modePacked,
                                                            firsts, counts, instanceCounts,
                                                            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsANGLE(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          const GLsizei *counts,
                                          DrawElementsType typePacked,
                                          const void *const *indices,
                                          GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsANGLE_counts(glState, isCallValid, modePacked, counts, typePacked,
                                             indices, drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsANGLE_indices(glState, isCallValid, modePacked, counts, typePacked,
                                              indices, drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedANGLE(const State &glState,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   const GLsizei *counts,
                                                   DrawElementsType typePacked,
                                                   const void *const *indices,
                                                   const GLsizei *instanceCounts,
                                                   GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsInstancedANGLE_counts(glState, isCallValid, modePacked, counts,
                                                      typePacked, indices, instanceCounts,
                                                      drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsInstancedANGLE_indices(glState, isCallValid, modePacked, counts,
                                                       typePacked, indices, instanceCounts,
                                                       drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawElementsInstancedANGLE_instanceCounts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsInstancedANGLE,
                       std::move(paramBuffer));
}

CallCapture CapturePolygonModeANGLE(const State &glState,
                                    bool isCallValid,
                                    GLenum face,
                                    PolygonMode modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("modePacked", ParamType::TPolygonMode, modePacked);

    return CallCapture(angle::EntryPoint::GLPolygonModeANGLE, std::move(paramBuffer));
}

CallCapture CaptureProvokingVertexANGLE(const State &glState,
                                        bool isCallValid,
                                        ProvokingVertexConvention provokeModePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("provokeModePacked", ParamType::TProvokingVertexConvention,
                              provokeModePacked);

    return CallCapture(angle::EntryPoint::GLProvokingVertexANGLE, std::move(paramBuffer));
}

CallCapture CaptureRequestExtensionANGLE(const State &glState, bool isCallValid, const GLchar *name)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureRequestExtensionANGLE_name(glState, isCallValid, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLRequestExtensionANGLE, std::move(paramBuffer));
}

CallCapture CaptureDisableExtensionANGLE(const State &glState, bool isCallValid, const GLchar *name)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureDisableExtensionANGLE_name(glState, isCallValid, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLDisableExtensionANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBooleanvRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBooleanvRobustANGLE_length(glState, isCallValid, pname, bufSize, length, params,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, params, &paramsParam.value);
        CaptureGetBooleanvRobustANGLE_params(glState, isCallValid, pname, bufSize, length, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBooleanvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameterivRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   BufferBinding targetPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferParameterivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                      bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetBufferParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                      bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFloatvRobustANGLE(const State &glState,
                                        bool isCallValid,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFloatvRobustANGLE_length(glState, isCallValid, pname, bufSize, length, params,
                                           &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetFloatvRobustANGLE_params(glState, isCallValid, pname, bufSize, length, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFloatvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivRobustANGLE(const State &glState,
                                                                  bool isCallValid,
                                                                  GLenum target,
                                                                  GLenum attachment,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::AllEnums, ParamType::TGLenum, attachment);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferAttachmentParameterivRobustANGLE_length(
            glState, isCallValid, target, attachment, pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferAttachmentParameterivRobustANGLE_params(
            glState, isCallValid, target, attachment, pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferAttachmentParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetIntegervRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetIntegervRobustANGLE_length(glState, isCallValid, pname, bufSize, length, data,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegervRobustANGLE_data(glState, isCallValid, pname, bufSize, length, data,
                                           &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetIntegervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetProgramivRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramivRobustANGLE_length(glState, isCallValid, programPacked, pname, bufSize,
                                              length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramivRobustANGLE_params(glState, isCallValid, programPacked, pname, bufSize,
                                              length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivRobustANGLE(const State &glState,
                                                         bool isCallValid,
                                                         GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetRenderbufferParameterivRobustANGLE_length(glState, isCallValid, target, pname,
                                                            bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetRenderbufferParameterivRobustANGLE_params(glState, isCallValid, target, pname,
                                                            bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetRenderbufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetShaderivRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          ShaderProgramID shaderPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetShaderivRobustANGLE_length(glState, isCallValid, shaderPacked, pname, bufSize,
                                             length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetShaderivRobustANGLE_params(glState, isCallValid, shaderPacked, pname, bufSize,
                                             length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetShaderivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfvRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterfvRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformfvRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformfvRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetUniformfvRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformivRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetUniformivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfvRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribfvRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetVertexAttribfvRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointervRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      GLuint index,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribPointervRobustANGLE_length(glState, isCallValid, index, pname,
                                                         bufSize, length, pointer, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
        CaptureGetVertexAttribPointervRobustANGLE_pointer(glState, isCallValid, index, pname,
                                                          bufSize, length, pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribPointervRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureReadPixelsRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLsizei *columns,
                                         GLsizei *rows,
                                         void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureReadPixelsRobustANGLE_length(glState, isCallValid, x, y, width, height, format, type,
                                            bufSize, length, columns, rows, pixels, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
        CaptureReadPixelsRobustANGLE_columns(glState, isCallValid, x, y, width, height, format,
                                             type, bufSize, length, columns, rows, pixels,
                                             &columnsParam);
        paramBuffer.addParam(std::move(columnsParam));
    }
    else
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &columnsParam.value);
        paramBuffer.addParam(std::move(columnsParam));
    }

    if (isCallValid)
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
        CaptureReadPixelsRobustANGLE_rows(glState, isCallValid, x, y, width, height, format, type,
                                          bufSize, length, columns, rows, pixels, &rowsParam);
        paramBuffer.addParam(std::move(rowsParam));
    }
    else
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &rowsParam.value);
        paramBuffer.addParam(std::move(rowsParam));
    }

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureReadPixelsRobustANGLE_pixels(glState, isCallValid, x, y, width, height, format, type,
                                            bufSize, length, columns, rows, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLReadPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage2DRobustANGLE_pixels(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, border, format, type,
                                            bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterfvRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterivRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2DRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage2DRobustANGLE_pixels(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, width, height, format, type, bufSize,
                                               pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexSubImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage3DRobustANGLE_pixels(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, depth, border, format,
                                            type, bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage3DRobustANGLE_pixels(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, zoffset, width, height, depth, format, type,
                                               bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexSubImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2DRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage2DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                    internalformat, width, height, border,
                                                    imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexImage2DRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2DRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLsizei xoffset,
                                                      GLsizei yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLsizei, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLsizei, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage2DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                       xoffset, yoffset, width, height, format,
                                                       imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage2DRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage3DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                    internalformat, width, height, depth, border,
                                                    imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexImage3DRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage3DRobustANGLE_data(
            glState, isCallValid, targetPacked, level, xoffset, yoffset, zoffset, width, height,
            depth, format, imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage3DRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetQueryivRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         QueryType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryivRobustANGLE_length(glState, isCallValid, targetPacked, pname, bufSize,
                                            length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                            length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                QueryID idPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectuivRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectuivRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                BufferBinding targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferPointervRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetBufferPointervRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBufferPointervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetIntegeri_vRobustANGLE_length(glState, isCallValid, target, index, bufSize, length,
                                               data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegeri_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                             data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetIntegeri_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum internalformat,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInternalformativRobustANGLE_length(glState, isCallValid, target, internalformat,
                                                     pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetInternalformativRobustANGLE_params(glState, isCallValid, target, internalformat,
                                                     pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetInternalformativRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribIivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                    length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                    length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribIuivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                     length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIuivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                     length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetVertexAttribIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformuivRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformuivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetUniformuivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockivRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      UniformBlockIndex uniformBlockIndexPacked,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex,
                              uniformBlockIndexPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveUniformBlockivRobustANGLE_length(glState, isCallValid, programPacked,
                                                         uniformBlockIndexPacked, pname, bufSize,
                                                         length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetActiveUniformBlockivRobustANGLE_params(glState, isCallValid, programPacked,
                                                         uniformBlockIndexPacked, pname, bufSize,
                                                         length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveUniformBlockivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInteger64vRobustANGLE_length(glState, isCallValid, pname, bufSize, length, data,
                                               &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64vRobustANGLE_data(glState, isCallValid, pname, bufSize, length, data,
                                             &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetInteger64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_vRobustANGLE(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInteger64i_vRobustANGLE_length(glState, isCallValid, target, index, bufSize,
                                                 length, data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64i_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                               data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetInteger64i_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64vRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     BufferBinding targetPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferParameteri64vRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                        bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetBufferParameteri64vRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                        bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBufferParameteri64vRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLuint pname,
                                                 GLsizei bufSize,
                                                 const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLuint, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                   bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfvRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
        CaptureSamplerParameterfvRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                   bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterivRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfvRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterfvRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterfvRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterfvRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameterivRobustANGLE(const State &glState,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferParameterivRobustANGLE_length(glState, isCallValid, target, pname,
                                                           bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferParameterivRobustANGLE_params(glState, isCallValid, target, pname,
                                                           bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceivRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    ShaderProgramID programPacked,
                                                    GLenum programInterface,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLESEnum::AllEnums, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramInterfaceivRobustANGLE_length(glState, isCallValid, programPacked,
                                                       programInterface, pname, bufSize, length,
                                                       params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramInterfaceivRobustANGLE_params(glState, isCallValid, programPacked,
                                                       programInterface, pname, bufSize, length,
                                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramInterfaceivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBooleani_vRobustANGLE_length(glState, isCallValid, target, index, bufSize, length,
                                               data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
        CaptureGetBooleani_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                             data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBooleani_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               GLenum pname,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetMultisamplefvRobustANGLE_length(glState, isCallValid, pname, index, bufSize,
                                                  length, val, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
        CaptureGetMultisamplefvRobustANGLE_val(glState, isCallValid, pname, index, bufSize, length,
                                               val, &valParam);
        paramBuffer.addParam(std::move(valParam));
    }
    else
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valParam.value);
        paramBuffer.addParam(std::move(valParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMultisamplefvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexLevelParameterivRobustANGLE_length(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterivRobustANGLE_params(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexLevelParameterfvRobustANGLE_length(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameterfvRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetPointervRobustANGLERobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetPointervRobustANGLERobustANGLE_length(glState, isCallValid, pname, bufSize,
                                                        length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointervRobustANGLERobustANGLE_params(glState, isCallValid, pname, bufSize,
                                                        length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPointervRobustANGLERobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::AllEnums, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureReadnPixelsRobustANGLE_length(glState, isCallValid, x, y, width, height, format,
                                             type, bufSize, length, columns, rows, data,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
        CaptureReadnPixelsRobustANGLE_columns(glState, isCallValid, x, y, width, height, format,
                                              type, bufSize, length, columns, rows, data,
                                              &columnsParam);
        paramBuffer.addParam(std::move(columnsParam));
    }
    else
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &columnsParam.value);
        paramBuffer.addParam(std::move(columnsParam));
    }

    if (isCallValid)
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
        CaptureReadnPixelsRobustANGLE_rows(glState, isCallValid, x, y, width, height, format, type,
                                           bufSize, length, columns, rows, data, &rowsParam);
        paramBuffer.addParam(std::move(rowsParam));
    }
    else
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &rowsParam.value);
        paramBuffer.addParam(std::move(rowsParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixelsRobustANGLE_data(glState, isCallValid, x, y, width, height, format, type,
                                           bufSize, length, columns, rows, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLReadnPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformfvRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfvRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuivRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformuivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                                bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetnUniformuivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                                bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivRobustANGLE(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureType targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                  bufSize, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterIivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  TextureType targetPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterIuivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                     bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                     bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  SamplerID samplerPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                    bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   SamplerID samplerPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                     bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIuivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     SamplerID samplerPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterIivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                        bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                        bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      SamplerID samplerPacked,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterIuivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                         bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                         bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIuivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               QueryID idPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectivRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                  length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectivRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                  length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 QueryID idPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjecti64vRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                    length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjecti64vRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                    length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjecti64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  QueryID idPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectui64vRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                     length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjectui64vRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                     length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectui64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferPixelLocalStorageParameterfvRobustANGLE(const State &glState,
                                                                         bool isCallValid,
                                                                         GLint plane,
                                                                         GLenum pname,
                                                                         GLsizei bufSize,
                                                                         GLsizei *length,
                                                                         GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addEnumParam("pname", GLESEnum::PLSQueryFloat, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterfvRobustANGLE_length(
            glState, isCallValid, plane, pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterfvRobustANGLE_params(
            glState, isCallValid, plane, pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferPixelLocalStorageParameterivRobustANGLE(const State &glState,
                                                                         bool isCallValid,
                                                                         GLint plane,
                                                                         GLenum pname,
                                                                         GLsizei bufSize,
                                                                         GLsizei *length,
                                                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addEnumParam("pname", GLESEnum::PLSQueryInt, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterivRobustANGLE_length(
            glState, isCallValid, plane, pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterivRobustANGLE_params(
            glState, isCallValid, plane, pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreZirconHandleANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SemaphoreID semaphorePacked,
                                                    HandleType handleTypePacked,
                                                    GLuint handle)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("handle", ParamType::TGLuint, handle);

    return CallCapture(angle::EntryPoint::GLImportSemaphoreZirconHandleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferMemorylessPixelLocalStorageANGLE(const State &glState,
                                                               bool isCallValid,
                                                               GLint plane,
                                                               GLenum internalformat)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addEnumParam("internalformat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalformat);

    return CallCapture(angle::EntryPoint::GLFramebufferMemorylessPixelLocalStorageANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexturePixelLocalStorageANGLE(const State &glState,
                                                            bool isCallValid,
                                                            GLint plane,
                                                            TextureID backingtexturePacked,
                                                            GLint level,
                                                            GLint layer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addValueParam("backingtexturePacked", ParamType::TTextureID, backingtexturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);

    return CallCapture(angle::EntryPoint::GLFramebufferTexturePixelLocalStorageANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferPixelLocalClearValuefvANGLE(const State &glState,
                                                          bool isCallValid,
                                                          GLint plane,
                                                          const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureFramebufferPixelLocalClearValuefvANGLE_value(glState, isCallValid, plane, value,
                                                            &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLFramebufferPixelLocalClearValuefvANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferPixelLocalClearValueivANGLE(const State &glState,
                                                          bool isCallValid,
                                                          GLint plane,
                                                          const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureFramebufferPixelLocalClearValueivANGLE_value(glState, isCallValid, plane, value,
                                                            &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLFramebufferPixelLocalClearValueivANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferPixelLocalClearValueuivANGLE(const State &glState,
                                                           bool isCallValid,
                                                           GLint plane,
                                                           const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureFramebufferPixelLocalClearValueuivANGLE_value(glState, isCallValid, plane, value,
                                                             &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLFramebufferPixelLocalClearValueuivANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureBeginPixelLocalStorageANGLE(const State &glState,
                                               bool isCallValid,
                                               GLsizei n,
                                               const GLenum *loadops)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture loadopsParam("loadops", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, loadops, &loadopsParam.value);
        CaptureBeginPixelLocalStorageANGLE_loadops(glState, isCallValid, n, loadops, &loadopsParam);
        paramBuffer.addParam(std::move(loadopsParam));
    }
    else
    {
        ParamCapture loadopsParam("loadops", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &loadopsParam.value);
        paramBuffer.addParam(std::move(loadopsParam));
    }

    return CallCapture(angle::EntryPoint::GLBeginPixelLocalStorageANGLE, std::move(paramBuffer));
}

CallCapture CaptureEndPixelLocalStorageANGLE(const State &glState,
                                             bool isCallValid,
                                             GLsizei n,
                                             const GLenum *storeops)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture storeopsParam("storeops", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, storeops, &storeopsParam.value);
        CaptureEndPixelLocalStorageANGLE_storeops(glState, isCallValid, n, storeops,
                                                  &storeopsParam);
        paramBuffer.addParam(std::move(storeopsParam));
    }
    else
    {
        ParamCapture storeopsParam("storeops", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &storeopsParam.value);
        paramBuffer.addParam(std::move(storeopsParam));
    }

    return CallCapture(angle::EntryPoint::GLEndPixelLocalStorageANGLE, std::move(paramBuffer));
}

CallCapture CapturePixelLocalStorageBarrierANGLE(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPixelLocalStorageBarrierANGLE, std::move(paramBuffer));
}

CallCapture CaptureFramebufferPixelLocalStorageInterruptANGLE(const State &glState,
                                                              bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLFramebufferPixelLocalStorageInterruptANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureFramebufferPixelLocalStorageRestoreANGLE(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLFramebufferPixelLocalStorageRestoreANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferPixelLocalStorageParameterfvANGLE(const State &glState,
                                                                   bool isCallValid,
                                                                   GLint plane,
                                                                   GLenum pname,
                                                                   GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addEnumParam("pname", GLESEnum::PLSQueryFloat, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterfvANGLE_params(glState, isCallValid, plane,
                                                                      pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferPixelLocalStorageParameterivANGLE(const State &glState,
                                                                   bool isCallValid,
                                                                   GLint plane,
                                                                   GLenum pname,
                                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("plane", ParamType::TGLint, plane);
    paramBuffer.addEnumParam("pname", GLESEnum::PLSQueryInt, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferPixelLocalStorageParameterivANGLE_params(glState, isCallValid, plane,
                                                                      pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureTexImage2DExternalANGLE(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLint border,
                                           GLenum format,
                                           GLenum type)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    return CallCapture(angle::EntryPoint::GLTexImage2DExternalANGLE, std::move(paramBuffer));
}

CallCapture CaptureInvalidateTextureANGLE(const State &glState,
                                          bool isCallValid,
                                          TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(angle::EntryPoint::GLInvalidateTextureANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisampleANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::AllEnums, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexStorage2DMultisampleANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvANGLE(const State &glState,
                                         bool isCallValid,
                                         GLenum pname,
                                         GLuint index,
                                         GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
        CaptureGetMultisamplefvANGLE_val(glState, isCallValid, pname, index, val, &valParam);
        paramBuffer.addParam(std::move(valParam));
    }
    else
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valParam.value);
        paramBuffer.addParam(std::move(valParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMultisamplefvANGLE, std::move(paramBuffer));
}

CallCapture CaptureSampleMaskiANGLE(const State &glState,
                                    bool isCallValid,
                                    GLuint maskNumber,
                                    GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addEnumParam("mask", GLESEnum::AllEnums, ParamType::TGLbitfield, mask);

    return CallCapture(angle::EntryPoint::GLSampleMaskiANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTranslatedShaderSourceANGLE(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID shaderPacked,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTranslatedShaderSourceANGLE_length(glState, isCallValid, shaderPacked, bufSize,
                                                     length, source, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture sourceParam("source", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
        CaptureGetTranslatedShaderSourceANGLE_source(glState, isCallValid, shaderPacked, bufSize,
                                                     length, source, &sourceParam);
        paramBuffer.addParam(std::move(sourceParam));
    }
    else
    {
        ParamCapture sourceParam("source", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &sourceParam.value);
        paramBuffer.addParam(std::move(sourceParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTranslatedShaderSourceANGLE, std::move(paramBuffer));
}

CallCapture CaptureBindMetalRasterizationRateMapANGLE(const State &glState,
                                                      bool isCallValid,
                                                      GLuint framebuffer,
                                                      GLMTLRasterizationRateMapANGLE map)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebuffer", ParamType::TGLuint, framebuffer);
    paramBuffer.addValueParam("map", ParamType::TGLMTLRasterizationRateMapANGLE, map);

    return CallCapture(angle::EntryPoint::GLBindMetalRasterizationRateMapANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureAcquireTexturesANGLE(const State &glState,
                                        bool isCallValid,
                                        GLuint numTextures,
                                        const TextureID *texturesPacked,
                                        const GLenum *layouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numTextures", ParamType::TGLuint, numTextures);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureAcquireTexturesANGLE_texturesPacked(glState, isCallValid, numTextures,
                                                   texturesPacked, layouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture layoutsParam("layouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, layouts, &layoutsParam.value);
        CaptureAcquireTexturesANGLE_layouts(glState, isCallValid, numTextures, texturesPacked,
                                            layouts, &layoutsParam);
        paramBuffer.addParam(std::move(layoutsParam));
    }
    else
    {
        ParamCapture layoutsParam("layouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &layoutsParam.value);
        paramBuffer.addParam(std::move(layoutsParam));
    }

    return CallCapture(angle::EntryPoint::GLAcquireTexturesANGLE, std::move(paramBuffer));
}

CallCapture CaptureReleaseTexturesANGLE(const State &glState,
                                        bool isCallValid,
                                        GLuint numTextures,
                                        const TextureID *texturesPacked,
                                        GLenum *layouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numTextures", ParamType::TGLuint, numTextures);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureReleaseTexturesANGLE_texturesPacked(glState, isCallValid, numTextures,
                                                   texturesPacked, layouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture layoutsParam("layouts", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, layouts, &layoutsParam.value);
        CaptureReleaseTexturesANGLE_layouts(glState, isCallValid, numTextures, texturesPacked,
                                            layouts, &layoutsParam);
        paramBuffer.addParam(std::move(layoutsParam));
    }
    else
    {
        ParamCapture layoutsParam("layouts", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &layoutsParam.value);
        paramBuffer.addParam(std::move(layoutsParam));
    }

    return CallCapture(angle::EntryPoint::GLReleaseTexturesANGLE, std::move(paramBuffer));
}

CallCapture CaptureBindUniformLocationCHROMIUM(const State &glState,
                                               bool isCallValid,
                                               ShaderProgramID programPacked,
                                               UniformLocation locationPacked,
                                               const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindUniformLocationCHROMIUM_name(glState, isCallValid, programPacked, locationPacked,
                                                name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLBindUniformLocationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCompressedCopyTextureCHROMIUM(const State &glState,
                                                 bool isCallValid,
                                                 TextureID sourceIdPacked,
                                                 TextureID destIdPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);

    return CallCapture(angle::EntryPoint::GLCompressedCopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureCHROMIUM(const State &glState,
                                       bool isCallValid,
                                       TextureID sourceIdPacked,
                                       GLint sourceLevel,
                                       TextureTarget destTargetPacked,
                                       TextureID destIdPacked,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLESEnum::AllEnums, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(angle::EntryPoint::GLCopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopySubTextureCHROMIUM(const State &glState,
                                          bool isCallValid,
                                          TextureID sourceIdPacked,
                                          GLint sourceLevel,
                                          TextureTarget destTargetPacked,
                                          TextureID destIdPacked,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLint width,
                                          GLint height,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(angle::EntryPoint::GLCopySubTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverageModulationCHROMIUM(const State &glState,
                                              bool isCallValid,
                                              GLenum components)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("components", GLESEnum::AllEnums, ParamType::TGLenum, components);

    return CallCapture(angle::EntryPoint::GLCoverageModulationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureLoseContextCHROMIUM(const State &glState,
                                       bool isCallValid,
                                       GraphicsResetStatus currentPacked,
                                       GraphicsResetStatus otherPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("currentPacked", ParamType::TGraphicsResetStatus, currentPacked);
    paramBuffer.addValueParam("otherPacked", ParamType::TGraphicsResetStatus, otherPacked);

    return CallCapture(angle::EntryPoint::GLLoseContextCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetTexStorageEXT(const State &glState,
                                               bool isCallValid,
                                               GLenum target,
                                               egl::ImageID imagePacked,
                                               const GLint *attrib_list)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);

    if (isCallValid)
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, attrib_list, &attrib_listParam.value);
        CaptureEGLImageTargetTexStorageEXT_attrib_list(glState, isCallValid, target, imagePacked,
                                                       attrib_list, &attrib_listParam);
        paramBuffer.addParam(std::move(attrib_listParam));
    }
    else
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &attrib_listParam.value);
        paramBuffer.addParam(std::move(attrib_listParam));
    }

    return CallCapture(angle::EntryPoint::GLEGLImageTargetTexStorageEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedBaseInstanceEXT(const State &glState,
                                                      bool isCallValid,
                                                      PrimitiveMode modePacked,
                                                      GLint first,
                                                      GLsizei count,
                                                      GLsizei instancecount,
                                                      GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstancedBaseInstanceEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseInstanceEXT(const State &glState,
                                                        bool isCallValid,
                                                        PrimitiveMode modePacked,
                                                        GLsizei count,
                                                        DrawElementsType typePacked,
                                                        const void *indices,
                                                        GLsizei instancecount,
                                                        GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseInstanceEXT_indices(glState, isCallValid, modePacked, count,
                                                            typePacked, indices, instancecount,
                                                            baseinstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseInstanceEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexBaseInstanceEXT(const State &glState,
                                                                  bool isCallValid,
                                                                  PrimitiveMode modePacked,
                                                                  GLsizei count,
                                                                  DrawElementsType typePacked,
                                                                  const void *indices,
                                                                  GLsizei instancecount,
                                                                  GLint basevertex,
                                                                  GLuint baseinstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexBaseInstanceEXT_indices(
            glState, isCallValid, modePacked, count, typePacked, indices, instancecount, basevertex,
            baseinstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);
    paramBuffer.addValueParam("baseinstance", ParamType::TGLuint, baseinstance);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationEXT(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLuint color,
                                           const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocationEXT_name(glState, isCallValid, programPacked, color, name,
                                            &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLBindFragDataLocationEXT, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationIndexedEXT(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID programPacked,
                                                  GLuint colorNumber,
                                                  GLuint index,
                                                  const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("colorNumber", ParamType::TGLuint, colorNumber);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocationIndexedEXT_name(glState, isCallValid, programPacked, colorNumber,
                                                   index, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLBindFragDataLocationIndexedEXT, std::move(paramBuffer));
}

CallCapture CaptureGetFragDataIndexEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       const GLchar *name,
                                       GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetFragDataIndexEXT_name(glState, isCallValid, programPacked, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetFragDataIndexEXT, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocationIndexEXT(const State &glState,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      GLenum programInterface,
                                                      const GLchar *name,
                                                      GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLESEnum::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetProgramResourceLocationIndexEXT_name(glState, isCallValid, programPacked,
                                                       programInterface, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetProgramResourceLocationIndexEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureBufferStorageEXT(const State &glState,
                                    bool isCallValid,
                                    BufferBinding targetPacked,
                                    GLsizeiptr size,
                                    const void *data,
                                    GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureBufferStorageEXT_data(glState, isCallValid, targetPacked, size, data, flags,
                                     &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    paramBuffer.addEnumParam("flags", GLESEnum::BufferStorageMask, ParamType::TGLbitfield, flags);

    return CallCapture(angle::EntryPoint::GLBufferStorageEXT, std::move(paramBuffer));
}

CallCapture CaptureClearTexImageEXT(const State &glState,
                                    bool isCallValid,
                                    TextureID texturePacked,
                                    GLint level,
                                    GLenum format,
                                    GLenum type,
                                    const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearTexImageEXT_data(glState, isCallValid, texturePacked, level, format, type, data,
                                     &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearTexImageEXT, std::move(paramBuffer));
}

CallCapture CaptureClearTexSubImageEXT(const State &glState,
                                       bool isCallValid,
                                       TextureID texturePacked,
                                       GLint level,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint zoffset,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLenum format,
                                       GLenum type,
                                       const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureClearTexSubImageEXT_data(glState, isCallValid, texturePacked, level, xoffset,
                                        yoffset, zoffset, width, height, depth, format, type, data,
                                        &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLClearTexSubImageEXT, std::move(paramBuffer));
}

CallCapture CaptureClipControlEXT(const State &glState,
                                  bool isCallValid,
                                  ClipOrigin originPacked,
                                  ClipDepthMode depthPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("originPacked", ParamType::TClipOrigin, originPacked);
    paramBuffer.addValueParam("depthPacked", ParamType::TClipDepthMode, depthPacked);

    return CallCapture(angle::EntryPoint::GLClipControlEXT, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubDataEXT(const State &glState,
                                       bool isCallValid,
                                       GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLESEnum::CopyBufferSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLESEnum::CopyBufferSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(angle::EntryPoint::GLCopyImageSubDataEXT, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabelEXT(const State &glState,
                                     bool isCallValid,
                                     GLenum type,
                                     GLuint object,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("object", ParamType::TGLuint, object);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectLabelEXT_length(glState, isCallValid, type, object, bufSize, length, label,
                                        &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectLabelEXT_label(glState, isCallValid, type, object, bufSize, length, label,
                                       &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLGetObjectLabelEXT, std::move(paramBuffer));
}

CallCapture CaptureLabelObjectEXT(const State &glState,
                                  bool isCallValid,
                                  GLenum type,
                                  GLuint object,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("object", ParamType::TGLuint, object);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureLabelObjectEXT_label(glState, isCallValid, type, object, length, label, &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLLabelObjectEXT, std::move(paramBuffer));
}

CallCapture CaptureInsertEventMarkerEXT(const State &glState,
                                        bool isCallValid,
                                        GLsizei length,
                                        const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
        CaptureInsertEventMarkerEXT_marker(glState, isCallValid, length, marker, &markerParam);
        paramBuffer.addParam(std::move(markerParam));
    }
    else
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &markerParam.value);
        paramBuffer.addParam(std::move(markerParam));
    }

    return CallCapture(angle::EntryPoint::GLInsertEventMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePopGroupMarkerEXT(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePushGroupMarkerEXT(const State &glState,
                                      bool isCallValid,
                                      GLsizei length,
                                      const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
        CapturePushGroupMarkerEXT_marker(glState, isCallValid, length, marker, &markerParam);
        paramBuffer.addParam(std::move(markerParam));
    }
    else
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &markerParam.value);
        paramBuffer.addParam(std::move(markerParam));
    }

    return CallCapture(angle::EntryPoint::GLPushGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CaptureDiscardFramebufferEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    if (isCallValid)
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureDiscardFramebufferEXT_attachments(glState, isCallValid, target, numAttachments,
                                                 attachments, &attachmentsParam);
        paramBuffer.addParam(std::move(attachmentsParam));
    }
    else
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
        paramBuffer.addParam(std::move(attachmentsParam));
    }

    return CallCapture(angle::EntryPoint::GLDiscardFramebufferEXT, std::move(paramBuffer));
}

CallCapture CaptureBeginQueryEXT(const State &glState,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 QueryID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    return CallCapture(angle::EntryPoint::GLBeginQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteQueriesEXT(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    const QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
        InitParamValue(ParamType::TQueryIDConstPointer, idsPacked, &idsPackedParam.value);
        CaptureDeleteQueriesEXT_idsPacked(glState, isCallValid, n, idsPacked, &idsPackedParam);
        paramBuffer.addParam(std::move(idsPackedParam));
    }
    else
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
        InitParamValue(ParamType::TQueryIDConstPointer, static_cast<const QueryID *>(nullptr),
                       &idsPackedParam.value);
        paramBuffer.addParam(std::move(idsPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureEndQueryEXT(const State &glState, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(angle::EntryPoint::GLEndQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureGenQueriesEXT(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
        InitParamValue(ParamType::TQueryIDPointer, idsPacked, &idsPackedParam.value);
        CaptureGenQueriesEXT_idsPacked(glState, isCallValid, n, idsPacked, &idsPackedParam);
        paramBuffer.addParam(std::move(idsPackedParam));
    }
    else
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
        InitParamValue(ParamType::TQueryIDPointer, static_cast<QueryID *>(nullptr),
                       &idsPackedParam.value);
        paramBuffer.addParam(std::move(idsPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vEXT(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64vEXT_data(glState, isCallValid, pname, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetInteger64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vEXT(const State &glState,
                                         bool isCallValid,
                                         QueryID idPacked,
                                         GLenum pname,
                                         GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjecti64vEXT_params(glState, isCallValid, idPacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjecti64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivEXT(const State &glState,
                                       bool isCallValid,
                                       QueryID idPacked,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectivEXT_params(glState, isCallValid, idPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vEXT(const State &glState,
                                          bool isCallValid,
                                          QueryID idPacked,
                                          GLenum pname,
                                          GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjectui64vEXT_params(glState, isCallValid, idPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivEXT(const State &glState,
                                        bool isCallValid,
                                        QueryID idPacked,
                                        GLenum pname,
                                        GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectuivEXT_params(glState, isCallValid, idPacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectuivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryivEXT(const State &glState,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 GLenum pname,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryivEXT, std::move(paramBuffer));
}

CallCapture CaptureIsQueryEXT(const State &glState,
                              bool isCallValid,
                              QueryID idPacked,
                              GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryCounterEXT(const State &glState,
                                   bool isCallValid,
                                   QueryID idPacked,
                                   QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(angle::EntryPoint::GLQueryCounterEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawBuffersEXT(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
        CaptureDrawBuffersEXT_bufs(glState, isCallValid, n, bufs, &bufsParam);
        paramBuffer.addParam(std::move(bufsParam));
    }
    else
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &bufsParam.value);
        paramBuffer.addParam(std::move(bufsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawBuffersEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparateiEXT(const State &glState,
                                             bool isCallValid,
                                             GLuint buf,
                                             GLenum modeRGB,
                                             GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(angle::EntryPoint::GLBlendEquationSeparateiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationiEXT(const State &glState,
                                     bool isCallValid,
                                     GLuint buf,
                                     GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBlendEquationiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparateiEXT(const State &glState,
                                         bool isCallValid,
                                         GLuint buf,
                                         GLenum srcRGB,
                                         GLenum dstRGB,
                                         GLenum srcAlpha,
                                         GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(angle::EntryPoint::GLBlendFuncSeparateiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendFunciEXT(const State &glState,
                                 bool isCallValid,
                                 GLuint buf,
                                 GLenum src,
                                 GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLESEnum::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLESEnum::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(angle::EntryPoint::GLBlendFunciEXT, std::move(paramBuffer));
}

CallCapture CaptureColorMaskiEXT(const State &glState,
                                 bool isCallValid,
                                 GLuint index,
                                 GLboolean r,
                                 GLboolean g,
                                 GLboolean b,
                                 GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(angle::EntryPoint::GLColorMaskiEXT, std::move(paramBuffer));
}

CallCapture CaptureDisableiEXT(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLDisableiEXT, std::move(paramBuffer));
}

CallCapture CaptureEnableiEXT(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEnableiEXT, std::move(paramBuffer));
}

CallCapture CaptureIsEnablediEXT(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsEnablediEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertexEXT(const State &glState,
                                             bool isCallValid,
                                             PrimitiveMode modePacked,
                                             GLsizei count,
                                             DrawElementsType typePacked,
                                             const void *indices,
                                             GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                 typePacked, indices, basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexEXT(const State &glState,
                                                      bool isCallValid,
                                                      PrimitiveMode modePacked,
                                                      GLsizei count,
                                                      DrawElementsType typePacked,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                          typePacked, indices, instancecount,
                                                          basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertexEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertexEXT(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  DrawElementsType typePacked,
                                                  const void *indices,
                                                  GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, start, end,
                                                      count, typePacked, indices, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawRangeElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsBaseVertexEXT(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  const GLsizei *count,
                                                  DrawElementsType typePacked,
                                                  const void *const *indices,
                                                  GLsizei drawcount,
                                                  const GLint *basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_count(glState, isCallValid, modePacked, count,
                                                    typePacked, indices, drawcount, basevertex,
                                                    &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                      typePacked, indices, drawcount, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    if (isCallValid)
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, basevertex, &basevertexParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_basevertex(glState, isCallValid, modePacked, count,
                                                         typePacked, indices, drawcount, basevertex,
                                                         &basevertexParam);
        paramBuffer.addParam(std::move(basevertexParam));
    }
    else
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &basevertexParam.value);
        paramBuffer.addParam(std::move(basevertexParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedEXT(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLint start,
                                          GLsizei count,
                                          GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLint, start);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedEXT(const State &glState,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedEXT_indices(glState, isCallValid, modePacked, count, typePacked,
                                                indices, primcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageExternalEXT(const State &glState,
                                            bool isCallValid,
                                            BufferBinding targetPacked,
                                            GLintptr offset,
                                            GLsizeiptr size,
                                            GLeglClientBufferEXT clientBuffer,
                                            GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("clientBuffer", ParamType::TGLeglClientBufferEXT, clientBuffer);
    paramBuffer.addEnumParam("flags", GLESEnum::BufferStorageMask, ParamType::TGLbitfield, flags);

    return CallCapture(angle::EntryPoint::GLBufferStorageExternalEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferShadingRateEXT(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum attachment,
                                             GLuint texture,
                                             GLint baseLayer,
                                             GLsizei numLayers,
                                             GLsizei texelWidth,
                                             GLsizei texelHeight)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("baseLayer", ParamType::TGLint, baseLayer);
    paramBuffer.addValueParam("numLayers", ParamType::TGLsizei, numLayers);
    paramBuffer.addValueParam("texelWidth", ParamType::TGLsizei, texelWidth);
    paramBuffer.addValueParam("texelHeight", ParamType::TGLsizei, texelHeight);

    return CallCapture(angle::EntryPoint::GLFramebufferShadingRateEXT, std::move(paramBuffer));
}

CallCapture CaptureGetFragmentShadingRatesEXT(const State &glState,
                                              bool isCallValid,
                                              GLsizei samples,
                                              GLsizei maxCount,
                                              GLsizei *count,
                                              GLenum *shadingRates)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addValueParam("maxCount", ParamType::TGLsizei, maxCount);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, count, &countParam.value);
        CaptureGetFragmentShadingRatesEXT_count(glState, isCallValid, samples, maxCount, count,
                                                shadingRates, &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    if (isCallValid)
    {
        ParamCapture shadingRatesParam("shadingRates", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, shadingRates, &shadingRatesParam.value);
        CaptureGetFragmentShadingRatesEXT_shadingRates(glState, isCallValid, samples, maxCount,
                                                       count, shadingRates, &shadingRatesParam);
        paramBuffer.addParam(std::move(shadingRatesParam));
    }
    else
    {
        ParamCapture shadingRatesParam("shadingRates", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &shadingRatesParam.value);
        paramBuffer.addParam(std::move(shadingRatesParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFragmentShadingRatesEXT, std::move(paramBuffer));
}

CallCapture CaptureShadingRateEXT(const State &glState, bool isCallValid, GLenum rate)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("rate", GLESEnum::ShadingRate, ParamType::TGLenum, rate);

    return CallCapture(angle::EntryPoint::GLShadingRateEXT, std::move(paramBuffer));
}

CallCapture CaptureShadingRateCombinerOpsEXT(const State &glState,
                                             bool isCallValid,
                                             GLenum combinerOp0,
                                             GLenum combinerOp1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("combinerOp0", GLESEnum::ShadingRateCombinerOp, ParamType::TGLenum,
                             combinerOp0);
    paramBuffer.addEnumParam("combinerOp1", GLESEnum::ShadingRateCombinerOp, ParamType::TGLenum,
                             combinerOp1);

    return CallCapture(angle::EntryPoint::GLShadingRateCombinerOpsEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum attachment,
                                         TextureID texturePacked,
                                         GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTextureEXT, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorEXT(const State &glState,
                                          bool isCallValid,
                                          GLuint index,
                                          GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(angle::EntryPoint::GLVertexAttribDivisorEXT, std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRangeEXT(const State &glState,
                                             bool isCallValid,
                                             BufferBinding targetPacked,
                                             GLintptr offset,
                                             GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(angle::EntryPoint::GLFlushMappedBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureMapBufferRangeEXT(const State &glState,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLintptr offset,
                                     GLsizeiptr length,
                                     GLbitfield access,
                                     void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addEnumParam("access", GLESEnum::MapBufferAccessMask, ParamType::TGLbitfield,
                             access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageMemEXT(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLsizeiptr size,
                                       MemoryObjectID memoryPacked,
                                       GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(angle::EntryPoint::GLBufferStorageMemEXT, std::move(paramBuffer));
}

CallCapture CaptureCreateMemoryObjectsEXT(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDPointer);
        InitParamValue(ParamType::TMemoryObjectIDPointer, memoryObjectsPacked,
                       &memoryObjectsPackedParam.value);
        CaptureCreateMemoryObjectsEXT_memoryObjectsPacked(
            glState, isCallValid, n, memoryObjectsPacked, &memoryObjectsPackedParam);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }
    else
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDPointer);
        InitParamValue(ParamType::TMemoryObjectIDPointer, static_cast<MemoryObjectID *>(nullptr),
                       &memoryObjectsPackedParam.value);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLCreateMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteMemoryObjectsEXT(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDConstPointer);
        InitParamValue(ParamType::TMemoryObjectIDConstPointer, memoryObjectsPacked,
                       &memoryObjectsPackedParam.value);
        CaptureDeleteMemoryObjectsEXT_memoryObjectsPacked(
            glState, isCallValid, n, memoryObjectsPacked, &memoryObjectsPackedParam);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }
    else
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDConstPointer);
        InitParamValue(ParamType::TMemoryObjectIDConstPointer,
                       static_cast<const MemoryObjectID *>(nullptr),
                       &memoryObjectsPackedParam.value);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureGetMemoryObjectParameterivEXT(const State &glState,
                                                 bool isCallValid,
                                                 MemoryObjectID memoryObjectPacked,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetMemoryObjectParameterivEXT_params(glState, isCallValid, memoryObjectPacked, pname,
                                                    params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytevEXT(const State &glState,
                                       bool isCallValid,
                                       GLenum pname,
                                       GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
        CaptureGetUnsignedBytevEXT_data(glState, isCallValid, pname, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUnsignedBytevEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytei_vEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLuint index,
                                         GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
        CaptureGetUnsignedBytei_vEXT_data(glState, isCallValid, target, index, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetUnsignedBytei_vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsMemoryObjectEXT(const State &glState,
                                     bool isCallValid,
                                     MemoryObjectID memoryObjectPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsMemoryObjectEXT, std::move(paramBuffer));
}

CallCapture CaptureMemoryObjectParameterivEXT(const State &glState,
                                              bool isCallValid,
                                              MemoryObjectID memoryObjectPacked,
                                              GLenum pname,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureMemoryObjectParameterivEXT_params(glState, isCallValid, memoryObjectPacked, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLMemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DEXT(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(angle::EntryPoint::GLTexStorageMem2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DMultisampleEXT(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(angle::EntryPoint::GLTexStorageMem2DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DEXT(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(angle::EntryPoint::GLTexStorageMem3DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DMultisampleEXT(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(angle::EntryPoint::GLTexStorageMem3DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureImportMemoryFdEXT(const State &glState,
                                     bool isCallValid,
                                     MemoryObjectID memoryPacked,
                                     GLuint64 size,
                                     HandleType handleTypePacked,
                                     GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(angle::EntryPoint::GLImportMemoryFdEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysEXT(const State &glState,
                                      bool isCallValid,
                                      PrimitiveMode modePacked,
                                      const GLint *first,
                                      const GLsizei *count,
                                      GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstParam("first", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, first, &firstParam.value);
        CaptureMultiDrawArraysEXT_first(glState, isCallValid, modePacked, first, count, primcount,
                                        &firstParam);
        paramBuffer.addParam(std::move(firstParam));
    }
    else
    {
        ParamCapture firstParam("first", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstParam.value);
        paramBuffer.addParam(std::move(firstParam));
    }

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawArraysEXT_count(glState, isCallValid, modePacked, first, count, primcount,
                                        &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsEXT(const State &glState,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        const GLsizei *count,
                                        DrawElementsType typePacked,
                                        const void *const *indices,
                                        GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawElementsEXT_count(glState, isCallValid, modePacked, count, typePacked,
                                          indices, primcount, &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsEXT_indices(glState, isCallValid, modePacked, count, typePacked,
                                            indices, primcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysIndirectEXT(const State &glState,
                                              bool isCallValid,
                                              PrimitiveMode modePacked,
                                              const void *indirect,
                                              GLsizei drawcount,
                                              GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawArraysIndirectEXT_indirect(glState, isCallValid, modePacked, indirect,
                                                   drawcount, stride, &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawArraysIndirectEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsIndirectEXT(const State &glState,
                                                bool isCallValid,
                                                PrimitiveMode modePacked,
                                                DrawElementsType typePacked,
                                                const void *indirect,
                                                GLsizei drawcount,
                                                GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureMultiDrawElementsIndirectEXT_indirect(glState, isCallValid, modePacked, typePacked,
                                                     indirect, drawcount, stride, &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsIndirectEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DMultisampleEXT(const State &glState,
                                                      bool isCallValid,
                                                      GLenum target,
                                                      GLenum attachment,
                                                      TextureTarget textargetPacked,
                                                      TextureID texturePacked,
                                                      GLint level,
                                                      GLsizei samples)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture2DMultisampleEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleEXT(const State &glState,
                                                     bool isCallValid,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLRenderbufferStorageMultisampleEXT,
                       std::move(paramBuffer));
}

CallCapture CapturePolygonOffsetClampEXT(const State &glState,
                                         bool isCallValid,
                                         GLfloat factor,
                                         GLfloat units,
                                         GLfloat clamp)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfloat, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfloat, units);
    paramBuffer.addValueParam("clamp", ParamType::TGLfloat, clamp);

    return CallCapture(angle::EntryPoint::GLPolygonOffsetClampEXT, std::move(paramBuffer));
}

CallCapture CapturePrimitiveBoundingBoxEXT(const State &glState,
                                           bool isCallValid,
                                           GLfloat minX,
                                           GLfloat minY,
                                           GLfloat minZ,
                                           GLfloat minW,
                                           GLfloat maxX,
                                           GLfloat maxY,
                                           GLfloat maxZ,
                                           GLfloat maxW)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("minX", ParamType::TGLfloat, minX);
    paramBuffer.addValueParam("minY", ParamType::TGLfloat, minY);
    paramBuffer.addValueParam("minZ", ParamType::TGLfloat, minZ);
    paramBuffer.addValueParam("minW", ParamType::TGLfloat, minW);
    paramBuffer.addValueParam("maxX", ParamType::TGLfloat, maxX);
    paramBuffer.addValueParam("maxY", ParamType::TGLfloat, maxY);
    paramBuffer.addValueParam("maxZ", ParamType::TGLfloat, maxZ);
    paramBuffer.addValueParam("maxW", ParamType::TGLfloat, maxW);

    return CallCapture(angle::EntryPoint::GLPrimitiveBoundingBoxEXT, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatusEXT(const State &glState,
                                             bool isCallValid,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetGraphicsResetStatusEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvEXT(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfvEXT_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformfvEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivEXT(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformivEXT_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformivEXT, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsEXT(const State &glState,
                                  bool isCallValid,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixelsEXT_data(glState, isCallValid, x, y, width, height, format, type, bufSize,
                                   data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLReadnPixelsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteSemaphoresEXT(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       const SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDConstPointer);
        InitParamValue(ParamType::TSemaphoreIDConstPointer, semaphoresPacked,
                       &semaphoresPackedParam.value);
        CaptureDeleteSemaphoresEXT_semaphoresPacked(glState, isCallValid, n, semaphoresPacked,
                                                    &semaphoresPackedParam);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }
    else
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDConstPointer);
        InitParamValue(ParamType::TSemaphoreIDConstPointer,
                       static_cast<const SemaphoreID *>(nullptr), &semaphoresPackedParam.value);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGenSemaphoresEXT(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDPointer);
        InitParamValue(ParamType::TSemaphoreIDPointer, semaphoresPacked,
                       &semaphoresPackedParam.value);
        CaptureGenSemaphoresEXT_semaphoresPacked(glState, isCallValid, n, semaphoresPacked,
                                                 &semaphoresPackedParam);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }
    else
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDPointer);
        InitParamValue(ParamType::TSemaphoreIDPointer, static_cast<SemaphoreID *>(nullptr),
                       &semaphoresPackedParam.value);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGetSemaphoreParameterui64vEXT(const State &glState,
                                                 bool isCallValid,
                                                 SemaphoreID semaphorePacked,
                                                 GLenum pname,
                                                 GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SemaphoreParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetSemaphoreParameterui64vEXT_params(glState, isCallValid, semaphorePacked, pname,
                                                    params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsSemaphoreEXT(const State &glState,
                                  bool isCallValid,
                                  SemaphoreID semaphorePacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureSemaphoreParameterui64vEXT(const State &glState,
                                              bool isCallValid,
                                              SemaphoreID semaphorePacked,
                                              GLenum pname,
                                              const GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SemaphoreParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
        InitParamValue(ParamType::TGLuint64ConstPointer, params, &paramsParam.value);
        CaptureSemaphoreParameterui64vEXT_params(glState, isCallValid, semaphorePacked, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
        InitParamValue(ParamType::TGLuint64ConstPointer, static_cast<const GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLSemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureSignalSemaphoreEXT(const State &glState,
                                      bool isCallValid,
                                      SemaphoreID semaphorePacked,
                                      GLuint numBufferBarriers,
                                      const BufferID *buffersPacked,
                                      GLuint numTextureBarriers,
                                      const TextureID *texturesPacked,
                                      const GLenum *dstLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureSignalSemaphoreEXT_buffersPacked(
            glState, isCallValid, semaphorePacked, numBufferBarriers, buffersPacked,
            numTextureBarriers, texturesPacked, dstLayouts, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureSignalSemaphoreEXT_texturesPacked(
            glState, isCallValid, semaphorePacked, numBufferBarriers, buffersPacked,
            numTextureBarriers, texturesPacked, dstLayouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, dstLayouts, &dstLayoutsParam.value);
        CaptureSignalSemaphoreEXT_dstLayouts(glState, isCallValid, semaphorePacked,
                                             numBufferBarriers, buffersPacked, numTextureBarriers,
                                             texturesPacked, dstLayouts, &dstLayoutsParam);
        paramBuffer.addParam(std::move(dstLayoutsParam));
    }
    else
    {
        ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &dstLayoutsParam.value);
        paramBuffer.addParam(std::move(dstLayoutsParam));
    }

    return CallCapture(angle::EntryPoint::GLSignalSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureWaitSemaphoreEXT(const State &glState,
                                    bool isCallValid,
                                    SemaphoreID semaphorePacked,
                                    GLuint numBufferBarriers,
                                    const BufferID *buffersPacked,
                                    GLuint numTextureBarriers,
                                    const TextureID *texturesPacked,
                                    const GLenum *srcLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureWaitSemaphoreEXT_buffersPacked(glState, isCallValid, semaphorePacked,
                                              numBufferBarriers, buffersPacked, numTextureBarriers,
                                              texturesPacked, srcLayouts, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureWaitSemaphoreEXT_texturesPacked(glState, isCallValid, semaphorePacked,
                                               numBufferBarriers, buffersPacked, numTextureBarriers,
                                               texturesPacked, srcLayouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, srcLayouts, &srcLayoutsParam.value);
        CaptureWaitSemaphoreEXT_srcLayouts(glState, isCallValid, semaphorePacked, numBufferBarriers,
                                           buffersPacked, numTextureBarriers, texturesPacked,
                                           srcLayouts, &srcLayoutsParam);
        paramBuffer.addParam(std::move(srcLayoutsParam));
    }
    else
    {
        ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &srcLayoutsParam.value);
        paramBuffer.addParam(std::move(srcLayoutsParam));
    }

    return CallCapture(angle::EntryPoint::GLWaitSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreFdEXT(const State &glState,
                                        bool isCallValid,
                                        SemaphoreID semaphorePacked,
                                        HandleType handleTypePacked,
                                        GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(angle::EntryPoint::GLImportSemaphoreFdEXT, std::move(paramBuffer));
}

CallCapture CaptureActiveShaderProgramEXT(const State &glState,
                                          bool isCallValid,
                                          ProgramPipelineID pipelinePacked,
                                          ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLActiveShaderProgramEXT, std::move(paramBuffer));
}

CallCapture CaptureBindProgramPipelineEXT(const State &glState,
                                          bool isCallValid,
                                          ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(angle::EntryPoint::GLBindProgramPipelineEXT, std::move(paramBuffer));
}

CallCapture CaptureCreateShaderProgramvEXT(const State &glState,
                                           bool isCallValid,
                                           ShaderType typePacked,
                                           GLsizei count,
                                           const GLchar *const *strings,
                                           GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture stringsParam("strings", ParamType::TGLcharConstPointerPointer);
        InitParamValue(ParamType::TGLcharConstPointerPointer, strings, &stringsParam.value);
        CaptureCreateShaderProgramvEXT_strings(glState, isCallValid, typePacked, count, strings,
                                               &stringsParam);
        paramBuffer.addParam(std::move(stringsParam));
    }
    else
    {
        ParamCapture stringsParam("strings", ParamType::TGLcharConstPointerPointer);
        InitParamValue(ParamType::TGLcharConstPointerPointer,
                       static_cast<const GLchar *const *>(nullptr), &stringsParam.value);
        paramBuffer.addParam(std::move(stringsParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCreateShaderProgramvEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteProgramPipelinesEXT(const State &glState,
                                             bool isCallValid,
                                             GLsizei n,
                                             const ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked",
                                          ParamType::TProgramPipelineIDConstPointer);
        InitParamValue(ParamType::TProgramPipelineIDConstPointer, pipelinesPacked,
                       &pipelinesPackedParam.value);
        CaptureDeleteProgramPipelinesEXT_pipelinesPacked(glState, isCallValid, n, pipelinesPacked,
                                                         &pipelinesPackedParam);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }
    else
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked",
                                          ParamType::TProgramPipelineIDConstPointer);
        InitParamValue(ParamType::TProgramPipelineIDConstPointer,
                       static_cast<const ProgramPipelineID *>(nullptr),
                       &pipelinesPackedParam.value);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteProgramPipelinesEXT, std::move(paramBuffer));
}

CallCapture CaptureGenProgramPipelinesEXT(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer);
        InitParamValue(ParamType::TProgramPipelineIDPointer, pipelinesPacked,
                       &pipelinesPackedParam.value);
        CaptureGenProgramPipelinesEXT_pipelinesPacked(glState, isCallValid, n, pipelinesPacked,
                                                      &pipelinesPackedParam);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }
    else
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer);
        InitParamValue(ParamType::TProgramPipelineIDPointer,
                       static_cast<ProgramPipelineID *>(nullptr), &pipelinesPackedParam.value);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenProgramPipelinesEXT, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineInfoLogEXT(const State &glState,
                                                bool isCallValid,
                                                ProgramPipelineID pipelinePacked,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramPipelineInfoLogEXT_length(glState, isCallValid, pipelinePacked, bufSize,
                                                   length, infoLog, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
        CaptureGetProgramPipelineInfoLogEXT_infoLog(glState, isCallValid, pipelinePacked, bufSize,
                                                    length, infoLog, &infoLogParam);
        paramBuffer.addParam(std::move(infoLogParam));
    }
    else
    {
        ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &infoLogParam.value);
        paramBuffer.addParam(std::move(infoLogParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramPipelineInfoLogEXT, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineivEXT(const State &glState,
                                           bool isCallValid,
                                           ProgramPipelineID pipelinePacked,
                                           GLenum pname,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("pname", GLESEnum::PipelineParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramPipelineivEXT_params(glState, isCallValid, pipelinePacked, pname, params,
                                              &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramPipelineivEXT, std::move(paramBuffer));
}

CallCapture CaptureIsProgramPipelineEXT(const State &glState,
                                        bool isCallValid,
                                        ProgramPipelineID pipelinePacked,
                                        GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsProgramPipelineEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramParameteriEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        GLenum pname,
                                        GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::ProgramParameterPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(angle::EntryPoint::GLProgramParameteriEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1fEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1fEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1fvEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform1fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1iEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1iEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1ivEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform1ivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1ivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1uiEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLuint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1uiEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1uivEXT(const State &glState,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         UniformLocation locationPacked,
                                         GLsizei count,
                                         const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform1uivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                           count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1uivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2fEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLfloat v0,
                                       GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2fEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2fvEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform2fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2iEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLint v0,
                                       GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2iEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2ivEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform2ivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2ivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2uiEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLuint v0,
                                        GLuint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2uiEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2uivEXT(const State &glState,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         UniformLocation locationPacked,
                                         GLsizei count,
                                         const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform2uivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                           count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2uivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3fEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLfloat v0,
                                       GLfloat v1,
                                       GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3fEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3fvEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform3fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3iEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLint v0,
                                       GLint v1,
                                       GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3iEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3ivEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform3ivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3ivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3uiEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLuint v0,
                                        GLuint v1,
                                        GLuint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3uiEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3uivEXT(const State &glState,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         UniformLocation locationPacked,
                                         GLsizei count,
                                         const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform3uivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                           count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3uivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4fEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLfloat v0,
                                       GLfloat v1,
                                       GLfloat v2,
                                       GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4fEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4fvEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform4fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4iEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLint v0,
                                       GLint v1,
                                       GLint v2,
                                       GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4iEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4ivEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform4ivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                          count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4ivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4uiEXT(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLuint v0,
                                        GLuint v1,
                                        GLuint v2,
                                        GLuint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLuint, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4uiEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4uivEXT(const State &glState,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         UniformLocation locationPacked,
                                         GLsizei count,
                                         const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform4uivEXT_value(glState, isCallValid, programPacked, locationPacked,
                                           count, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4uivEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2fvEXT(const State &glState,
                                              bool isCallValid,
                                              ShaderProgramID programPacked,
                                              UniformLocation locationPacked,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                                count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x3fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x3fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x3fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x4fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x4fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x4fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3fvEXT(const State &glState,
                                              bool isCallValid,
                                              ShaderProgramID programPacked,
                                              UniformLocation locationPacked,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                                count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x2fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x2fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x2fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x4fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x4fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x4fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4fvEXT(const State &glState,
                                              bool isCallValid,
                                              ShaderProgramID programPacked,
                                              UniformLocation locationPacked,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4fvEXT_value(glState, isCallValid, programPacked, locationPacked,
                                                count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x2fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x2fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x2fvEXT, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x3fvEXT(const State &glState,
                                                bool isCallValid,
                                                ShaderProgramID programPacked,
                                                UniformLocation locationPacked,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x3fvEXT_value(glState, isCallValid, programPacked,
                                                  locationPacked, count, transpose, value,
                                                  &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x3fvEXT, std::move(paramBuffer));
}

CallCapture CaptureUseProgramStagesEXT(const State &glState,
                                       bool isCallValid,
                                       ProgramPipelineID pipelinePacked,
                                       GLbitfield stages,
                                       ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("stages", GLESEnum::UseProgramStageMask, ParamType::TGLbitfield,
                             stages);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLUseProgramStagesEXT, std::move(paramBuffer));
}

CallCapture CaptureValidateProgramPipelineEXT(const State &glState,
                                              bool isCallValid,
                                              ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(angle::EntryPoint::GLValidateProgramPipelineEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferFetchBarrierEXT(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLFramebufferFetchBarrierEXT, std::move(paramBuffer));
}

CallCapture CapturePatchParameteriEXT(const State &glState,
                                      bool isCallValid,
                                      GLenum pname,
                                      GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::PatchParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(angle::EntryPoint::GLPatchParameteriEXT, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivEXT(const State &glState,
                                             bool isCallValid,
                                             SamplerID samplerPacked,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIivEXT_params(glState, isCallValid, samplerPacked, pname, params,
                                                &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivEXT(const State &glState,
                                              bool isCallValid,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuivEXT_params(glState, isCallValid, samplerPacked, pname, params,
                                                 &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIuivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivEXT(const State &glState,
                                         bool isCallValid,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivEXT(const State &glState,
                                          bool isCallValid,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIuivEXT, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivEXT(const State &glState,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIivEXT_param(glState, isCallValid, samplerPacked, pname, param,
                                            &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIivEXT, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivEXT(const State &glState,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuivEXT_param(glState, isCallValid, samplerPacked, pname, param,
                                             &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIuivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivEXT(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivEXT(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIuivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexBufferEXT(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLenum internalformat,
                                BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLTexBufferEXT, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRangeEXT(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum internalformat,
                                     BufferID bufferPacked,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLTexBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DEXT(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLTexStorage2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DEXT(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(angle::EntryPoint::GLTexStorage3DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageAttribs2DEXT(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          const GLint *attrib_list)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    if (isCallValid)
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, attrib_list, &attrib_listParam.value);
        CaptureTexStorageAttribs2DEXT_attrib_list(glState, isCallValid, target, levels,
                                                  internalformat, width, height, attrib_list,
                                                  &attrib_listParam);
        paramBuffer.addParam(std::move(attrib_listParam));
    }
    else
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &attrib_listParam.value);
        paramBuffer.addParam(std::move(attrib_listParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageAttribs2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageAttribs3DEXT(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          const GLint *attrib_list)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    if (isCallValid)
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, attrib_list, &attrib_listParam.value);
        CaptureTexStorageAttribs3DEXT_attrib_list(glState, isCallValid, target, levels,
                                                  internalformat, width, height, depth, attrib_list,
                                                  &attrib_listParam);
        paramBuffer.addParam(std::move(attrib_listParam));
    }
    else
    {
        ParamCapture attrib_listParam("attrib_list", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &attrib_listParam.value);
        paramBuffer.addParam(std::move(attrib_listParam));
    }

    return CallCapture(angle::EntryPoint::GLTexStorageAttribs3DEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendBarrierKHR(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLBlendBarrierKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallbackKHR(const State &glState,
                                           bool isCallValid,
                                           GLDEBUGPROCKHR callback,
                                           const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROCKHR, callback);

    if (isCallValid)
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
        CaptureDebugMessageCallbackKHR_userParam(glState, isCallValid, callback, userParam,
                                                 &userParamParam);
        paramBuffer.addParam(std::move(userParamParam));
    }
    else
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &userParamParam.value);
        paramBuffer.addParam(std::move(userParamParam));
    }

    return CallCapture(angle::EntryPoint::GLDebugMessageCallbackKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControlKHR(const State &glState,
                                          bool isCallValid,
                                          GLenum source,
                                          GLenum type,
                                          GLenum severity,
                                          GLsizei count,
                                          const GLuint *ids,
                                          GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLESEnum::DebugType, ParamType::TGLenum, type);
    paramBuffer.addEnumParam("severity", GLESEnum::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
        CaptureDebugMessageControlKHR_ids(glState, isCallValid, source, type, severity, count, ids,
                                          enabled, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture(angle::EntryPoint::GLDebugMessageControlKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsertKHR(const State &glState,
                                         bool isCallValid,
                                         GLenum source,
                                         GLenum type,
                                         GLuint id,
                                         GLenum severity,
                                         GLsizei length,
                                         const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLESEnum::DebugType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("severity", GLESEnum::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
        CaptureDebugMessageInsertKHR_buf(glState, isCallValid, source, type, id, severity, length,
                                         buf, &bufParam);
        paramBuffer.addParam(std::move(bufParam));
    }
    else
    {
        ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &bufParam.value);
        paramBuffer.addParam(std::move(bufParam));
    }

    return CallCapture(angle::EntryPoint::GLDebugMessageInsertKHR, std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLogKHR(const State &glState,
                                         bool isCallValid,
                                         GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog,
                                         GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
        CaptureGetDebugMessageLogKHR_sources(glState, isCallValid, count, bufSize, sources, types,
                                             ids, severities, lengths, messageLog, &sourcesParam);
        paramBuffer.addParam(std::move(sourcesParam));
    }
    else
    {
        ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &sourcesParam.value);
        paramBuffer.addParam(std::move(sourcesParam));
    }

    if (isCallValid)
    {
        ParamCapture typesParam("types", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
        CaptureGetDebugMessageLogKHR_types(glState, isCallValid, count, bufSize, sources, types,
                                           ids, severities, lengths, messageLog, &typesParam);
        paramBuffer.addParam(std::move(typesParam));
    }
    else
    {
        ParamCapture typesParam("types", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &typesParam.value);
        paramBuffer.addParam(std::move(typesParam));
    }

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
        CaptureGetDebugMessageLogKHR_ids(glState, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    if (isCallValid)
    {
        ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
        CaptureGetDebugMessageLogKHR_severities(glState, isCallValid, count, bufSize, sources,
                                                types, ids, severities, lengths, messageLog,
                                                &severitiesParam);
        paramBuffer.addParam(std::move(severitiesParam));
    }
    else
    {
        ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &severitiesParam.value);
        paramBuffer.addParam(std::move(severitiesParam));
    }

    if (isCallValid)
    {
        ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
        CaptureGetDebugMessageLogKHR_lengths(glState, isCallValid, count, bufSize, sources, types,
                                             ids, severities, lengths, messageLog, &lengthsParam);
        paramBuffer.addParam(std::move(lengthsParam));
    }
    else
    {
        ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthsParam.value);
        paramBuffer.addParam(std::move(lengthsParam));
    }

    if (isCallValid)
    {
        ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
        CaptureGetDebugMessageLogKHR_messageLog(glState, isCallValid, count, bufSize, sources,
                                                types, ids, severities, lengths, messageLog,
                                                &messageLogParam);
        paramBuffer.addParam(std::move(messageLogParam));
    }
    else
    {
        ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &messageLogParam.value);
        paramBuffer.addParam(std::move(messageLogParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetDebugMessageLogKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabelKHR(const State &glState,
                                     bool isCallValid,
                                     GLenum identifier,
                                     GLuint name,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLESEnum::AllEnums, ParamType::TGLenum, identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectLabelKHR_length(glState, isCallValid, identifier, name, bufSize, length,
                                        label, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectLabelKHR_label(glState, isCallValid, identifier, name, bufSize, length,
                                       label, &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLGetObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabelKHR(const State &glState,
                                        bool isCallValid,
                                        const void *ptr,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *label)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureGetObjectPtrLabelKHR_ptr(glState, isCallValid, ptr, bufSize, length, label,
                                        &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectPtrLabelKHR_length(glState, isCallValid, ptr, bufSize, length, label,
                                           &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectPtrLabelKHR_label(glState, isCallValid, ptr, bufSize, length, label,
                                          &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLGetObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetPointervKHR(const State &glState,
                                  bool isCallValid,
                                  GLenum pname,
                                  void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointervKHR_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetPointervKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectLabelKHR(const State &glState,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLESEnum::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectLabelKHR_label(glState, isCallValid, identifier, name, length, label,
                                    &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabelKHR(const State &glState,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei length,
                                     const GLchar *label)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureObjectPtrLabelKHR_ptr(glState, isCallValid, ptr, length, label, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectPtrLabelKHR_label(glState, isCallValid, ptr, length, label, &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(angle::EntryPoint::GLObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CapturePopDebugGroupKHR(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CapturePushDebugGroupKHR(const State &glState,
                                     bool isCallValid,
                                     GLenum source,
                                     GLuint id,
                                     GLsizei length,
                                     const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLESEnum::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
        CapturePushDebugGroupKHR_message(glState, isCallValid, source, id, length, message,
                                         &messageParam);
        paramBuffer.addParam(std::move(messageParam));
    }
    else
    {
        ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &messageParam.value);
        paramBuffer.addParam(std::move(messageParam));
    }

    return CallCapture(angle::EntryPoint::GLPushDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CaptureMaxShaderCompilerThreadsKHR(const State &glState, bool isCallValid, GLuint count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);

    return CallCapture(angle::EntryPoint::GLMaxShaderCompilerThreadsKHR, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatusKHR(const State &glState,
                                             bool isCallValid,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetGraphicsResetStatusKHR, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvKHR(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfvKHR_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformfvKHR, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivKHR(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformivKHR_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformivKHR, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuivKHR(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei bufSize,
                                     GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetnUniformuivKHR_params(glState, isCallValid, programPacked, locationPacked,
                                        bufSize, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetnUniformuivKHR, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsKHR(const State &glState,
                                  bool isCallValid,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixelsKHR_data(glState, isCallValid, x, y, width, height, format, type, bufSize,
                                   data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLReadnPixelsKHR, std::move(paramBuffer));
}

CallCapture CaptureFramebufferParameteriMESA(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum pname,
                                             GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::FramebufferParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLFramebufferParameteriMESA, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameterivMESA(const State &glState,
                                                 bool isCallValid,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferParameterivMESA_params(glState, isCallValid, target, pname, params,
                                                    &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferParameterivMESA, std::move(paramBuffer));
}

CallCapture CaptureDeleteFencesNV(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDConstPointer);
        InitParamValue(ParamType::TFenceNVIDConstPointer, fencesPacked, &fencesPackedParam.value);
        CaptureDeleteFencesNV_fencesPacked(glState, isCallValid, n, fencesPacked,
                                           &fencesPackedParam);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }
    else
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDConstPointer);
        InitParamValue(ParamType::TFenceNVIDConstPointer, static_cast<const FenceNVID *>(nullptr),
                       &fencesPackedParam.value);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteFencesNV, std::move(paramBuffer));
}

CallCapture CaptureFinishFenceNV(const State &glState, bool isCallValid, FenceNVID fencePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    return CallCapture(angle::EntryPoint::GLFinishFenceNV, std::move(paramBuffer));
}

CallCapture CaptureGenFencesNV(const State &glState,
                               bool isCallValid,
                               GLsizei n,
                               FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDPointer);
        InitParamValue(ParamType::TFenceNVIDPointer, fencesPacked, &fencesPackedParam.value);
        CaptureGenFencesNV_fencesPacked(glState, isCallValid, n, fencesPacked, &fencesPackedParam);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }
    else
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDPointer);
        InitParamValue(ParamType::TFenceNVIDPointer, static_cast<FenceNVID *>(nullptr),
                       &fencesPackedParam.value);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenFencesNV, std::move(paramBuffer));
}

CallCapture CaptureGetFenceivNV(const State &glState,
                                bool isCallValid,
                                FenceNVID fencePacked,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFenceivNV_params(glState, isCallValid, fencePacked, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFenceivNV, std::move(paramBuffer));
}

CallCapture CaptureIsFenceNV(const State &glState,
                             bool isCallValid,
                             FenceNVID fencePacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsFenceNV, std::move(paramBuffer));
}

CallCapture CaptureSetFenceNV(const State &glState,
                              bool isCallValid,
                              FenceNVID fencePacked,
                              GLenum condition)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("condition", GLESEnum::AllEnums, ParamType::TGLenum, condition);

    return CallCapture(angle::EntryPoint::GLSetFenceNV, std::move(paramBuffer));
}

CallCapture CaptureTestFenceNV(const State &glState,
                               bool isCallValid,
                               FenceNVID fencePacked,
                               GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLTestFenceNV, std::move(paramBuffer));
}

CallCapture CaptureBlitFramebufferNV(const State &glState,
                                     bool isCallValid,
                                     GLint srcX0,
                                     GLint srcY0,
                                     GLint srcX1,
                                     GLint srcY1,
                                     GLint dstX0,
                                     GLint dstY0,
                                     GLint dstX1,
                                     GLint dstY1,
                                     GLbitfield mask,
                                     GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", GLESEnum::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", GLESEnum::BlitFramebufferFilter, ParamType::TGLenum, filter);

    return CallCapture(angle::EntryPoint::GLBlitFramebufferNV, std::move(paramBuffer));
}

CallCapture CapturePolygonModeNV(const State &glState,
                                 bool isCallValid,
                                 GLenum face,
                                 PolygonMode modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("modePacked", ParamType::TPolygonMode, modePacked);

    return CallCapture(angle::EntryPoint::GLPolygonModeNV, std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetRenderbufferStorageOES(const State &glState,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        egl::ImageID imagePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);

    return CallCapture(angle::EntryPoint::GLEGLImageTargetRenderbufferStorageOES,
                       std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetTexture2DOES(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              egl::ImageID imagePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);

    return CallCapture(angle::EntryPoint::GLEGLImageTargetTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationOES(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBlendEquationOES, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubDataOES(const State &glState,
                                       bool isCallValid,
                                       GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLESEnum::CopyBufferSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLESEnum::CopyBufferSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(angle::EntryPoint::GLCopyImageSubDataOES, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparateiOES(const State &glState,
                                             bool isCallValid,
                                             GLuint buf,
                                             GLenum modeRGB,
                                             GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(angle::EntryPoint::GLBlendEquationSeparateiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationiOES(const State &glState,
                                     bool isCallValid,
                                     GLuint buf,
                                     GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBlendEquationiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparateiOES(const State &glState,
                                         bool isCallValid,
                                         GLuint buf,
                                         GLenum srcRGB,
                                         GLenum dstRGB,
                                         GLenum srcAlpha,
                                         GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLESEnum::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(angle::EntryPoint::GLBlendFuncSeparateiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendFunciOES(const State &glState,
                                 bool isCallValid,
                                 GLuint buf,
                                 GLenum src,
                                 GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLESEnum::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLESEnum::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(angle::EntryPoint::GLBlendFunciOES, std::move(paramBuffer));
}

CallCapture CaptureColorMaskiOES(const State &glState,
                                 bool isCallValid,
                                 GLuint index,
                                 GLboolean r,
                                 GLboolean g,
                                 GLboolean b,
                                 GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(angle::EntryPoint::GLColorMaskiOES, std::move(paramBuffer));
}

CallCapture CaptureDisableiOES(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLDisableiOES, std::move(paramBuffer));
}

CallCapture CaptureEnableiOES(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEnableiOES, std::move(paramBuffer));
}

CallCapture CaptureIsEnablediOES(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsEnablediOES, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertexOES(const State &glState,
                                             bool isCallValid,
                                             PrimitiveMode modePacked,
                                             GLsizei count,
                                             DrawElementsType typePacked,
                                             const void *indices,
                                             GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsBaseVertexOES_indices(glState, isCallValid, modePacked, count,
                                                 typePacked, indices, basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsBaseVertexOES, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexOES(const State &glState,
                                                      bool isCallValid,
                                                      PrimitiveMode modePacked,
                                                      GLsizei count,
                                                      DrawElementsType typePacked,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexOES_indices(glState, isCallValid, modePacked, count,
                                                          typePacked, indices, instancecount,
                                                          basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstancedBaseVertexOES,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertexOES(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  DrawElementsType typePacked,
                                                  const void *indices,
                                                  GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElementsBaseVertexOES_indices(glState, isCallValid, modePacked, start, end,
                                                      count, typePacked, indices, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(angle::EntryPoint::GLDrawRangeElementsBaseVertexOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfOES(const State &glState,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z,
                               GLfloat width,
                               GLfloat height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);
    paramBuffer.addValueParam("height", ParamType::TGLfloat, height);

    return CallCapture(angle::EntryPoint::GLDrawTexfOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfvOES(const State &glState, bool isCallValid, const GLfloat *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, coords, &coordsParam.value);
        CaptureDrawTexfvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawTexfvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexiOES(const State &glState,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLint z,
                               GLint width,
                               GLint height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);

    return CallCapture(angle::EntryPoint::GLDrawTexiOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexivOES(const State &glState, bool isCallValid, const GLint *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, coords, &coordsParam.value);
        CaptureDrawTexivOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawTexivOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsOES(const State &glState,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z,
                               GLshort width,
                               GLshort height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("width", ParamType::TGLshort, width);
    paramBuffer.addValueParam("height", ParamType::TGLshort, height);

    return CallCapture(angle::EntryPoint::GLDrawTexsOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsvOES(const State &glState, bool isCallValid, const GLshort *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, coords, &coordsParam.value);
        CaptureDrawTexsvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawTexsvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxOES(const State &glState,
                               bool isCallValid,
                               GLfixed x,
                               GLfixed y,
                               GLfixed z,
                               GLfixed width,
                               GLfixed height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);
    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);
    paramBuffer.addValueParam("height", ParamType::TGLfixed, height);

    return CallCapture(angle::EntryPoint::GLDrawTexxOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxvOES(const State &glState, bool isCallValid, const GLfixed *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, coords, &coordsParam.value);
        CaptureDrawTexxvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawTexxvOES, std::move(paramBuffer));
}

CallCapture CaptureBindFramebufferOES(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      FramebufferID framebufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    return CallCapture(angle::EntryPoint::GLBindFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureBindRenderbufferOES(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLBindRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatusOES(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCheckFramebufferStatusOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffersOES(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         const FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDConstPointer);
        InitParamValue(ParamType::TFramebufferIDConstPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureDeleteFramebuffersOES_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                                        &framebuffersPackedParam);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }
    else
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDConstPointer);
        InitParamValue(ParamType::TFramebufferIDConstPointer,
                       static_cast<const FramebufferID *>(nullptr), &framebuffersPackedParam.value);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffersOES(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDConstPointer);
        InitParamValue(ParamType::TRenderbufferIDConstPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureDeleteRenderbuffersOES_renderbuffersPacked(
            glState, isCallValid, n, renderbuffersPacked, &renderbuffersPackedParam);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }
    else
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDConstPointer);
        InitParamValue(ParamType::TRenderbufferIDConstPointer,
                       static_cast<const RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbufferOES(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLESEnum::RenderbufferTarget, ParamType::TGLenum,
                             renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLFramebufferRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DOES(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffersOES(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDPointer);
        InitParamValue(ParamType::TFramebufferIDPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureGenFramebuffersOES_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                                     &framebuffersPackedParam);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }
    else
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDPointer);
        InitParamValue(ParamType::TFramebufferIDPointer, static_cast<FramebufferID *>(nullptr),
                       &framebuffersPackedParam.value);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffersOES(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureGenRenderbuffersOES_renderbuffersPacked(glState, isCallValid, n, renderbuffersPacked,
                                                       &renderbuffersPackedParam);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }
    else
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, static_cast<RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmapOES(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(angle::EntryPoint::GLGenerateMipmapOES, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivOES(const State &glState,
                                                          bool isCallValid,
                                                          GLenum target,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLESEnum::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferAttachmentParameterivOES_params(
            glState, isCallValid, target, attachment, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferAttachmentParameterivOES,
                       std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivOES(const State &glState,
                                                 bool isCallValid,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetRenderbufferParameterivOES_params(glState, isCallValid, target, pname, params,
                                                    &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetRenderbufferParameterivOES, std::move(paramBuffer));
}

CallCapture CaptureIsFramebufferOES(const State &glState,
                                    bool isCallValid,
                                    FramebufferID framebufferPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureIsRenderbufferOES(const State &glState,
                                     bool isCallValid,
                                     RenderbufferID renderbufferPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageOES(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLRenderbufferStorageOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureOES(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum attachment,
                                         TextureID texturePacked,
                                         GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTextureOES, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinaryOES(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLenum *binaryFormat,
                                       void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramBinaryOES_length(glState, isCallValid, programPacked, bufSize, length,
                                          binaryFormat, binary, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
        CaptureGetProgramBinaryOES_binaryFormat(glState, isCallValid, programPacked, bufSize,
                                                length, binaryFormat, binary, &binaryFormatParam);
        paramBuffer.addParam(std::move(binaryFormatParam));
    }
    else
    {
        ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &binaryFormatParam.value);
        paramBuffer.addParam(std::move(binaryFormatParam));
    }

    if (isCallValid)
    {
        ParamCapture binaryParam("binary", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
        CaptureGetProgramBinaryOES_binary(glState, isCallValid, programPacked, bufSize, length,
                                          binaryFormat, binary, &binaryParam);
        paramBuffer.addParam(std::move(binaryParam));
    }
    else
    {
        ParamCapture binaryParam("binary", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &binaryParam.value);
        paramBuffer.addParam(std::move(binaryParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureProgramBinaryOES(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLenum binaryFormat,
                                    const void *binary,
                                    GLint length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("binaryFormat", GLESEnum::AllEnums, ParamType::TGLenum, binaryFormat);

    if (isCallValid)
    {
        ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
        CaptureProgramBinaryOES_binary(glState, isCallValid, programPacked, binaryFormat, binary,
                                       length, &binaryParam);
        paramBuffer.addParam(std::move(binaryParam));
    }
    else
    {
        ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &binaryParam.value);
        paramBuffer.addParam(std::move(binaryParam));
    }

    paramBuffer.addValueParam("length", ParamType::TGLint, length);

    return CallCapture(angle::EntryPoint::GLProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervOES(const State &glState,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetBufferPointervOES_params(glState, isCallValid, targetPacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBufferPointervOES, std::move(paramBuffer));
}

CallCapture CaptureMapBufferOES(const State &glState,
                                bool isCallValid,
                                BufferBinding targetPacked,
                                GLenum access,
                                void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("access", GLESEnum::BufferAccessARB, ParamType::TGLenum, access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureUnmapBufferOES(const State &glState,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLUnmapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureCurrentPaletteMatrixOES(const State &glState,
                                           bool isCallValid,
                                           GLuint matrixpaletteindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixpaletteindex", ParamType::TGLuint, matrixpaletteindex);

    return CallCapture(angle::EntryPoint::GLCurrentPaletteMatrixOES, std::move(paramBuffer));
}

CallCapture CaptureLoadPaletteFromModelViewMatrixOES(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLLoadPaletteFromModelViewMatrixOES,
                       std::move(paramBuffer));
}

CallCapture CaptureMatrixIndexPointerOES(const State &glState,
                                         bool isCallValid,
                                         GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureMatrixIndexPointerOES_pointer(glState, isCallValid, size, type, stride, pointer,
                                             &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLMatrixIndexPointerOES, std::move(paramBuffer));
}

CallCapture CaptureWeightPointerOES(const State &glState,
                                    bool isCallValid,
                                    GLint size,
                                    GLenum type,
                                    GLsizei stride,
                                    const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLESEnum::AllEnums, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureWeightPointerOES_pointer(glState, isCallValid, size, type, stride, pointer,
                                        &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLWeightPointerOES, std::move(paramBuffer));
}

CallCapture CapturePointSizePointerOES(const State &glState,
                                       bool isCallValid,
                                       VertexAttribType typePacked,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CapturePointSizePointerOES_pointer(glState, isCallValid, typePacked, stride, pointer,
                                           &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLPointSizePointerOES, std::move(paramBuffer));
}

CallCapture CapturePrimitiveBoundingBoxOES(const State &glState,
                                           bool isCallValid,
                                           GLfloat minX,
                                           GLfloat minY,
                                           GLfloat minZ,
                                           GLfloat minW,
                                           GLfloat maxX,
                                           GLfloat maxY,
                                           GLfloat maxZ,
                                           GLfloat maxW)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("minX", ParamType::TGLfloat, minX);
    paramBuffer.addValueParam("minY", ParamType::TGLfloat, minY);
    paramBuffer.addValueParam("minZ", ParamType::TGLfloat, minZ);
    paramBuffer.addValueParam("minW", ParamType::TGLfloat, minW);
    paramBuffer.addValueParam("maxX", ParamType::TGLfloat, maxX);
    paramBuffer.addValueParam("maxY", ParamType::TGLfloat, maxY);
    paramBuffer.addValueParam("maxZ", ParamType::TGLfloat, maxZ);
    paramBuffer.addValueParam("maxW", ParamType::TGLfloat, maxW);

    return CallCapture(angle::EntryPoint::GLPrimitiveBoundingBoxOES, std::move(paramBuffer));
}

CallCapture CaptureQueryMatrixxOES(const State &glState,
                                   bool isCallValid,
                                   GLfixed *mantissa,
                                   GLint *exponent,
                                   GLbitfield returnValue)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, mantissa, &mantissaParam.value);
        CaptureQueryMatrixxOES_mantissa(glState, isCallValid, mantissa, exponent, &mantissaParam);
        paramBuffer.addParam(std::move(mantissaParam));
    }
    else
    {
        ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &mantissaParam.value);
        paramBuffer.addParam(std::move(mantissaParam));
    }

    if (isCallValid)
    {
        ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, exponent, &exponentParam.value);
        CaptureQueryMatrixxOES_exponent(glState, isCallValid, mantissa, exponent, &exponentParam);
        paramBuffer.addParam(std::move(exponentParam));
    }
    else
    {
        ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &exponentParam.value);
        paramBuffer.addParam(std::move(exponentParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLbitfield);
    InitParamValue(ParamType::TGLbitfield, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLQueryMatrixxOES, std::move(paramBuffer));
}

CallCapture CaptureMinSampleShadingOES(const State &glState, bool isCallValid, GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(angle::EntryPoint::GLMinSampleShadingOES, std::move(paramBuffer));
}

CallCapture CapturePatchParameteriOES(const State &glState,
                                      bool isCallValid,
                                      GLenum pname,
                                      GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::PatchParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(angle::EntryPoint::GLPatchParameteriOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DOES(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage3DOES_data(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, depth, border, imageSize,
                                            data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DOES(const State &glState,
                                              bool isCallValid,
                                              TextureTarget targetPacked,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLsizei imageSize,
                                              const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage3DOES_data(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, zoffset, width, height, depth, format,
                                               imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3DOES(const State &glState,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLCopyTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture3DOES(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level,
                                           GLint zoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DOES(const State &glState,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLint border,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage3DOES_pixels(glState, isCallValid, targetPacked, level, internalformat,
                                    width, height, depth, border, format, type, pixels,
                                    &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DOES(const State &glState,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage3DOES_pixels(glState, isCallValid, targetPacked, level, xoffset, yoffset,
                                       zoffset, width, height, depth, format, type, pixels,
                                       &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivOES(const State &glState,
                                             bool isCallValid,
                                             SamplerID samplerPacked,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIivOES_params(glState, isCallValid, samplerPacked, pname, params,
                                                &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivOES(const State &glState,
                                              bool isCallValid,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuivOES_params(glState, isCallValid, samplerPacked, pname, params,
                                                 &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivOES(const State &glState,
                                         bool isCallValid,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIivOES_params(glState, isCallValid, targetPacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivOES(const State &glState,
                                          bool isCallValid,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuivOES_params(glState, isCallValid, targetPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivOES(const State &glState,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIivOES_param(glState, isCallValid, samplerPacked, pname, param,
                                            &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivOES(const State &glState,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuivOES_param(glState, isCallValid, samplerPacked, pname, param,
                                             &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLSamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivOES(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIivOES_params(glState, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivOES(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuivOES_params(glState, isCallValid, targetPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureTexBufferOES(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLenum internalformat,
                                BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLTexBufferOES, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRangeOES(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum internalformat,
                                     BufferID bufferPacked,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLTexBufferRangeOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenfvOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexGenfvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenivOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexGenivOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenxvOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetTexGenxvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLTexGenfOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfvOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexGenfvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGeniOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLTexGeniOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenivOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexGenivOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLTexGenxOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxvOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLESEnum::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CaptureTexGenxvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisampleOES(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexStorage3DMultisampleOES, std::move(paramBuffer));
}

CallCapture CaptureBindVertexArrayOES(const State &glState,
                                      bool isCallValid,
                                      VertexArrayID arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    return CallCapture(angle::EntryPoint::GLBindVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArraysOES(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         const VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
        InitParamValue(ParamType::TVertexArrayIDConstPointer, arraysPacked,
                       &arraysPackedParam.value);
        CaptureDeleteVertexArraysOES_arraysPacked(glState, isCallValid, n, arraysPacked,
                                                  &arraysPackedParam);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }
    else
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
        InitParamValue(ParamType::TVertexArrayIDConstPointer,
                       static_cast<const VertexArrayID *>(nullptr), &arraysPackedParam.value);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureGenVertexArraysOES(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, arraysPacked, &arraysPackedParam.value);
        CaptureGenVertexArraysOES_arraysPacked(glState, isCallValid, n, arraysPacked,
                                               &arraysPackedParam);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }
    else
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, static_cast<VertexArrayID *>(nullptr),
                       &arraysPackedParam.value);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureIsVertexArrayOES(const State &glState,
                                    bool isCallValid,
                                    VertexArrayID arrayPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureMultiviewOVR(const State &glState,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  TextureID texturePacked,
                                                  GLint level,
                                                  GLint baseViewIndex,
                                                  GLsizei numViews)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("baseViewIndex", ParamType::TGLint, baseViewIndex);
    paramBuffer.addValueParam("numViews", ParamType::TGLsizei, numViews);

    return CallCapture(angle::EntryPoint::GLFramebufferTextureMultiviewOVR, std::move(paramBuffer));
}

CallCapture CaptureFramebufferFoveationConfigQCOM(const State &glState,
                                                  bool isCallValid,
                                                  FramebufferID framebufferPacked,
                                                  GLuint numLayers,
                                                  GLuint focalPointsPerLayer,
                                                  GLuint requestedFeatures,
                                                  GLuint *providedFeatures)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addValueParam("numLayers", ParamType::TGLuint, numLayers);
    paramBuffer.addValueParam("focalPointsPerLayer", ParamType::TGLuint, focalPointsPerLayer);
    paramBuffer.addValueParam("requestedFeatures", ParamType::TGLuint, requestedFeatures);

    if (isCallValid)
    {
        ParamCapture providedFeaturesParam("providedFeatures", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, providedFeatures, &providedFeaturesParam.value);
        CaptureFramebufferFoveationConfigQCOM_providedFeatures(
            glState, isCallValid, framebufferPacked, numLayers, focalPointsPerLayer,
            requestedFeatures, providedFeatures, &providedFeaturesParam);
        paramBuffer.addParam(std::move(providedFeaturesParam));
    }
    else
    {
        ParamCapture providedFeaturesParam("providedFeatures", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &providedFeaturesParam.value);
        paramBuffer.addParam(std::move(providedFeaturesParam));
    }

    return CallCapture(angle::EntryPoint::GLFramebufferFoveationConfigQCOM, std::move(paramBuffer));
}

CallCapture CaptureFramebufferFoveationParametersQCOM(const State &glState,
                                                      bool isCallValid,
                                                      FramebufferID framebufferPacked,
                                                      GLuint layer,
                                                      GLuint focalPoint,
                                                      GLfloat focalX,
                                                      GLfloat focalY,
                                                      GLfloat gainX,
                                                      GLfloat gainY,
                                                      GLfloat foveaArea)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);
    paramBuffer.addValueParam("layer", ParamType::TGLuint, layer);
    paramBuffer.addValueParam("focalPoint", ParamType::TGLuint, focalPoint);
    paramBuffer.addValueParam("focalX", ParamType::TGLfloat, focalX);
    paramBuffer.addValueParam("focalY", ParamType::TGLfloat, focalY);
    paramBuffer.addValueParam("gainX", ParamType::TGLfloat, gainX);
    paramBuffer.addValueParam("gainY", ParamType::TGLfloat, gainY);
    paramBuffer.addValueParam("foveaArea", ParamType::TGLfloat, foveaArea);

    return CallCapture(angle::EntryPoint::GLFramebufferFoveationParametersQCOM,
                       std::move(paramBuffer));
}

CallCapture CaptureShadingRateQCOM(const State &glState, bool isCallValid, GLenum rate)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("rate", GLESEnum::ShadingRateQCOM, ParamType::TGLenum, rate);

    return CallCapture(angle::EntryPoint::GLShadingRateQCOM, std::move(paramBuffer));
}

CallCapture CaptureTextureFoveationParametersQCOM(const State &glState,
                                                  bool isCallValid,
                                                  TextureID texturePacked,
                                                  GLuint layer,
                                                  GLuint focalPoint,
                                                  GLfloat focalX,
                                                  GLfloat focalY,
                                                  GLfloat gainX,
                                                  GLfloat gainY,
                                                  GLfloat foveaArea)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("layer", ParamType::TGLuint, layer);
    paramBuffer.addValueParam("focalPoint", ParamType::TGLuint, focalPoint);
    paramBuffer.addValueParam("focalX", ParamType::TGLfloat, focalX);
    paramBuffer.addValueParam("focalY", ParamType::TGLfloat, focalY);
    paramBuffer.addValueParam("gainX", ParamType::TGLfloat, gainX);
    paramBuffer.addValueParam("gainY", ParamType::TGLfloat, gainY);
    paramBuffer.addValueParam("foveaArea", ParamType::TGLfloat, foveaArea);

    return CallCapture(angle::EntryPoint::GLTextureFoveationParametersQCOM, std::move(paramBuffer));
}

CallCapture CaptureEndTilingQCOM(const State &glState, bool isCallValid, GLbitfield preserveMask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("preserveMask", GLESEnum::BufferBitQCOM, ParamType::TGLbitfield,
                             preserveMask);

    return CallCapture(angle::EntryPoint::GLEndTilingQCOM, std::move(paramBuffer));
}

CallCapture CaptureStartTilingQCOM(const State &glState,
                                   bool isCallValid,
                                   GLuint x,
                                   GLuint y,
                                   GLuint width,
                                   GLuint height,
                                   GLbitfield preserveMask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLuint, x);
    paramBuffer.addValueParam("y", ParamType::TGLuint, y);
    paramBuffer.addValueParam("width", ParamType::TGLuint, width);
    paramBuffer.addValueParam("height", ParamType::TGLuint, height);
    paramBuffer.addEnumParam("preserveMask", GLESEnum::BufferBitQCOM, ParamType::TGLbitfield,
                             preserveMask);

    return CallCapture(angle::EntryPoint::GLStartTilingQCOM, std::move(paramBuffer));
}

CallCapture CaptureFramebufferResolveRenderbufferWEBKIT(const State &glState,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum renderbuffertarget,
                                                        RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::AllEnums, ParamType::TGLenum, attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLESEnum::AllEnums, ParamType::TGLenum,
                             renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLFramebufferResolveRenderbufferWEBKIT,
                       std::move(paramBuffer));
}

}  // namespace gl
