---
myst:
  html_meta:
    keywords: LaTeX, R, Quarto, statistiques
---

# Comment organiser du travail ?

Pour un travail simple tout peut être (et doit) être dans un seul fichier. Pour
un travail plus complexe ce fichier deviendrait trop lourd, illisible. De plus,
si le travail produit plusieurs documents (un rapport intermédiaire, un final,
etc.) avoir un en-tête commun permet d'uniformiser les sorties (police, page de
titre, etc.)

On aura typiquement trois voire quatre fichiers :

1. un contenant l'en-tête, écrit principalement en `yaml` (voir
   [l'en-tête](/4_domaines_specialises/sciences/statistiques/R/trucslatex)) ;
2. un document (`_quarto.yml`) avec le code LaTeX présent dans
   l'en-tête. Uniquement si ce code est long, sinon il prend place directement
   dans l'en-tête en `yaml` ;
3. un fichier `R` contenant l'import ainsi que la mise en forme des données qui
   pourra servir pour plusieurs documents ;
4. le ou les documents de travail eux-mêmes en `Quarto`, allégés de l'en-tête et
   de la mise en forme des données.

## Import

Prenons le cas de données dans un fichier `.csv`. Le travail va consister à les
importer, mettre en forme les titres mais aussi certaines variables puis
exporter le résultat en format `Rdata` pour pouvoir l'utiliser dans les divers
documents.

```r
import <- function() {
library(tidyverse)
library(janitor)
...
tt <- read.csv("datas/mesdonnees.csv") |>
    clean_names() |>
...
save(tt, file = "datas/mesdonnees.Rdata")
}
```

Ensuite, dans chaque document, on écrira dans un premier chunk :


```r
load("datas/mesdonnees.Rdata")
```

## Dossier de travail

Votre dossier de travail (ou projet) pourrait ressembler à ceci :

```
monprojet/
├── docs/
│   ├── projet.pdf
│   └── liste_variables.pdf
├── datas/
│   ├── mesdonnees.csv
│   ├── mesdonnees.Rdata
│   └── reserve
│        └──mesdonnees.xlsx
├── _quarto.yml
├── mesreglages.tex
├── rapport.qmd
└── rapport2.qmd
```
