---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, tabulations.
---

# Comment définir des tabulations ?

L'environnement `tabbing` permet de placer des marques d'alignement 
dans un texte :
- la commande `\=` place des taquets de tabulation ;
- la commande `\>` applique les tabulations en fonction des taquets 
  prédéfinis ;
- la commande `\kill` n'affiche pas la ligne courante (cette ligne permet 
  alors en général de définir les taquets).

L'utilisation de cet environnement est développée dans la section dédiée aux 
[tabulations](/3_composition/tableaux/tabulations/composer_un_tableau_avec_des_tabulations).

En voici un exemple dans lequel notre code exacerbe les espaces 
pour mieux repérer les tabulations et alignements associés.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabbing}
Voici \= des      \= marques   \= de tabulation.         \\
      \> Là, je m'aligne sur la première.                \\
      \>          \>           \> Là, sur la troisième.  \\ 
\hspace{3cm}    \= \hspace{2cm}    \=                    \kill
Un              \> autre           \> exemple.
\end{tabbing}
\end{document}
```