---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, syntaxe, 
              thèse, mémoire
---

# Comment faire référence à une thèse française ou un mémoire en bibliographie ?

## Avec BibTeX 

Il faut utiliser une entrée de type `\@phdthesis`.

Se pose alors le problème de la traduction en français 
du style bibliographique. Vous pouvez ici consulter la question
"[](/3_composition/annexes/bibliographie/style_bst/bibliographies_internationales)".


## Avec [BibLaTeX](ctanpkg:biblatex)

Plusieurs types d'entrée permettent de répondre à la question.

  - `bathesis` pour les mémoires de licence (*bachelor’s thesis*) ;
  - `mathesis` pour les mémoires de maîtrise (*master’s thesis*) ;
  - `phdthesis` pour les thèses de doctorat (*PhD thesis*, *PhD dissertation*,
    *doctoral thesis*, etc) ;
  - `candthesis` qui sert pour les *candidate thesis* dans le monde anglophone
    pour des diplômes dont le niveau n'est pas précis (entre la maîtrise et le
    doctorat).

Le dernier type permet, par un jeu de rédéfinition de libellé avec la commande
`\DefineBibliographyStrings`, de pouvoir par exemple gérer une thèse 
de troisième cycle, comme le fait l'exemple suivant. Cette commande peut,
bien entendu, être utilisée pour d'autres types.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @thesis{licence,
    title = {Les coccinelles},
    author = {Fernand, Jules},
    type = {bathesis} 
  }
  @thesis{maitrise,
    title = {Les coccinelles, une passion dévorante},
    author = {Fernand, Jules},
    type = {mathesis}
  }
  @thesis{cycle,
    title = {Les coccinelles, une vraie croisade},
    author = {Fernand, Jules},
    type = {candthesis}
  }
  @thesis{doctorat,
    title = {La maladie de Jules Fernand},
    author = {Gabrielle, Alice},
    type = {phdthesis}
  }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{filecontents}   % Inclusion de fichier dans le document
  \usepackage{csquotes}       % Guillemets français dans la bibliographie
  \usepackage{biblatex}
  \addbibresource{mabiblio.bib}
  \nocite{*}

  % Redéfinitions de libellés
  \DefineBibliographyStrings{french}{bathesis = {mém. de licence}}
  \DefineBibliographyStrings{french}{candthesis = {thèse de 3\ieme{} cycle}}

\begin{document}
\printbibliography
\thispagestyle{empty}
\end{document}
```


:::{sources}
- [Bibtex : thèse de troisième cycle](https://texnique.fr/osqa/questions/5661/bibtex-these-de-troisieme-cycle), 
  sur [TeXnique.fr](https://texnique.fr/)
:::