use desktop_edit::Desktop;
use std::str::FromStr;

fn main() {
    let input = r###"[Desktop Entry]
Name=Example Application
Type=Application
Exec=example
# This is a comment
Icon=example.png
"###;

    println!("Input:\n{}", input);
    println!("\nParsing...");
    match Desktop::from_str(input) {
        Ok(desktop) => {
            println!("Success! Groups: {}", desktop.groups().count());
            for group in desktop.groups() {
                println!("Group: {:?}", group.name());
            }
        }
        Err(e) => {
            println!("Error: {}", e);
        }
    }
}
