% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{delete_rows}
\alias{delete_rows}
\title{Delete flextable rows}
\usage{
delete_rows(x, i = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
The function removes one or more rows
from a 'flextable'.
}
\details{
Deleting one or more rows will result in the deletion
of any span parameters that may have been set previously.
They will have to be redone after this operation or
performed only after this deletion.
}
\examples{
ft <- flextable(head(iris))
ft <- delete_rows(ft, i = 1:5, part = "body")
ft
}
