% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkAccess.R
\name{checkAccess}
\alias{checkAccess}
\alias{check_access}
\alias{assertAccess}
\alias{assert_access}
\alias{testAccess}
\alias{test_access}
\alias{expect_access}
\title{Check file system access rights}
\usage{
checkAccess(x, access = "")

check_access(x, access = "")

assertAccess(x, access = "", .var.name = vname(x), add = NULL)

assert_access(x, access = "", .var.name = vname(x), add = NULL)

testAccess(x, access = "")

test_access(x, access = "")

expect_access(x, access = "", info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertAccess}/\code{assert_access} return 
 \code{x} invisibly, whereas
 \code{checkAccess}/\code{check_access} and 
 \code{testAccess}/\code{test_access} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertAccess}/\code{assert_access}
 throws an error message, 
 \code{testAccess}/\code{test_access}
 returns \code{FALSE},
 and \code{checkAccess}/\code{check_access} 
 return a string with the error message.
 The function \code{expect_access} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check file system access rights
}
\examples{
# Is R's home directory readable?
testAccess(R.home(), "r")

# Is R's home directory writeable?
testAccess(R.home(), "w")
}
\seealso{
Other filesystem: 
\code{\link{checkDirectoryExists}()},
\code{\link{checkFileExists}()},
\code{\link{checkPathForOutput}()}
}
\concept{filesystem}
