# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActualState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Actual state."""

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    UNKNOWN = "Unknown"


class AzureADOnlyAuthenticationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AzureADOnlyAuthenticationName."""

    DEFAULT = "default"


class AzureScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scale type."""

    AUTOMATIC = "automatic"
    MANUAL = "manual"
    NONE = "none"


class BlobAuditingPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BlobAuditingPolicyName."""

    DEFAULT = "default"


class BlobAuditingPolicyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the state of the policy. If state is Enabled, storageEndpoint or
    isAzureMonitorTargetEnabled are required.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class BlobStorageEventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of blob storage event type to process."""

    MICROSOFT_STORAGE_BLOB_CREATED = "Microsoft.Storage.BlobCreated"
    MICROSOFT_STORAGE_BLOB_RENAMED = "Microsoft.Storage.BlobRenamed"


class ClusterPrincipalRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster principal role."""

    ALL_DATABASES_ADMIN = "AllDatabasesAdmin"
    ALL_DATABASES_VIEWER = "AllDatabasesViewer"


class ColumnDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The column data type."""

    IMAGE = "image"
    TEXT = "text"
    UNIQUEIDENTIFIER = "uniqueidentifier"
    DATE = "date"
    TIME = "time"
    DATETIME2 = "datetime2"
    DATETIMEOFFSET = "datetimeoffset"
    TINYINT = "tinyint"
    SMALLINT = "smallint"
    INT = "int"
    SMALLDATETIME = "smalldatetime"
    REAL = "real"
    MONEY = "money"
    DATETIME = "datetime"
    FLOAT = "float"
    SQL_VARIANT = "sql_variant"
    NTEXT = "ntext"
    BIT = "bit"
    DECIMAL = "decimal"
    NUMERIC = "numeric"
    SMALLMONEY = "smallmoney"
    BIGINT = "bigint"
    HIERARCHYID = "hierarchyid"
    GEOMETRY = "geometry"
    GEOGRAPHY = "geography"
    VARBINARY = "varbinary"
    VARCHAR = "varchar"
    BINARY = "binary"
    CHAR = "char"
    TIMESTAMP = "timestamp"
    NVARCHAR = "nvarchar"
    NCHAR = "nchar"
    XML = "xml"
    SYSNAME = "sysname"


class Compression(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The compression type."""

    NONE = "None"
    G_ZIP = "GZip"


class ConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the spark config properties file."""

    FILE = "File"
    ARTIFACT = "Artifact"


class ConnectionPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConnectionPolicyName."""

    DEFAULT = "default"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the mode of sql pool creation.

    Default: regular sql pool creation.

    PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql
    pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and
    restorePointInTime must be specified.

    Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as
    the recoverableDatabaseId to restore.

    Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId
    should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate
    must be specified.
    """

    DEFAULT = "Default"
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    RECOVERY = "Recovery"
    RESTORE = "Restore"


class DatabasePrincipalRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database principal role."""

    ADMIN = "Admin"
    INGESTOR = "Ingestor"
    MONITOR = "Monitor"
    USER = "User"
    UNRESTRICTED_VIEWER = "UnrestrictedViewer"
    VIEWER = "Viewer"


class DataConnectionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the endpoint for the data connection."""

    EVENT_HUB = "EventHub"
    EVENT_GRID = "EventGrid"
    IOT_HUB = "IotHub"


class DataFlowComputeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compute type of the cluster which will execute data flow job."""

    GENERAL = "General"
    MEMORY_OPTIMIZED = "MemoryOptimized"
    COMPUTE_OPTIMIZED = "ComputeOptimized"


class DataMaskingFunction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The masking function that is used for the data masking rule."""

    DEFAULT = "Default"
    CCN = "CCN"
    EMAIL = "Email"
    NUMBER = "Number"
    SSN = "SSN"
    TEXT = "Text"


class DataMaskingRuleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName,
    tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule
    doesn't already exist, the rule will be created with ruleState set to enabled, regardless of
    the provided value of ruleState.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DataMaskingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the data masking policy."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DataWarehouseUserActivityName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataWarehouseUserActivityName."""

    CURRENT = "current"


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Day of maintenance window."""

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"


class DedicatedSQLMinimalTlsSettingsName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DedicatedSQLMinimalTlsSettingsName."""

    DEFAULT = "default"


class DefaultPrincipalsModificationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The default principals modification kind."""

    UNION = "Union"
    REPLACE = "Replace"
    NONE = "None"


class DesiredState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Desired state."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class EncryptionProtectorName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EncryptionProtectorName."""

    CURRENT = "current"


class EventGridDataFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data format of the message. Optionally the data format can be added to each message."""

    MULTIJSON = "MULTIJSON"
    JSON = "JSON"
    CSV = "CSV"
    TSV = "TSV"
    SCSV = "SCSV"
    SOHSV = "SOHSV"
    PSV = "PSV"
    TXT = "TXT"
    RAW = "RAW"
    SINGLEJSON = "SINGLEJSON"
    AVRO = "AVRO"
    TSVE = "TSVE"
    PARQUET = "PARQUET"
    ORC = "ORC"
    APACHEAVRO = "APACHEAVRO"
    W3_CLOGFILE = "W3CLOGFILE"


class EventHubDataFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data format of the message. Optionally the data format can be added to each message."""

    MULTIJSON = "MULTIJSON"
    JSON = "JSON"
    CSV = "CSV"
    TSV = "TSV"
    SCSV = "SCSV"
    SOHSV = "SOHSV"
    PSV = "PSV"
    TXT = "TXT"
    RAW = "RAW"
    SINGLEJSON = "SINGLEJSON"
    AVRO = "AVRO"
    TSVE = "TSVE"
    PARQUET = "PARQUET"
    ORC = "ORC"
    APACHEAVRO = "APACHEAVRO"
    W3_CLOGFILE = "W3CLOGFILE"


class GeoBackupPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GeoBackupPolicyName."""

    DEFAULT = "Default"


class GeoBackupPolicyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the geo backup policy."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class IntegrationRuntimeAuthKeyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the authentication key to regenerate."""

    AUTH_KEY1 = "authKey1"
    AUTH_KEY2 = "authKey2"


class IntegrationRuntimeAutoUpdate(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of integration runtime auto update."""

    ON = "On"
    OFF = "Off"


class IntegrationRuntimeEdition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The edition for the SSIS Integration Runtime."""

    STANDARD = "Standard"
    ENTERPRISE = "Enterprise"


class IntegrationRuntimeEntityReferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of this referenced entity."""

    INTEGRATION_RUNTIME_REFERENCE = "IntegrationRuntimeReference"
    LINKED_SERVICE_REFERENCE = "LinkedServiceReference"


class IntegrationRuntimeInternalChannelEncryptionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """It is used to set the encryption mode for node-node communication channel (when more than 2
    self-hosted integration runtime nodes exist).
    """

    NOT_SET = "NotSet"
    SSL_ENCRYPTED = "SslEncrypted"
    NOT_ENCRYPTED = "NotEncrypted"


class IntegrationRuntimeLicenseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """License type for bringing your own license scenario."""

    BASE_PRICE = "BasePrice"
    LICENSE_INCLUDED = "LicenseIncluded"


class IntegrationRuntimeSsisCatalogPricingTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The pricing tier for the catalog database. The valid values could be found in
    https://azure.microsoft.com/en-us/pricing/details/sql-database/.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PREMIUM_RS = "PremiumRS"


class IntegrationRuntimeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of integration runtime."""

    INITIAL = "Initial"
    STOPPED = "Stopped"
    STARTED = "Started"
    STARTING = "Starting"
    STOPPING = "Stopping"
    NEED_REGISTRATION = "NeedRegistration"
    ONLINE = "Online"
    LIMITED = "Limited"
    OFFLINE = "Offline"
    ACCESS_DENIED = "AccessDenied"


class IntegrationRuntimeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of integration runtime."""

    MANAGED = "Managed"
    SELF_HOSTED = "SelfHosted"


class IntegrationRuntimeUpdateResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the last integration runtime node update."""

    NONE = "None"
    SUCCEED = "Succeed"
    FAIL = "Fail"


class IotHubDataFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data format of the message. Optionally the data format can be added to each message."""

    MULTIJSON = "MULTIJSON"
    JSON = "JSON"
    CSV = "CSV"
    TSV = "TSV"
    SCSV = "SCSV"
    SOHSV = "SOHSV"
    PSV = "PSV"
    TXT = "TXT"
    RAW = "RAW"
    SINGLEJSON = "SINGLEJSON"
    AVRO = "AVRO"
    TSVE = "TSVE"
    PARQUET = "PARQUET"
    ORC = "ORC"
    APACHEAVRO = "APACHEAVRO"
    W3_CLOGFILE = "W3CLOGFILE"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the database."""

    READ_WRITE = "ReadWrite"
    READ_ONLY_FOLLOWING = "ReadOnlyFollowing"


class LanguageExtensionName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Language extension that can run within KQL query."""

    PYTHON = "PYTHON"
    R = "R"


class ManagedIntegrationRuntimeNodeStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The managed integration runtime node status."""

    STARTING = "Starting"
    AVAILABLE = "Available"
    RECYCLING = "Recycling"
    UNAVAILABLE = "Unavailable"


class ManagementOperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation state."""

    PENDING = "Pending"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCEL_IN_PROGRESS = "CancelInProgress"
    CANCELLED = "Cancelled"


class NodeSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level of compute power that each node in the Big Data pool has."""

    NONE = "None"
    SMALL = "Small"
    MEDIUM = "Medium"
    LARGE = "Large"
    X_LARGE = "XLarge"
    XX_LARGE = "XXLarge"
    XXX_LARGE = "XXXLarge"


class NodeSizeFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of nodes that the Big Data pool provides."""

    NONE = "None"
    MEMORY_OPTIMIZED = "MemoryOptimized"
    HARDWARE_ACCELERATED_FPGA = "HardwareAcceleratedFPGA"
    HARDWARE_ACCELERATED_GPU = "HardwareAcceleratedGPU"


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status."""

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class PrincipalsModificationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The principals modification kind of the database."""

    UNION = "Union"
    REPLACE = "Replace"
    NONE = "None"


class PrincipalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Principal type."""

    APP = "App"
    GROUP = "Group"
    USER = "User"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource provisioning state."""

    PROVISIONING = "Provisioning"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    FAILED = "Failed"
    DELETE_ERROR = "DeleteError"


class QueryAggregationFunction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The function that is used to aggregate each query's metrics."""

    MIN = "min"
    MAX = "max"
    AVG = "avg"
    SUM = "sum"


class QueryExecutionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The execution type that is used to filter the query instances that are returned."""

    ANY = "any"
    REGULAR = "regular"
    IRREGULAR = "irregular"
    ABORTED = "aborted"
    EXCEPTION = "exception"


class QueryMetricUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit of measurement."""

    PERCENTAGE = "percentage"
    KB = "KB"
    MICROSECONDS = "microseconds"


class QueryObservedMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of metric to use for ordering the top metrics."""

    CPU = "cpu"
    IO = "io"
    LOGIO = "logio"
    DURATION = "duration"
    EXECUTION_COUNT = "executionCount"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Message providing the reason why the given name is invalid."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class RecommendedSensitivityLabelUpdateKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RecommendedSensitivityLabelUpdateKind."""

    ENABLE = "enable"
    DISABLE = "disable"


class ReplicationRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role of the Sql pool in the replication link."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    NON_READABLE_SECONDARY = "NonReadableSecondary"
    SOURCE = "Source"
    COPY = "Copy"


class ReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The replication state for the replication link."""

    PENDING = "PENDING"
    SEEDING = "SEEDING"
    CATCH_UP = "CATCH_UP"
    SUSPENDED = "SUSPENDED"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity for the workspace."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioned state of the resource."""

    RUNNING = "Running"
    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    MOVING = "Moving"
    CANCELED = "Canceled"


class RestorePointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restore point."""

    CONTINUOUS = "CONTINUOUS"
    DISCRETE = "DISCRETE"


class SecurityAlertPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SecurityAlertPolicyName."""

    DEFAULT = "default"


class SecurityAlertPolicyNameAutoGenerated(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SecurityAlertPolicyNameAutoGenerated."""

    DEFAULT = "Default"


class SecurityAlertPolicyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the state of the policy, whether it is enabled or disabled or a policy has not been
    applied yet on the specific Sql pool.
    """

    NEW = "New"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SelfHostedIntegrationRuntimeNodeStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the integration runtime node."""

    NEED_REGISTRATION = "NeedRegistration"
    ONLINE = "Online"
    LIMITED = "Limited"
    OFFLINE = "Offline"
    UPGRADING = "Upgrading"
    INITIALIZING = "Initializing"
    INITIALIZE_FAILED = "InitializeFailed"


class SensitivityLabelRank(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SensitivityLabelRank."""

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
    CRITICAL = "Critical"


class SensitivityLabelSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SensitivityLabelSource."""

    CURRENT = "current"
    RECOMMENDED = "recommended"


class SensitivityLabelUpdateKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SensitivityLabelUpdateKind."""

    SET = "set"
    REMOVE = "remove"


class ServerKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption protector type like 'ServiceManaged', 'AzureKeyVault'."""

    SERVICE_MANAGED = "ServiceManaged"
    AZURE_KEY_VAULT = "AzureKeyVault"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU name."""

    COMPUTE_OPTIMIZED = "Compute optimized"
    STORAGE_OPTIMIZED = "Storage optimized"


class SkuSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU size."""

    EXTRA_SMALL = "Extra small"
    SMALL = "Small"
    MEDIUM = "Medium"
    LARGE = "Large"


class SsisObjectMetadataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of SSIS object metadata."""

    FOLDER = "Folder"
    PROJECT = "Project"
    PACKAGE = "Package"
    ENVIRONMENT = "Environment"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the resource."""

    CREATING = "Creating"
    UNAVAILABLE = "Unavailable"
    RUNNING = "Running"
    DELETING = "Deleting"
    DELETED = "Deleted"
    STOPPING = "Stopping"
    STOPPED = "Stopped"
    STARTING = "Starting"
    UPDATING = "Updating"


class StateValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """property configuration state."""

    CONSISTENT = "Consistent"
    IN_CONSISTENT = "InConsistent"
    UPDATING = "Updating"


class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The storage account type used to store backups for this sql pool."""

    GRS = "GRS"
    LRS = "LRS"


class TransparentDataEncryptionName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TransparentDataEncryptionName."""

    CURRENT = "current"


class TransparentDataEncryptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the database transparent data encryption."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of resource, for instance Microsoft.Synapse/workspaces/kustoPools/databases."""

    MICROSOFT_SYNAPSE_WORKSPACES_KUSTO_POOLS_DATABASES = "Microsoft.Synapse/workspaces/kustoPools/databases"
    MICROSOFT_SYNAPSE_WORKSPACES_KUSTO_POOLS_ATTACHED_DATABASE_CONFIGURATIONS = (
        "Microsoft.Synapse/workspaces/kustoPools/attachedDatabaseConfigurations"
    )


class VulnerabilityAssessmentName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VulnerabilityAssessmentName."""

    DEFAULT = "default"


class VulnerabilityAssessmentPolicyBaselineName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VulnerabilityAssessmentPolicyBaselineName."""

    MASTER = "master"
    DEFAULT = "default"


class VulnerabilityAssessmentScanState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan status."""

    PASSED = "Passed"
    FAILED = "Failed"
    FAILED_TO_RUN = "FailedToRun"
    IN_PROGRESS = "InProgress"


class VulnerabilityAssessmentScanTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan trigger type."""

    ON_DEMAND = "OnDemand"
    RECURRING = "Recurring"


class WorkspacePublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable public network access to workspace."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class WorkspaceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """status of Start Integrationruntimes."""

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
