# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRightsDescription(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rights that this key has."""

    SERVICE_CONFIG = "ServiceConfig"
    ENROLLMENT_READ = "EnrollmentRead"
    ENROLLMENT_WRITE = "EnrollmentWrite"
    DEVICE_CONNECT = "DeviceConnect"
    REGISTRATION_STATUS_READ = "RegistrationStatusRead"
    REGISTRATION_STATUS_WRITE = "RegistrationStatusWrite"


class AllocationPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allocation policy to be used by this provisioning service."""

    HASHED = "Hashed"
    GEO_LATENCY = "GeoLatency"
    STATIC = "Static"


class CertificatePurpose(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of CertificatePurpose."""

    CLIENT_AUTHENTICATION = "clientAuthentication"
    SERVER_AUTHENTICATION = "serverAuthentication"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeviceRegistryNamespaceAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Device Registry Namespace MI authentication type: UserAssigned, SystemAssigned."""

    USER_ASSIGNED = "UserAssigned"
    """User assigned authentication type."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned authentication type."""


class IotDpsSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku name."""

    S1 = "S1"


class IpFilterActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The desired action for requests captured by this rule."""

    ACCEPT = "Accept"
    REJECT = "Reject"


class IpFilterTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target for requests captured by this rule."""

    ALL = "all"
    SERVICE_API = "serviceApi"
    DEVICE_API = "deviceApi"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class NameUnavailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """specifies the reason a name is unavailable."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class PrivateLinkServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a private endpoint connection."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether requests from Public Network are allowed."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current state of the provisioning service."""

    ACTIVATING = "Activating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DELETED = "Deleted"
    ACTIVATION_FAILED = "ActivationFailed"
    DELETION_FAILED = "DeletionFailed"
    TRANSITIONING = "Transitioning"
    SUSPENDING = "Suspending"
    SUSPENDED = "Suspended"
    RESUMING = "Resuming"
    FAILING_OVER = "FailingOver"
    FAILOVER_FAILED = "FailoverFailed"
