# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.frontdoor import FrontDoorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-frontdoor
# USAGE
    python waf_policy_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = FrontDoorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.policies.begin_create_or_update(
        resource_group_name="rg1",
        policy_name="Policy1",
        parameters={
            "location": "WestUs",
            "properties": {
                "customRules": {
                    "rules": [
                        {
                            "action": "Block",
                            "matchConditions": [
                                {
                                    "matchValue": ["192.168.1.0/24", "10.0.0.0/24"],
                                    "matchVariable": "RemoteAddr",
                                    "operator": "IPMatch",
                                }
                            ],
                            "name": "Rule1",
                            "priority": 1,
                            "rateLimitThreshold": 1000,
                            "ruleType": "RateLimitRule",
                        },
                        {
                            "action": "Block",
                            "matchConditions": [
                                {"matchValue": ["CH"], "matchVariable": "RemoteAddr", "operator": "GeoMatch"},
                                {
                                    "matchValue": ["windows"],
                                    "matchVariable": "RequestHeader",
                                    "operator": "Contains",
                                    "selector": "UserAgent",
                                    "transforms": ["Lowercase"],
                                },
                            ],
                            "name": "Rule2",
                            "priority": 2,
                            "ruleType": "MatchRule",
                        },
                    ]
                },
                "managedRules": {
                    "managedRuleSets": [
                        {
                            "exclusions": [
                                {
                                    "matchVariable": "RequestHeaderNames",
                                    "selector": "User-Agent",
                                    "selectorMatchOperator": "Equals",
                                }
                            ],
                            "ruleGroupOverrides": [
                                {
                                    "exclusions": [
                                        {
                                            "matchVariable": "RequestCookieNames",
                                            "selector": "token",
                                            "selectorMatchOperator": "StartsWith",
                                        }
                                    ],
                                    "ruleGroupName": "SQLI",
                                    "rules": [
                                        {
                                            "action": "Redirect",
                                            "enabledState": "Enabled",
                                            "exclusions": [
                                                {
                                                    "matchVariable": "QueryStringArgNames",
                                                    "selector": "query",
                                                    "selectorMatchOperator": "Equals",
                                                }
                                            ],
                                            "ruleId": "942100",
                                        },
                                        {"enabledState": "Disabled", "ruleId": "942110"},
                                    ],
                                }
                            ],
                            "ruleSetAction": "Block",
                            "ruleSetType": "DefaultRuleSet",
                            "ruleSetVersion": "1.0",
                        }
                    ]
                },
                "policySettings": {
                    "customBlockResponseBody": "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
                    "customBlockResponseStatusCode": 429,
                    "enabledState": "Enabled",
                    "javascriptChallengeExpirationInMinutes": 30,
                    "logScrubbing": {
                        "scrubbingRules": [
                            {
                                "matchVariable": "RequestIPAddress",
                                "selector": None,
                                "selectorMatchOperator": "EqualsAny",
                                "state": "Enabled",
                            }
                        ],
                        "state": "Enabled",
                    },
                    "mode": "Prevention",
                    "redirectUrl": "http://www.bing.com",
                    "requestBodyCheck": "Disabled",
                },
            },
            "sku": {"name": "Premium_AzureFrontDoor"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/frontdoor/resource-manager/Microsoft.Network/stable/2024-02-01/examples/WafPolicyCreateOrUpdate.json
if __name__ == "__main__":
    main()
