# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DeploymentSafeguardsLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the level of Deployment Safeguards."""

    WARN = "Warn"
    """Best practice violations will only show warnings"""
    ENFORCE = "Enforce"
    """Best practice violations will be denied"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PodSecurityStandardsLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the Pod Security Standards level."""

    POD_SECURITY_STANDARDS_PRIVILEGED = "Privileged"
    """Privileged level is an unrestricted policy, providing the widest possible level of permissions.
    This policy allows for known privilege escalations."""
    POD_SECURITY_STANDARDS_BASELINE = "Baseline"
    """Baseline level is a minimally restrictive policy which prevents known privilege escalations.
    Allows the default (minimally specified) Pod configuration."""
    POD_SECURITY_STANDARDS_RESTRICTED = "Restricted"
    """Restricted level is a heavily restricted policy, following current Pod hardening best
    practices."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the last accepted operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    """The provisioning state of DeploymentSafeguards being created."""
    UPDATING = "Updating"
    """The provisioning state of DeploymentSafeguards being updated."""
    DELETING = "Deleting"
    """The provisioning state of DeploymentSafeguards being deleted."""
