
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_utilities.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AssumedPartitionCheck_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AssumedPartitionCheck_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AssumedPartitionCheck_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AssumedPartitionCheck_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CheckError_pre( HYPRE_Precision precision, HYPRE_Int hypre_ierr, HYPRE_Int hypre_error_code )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CheckError_flt( hypre_ierr, hypre_error_code );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CheckError_dbl( hypre_ierr, hypre_error_code );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CheckError_long_dbl( hypre_ierr, hypre_error_code );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearAllErrors_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ClearAllErrors_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ClearAllErrors_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ClearAllErrors_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearError_pre( HYPRE_Precision precision, HYPRE_Int hypre_error_code )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ClearError_flt( hypre_error_code );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ClearError_dbl( hypre_error_code );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ClearError_long_dbl( hypre_error_code );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ClearErrorMessages_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ClearErrorMessages_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ClearErrorMessages_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ClearErrorMessages_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void
HYPRE_DescribeError_pre( HYPRE_Precision precision, HYPRE_Int hypre_ierr, char *descr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_DescribeError_flt( hypre_ierr, descr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_DescribeError_dbl( hypre_ierr, descr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_DescribeError_long_dbl( hypre_ierr, descr );
      default:
         hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision");
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_DeviceInitialize_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_DeviceInitialize_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_DeviceInitialize_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_DeviceInitialize_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Finalize_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Finalize_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Finalize_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Finalize_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Finalized_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Finalized_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Finalized_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Finalized_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetError_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetError_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetError_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetError_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetErrorArg_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetErrorArg_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetErrorArg_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetErrorArg_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetErrorMessages_pre( HYPRE_Precision precision, char **buffer, HYPRE_Int *bufsz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetErrorMessages_flt( buffer, bufsz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetErrorMessages_dbl( buffer, bufsz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetErrorMessages_long_dbl( buffer, bufsz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetExecutionPolicy_pre( HYPRE_Precision precision, HYPRE_ExecutionPolicy *exec_policy )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetExecutionPolicy_flt( exec_policy );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetExecutionPolicy_dbl( exec_policy );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetExecutionPolicy_long_dbl( exec_policy );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

const char*
HYPRE_GetExecutionPolicyName_pre( HYPRE_Precision precision, HYPRE_ExecutionPolicy exec_policy )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetExecutionPolicyName_flt( exec_policy );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetExecutionPolicyName_dbl( exec_policy );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetExecutionPolicyName_long_dbl( exec_policy );
      default:
         { const char* value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetGlobalError_pre( HYPRE_Precision precision, MPI_Comm comm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetGlobalError_flt( comm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetGlobalError_dbl( comm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetGlobalError_long_dbl( comm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GetMemoryLocation_pre( HYPRE_Precision precision, HYPRE_MemoryLocation *memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_GetMemoryLocation_flt( memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_GetMemoryLocation_dbl( memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_GetMemoryLocation_long_dbl( memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Initialize_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Initialize_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Initialize_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Initialize_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Initialized_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Initialized_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Initialized_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Initialized_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MemoryPrintUsage_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Int level, const char *function, HYPRE_Int line )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MemoryPrintUsage_flt( comm, level, function, line );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MemoryPrintUsage_dbl( comm, level, function, line );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MemoryPrintUsage_long_dbl( comm, level, function, line );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PrintDeviceInfo_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PrintDeviceInfo_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PrintDeviceInfo_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PrintDeviceInfo_long_dbl( );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PrintErrorMessages_pre( HYPRE_Precision precision, MPI_Comm comm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_PrintErrorMessages_flt( comm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_PrintErrorMessages_dbl( comm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_PrintErrorMessages_long_dbl( comm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetExecutionPolicy_pre( HYPRE_Precision precision, HYPRE_ExecutionPolicy exec_policy )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetExecutionPolicy_flt( exec_policy );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetExecutionPolicy_dbl( exec_policy );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetExecutionPolicy_long_dbl( exec_policy );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetGPUMemoryPoolSize_pre( HYPRE_Precision precision, HYPRE_Int bin_growth, HYPRE_Int min_bin, HYPRE_Int max_bin, size_t max_cached_bytes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetGPUMemoryPoolSize_flt( bin_growth, min_bin, max_bin, max_cached_bytes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetGPUMemoryPoolSize_dbl( bin_growth, min_bin, max_bin, max_cached_bytes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetGPUMemoryPoolSize_long_dbl( bin_growth, min_bin, max_bin, max_cached_bytes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetGpuAwareMPI_pre( HYPRE_Precision precision, HYPRE_Int use_gpu_aware_mpi )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetGpuAwareMPI_flt( use_gpu_aware_mpi );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetGpuAwareMPI_dbl( use_gpu_aware_mpi );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetGpuAwareMPI_long_dbl( use_gpu_aware_mpi );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetLogLevel_pre( HYPRE_Precision precision, HYPRE_Int log_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetLogLevel_flt( log_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetLogLevel_dbl( log_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetLogLevel_long_dbl( log_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetMemoryLocation_pre( HYPRE_Precision precision, HYPRE_MemoryLocation memory_location )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetMemoryLocation_flt( memory_location );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetMemoryLocation_dbl( memory_location );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetMemoryLocation_long_dbl( memory_location );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetPrintErrorMode_pre( HYPRE_Precision precision, HYPRE_Int mode )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetPrintErrorMode_flt( mode );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetPrintErrorMode_dbl( mode );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetPrintErrorMode_long_dbl( mode );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetPrintErrorVerbosity_pre( HYPRE_Precision precision, HYPRE_Int code, HYPRE_Int verbosity )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetPrintErrorVerbosity_flt( code, verbosity );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetPrintErrorVerbosity_dbl( code, verbosity );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetPrintErrorVerbosity_long_dbl( code, verbosity );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpGemmUseVendor_pre( HYPRE_Precision precision, HYPRE_Int use_vendor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetSpGemmUseVendor_flt( use_vendor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetSpGemmUseVendor_dbl( use_vendor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetSpGemmUseVendor_long_dbl( use_vendor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpMVUseVendor_pre( HYPRE_Precision precision, HYPRE_Int use_vendor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetSpMVUseVendor_flt( use_vendor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetSpMVUseVendor_dbl( use_vendor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetSpMVUseVendor_long_dbl( use_vendor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetSpTransUseVendor_pre( HYPRE_Precision precision, HYPRE_Int use_vendor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetSpTransUseVendor_flt( use_vendor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetSpTransUseVendor_dbl( use_vendor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetSpTransUseVendor_long_dbl( use_vendor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SetUseGpuRand_pre( HYPRE_Precision precision, HYPRE_Int use_curand )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SetUseGpuRand_flt( use_curand );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SetUseGpuRand_dbl( use_curand );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SetUseGpuRand_long_dbl( use_curand );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Version_pre( HYPRE_Precision precision, char **version_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Version_flt( version_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Version_dbl( version_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Version_long_dbl( version_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VersionNumber_pre( HYPRE_Precision precision, HYPRE_Int *major_ptr, HYPRE_Int *minor_ptr, HYPRE_Int *patch_ptr, HYPRE_Int *single_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VersionNumber_flt( major_ptr, minor_ptr, patch_ptr, single_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VersionNumber_dbl( major_ptr, minor_ptr, patch_ptr, single_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VersionNumber_long_dbl( major_ptr, minor_ptr, patch_ptr, single_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

