
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_struct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetResidual( HYPRE_StructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetAbsoluteTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructBiCGSTABSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetBase( HYPRE_StructSolver solver, HYPRE_Int ndim, HYPRE_Int *base_index, HYPRE_Int *base_stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedSetBase_pre( precision, solver, ndim, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetTDim( HYPRE_StructSolver solver, HYPRE_Int tdim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedSetTDim_pre( precision, solver, tdim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructCycRedSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructDiagScale( HYPRE_StructSolver solver, HYPRE_StructMatrix HA, HYPRE_StructVector Hy, HYPRE_StructVector Hx )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructDiagScale_pre( precision, solver, HA, Hy, Hx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructDiagScaleSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector y, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructDiagScaleSetup_pre( precision, solver, A, y, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetAbsoluteTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetKDim( HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetModifyPC( HYPRE_StructSolver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetModifyPC_pre( precision, solver, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructFlexGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetAbsoluteTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetKDim( HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetDSCGNumIterations( HYPRE_StructSolver solver, HYPRE_Int *ds_num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetDSCGNumIterations_pre( precision, solver, ds_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetNumIterations_pre( precision, solver, num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetPCGNumIterations( HYPRE_StructSolver solver, HYPRE_Int *pre_num_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetPCGNumIterations_pre( precision, solver, pre_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetRecomputeResidual( HYPRE_StructSolver solver, HYPRE_Int *recompute_residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetRecomputeResidual_pre( precision, solver, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetRecomputeResidualP( HYPRE_StructSolver solver, HYPRE_Int *recompute_residual_p )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridGetRecomputeResidualP_pre( precision, solver, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetConvergenceTol( HYPRE_StructSolver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetConvergenceTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetDSCGMaxIter( HYPRE_StructSolver solver, HYPRE_Int ds_max_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetDSCGMaxIter_pre( precision, solver, ds_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetKDim( HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPCGAbsoluteTolFactor( HYPRE_StructSolver solver, hypre_long_double pcg_atolf )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetPCGAbsoluteTolFactor_pre( precision, solver, pcg_atolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPCGMaxIter( HYPRE_StructSolver solver, HYPRE_Int pre_max_its )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetPCGMaxIter_pre( precision, solver, pre_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRecomputeResidual( HYPRE_StructSolver solver, HYPRE_Int recompute_residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetRecomputeResidual_pre( precision, solver, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRecomputeResidualP( HYPRE_StructSolver solver, HYPRE_Int recompute_residual_p )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetRecomputeResidualP_pre( precision, solver, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRelChange( HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetSolverType( HYPRE_StructSolver solver, HYPRE_Int solver_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetSolverType_pre( precision, solver, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetStopCrit( HYPRE_StructSolver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetTwoNorm( HYPRE_StructSolver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructHybridSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetMaxIter( HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetTol( HYPRE_StructSolver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetZeroGuess( HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiGetZeroGuess_pre( precision, solver, zeroguess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetNonZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructJacobiSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetAbsoluteTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetAugDim( HYPRE_StructSolver solver, HYPRE_Int aug_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetAugDim_pre( precision, solver, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetKDim( HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructLGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetAbsoluteTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetPrecond( HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetRelChange( HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetTwoNorm( HYPRE_StructSolver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPCGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetJacobiWeight( HYPRE_StructSolver solver, void *weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetJacobiWeight_pre( precision, solver, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetLogging( HYPRE_StructSolver solver, HYPRE_Int *logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMatmultType( HYPRE_StructSolver solver, HYPRE_Int *matmult_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetMatmultType_pre( precision, solver, matmult_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMaxIter( HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMaxLevels( HYPRE_StructSolver solver, HYPRE_Int *max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumPostRelax( HYPRE_StructSolver solver, HYPRE_Int *num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumPreRelax( HYPRE_StructSolver solver, HYPRE_Int *num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int *print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRAPType( HYPRE_StructSolver solver, HYPRE_Int *rap_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetRAPType_pre( precision, solver, rap_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRelChange( HYPRE_StructSolver solver, HYPRE_Int *rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRelaxType( HYPRE_StructSolver solver, HYPRE_Int *relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetSkipRelax( HYPRE_StructSolver solver, HYPRE_Int *skip_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetSkipRelax_pre( precision, solver, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetTol( HYPRE_StructSolver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetZeroGuess( HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGGetZeroGuess_pre( precision, solver, zeroguess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetDxyz( HYPRE_StructSolver solver, void *dxyz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetDxyz_pre( precision, solver, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetJacobiWeight( HYPRE_StructSolver solver, hypre_long_double weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetJacobiWeight_pre( precision, solver, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMatmultType( HYPRE_StructSolver solver, HYPRE_Int matmult_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetMatmultType_pre( precision, solver, matmult_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMaxLevels( HYPRE_StructSolver solver, HYPRE_Int max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNonZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNumPostRelax( HYPRE_StructSolver solver, HYPRE_Int num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNumPreRelax( HYPRE_StructSolver solver, HYPRE_Int num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRAPType( HYPRE_StructSolver solver, HYPRE_Int rap_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetRAPType_pre( precision, solver, rap_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRelChange( HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRelaxType( HYPRE_StructSolver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetSkipRelax( HYPRE_StructSolver solver, HYPRE_Int skip_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetSkipRelax_pre( precision, solver, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructPFMGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGCreate( MPI_Comm comm, HYPRE_StructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGDestroy( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetFinalRelativeResidualNorm( HYPRE_StructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetLogging( HYPRE_StructSolver solver, HYPRE_Int *logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetMaxIter( HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetMemoryUse( HYPRE_StructSolver solver, HYPRE_Int *memory_use )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetMemoryUse_pre( precision, solver, memory_use );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumIterations( HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumPostRelax( HYPRE_StructSolver solver, HYPRE_Int *num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumPreRelax( HYPRE_StructSolver solver, HYPRE_Int *num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int *print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetRelChange( HYPRE_StructSolver solver, HYPRE_Int *rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetTol( HYPRE_StructSolver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetZeroGuess( HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGGetZeroGuess_pre( precision, solver, zeroguess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetLogging( HYPRE_StructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetMaxIter( HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetMemoryUse( HYPRE_StructSolver solver, HYPRE_Int memory_use )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetMemoryUse_pre( precision, solver, memory_use );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNonZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNumPostRelax( HYPRE_StructSolver solver, HYPRE_Int num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNumPreRelax( HYPRE_StructSolver solver, HYPRE_Int num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetPrintLevel( HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetRelChange( HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetTol( HYPRE_StructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetZeroGuess( HYPRE_StructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetup( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSolve( HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSMGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSetupInterpreter( mv_InterfaceInterpreter *i )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSetupInterpreter_pre( precision, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSetupMatvec( HYPRE_MatvecFunctions *mv )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructSetupMatvec_pre( precision, mv );
}



#endif

