
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_sstruct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetResidual_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetMinIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetPrecond_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetStopCrit_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructBiCGSTABSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructBiCGSTABSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructBiCGSTABSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructDiagScale_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector y, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructDiagScale_flt( solver, A, y, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructDiagScale_dbl( solver, A, y, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructDiagScale_long_dbl( solver, A, y, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructDiagScaleSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector y, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructDiagScaleSetup_flt( solver, A, y, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructDiagScaleSetup_dbl( solver, A, y, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructDiagScaleSetup_long_dbl( solver, A, y, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetModifyPC_flt( solver, modify_pc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetModifyPC_dbl( solver, modify_pc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetModifyPC_long_dbl( solver, modify_pc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructFlexGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructFlexGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructFlexGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetStopCrit_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetAugDim_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int aug_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetAugDim_flt( solver, aug_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetAugDim_dbl( solver, aug_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetAugDim_long_dbl( solver, aug_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructLGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructLGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructLGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetResidual_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetRelChange_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructPCGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructPCGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructPCGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetCoarseSolverType_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int csolver_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetCoarseSolverType_flt( solver, csolver_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetCoarseSolverType_dbl( solver, csolver_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetCoarseSolverType_long_dbl( solver, csolver_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetDxyz_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int nparts, void *dxyz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetDxyz_flt( solver, nparts, dxyz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetDxyz_dbl( solver, nparts, dxyz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetDxyz_long_dbl( solver, nparts, dxyz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetInterpType_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetInterpType_flt( solver, interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetInterpType_dbl( solver, interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetInterpType_long_dbl( solver, interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetMaxCoarseSize_flt( solver, max_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetMaxCoarseSize_dbl( solver, max_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetMaxCoarseSize_long_dbl( solver, max_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNonGalerkinRAP_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int non_galerkin )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetNonGalerkinRAP_flt( solver, non_galerkin );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetNonGalerkinRAP_dbl( solver, non_galerkin );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetNonGalerkinRAP_long_dbl( solver, non_galerkin );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumCoarseRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int num_coarse_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetNumCoarseRelax_flt( solver, num_coarse_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetNumCoarseRelax_dbl( solver, num_coarse_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetNumCoarseRelax_long_dbl( solver, num_coarse_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetPrintFreq_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_freq )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetPrintFreq_flt( solver, print_freq );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetPrintFreq_dbl( solver, print_freq );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetPrintFreq_long_dbl( solver, print_freq );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelChange_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelaxType_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetRelaxWeight_flt( solver, weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetRelaxWeight_dbl( solver, weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetRelaxWeight_long_dbl( solver, weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetSkipRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int skip_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetSkipRelax_flt( solver, skip_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetSkipRelax_dbl( solver, skip_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetSkipRelax_long_dbl( solver, skip_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSSAMGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSSAMGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSSAMGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSetupInterpreter_flt( i );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSetupInterpreter_dbl( i );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSetupInterpreter_long_dbl( i );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSetupMatvec_pre( HYPRE_Precision precision, HYPRE_MatvecFunctions *mv )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSetupMatvec_flt( mv );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSetupMatvec_dbl( mv );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSetupMatvec_long_dbl( mv );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitPrintLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitPrintLogging_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitPrintLogging_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitPrintLogging_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetStructSolver_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int ssolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetStructSolver_flt( solver, ssolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetStructSolver_dbl( solver, ssolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetStructSolver_long_dbl( solver, ssolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSplitSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSplitSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSplitSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGDestroy_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetDxyz_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, void *dxyz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetDxyz_flt( solver, dxyz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetDxyz_dbl( solver, dxyz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetDxyz_long_dbl( solver, dxyz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetJacobiWeight_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetJacobiWeight_flt( solver, weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetJacobiWeight_dbl( solver, weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetJacobiWeight_long_dbl( solver, weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetLogging_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetRelChange_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetRelaxType_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetSkipRelax_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_Int skip_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetSkipRelax_flt( solver, skip_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetSkipRelax_dbl( solver, skip_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetSkipRelax_long_dbl( solver, skip_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetTol_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetup_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSolve_pre( HYPRE_Precision precision, HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructSysPFMGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructSysPFMGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructSysPFMGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

