
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_SSTRUCT_LS_MUP_HEADER
#define hypre_SSTRUCT_LS_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
hypre_NodeRelax_flt( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_NodeRelax_dbl( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_NodeRelax_long_dbl( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );

void *
hypre_NodeRelaxCreate_flt( MPI_Comm comm );
void *
hypre_NodeRelaxCreate_dbl( MPI_Comm comm );
void *
hypre_NodeRelaxCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_NodeRelaxDestroy_flt( void *relax_vdata );
HYPRE_Int
hypre_NodeRelaxDestroy_dbl( void *relax_vdata );
HYPRE_Int
hypre_NodeRelaxDestroy_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_NodeRelaxSetMaxIter_flt( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_NodeRelaxSetMaxIter_dbl( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_NodeRelaxSetMaxIter_long_dbl( void *relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_NodeRelaxSetNodeset_flt( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );
HYPRE_Int
hypre_NodeRelaxSetNodeset_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );
HYPRE_Int
hypre_NodeRelaxSetNodeset_long_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );

HYPRE_Int
hypre_NodeRelaxSetNodesetRank_flt( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );
HYPRE_Int
hypre_NodeRelaxSetNodesetRank_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );
HYPRE_Int
hypre_NodeRelaxSetNodesetRank_long_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );

HYPRE_Int
hypre_NodeRelaxSetNumNodesets_flt( void *relax_vdata, HYPRE_Int num_nodesets );
HYPRE_Int
hypre_NodeRelaxSetNumNodesets_dbl( void *relax_vdata, HYPRE_Int num_nodesets );
HYPRE_Int
hypre_NodeRelaxSetNumNodesets_long_dbl( void *relax_vdata, HYPRE_Int num_nodesets );

HYPRE_Int
hypre_NodeRelaxSetTempVec_flt( void *relax_vdata, hypre_SStructPVector *t );
HYPRE_Int
hypre_NodeRelaxSetTempVec_dbl( void *relax_vdata, hypre_SStructPVector *t );
HYPRE_Int
hypre_NodeRelaxSetTempVec_long_dbl( void *relax_vdata, hypre_SStructPVector *t );

HYPRE_Int
hypre_NodeRelaxSetTol_flt( void *relax_vdata, hypre_float tol );
HYPRE_Int
hypre_NodeRelaxSetTol_dbl( void *relax_vdata, hypre_double tol );
HYPRE_Int
hypre_NodeRelaxSetTol_long_dbl( void *relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_NodeRelaxSetWeight_flt( void *relax_vdata, hypre_float weight );
HYPRE_Int
hypre_NodeRelaxSetWeight_dbl( void *relax_vdata, hypre_double weight );
HYPRE_Int
hypre_NodeRelaxSetWeight_long_dbl( void *relax_vdata, hypre_long_double weight );

HYPRE_Int
hypre_NodeRelaxSetZeroGuess_flt( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_NodeRelaxSetZeroGuess_dbl( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_NodeRelaxSetZeroGuess_long_dbl( void *relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_NodeRelaxSetup_flt( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_NodeRelaxSetup_dbl( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_NodeRelaxSetup_long_dbl( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );

HYPRE_Int
hypre_SSAMGCoarseSolve_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolve_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolve_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGCoarseSolverDestroy_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolverDestroy_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolverDestroy_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGCoarseSolverSetup_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolverSetup_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGCoarseSolverSetup_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGCoarsen_flt( void *ssamg_vdata, hypre_SStructGrid *grid, HYPRE_Int *dxyz_flag, hypre_float **dxyz );
HYPRE_Int
hypre_SSAMGCoarsen_dbl( void *ssamg_vdata, hypre_SStructGrid *grid, HYPRE_Int *dxyz_flag, hypre_double **dxyz );
HYPRE_Int
hypre_SSAMGCoarsen_long_dbl( void *ssamg_vdata, hypre_SStructGrid *grid, HYPRE_Int *dxyz_flag, hypre_long_double **dxyz );

HYPRE_Int
hypre_SSAMGComputeDxyz_flt( hypre_SStructMatrix *A, hypre_float **dxyz, HYPRE_Int *dxyz_flag );
HYPRE_Int
hypre_SSAMGComputeDxyz_dbl( hypre_SStructMatrix *A, hypre_double **dxyz, HYPRE_Int *dxyz_flag );
HYPRE_Int
hypre_SSAMGComputeDxyz_long_dbl( hypre_SStructMatrix *A, hypre_long_double **dxyz, HYPRE_Int *dxyz_flag );

HYPRE_Int
hypre_SSAMGComputeMaxLevels_flt( hypre_SStructGrid *grid, HYPRE_Int *max_levels );
HYPRE_Int
hypre_SSAMGComputeMaxLevels_dbl( hypre_SStructGrid *grid, HYPRE_Int *max_levels );
HYPRE_Int
hypre_SSAMGComputeMaxLevels_long_dbl( hypre_SStructGrid *grid, HYPRE_Int *max_levels );

HYPRE_Int
hypre_SSAMGComputeRAP_flt( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructGrid **cgrid, HYPRE_Int *cdir_p, HYPRE_Int non_galerkin, hypre_SStructMatrix **Ac_ptr );
HYPRE_Int
hypre_SSAMGComputeRAP_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructGrid **cgrid, HYPRE_Int *cdir_p, HYPRE_Int non_galerkin, hypre_SStructMatrix **Ac_ptr );
HYPRE_Int
hypre_SSAMGComputeRAP_long_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructGrid **cgrid, HYPRE_Int *cdir_p, HYPRE_Int non_galerkin, hypre_SStructMatrix **Ac_ptr );

HYPRE_Int
hypre_SSAMGComputeRAPNonGlk_flt( hypre_SStructMatrix *A, hypre_SStructMatrix *P, HYPRE_Int *cdir_p, hypre_SStructMatrix **Ac_ptr );
HYPRE_Int
hypre_SSAMGComputeRAPNonGlk_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, HYPRE_Int *cdir_p, hypre_SStructMatrix **Ac_ptr );
HYPRE_Int
hypre_SSAMGComputeRAPNonGlk_long_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, HYPRE_Int *cdir_p, hypre_SStructMatrix **Ac_ptr );

void *
hypre_SSAMGCreate_flt( hypre_MPI_Comm comm );
void *
hypre_SSAMGCreate_dbl( hypre_MPI_Comm comm );
void *
hypre_SSAMGCreate_long_dbl( hypre_MPI_Comm comm );

hypre_SStructMatrix*
hypre_SSAMGCreateInterpOp_flt( hypre_SStructMatrix *A, hypre_SStructGrid *cgrid, HYPRE_Int *cdir_p );
hypre_SStructMatrix*
hypre_SSAMGCreateInterpOp_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *cgrid, HYPRE_Int *cdir_p );
hypre_SStructMatrix*
hypre_SSAMGCreateInterpOp_long_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *cgrid, HYPRE_Int *cdir_p );

HYPRE_Int
hypre_SSAMGDestroy_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGDestroy_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGDestroy_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGGetFinalRelativeResidualNorm_flt( void *ssamg_vdata, hypre_float *relative_residual_norm );
HYPRE_Int
hypre_SSAMGGetFinalRelativeResidualNorm_dbl( void *ssamg_vdata, hypre_double *relative_residual_norm );
HYPRE_Int
hypre_SSAMGGetFinalRelativeResidualNorm_long_dbl( void *ssamg_vdata, hypre_long_double *relative_residual_norm );

HYPRE_Int
hypre_SSAMGGetNumIterations_flt( void *ssamg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SSAMGGetNumIterations_dbl( void *ssamg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SSAMGGetNumIterations_long_dbl( void *ssamg_vdata, HYPRE_Int *num_iterations );

HYPRE_Int
hypre_SSAMGPrintLogging_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGPrintLogging_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGPrintLogging_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGPrintStats_flt( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGPrintStats_dbl( void *ssamg_vdata );
HYPRE_Int
hypre_SSAMGPrintStats_long_dbl( void *ssamg_vdata );

HYPRE_Int
hypre_SSAMGRelax_flt( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelax_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelax_long_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SSAMGRelaxCreate_flt( MPI_Comm comm, HYPRE_Int nparts, void **relax_vdata_ptr );
HYPRE_Int
hypre_SSAMGRelaxCreate_dbl( MPI_Comm comm, HYPRE_Int nparts, void **relax_vdata_ptr );
HYPRE_Int
hypre_SSAMGRelaxCreate_long_dbl( MPI_Comm comm, HYPRE_Int nparts, void **relax_vdata_ptr );

HYPRE_Int
hypre_SSAMGRelaxDestroy_flt( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxDestroy_dbl( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxDestroy_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SSAMGRelaxGeneric_flt( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxGeneric_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxGeneric_long_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SSAMGRelaxJacobi_flt( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxJacobi_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxJacobi_long_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SSAMGRelaxSetActiveParts_flt( void *relax_vdata, HYPRE_Int *active_p );
HYPRE_Int
hypre_SSAMGRelaxSetActiveParts_dbl( void *relax_vdata, HYPRE_Int *active_p );
HYPRE_Int
hypre_SSAMGRelaxSetActiveParts_long_dbl( void *relax_vdata, HYPRE_Int *active_p );

HYPRE_Int
hypre_SSAMGRelaxSetMatvecData_flt( void *relax_vdata, void *matvec_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetMatvecData_dbl( void *relax_vdata, void *matvec_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetMatvecData_long_dbl( void *relax_vdata, void *matvec_vdata );

HYPRE_Int
hypre_SSAMGRelaxSetMaxIter_flt( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SSAMGRelaxSetMaxIter_dbl( void *relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SSAMGRelaxSetMaxIter_long_dbl( void *relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SSAMGRelaxSetNodeset_flt( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );
HYPRE_Int
hypre_SSAMGRelaxSetNodeset_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );
HYPRE_Int
hypre_SSAMGRelaxSetNodeset_long_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices );

HYPRE_Int
hypre_SSAMGRelaxSetNodesetRank_flt( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );
HYPRE_Int
hypre_SSAMGRelaxSetNodesetRank_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );
HYPRE_Int
hypre_SSAMGRelaxSetNodesetRank_long_dbl( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank );

HYPRE_Int
hypre_SSAMGRelaxSetNumNodesets_flt( void *relax_vdata, HYPRE_Int num_nodesets );
HYPRE_Int
hypre_SSAMGRelaxSetNumNodesets_dbl( void *relax_vdata, HYPRE_Int num_nodesets );
HYPRE_Int
hypre_SSAMGRelaxSetNumNodesets_long_dbl( void *relax_vdata, HYPRE_Int num_nodesets );

HYPRE_Int
hypre_SSAMGRelaxSetPostRelax_flt( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetPostRelax_dbl( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetPostRelax_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SSAMGRelaxSetPreRelax_flt( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetPreRelax_dbl( void *relax_vdata );
HYPRE_Int
hypre_SSAMGRelaxSetPreRelax_long_dbl( void *relax_vdata );

HYPRE_Int
hypre_SSAMGRelaxSetTempVec_flt( void *relax_vdata, hypre_SStructVector *t );
HYPRE_Int
hypre_SSAMGRelaxSetTempVec_dbl( void *relax_vdata, hypre_SStructVector *t );
HYPRE_Int
hypre_SSAMGRelaxSetTempVec_long_dbl( void *relax_vdata, hypre_SStructVector *t );

HYPRE_Int
hypre_SSAMGRelaxSetTol_flt( void *relax_vdata, hypre_float tol );
HYPRE_Int
hypre_SSAMGRelaxSetTol_dbl( void *relax_vdata, hypre_double tol );
HYPRE_Int
hypre_SSAMGRelaxSetTol_long_dbl( void *relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SSAMGRelaxSetType_flt( void *relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SSAMGRelaxSetType_dbl( void *relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SSAMGRelaxSetType_long_dbl( void *relax_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_SSAMGRelaxSetWeights_flt( void *relax_vdata, hypre_float *weights );
HYPRE_Int
hypre_SSAMGRelaxSetWeights_dbl( void *relax_vdata, hypre_double *weights );
HYPRE_Int
hypre_SSAMGRelaxSetWeights_long_dbl( void *relax_vdata, hypre_long_double *weights );

HYPRE_Int
hypre_SSAMGRelaxSetZeroGuess_flt( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SSAMGRelaxSetZeroGuess_dbl( void *relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SSAMGRelaxSetZeroGuess_long_dbl( void *relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SSAMGRelaxSetup_flt( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxSetup_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGRelaxSetup_long_dbl( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SSAMGSetCoarseSolverType_flt( void *ssamg_vdata, HYPRE_Int csolver_type );
HYPRE_Int
hypre_SSAMGSetCoarseSolverType_dbl( void *ssamg_vdata, HYPRE_Int csolver_type );
HYPRE_Int
hypre_SSAMGSetCoarseSolverType_long_dbl( void *ssamg_vdata, HYPRE_Int csolver_type );

HYPRE_Int
hypre_SSAMGSetDxyz_flt( void *ssamg_vdata, HYPRE_Int nparts, hypre_float **dxyz );
HYPRE_Int
hypre_SSAMGSetDxyz_dbl( void *ssamg_vdata, HYPRE_Int nparts, hypre_double **dxyz );
HYPRE_Int
hypre_SSAMGSetDxyz_long_dbl( void *ssamg_vdata, HYPRE_Int nparts, hypre_long_double **dxyz );

HYPRE_Int
hypre_SSAMGSetInterpType_flt( void *ssamg_vdata, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetInterpType_dbl( void *ssamg_vdata, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetInterpType_long_dbl( void *ssamg_vdata, HYPRE_Int interp_type );

HYPRE_Int
hypre_SSAMGSetLogging_flt( void *ssamg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SSAMGSetLogging_dbl( void *ssamg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SSAMGSetLogging_long_dbl( void *ssamg_vdata, HYPRE_Int logging );

HYPRE_Int
hypre_SSAMGSetMaxCoarseSize_flt( void *ssamg_vdata, HYPRE_Int max_coarse_size );
HYPRE_Int
hypre_SSAMGSetMaxCoarseSize_dbl( void *ssamg_vdata, HYPRE_Int max_coarse_size );
HYPRE_Int
hypre_SSAMGSetMaxCoarseSize_long_dbl( void *ssamg_vdata, HYPRE_Int max_coarse_size );

HYPRE_Int
hypre_SSAMGSetMaxIter_flt( void *ssamg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SSAMGSetMaxIter_dbl( void *ssamg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SSAMGSetMaxIter_long_dbl( void *ssamg_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SSAMGSetMaxLevels_flt( void *ssamg_vdata, HYPRE_Int max_levels );
HYPRE_Int
hypre_SSAMGSetMaxLevels_dbl( void *ssamg_vdata, HYPRE_Int max_levels );
HYPRE_Int
hypre_SSAMGSetMaxLevels_long_dbl( void *ssamg_vdata, HYPRE_Int max_levels );

HYPRE_Int
hypre_SSAMGSetNonGalerkinRAP_flt( void *ssamg_vdata, HYPRE_Int non_galerkin );
HYPRE_Int
hypre_SSAMGSetNonGalerkinRAP_dbl( void *ssamg_vdata, HYPRE_Int non_galerkin );
HYPRE_Int
hypre_SSAMGSetNonGalerkinRAP_long_dbl( void *ssamg_vdata, HYPRE_Int non_galerkin );

HYPRE_Int
hypre_SSAMGSetNumCoarseRelax_flt( void *ssamg_vdata, HYPRE_Int num_coarse_relax );
HYPRE_Int
hypre_SSAMGSetNumCoarseRelax_dbl( void *ssamg_vdata, HYPRE_Int num_coarse_relax );
HYPRE_Int
hypre_SSAMGSetNumCoarseRelax_long_dbl( void *ssamg_vdata, HYPRE_Int num_coarse_relax );

HYPRE_Int
hypre_SSAMGSetNumPosRelax_flt( void *ssamg_vdata, HYPRE_Int num_pos_relax );
HYPRE_Int
hypre_SSAMGSetNumPosRelax_dbl( void *ssamg_vdata, HYPRE_Int num_pos_relax );
HYPRE_Int
hypre_SSAMGSetNumPosRelax_long_dbl( void *ssamg_vdata, HYPRE_Int num_pos_relax );

HYPRE_Int
hypre_SSAMGSetNumPreRelax_flt( void *ssamg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SSAMGSetNumPreRelax_dbl( void *ssamg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SSAMGSetNumPreRelax_long_dbl( void *ssamg_vdata, HYPRE_Int num_pre_relax );

HYPRE_Int
hypre_SSAMGSetPrintFreq_flt( void *ssamg_vdata, HYPRE_Int print_freq );
HYPRE_Int
hypre_SSAMGSetPrintFreq_dbl( void *ssamg_vdata, HYPRE_Int print_freq );
HYPRE_Int
hypre_SSAMGSetPrintFreq_long_dbl( void *ssamg_vdata, HYPRE_Int print_freq );

HYPRE_Int
hypre_SSAMGSetPrintLevel_flt( void *ssamg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SSAMGSetPrintLevel_dbl( void *ssamg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SSAMGSetPrintLevel_long_dbl( void *ssamg_vdata, HYPRE_Int print_level );

HYPRE_Int
hypre_SSAMGSetRelChange_flt( void *ssamg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SSAMGSetRelChange_dbl( void *ssamg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SSAMGSetRelChange_long_dbl( void *ssamg_vdata, HYPRE_Int rel_change );

HYPRE_Int
hypre_SSAMGSetRelaxType_flt( void *ssamg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SSAMGSetRelaxType_dbl( void *ssamg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SSAMGSetRelaxType_long_dbl( void *ssamg_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_SSAMGSetRelaxWeight_flt( void *ssamg_vdata, hypre_float relax_weight );
HYPRE_Int
hypre_SSAMGSetRelaxWeight_dbl( void *ssamg_vdata, hypre_double relax_weight );
HYPRE_Int
hypre_SSAMGSetRelaxWeight_long_dbl( void *ssamg_vdata, hypre_long_double relax_weight );

HYPRE_Int
hypre_SSAMGSetSkipRelax_flt( void *ssamg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_SSAMGSetSkipRelax_dbl( void *ssamg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_SSAMGSetSkipRelax_long_dbl( void *ssamg_vdata, HYPRE_Int skip_relax );

HYPRE_Int
hypre_SSAMGSetTol_flt( void *ssamg_vdata, hypre_float tol );
HYPRE_Int
hypre_SSAMGSetTol_dbl( void *ssamg_vdata, hypre_double tol );
HYPRE_Int
hypre_SSAMGSetTol_long_dbl( void *ssamg_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SSAMGSetZeroGuess_flt( void *ssamg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SSAMGSetZeroGuess_dbl( void *ssamg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SSAMGSetZeroGuess_long_dbl( void *ssamg_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SSAMGSetup_flt( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGSetup_dbl( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGSetup_long_dbl( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SSAMGSetupInterpOp_flt( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetupInterpOp_dbl( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetupInterpOp_long_dbl( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );

HYPRE_Int
hypre_SSAMGSetupUInterpOp_flt( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetupUInterpOp_dbl( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );
HYPRE_Int
hypre_SSAMGSetupUInterpOp_long_dbl( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type );

HYPRE_Int
hypre_SSAMGSolve_flt( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGSolve_dbl( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );
HYPRE_Int
hypre_SSAMGSolve_long_dbl( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x );

HYPRE_Int
hypre_SStructKrylovAxpy_flt( hypre_float alpha, void *x, void *y );
HYPRE_Int
hypre_SStructKrylovAxpy_dbl( hypre_double alpha, void *x, void *y );
HYPRE_Int
hypre_SStructKrylovAxpy_long_dbl( hypre_long_double alpha, void *x, void *y );

void *
hypre_SStructKrylovCAlloc_flt( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_SStructKrylovCAlloc_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );
void *
hypre_SStructKrylovCAlloc_long_dbl( size_t count, size_t elt_size, HYPRE_MemoryLocation location );

HYPRE_Int
hypre_SStructKrylovClearVector_flt( void *x );
HYPRE_Int
hypre_SStructKrylovClearVector_dbl( void *x );
HYPRE_Int
hypre_SStructKrylovClearVector_long_dbl( void *x );

HYPRE_Int
hypre_SStructKrylovCommInfo_flt( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );
HYPRE_Int
hypre_SStructKrylovCommInfo_dbl( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );
HYPRE_Int
hypre_SStructKrylovCommInfo_long_dbl( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs );

HYPRE_Int
hypre_SStructKrylovCopyVector_flt( void *x, void *y );
HYPRE_Int
hypre_SStructKrylovCopyVector_dbl( void *x, void *y );
HYPRE_Int
hypre_SStructKrylovCopyVector_long_dbl( void *x, void *y );

void *
hypre_SStructKrylovCreateVector_flt( void *vvector );
void *
hypre_SStructKrylovCreateVector_dbl( void *vvector );
void *
hypre_SStructKrylovCreateVector_long_dbl( void *vvector );

void *
hypre_SStructKrylovCreateVectorArray_flt( HYPRE_Int n, void *vvector );
void *
hypre_SStructKrylovCreateVectorArray_dbl( HYPRE_Int n, void *vvector );
void *
hypre_SStructKrylovCreateVectorArray_long_dbl( HYPRE_Int n, void *vvector );

HYPRE_Int
hypre_SStructKrylovDestroyVector_flt( void *vvector );
HYPRE_Int
hypre_SStructKrylovDestroyVector_dbl( void *vvector );
HYPRE_Int
hypre_SStructKrylovDestroyVector_long_dbl( void *vvector );

HYPRE_Int
hypre_SStructKrylovFree_flt( void *ptr );
HYPRE_Int
hypre_SStructKrylovFree_dbl( void *ptr );
HYPRE_Int
hypre_SStructKrylovFree_long_dbl( void *ptr );

HYPRE_Int
hypre_SStructKrylovIdentity_flt( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_SStructKrylovIdentity_dbl( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_SStructKrylovIdentity_long_dbl( void *vdata, void *A, void *b, void *x );

HYPRE_Int
hypre_SStructKrylovIdentitySetup_flt( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_SStructKrylovIdentitySetup_dbl( void *vdata, void *A, void *b, void *x );
HYPRE_Int
hypre_SStructKrylovIdentitySetup_long_dbl( void *vdata, void *A, void *b, void *x );

HYPRE_Real
hypre_SStructKrylovInnerProd_flt( void *x, void *y );
HYPRE_Real
hypre_SStructKrylovInnerProd_dbl( void *x, void *y );
HYPRE_Real
hypre_SStructKrylovInnerProd_long_dbl( void *x, void *y );

HYPRE_Int
hypre_SStructKrylovInnerProdTagged_flt( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_float **iprod_ptr );
HYPRE_Int
hypre_SStructKrylovInnerProdTagged_dbl( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_double **iprod_ptr );
HYPRE_Int
hypre_SStructKrylovInnerProdTagged_long_dbl( void *x, void *y, HYPRE_Int *num_tags_ptr, hypre_long_double **iprod_ptr );

HYPRE_Int
hypre_SStructKrylovMatvec_flt( void *matvec_data, hypre_float alpha, void *A, void *x, hypre_float beta, void *y );
HYPRE_Int
hypre_SStructKrylovMatvec_dbl( void *matvec_data, hypre_double alpha, void *A, void *x, hypre_double beta, void *y );
HYPRE_Int
hypre_SStructKrylovMatvec_long_dbl( void *matvec_data, hypre_long_double alpha, void *A, void *x, hypre_long_double beta, void *y );

void *
hypre_SStructKrylovMatvecCreate_flt( void *A, void *x );
void *
hypre_SStructKrylovMatvecCreate_dbl( void *A, void *x );
void *
hypre_SStructKrylovMatvecCreate_long_dbl( void *A, void *x );

HYPRE_Int
hypre_SStructKrylovMatvecDestroy_flt( void *matvec_data );
HYPRE_Int
hypre_SStructKrylovMatvecDestroy_dbl( void *matvec_data );
HYPRE_Int
hypre_SStructKrylovMatvecDestroy_long_dbl( void *matvec_data );

HYPRE_Int
hypre_SStructKrylovScaleVector_flt( hypre_float alpha, void *x );
HYPRE_Int
hypre_SStructKrylovScaleVector_dbl( hypre_double alpha, void *x );
HYPRE_Int
hypre_SStructKrylovScaleVector_long_dbl( hypre_long_double alpha, void *x );

HYPRE_Int
hypre_SStructSetRandomValues_flt( void *v, HYPRE_Int seed );
HYPRE_Int
hypre_SStructSetRandomValues_dbl( void *v, HYPRE_Int seed );
HYPRE_Int
hypre_SStructSetRandomValues_long_dbl( void *v, HYPRE_Int seed );

void *
hypre_SysPFMGCreate_flt( MPI_Comm comm );
void *
hypre_SysPFMGCreate_dbl( MPI_Comm comm );
void *
hypre_SysPFMGCreate_long_dbl( MPI_Comm comm );

hypre_SStructPMatrix *
hypre_SysPFMGCreateInterpOp_flt( hypre_SStructPMatrix *A, HYPRE_Int cdir, hypre_Index stride );
hypre_SStructPMatrix *
hypre_SysPFMGCreateInterpOp_dbl( hypre_SStructPMatrix *A, HYPRE_Int cdir, hypre_Index stride );
hypre_SStructPMatrix *
hypre_SysPFMGCreateInterpOp_long_dbl( hypre_SStructPMatrix *A, HYPRE_Int cdir, hypre_Index stride );

HYPRE_Int
hypre_SysPFMGDestroy_flt( void *sys_pfmg_vdata );
HYPRE_Int
hypre_SysPFMGDestroy_dbl( void *sys_pfmg_vdata );
HYPRE_Int
hypre_SysPFMGDestroy_long_dbl( void *sys_pfmg_vdata );

HYPRE_Int
hypre_SysPFMGGetFinalRelativeResidualNorm_flt( void *sys_pfmg_vdata, hypre_float *relative_residual_norm );
HYPRE_Int
hypre_SysPFMGGetFinalRelativeResidualNorm_dbl( void *sys_pfmg_vdata, hypre_double *relative_residual_norm );
HYPRE_Int
hypre_SysPFMGGetFinalRelativeResidualNorm_long_dbl( void *sys_pfmg_vdata, hypre_long_double *relative_residual_norm );

HYPRE_Int
hypre_SysPFMGGetNumIterations_flt( void *sys_pfmg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SysPFMGGetNumIterations_dbl( void *sys_pfmg_vdata, HYPRE_Int *num_iterations );
HYPRE_Int
hypre_SysPFMGGetNumIterations_long_dbl( void *sys_pfmg_vdata, HYPRE_Int *num_iterations );

HYPRE_Int
hypre_SysPFMGPrintLogging_flt( void *sys_pfmg_vdata );
HYPRE_Int
hypre_SysPFMGPrintLogging_dbl( void *sys_pfmg_vdata );
HYPRE_Int
hypre_SysPFMGPrintLogging_long_dbl( void *sys_pfmg_vdata );

HYPRE_Int
hypre_SysPFMGRelax_flt( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_SysPFMGRelax_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_SysPFMGRelax_long_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );

void *
hypre_SysPFMGRelaxCreate_flt( MPI_Comm comm );
void *
hypre_SysPFMGRelaxCreate_dbl( MPI_Comm comm );
void *
hypre_SysPFMGRelaxCreate_long_dbl( MPI_Comm comm );

HYPRE_Int
hypre_SysPFMGRelaxDestroy_flt( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxDestroy_dbl( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxDestroy_long_dbl( void *sys_pfmg_relax_vdata );

HYPRE_Int
hypre_SysPFMGRelaxSetJacobiWeight_flt( void *sys_pfmg_relax_vdata, hypre_float weight );
HYPRE_Int
hypre_SysPFMGRelaxSetJacobiWeight_dbl( void *sys_pfmg_relax_vdata, hypre_double weight );
HYPRE_Int
hypre_SysPFMGRelaxSetJacobiWeight_long_dbl( void *sys_pfmg_relax_vdata, hypre_long_double weight );

HYPRE_Int
hypre_SysPFMGRelaxSetMaxIter_flt( void *sys_pfmg_relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SysPFMGRelaxSetMaxIter_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SysPFMGRelaxSetMaxIter_long_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SysPFMGRelaxSetPostRelax_flt( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxSetPostRelax_dbl( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxSetPostRelax_long_dbl( void *sys_pfmg_relax_vdata );

HYPRE_Int
hypre_SysPFMGRelaxSetPreRelax_flt( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxSetPreRelax_dbl( void *sys_pfmg_relax_vdata );
HYPRE_Int
hypre_SysPFMGRelaxSetPreRelax_long_dbl( void *sys_pfmg_relax_vdata );

HYPRE_Int
hypre_SysPFMGRelaxSetTempVec_flt( void *sys_pfmg_relax_vdata, hypre_SStructPVector *t );
HYPRE_Int
hypre_SysPFMGRelaxSetTempVec_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPVector *t );
HYPRE_Int
hypre_SysPFMGRelaxSetTempVec_long_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPVector *t );

HYPRE_Int
hypre_SysPFMGRelaxSetTol_flt( void *sys_pfmg_relax_vdata, hypre_float tol );
HYPRE_Int
hypre_SysPFMGRelaxSetTol_dbl( void *sys_pfmg_relax_vdata, hypre_double tol );
HYPRE_Int
hypre_SysPFMGRelaxSetTol_long_dbl( void *sys_pfmg_relax_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SysPFMGRelaxSetType_flt( void *sys_pfmg_relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SysPFMGRelaxSetType_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SysPFMGRelaxSetType_long_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_SysPFMGRelaxSetZeroGuess_flt( void *sys_pfmg_relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SysPFMGRelaxSetZeroGuess_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SysPFMGRelaxSetZeroGuess_long_dbl( void *sys_pfmg_relax_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SysPFMGRelaxSetup_flt( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_SysPFMGRelaxSetup_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );
HYPRE_Int
hypre_SysPFMGRelaxSetup_long_dbl( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x );

HYPRE_Int
hypre_SysPFMGSetDxyz_flt( void *sys_pfmg_vdata, hypre_float *dxyz );
HYPRE_Int
hypre_SysPFMGSetDxyz_dbl( void *sys_pfmg_vdata, hypre_double *dxyz );
HYPRE_Int
hypre_SysPFMGSetDxyz_long_dbl( void *sys_pfmg_vdata, hypre_long_double *dxyz );

HYPRE_Int
hypre_SysPFMGSetJacobiWeight_flt( void *sys_pfmg_vdata, hypre_float weight );
HYPRE_Int
hypre_SysPFMGSetJacobiWeight_dbl( void *sys_pfmg_vdata, hypre_double weight );
HYPRE_Int
hypre_SysPFMGSetJacobiWeight_long_dbl( void *sys_pfmg_vdata, hypre_long_double weight );

HYPRE_Int
hypre_SysPFMGSetLogging_flt( void *sys_pfmg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SysPFMGSetLogging_dbl( void *sys_pfmg_vdata, HYPRE_Int logging );
HYPRE_Int
hypre_SysPFMGSetLogging_long_dbl( void *sys_pfmg_vdata, HYPRE_Int logging );

HYPRE_Int
hypre_SysPFMGSetMaxIter_flt( void *sys_pfmg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SysPFMGSetMaxIter_dbl( void *sys_pfmg_vdata, HYPRE_Int max_iter );
HYPRE_Int
hypre_SysPFMGSetMaxIter_long_dbl( void *sys_pfmg_vdata, HYPRE_Int max_iter );

HYPRE_Int
hypre_SysPFMGSetNumPostRelax_flt( void *sys_pfmg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SysPFMGSetNumPostRelax_dbl( void *sys_pfmg_vdata, HYPRE_Int num_post_relax );
HYPRE_Int
hypre_SysPFMGSetNumPostRelax_long_dbl( void *sys_pfmg_vdata, HYPRE_Int num_post_relax );

HYPRE_Int
hypre_SysPFMGSetNumPreRelax_flt( void *sys_pfmg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SysPFMGSetNumPreRelax_dbl( void *sys_pfmg_vdata, HYPRE_Int num_pre_relax );
HYPRE_Int
hypre_SysPFMGSetNumPreRelax_long_dbl( void *sys_pfmg_vdata, HYPRE_Int num_pre_relax );

HYPRE_Int
hypre_SysPFMGSetPrintLevel_flt( void *sys_pfmg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SysPFMGSetPrintLevel_dbl( void *sys_pfmg_vdata, HYPRE_Int print_level );
HYPRE_Int
hypre_SysPFMGSetPrintLevel_long_dbl( void *sys_pfmg_vdata, HYPRE_Int print_level );

HYPRE_Int
hypre_SysPFMGSetRelChange_flt( void *sys_pfmg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SysPFMGSetRelChange_dbl( void *sys_pfmg_vdata, HYPRE_Int rel_change );
HYPRE_Int
hypre_SysPFMGSetRelChange_long_dbl( void *sys_pfmg_vdata, HYPRE_Int rel_change );

HYPRE_Int
hypre_SysPFMGSetRelaxType_flt( void *sys_pfmg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SysPFMGSetRelaxType_dbl( void *sys_pfmg_vdata, HYPRE_Int relax_type );
HYPRE_Int
hypre_SysPFMGSetRelaxType_long_dbl( void *sys_pfmg_vdata, HYPRE_Int relax_type );

HYPRE_Int
hypre_SysPFMGSetSkipRelax_flt( void *sys_pfmg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_SysPFMGSetSkipRelax_dbl( void *sys_pfmg_vdata, HYPRE_Int skip_relax );
HYPRE_Int
hypre_SysPFMGSetSkipRelax_long_dbl( void *sys_pfmg_vdata, HYPRE_Int skip_relax );

HYPRE_Int
hypre_SysPFMGSetTol_flt( void *sys_pfmg_vdata, hypre_float tol );
HYPRE_Int
hypre_SysPFMGSetTol_dbl( void *sys_pfmg_vdata, hypre_double tol );
HYPRE_Int
hypre_SysPFMGSetTol_long_dbl( void *sys_pfmg_vdata, hypre_long_double tol );

HYPRE_Int
hypre_SysPFMGSetZeroGuess_flt( void *sys_pfmg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SysPFMGSetZeroGuess_dbl( void *sys_pfmg_vdata, HYPRE_Int zero_guess );
HYPRE_Int
hypre_SysPFMGSetZeroGuess_long_dbl( void *sys_pfmg_vdata, HYPRE_Int zero_guess );

HYPRE_Int
hypre_SysPFMGSetup_flt( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );
HYPRE_Int
hypre_SysPFMGSetup_dbl( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );
HYPRE_Int
hypre_SysPFMGSetup_long_dbl( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );

HYPRE_Int
hypre_SysPFMGSetupInterpOp_flt( hypre_SStructPMatrix *P, hypre_SStructPMatrix *A, HYPRE_Int cdir );
HYPRE_Int
hypre_SysPFMGSetupInterpOp_dbl( hypre_SStructPMatrix *P, hypre_SStructPMatrix *A, HYPRE_Int cdir );
HYPRE_Int
hypre_SysPFMGSetupInterpOp_long_dbl( hypre_SStructPMatrix *P, hypre_SStructPMatrix *A, HYPRE_Int cdir );

HYPRE_Int
hypre_SysPFMGSolve_flt( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );
HYPRE_Int
hypre_SysPFMGSolve_dbl( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );
HYPRE_Int
hypre_SysPFMGSolve_long_dbl( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in );

HYPRE_Int
hypre_SysPFMGZeroDiagonal_flt( hypre_SStructPMatrix *A );
HYPRE_Int
hypre_SysPFMGZeroDiagonal_dbl( hypre_SStructPMatrix *A );
HYPRE_Int
hypre_SysPFMGZeroDiagonal_long_dbl( hypre_SStructPMatrix *A );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

