package words_test

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/17.0.0/ucd/auxiliary/WordBreakTest.txt

type unicodeTest struct {
	input    []byte
	expected [][]byte
	comment  string
}

var unicodeTests = [1944]unicodeTest{
	{
		input:    []byte{0xd, 0xd},
		expected: [][]byte{{0xd}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa},
		expected: [][]byte{{0xd, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xb},
		expected: [][]byte{{0xd}, {0xb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xd}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x41},
		expected: [][]byte{{0xd}, {0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x3a},
		expected: [][]byte{{0xd}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2c},
		expected: [][]byte{{0xd}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2e},
		expected: [][]byte{{0xd}, {0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x30},
		expected: [][]byte{{0xd}, {0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x5f},
		expected: [][]byte{{0xd}, {0x5f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xd7, 0x90},
		expected: [][]byte{{0xd}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x22},
		expected: [][]byte{{0xd}, {0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x27},
		expected: [][]byte{{0xd}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0xa9},
		expected: [][]byte{{0xd}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x20},
		expected: [][]byte{{0xd}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x0},
		expected: [][]byte{{0xd}, {0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x3a},
		expected: [][]byte{{0xd}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x27},
		expected: [][]byte{{0xd}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x2c},
		expected: [][]byte{{0xd}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x3a},
		expected: [][]byte{{0xd}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x27},
		expected: [][]byte{{0xd}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x2c},
		expected: [][]byte{{0xd}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd},
		expected: [][]byte{{0xa}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xa},
		expected: [][]byte{{0xa}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xb},
		expected: [][]byte{{0xa}, {0xb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xa}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xa}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x41},
		expected: [][]byte{{0xa}, {0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x3a},
		expected: [][]byte{{0xa}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2c},
		expected: [][]byte{{0xa}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2e},
		expected: [][]byte{{0xa}, {0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x30},
		expected: [][]byte{{0xa}, {0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x5f},
		expected: [][]byte{{0xa}, {0x5f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd7, 0x90},
		expected: [][]byte{{0xa}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x22},
		expected: [][]byte{{0xa}, {0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x27},
		expected: [][]byte{{0xa}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0xa9},
		expected: [][]byte{{0xa}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x20},
		expected: [][]byte{{0xa}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x0},
		expected: [][]byte{{0xa}, {0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x3a},
		expected: [][]byte{{0xa}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x27},
		expected: [][]byte{{0xa}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x2c},
		expected: [][]byte{{0xa}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x3a},
		expected: [][]byte{{0xa}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x27},
		expected: [][]byte{{0xa}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x2c},
		expected: [][]byte{{0xa}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xd},
		expected: [][]byte{{0xb}, {0xd}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xa},
		expected: [][]byte{{0xb}, {0xa}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xb},
		expected: [][]byte{{0xb}, {0xb}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x80},
		expected: [][]byte{{0xb}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xc2, 0xad},
		expected: [][]byte{{0xb}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xb}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xb}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x41},
		expected: [][]byte{{0xb}, {0x41}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x3a},
		expected: [][]byte{{0xb}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x2c},
		expected: [][]byte{{0xb}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x2e},
		expected: [][]byte{{0xb}, {0x2e}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x30},
		expected: [][]byte{{0xb}, {0x30}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x5f},
		expected: [][]byte{{0xb}, {0x5f}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xb}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xd7, 0x90},
		expected: [][]byte{{0xb}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x22},
		expected: [][]byte{{0xb}, {0x22}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x27},
		expected: [][]byte{{0xb}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xb}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xc2, 0xa9},
		expected: [][]byte{{0xb}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x20},
		expected: [][]byte{{0xb}, {0x20}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x0},
		expected: [][]byte{{0xb}, {0x0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x3a},
		expected: [][]byte{{0xb}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x27},
		expected: [][]byte{{0xb}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x2c},
		expected: [][]byte{{0xb}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x3a},
		expected: [][]byte{{0xb}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x27},
		expected: [][]byte{{0xb}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x2c},
		expected: [][]byte{{0xb}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd},
		expected: [][]byte{{0xcc, 0x80}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xa},
		expected: [][]byte{{0xcc, 0x80}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xb},
		expected: [][]byte{{0xcc, 0x80}, {0xb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xcc, 0x80}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xcc, 0x80}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x41},
		expected: [][]byte{{0xcc, 0x80}, {0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2e},
		expected: [][]byte{{0xcc, 0x80}, {0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x30},
		expected: [][]byte{{0xcc, 0x80}, {0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x5f},
		expected: [][]byte{{0xcc, 0x80}, {0x5f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd7, 0x90},
		expected: [][]byte{{0xcc, 0x80}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x22},
		expected: [][]byte{{0xcc, 0x80}, {0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0xa9},
		expected: [][]byte{{0xcc, 0x80}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x20},
		expected: [][]byte{{0xcc, 0x80}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x0},
		expected: [][]byte{{0xcc, 0x80}, {0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xd},
		expected: [][]byte{{0xc2, 0xad}, {0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xa},
		expected: [][]byte{{0xc2, 0xad}, {0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xb},
		expected: [][]byte{{0xc2, 0xad}, {0xb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xad}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xc2, 0xad}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x41},
		expected: [][]byte{{0xc2, 0xad}, {0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2e},
		expected: [][]byte{{0xc2, 0xad}, {0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x30},
		expected: [][]byte{{0xc2, 0xad}, {0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x5f},
		expected: [][]byte{{0xc2, 0xad}, {0x5f}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xad}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xad}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x22},
		expected: [][]byte{{0xc2, 0xad}, {0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xad, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xad}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x20},
		expected: [][]byte{{0xc2, 0xad}, {0x20}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x0},
		expected: [][]byte{{0xc2, 0xad}, {0x0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xd},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xd}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xa},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xa}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xb},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xb}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x80},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x80}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xc2, 0xad},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xc2, 0xad}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x41},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x41}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x2e},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x2e}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x30},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x30}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x5f},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0x5f}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xd7, 0x90},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xd7, 0x90}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x22},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x22}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xc2, 0xa9},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x20},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x20}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xd},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xd}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xa},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xa}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xb},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xb}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x80}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xc2, 0xad}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x41},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x41}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x2e},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x2e}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x30},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x30}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x5f},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x5f}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xd7, 0x90}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x22},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x22}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x20},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x20}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x0},
		expected: [][]byte{{0xe2, 0x93, 0x82}, {0x0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x61}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x61}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x61}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x31}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x31}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x31}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x93, 0x82, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xd},
		expected: [][]byte{{0x41}, {0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xa},
		expected: [][]byte{{0x41}, {0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xb},
		expected: [][]byte{{0x41}, {0xb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x41}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x41, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x41},
		expected: [][]byte{{0x41, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a},
		expected: [][]byte{{0x41}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2c},
		expected: [][]byte{{0x41}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2e},
		expected: [][]byte{{0x41}, {0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x30},
		expected: [][]byte{{0x41, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f},
		expected: [][]byte{{0x41, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x41}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xd7, 0x90},
		expected: [][]byte{{0x41, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x22},
		expected: [][]byte{{0x41}, {0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x27},
		expected: [][]byte{{0x41}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x41, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc2, 0xa9},
		expected: [][]byte{{0x41}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x20},
		expected: [][]byte{{0x41}, {0x20}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x0},
		expected: [][]byte{{0x41}, {0x0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x3a},
		expected: [][]byte{{0x41, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x27},
		expected: [][]byte{{0x41, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x2c},
		expected: [][]byte{{0x41, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x3a},
		expected: [][]byte{{0x41, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x27},
		expected: [][]byte{{0x41, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x2c},
		expected: [][]byte{{0x41, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xd},
		expected: [][]byte{{0x3a}, {0xd}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xa},
		expected: [][]byte{{0x3a}, {0xa}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xb},
		expected: [][]byte{{0x3a}, {0xb}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x3a}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x41},
		expected: [][]byte{{0x3a}, {0x41}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x3a},
		expected: [][]byte{{0x3a}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x2c},
		expected: [][]byte{{0x3a}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x2e},
		expected: [][]byte{{0x3a}, {0x2e}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x30},
		expected: [][]byte{{0x3a}, {0x30}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x5f},
		expected: [][]byte{{0x3a}, {0x5f}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x3a}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x22},
		expected: [][]byte{{0x3a}, {0x22}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x27},
		expected: [][]byte{{0x3a}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xc2, 0xa9},
		expected: [][]byte{{0x3a}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x20},
		expected: [][]byte{{0x3a}, {0x20}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x0},
		expected: [][]byte{{0x3a}, {0x0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x3a}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x27},
		expected: [][]byte{{0x3a}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x3a}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x27},
		expected: [][]byte{{0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xd},
		expected: [][]byte{{0x2c}, {0xd}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xa},
		expected: [][]byte{{0x2c}, {0xa}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xb},
		expected: [][]byte{{0x2c}, {0xb}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x2c}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x41},
		expected: [][]byte{{0x2c}, {0x41}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x3a},
		expected: [][]byte{{0x2c}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2c},
		expected: [][]byte{{0x2c}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2e},
		expected: [][]byte{{0x2c}, {0x2e}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x30},
		expected: [][]byte{{0x2c}, {0x30}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x5f},
		expected: [][]byte{{0x2c}, {0x5f}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x22},
		expected: [][]byte{{0x2c}, {0x22}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x27},
		expected: [][]byte{{0x2c}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc2, 0xa9},
		expected: [][]byte{{0x2c}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x20},
		expected: [][]byte{{0x2c}, {0x20}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x0},
		expected: [][]byte{{0x2c}, {0x0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x27},
		expected: [][]byte{{0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x2c}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x27},
		expected: [][]byte{{0x2c}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x2c}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xd},
		expected: [][]byte{{0x2e}, {0xd}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xa},
		expected: [][]byte{{0x2e}, {0xa}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xb},
		expected: [][]byte{{0x2e}, {0xb}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2e}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x2e}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x41},
		expected: [][]byte{{0x2e}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x3a},
		expected: [][]byte{{0x2e}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2c},
		expected: [][]byte{{0x2e}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2e},
		expected: [][]byte{{0x2e}, {0x2e}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x30},
		expected: [][]byte{{0x2e}, {0x30}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x5f},
		expected: [][]byte{{0x2e}, {0x5f}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2e}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xd7, 0x90},
		expected: [][]byte{{0x2e}, {0xd7, 0x90}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x22},
		expected: [][]byte{{0x2e}, {0x22}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x27},
		expected: [][]byte{{0x2e}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2e, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc2, 0xa9},
		expected: [][]byte{{0x2e}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x20},
		expected: [][]byte{{0x2e}, {0x20}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x0},
		expected: [][]byte{{0x2e}, {0x0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x3a},
		expected: [][]byte{{0x2e}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x27},
		expected: [][]byte{{0x2e}, {0x61}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x2c},
		expected: [][]byte{{0x2e}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x3a},
		expected: [][]byte{{0x2e}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x27},
		expected: [][]byte{{0x2e}, {0x31}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x2c},
		expected: [][]byte{{0x2e}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xd},
		expected: [][]byte{{0x30}, {0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xa},
		expected: [][]byte{{0x30}, {0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xb},
		expected: [][]byte{{0x30}, {0xb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x30}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x30, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x41},
		expected: [][]byte{{0x30, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x3a},
		expected: [][]byte{{0x30}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c},
		expected: [][]byte{{0x30}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2e},
		expected: [][]byte{{0x30}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x30},
		expected: [][]byte{{0x30, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x5f},
		expected: [][]byte{{0x30, 0x5f}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x30}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xd7, 0x90},
		expected: [][]byte{{0x30, 0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x22},
		expected: [][]byte{{0x30}, {0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x27},
		expected: [][]byte{{0x30}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x30, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc2, 0xa9},
		expected: [][]byte{{0x30}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x20},
		expected: [][]byte{{0x30}, {0x20}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x0},
		expected: [][]byte{{0x30}, {0x0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x3a},
		expected: [][]byte{{0x30, 0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x27},
		expected: [][]byte{{0x30, 0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x2c},
		expected: [][]byte{{0x30, 0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [10.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x3a},
		expected: [][]byte{{0x30, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x27},
		expected: [][]byte{{0x30, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x2c},
		expected: [][]byte{{0x30, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xd},
		expected: [][]byte{{0x5f}, {0xd}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xa},
		expected: [][]byte{{0x5f}, {0xa}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xb},
		expected: [][]byte{{0x5f}, {0xb}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x80},
		expected: [][]byte{{0x5f, 0xcc, 0x80}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xc2, 0xad},
		expected: [][]byte{{0x5f, 0xc2, 0xad}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x5f, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x5f, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x41},
		expected: [][]byte{{0x5f, 0x41}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x3a},
		expected: [][]byte{{0x5f}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x2c},
		expected: [][]byte{{0x5f}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x2e},
		expected: [][]byte{{0x5f}, {0x2e}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x30},
		expected: [][]byte{{0x5f, 0x30}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x5f},
		expected: [][]byte{{0x5f, 0x5f}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x5f}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xd7, 0x90},
		expected: [][]byte{{0x5f, 0xd7, 0x90}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x22},
		expected: [][]byte{{0x5f}, {0x22}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x27},
		expected: [][]byte{{0x5f}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x5f, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xc2, 0xa9},
		expected: [][]byte{{0x5f}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x20},
		expected: [][]byte{{0x5f}, {0x20}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x0},
		expected: [][]byte{{0x5f}, {0x0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x3a},
		expected: [][]byte{{0x5f, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x27},
		expected: [][]byte{{0x5f, 0x61}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x2c},
		expected: [][]byte{{0x5f, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x3a},
		expected: [][]byte{{0x5f, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x27},
		expected: [][]byte{{0x5f, 0x31}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x2c},
		expected: [][]byte{{0x5f, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xb},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xb}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x41},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x41}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2e},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x2e}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x30},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x30}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x5f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x5f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd7, 0x90},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd7, 0x90}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x22},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x22}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xa9},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xd},
		expected: [][]byte{{0xd7, 0x90}, {0xd}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xa},
		expected: [][]byte{{0xd7, 0x90}, {0xa}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xb},
		expected: [][]byte{{0xd7, 0x90}, {0xb}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x80},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x80}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xc2, 0xad},
		expected: [][]byte{{0xd7, 0x90, 0xc2, 0xad}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd7, 0x90}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xd7, 0x90, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x41},
		expected: [][]byte{{0xd7, 0x90, 0x41}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x3a},
		expected: [][]byte{{0xd7, 0x90}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x2c},
		expected: [][]byte{{0xd7, 0x90}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x2e},
		expected: [][]byte{{0xd7, 0x90}, {0x2e}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x30},
		expected: [][]byte{{0xd7, 0x90, 0x30}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x5f},
		expected: [][]byte{{0xd7, 0x90, 0x5f}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd7, 0x90}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x22},
		expected: [][]byte{{0xd7, 0x90}, {0x22}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd7, 0x90, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xc2, 0xa9},
		expected: [][]byte{{0xd7, 0x90}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x20},
		expected: [][]byte{{0xd7, 0x90}, {0x20}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x0},
		expected: [][]byte{{0xd7, 0x90}, {0x0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xd},
		expected: [][]byte{{0x22}, {0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xa},
		expected: [][]byte{{0x22}, {0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xb},
		expected: [][]byte{{0x22}, {0xb}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x22}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x22}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x41},
		expected: [][]byte{{0x22}, {0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x3a},
		expected: [][]byte{{0x22}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2c},
		expected: [][]byte{{0x22}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2e},
		expected: [][]byte{{0x22}, {0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x30},
		expected: [][]byte{{0x22}, {0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x5f},
		expected: [][]byte{{0x22}, {0x5f}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x22}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xd7, 0x90},
		expected: [][]byte{{0x22}, {0xd7, 0x90}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x22},
		expected: [][]byte{{0x22}, {0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x27},
		expected: [][]byte{{0x22}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x22, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc2, 0xa9},
		expected: [][]byte{{0x22}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x20},
		expected: [][]byte{{0x22}, {0x20}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x0},
		expected: [][]byte{{0x22}, {0x0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x3a},
		expected: [][]byte{{0x22}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x27},
		expected: [][]byte{{0x22}, {0x61}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x2c},
		expected: [][]byte{{0x22}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x3a},
		expected: [][]byte{{0x22}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x27},
		expected: [][]byte{{0x22}, {0x31}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x2c},
		expected: [][]byte{{0x22}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xd},
		expected: [][]byte{{0x27}, {0xd}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xa},
		expected: [][]byte{{0x27}, {0xa}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xb},
		expected: [][]byte{{0x27}, {0xb}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x80},
		expected: [][]byte{{0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xc2, 0xad},
		expected: [][]byte{{0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x27}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x41},
		expected: [][]byte{{0x27}, {0x41}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x3a},
		expected: [][]byte{{0x27}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x2c},
		expected: [][]byte{{0x27}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x2e},
		expected: [][]byte{{0x27}, {0x2e}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x30},
		expected: [][]byte{{0x27}, {0x30}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x5f},
		expected: [][]byte{{0x27}, {0x5f}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xd7, 0x90},
		expected: [][]byte{{0x27}, {0xd7, 0x90}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x22},
		expected: [][]byte{{0x27}, {0x22}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x27},
		expected: [][]byte{{0x27}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xc2, 0xa9},
		expected: [][]byte{{0x27}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x20},
		expected: [][]byte{{0x27}, {0x20}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x0},
		expected: [][]byte{{0x27}, {0x0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x3a},
		expected: [][]byte{{0x27}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x27},
		expected: [][]byte{{0x27}, {0x61}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x2c},
		expected: [][]byte{{0x27}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x3a},
		expected: [][]byte{{0x27}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x27},
		expected: [][]byte{{0x27}, {0x31}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x2c},
		expected: [][]byte{{0x27}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xb},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xb}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xc2, 0xad}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [3.3] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x41},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x41}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x2e},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x2e}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x30},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x30}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x5f},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x5f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd7, 0x90}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x22},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x22}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [3.3] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xd},
		expected: [][]byte{{0xc2, 0xa9}, {0xd}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xa},
		expected: [][]byte{{0xc2, 0xa9}, {0xa}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xb},
		expected: [][]byte{{0xc2, 0xa9}, {0xb}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xa9, 0xc2, 0xad}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xa9}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xc2, 0xa9}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x41},
		expected: [][]byte{{0xc2, 0xa9}, {0x41}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x3a},
		expected: [][]byte{{0xc2, 0xa9}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x2c},
		expected: [][]byte{{0xc2, 0xa9}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x2e},
		expected: [][]byte{{0xc2, 0xa9}, {0x2e}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x30},
		expected: [][]byte{{0xc2, 0xa9}, {0x30}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x5f},
		expected: [][]byte{{0xc2, 0xa9}, {0x5f}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xa9}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xa9}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x22},
		expected: [][]byte{{0xc2, 0xa9}, {0x22}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x27},
		expected: [][]byte{{0xc2, 0xa9}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xa9}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x20},
		expected: [][]byte{{0xc2, 0xa9}, {0x20}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x0},
		expected: [][]byte{{0xc2, 0xa9}, {0x0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xa9}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xa9}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xa9}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xa9}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xa9}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xa9}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xa9, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xa9, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COPYRIGHT SIGN (ExtPictmALetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd},
		expected: [][]byte{{0x20}, {0xd}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xa},
		expected: [][]byte{{0x20}, {0xa}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xb},
		expected: [][]byte{{0x20}, {0xb}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xc2, 0xad},
		expected: [][]byte{{0x20, 0xc2, 0xad}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x20}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x20}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x41},
		expected: [][]byte{{0x20}, {0x41}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x3a},
		expected: [][]byte{{0x20}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x2c},
		expected: [][]byte{{0x20}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x2e},
		expected: [][]byte{{0x20}, {0x2e}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x30},
		expected: [][]byte{{0x20}, {0x30}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x5f},
		expected: [][]byte{{0x20}, {0x5f}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd7, 0x90},
		expected: [][]byte{{0x20}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x22},
		expected: [][]byte{{0x20}, {0x22}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x27},
		expected: [][]byte{{0x20}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xc2, 0xa9},
		expected: [][]byte{{0x20}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x20},
		expected: [][]byte{{0x20, 0x20}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x0},
		expected: [][]byte{{0x20}, {0x0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x3a},
		expected: [][]byte{{0x20}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x27},
		expected: [][]byte{{0x20}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x2c},
		expected: [][]byte{{0x20}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x3a},
		expected: [][]byte{{0x20}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x27},
		expected: [][]byte{{0x20}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x2c},
		expected: [][]byte{{0x20}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xd},
		expected: [][]byte{{0x0}, {0xd}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xa},
		expected: [][]byte{{0x0}, {0xa}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xb},
		expected: [][]byte{{0x0}, {0xb}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x80},
		expected: [][]byte{{0x0, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc2, 0xad},
		expected: [][]byte{{0x0, 0xc2, 0xad}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x0}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x41},
		expected: [][]byte{{0x0}, {0x41}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x3a},
		expected: [][]byte{{0x0}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x2c},
		expected: [][]byte{{0x0}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x2e},
		expected: [][]byte{{0x0}, {0x2e}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x30},
		expected: [][]byte{{0x0}, {0x30}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x5f},
		expected: [][]byte{{0x0}, {0x5f}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xd7, 0x90},
		expected: [][]byte{{0x0}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x22},
		expected: [][]byte{{0x0}, {0x22}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x27},
		expected: [][]byte{{0x0}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc2, 0xa9},
		expected: [][]byte{{0x0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x20},
		expected: [][]byte{{0x0}, {0x20}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x0},
		expected: [][]byte{{0x0}, {0x0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61, 0x3a},
		expected: [][]byte{{0x0}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61, 0x27},
		expected: [][]byte{{0x0}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61, 0x2c},
		expected: [][]byte{{0x0}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x31, 0x3a},
		expected: [][]byte{{0x0}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x31, 0x27},
		expected: [][]byte{{0x0}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x31, 0x2c},
		expected: [][]byte{{0x0}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x0, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <NULL> (XXmExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xa9},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xd},
		expected: [][]byte{{0x61}, {0x3a}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xa},
		expected: [][]byte{{0x61}, {0x3a}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xb},
		expected: [][]byte{{0x61}, {0x3a}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x3a, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x41},
		expected: [][]byte{{0x61, 0x3a, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x30},
		expected: [][]byte{{0x61}, {0x3a}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x5f},
		expected: [][]byte{{0x61}, {0x3a}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x3a, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x22},
		expected: [][]byte{{0x61}, {0x3a}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x27},
		expected: [][]byte{{0x61}, {0x3a}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x3a}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x20},
		expected: [][]byte{{0x61}, {0x3a}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x0},
		expected: [][]byte{{0x61}, {0x3a}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xd},
		expected: [][]byte{{0x61}, {0x27}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xa},
		expected: [][]byte{{0x61}, {0x27}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xb},
		expected: [][]byte{{0x61}, {0x27}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x41},
		expected: [][]byte{{0x61, 0x27, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x3a},
		expected: [][]byte{{0x61}, {0x27}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x2c},
		expected: [][]byte{{0x61}, {0x27}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x2e},
		expected: [][]byte{{0x61}, {0x27}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x30},
		expected: [][]byte{{0x61}, {0x27}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x5f},
		expected: [][]byte{{0x61}, {0x27}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x22},
		expected: [][]byte{{0x61}, {0x27}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x27},
		expected: [][]byte{{0x61}, {0x27}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x27}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x20},
		expected: [][]byte{{0x61}, {0x27}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x0},
		expected: [][]byte{{0x61}, {0x27}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [7.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xd},
		expected: [][]byte{{0x61}, {0x2c}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xa},
		expected: [][]byte{{0x61}, {0x2c}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xb},
		expected: [][]byte{{0x61}, {0x2c}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61}, {0x2c}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x41},
		expected: [][]byte{{0x61}, {0x2c}, {0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x30},
		expected: [][]byte{{0x61}, {0x2c}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x5f},
		expected: [][]byte{{0x61}, {0x2c}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x61}, {0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x22},
		expected: [][]byte{{0x61}, {0x2c}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x2c}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x20},
		expected: [][]byte{{0x61}, {0x2c}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x0},
		expected: [][]byte{{0x61}, {0x2c}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xd},
		expected: [][]byte{{0x31}, {0x3a}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xa},
		expected: [][]byte{{0x31}, {0x3a}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xb},
		expected: [][]byte{{0x31}, {0x3a}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x3a}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x41},
		expected: [][]byte{{0x31}, {0x3a}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x30},
		expected: [][]byte{{0x31}, {0x3a}, {0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x5f},
		expected: [][]byte{{0x31}, {0x3a}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x3a}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x22},
		expected: [][]byte{{0x31}, {0x3a}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x3a}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x20},
		expected: [][]byte{{0x31}, {0x3a}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x0},
		expected: [][]byte{{0x31}, {0x3a}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xd},
		expected: [][]byte{{0x31}, {0x27}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xa},
		expected: [][]byte{{0x31}, {0x27}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xb},
		expected: [][]byte{{0x31}, {0x27}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x27}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x41},
		expected: [][]byte{{0x31}, {0x27}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x3a},
		expected: [][]byte{{0x31}, {0x27}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x2c},
		expected: [][]byte{{0x31}, {0x27}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x2e},
		expected: [][]byte{{0x31}, {0x27}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x30},
		expected: [][]byte{{0x31, 0x27, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x5f},
		expected: [][]byte{{0x31}, {0x27}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x27}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x22},
		expected: [][]byte{{0x31}, {0x27}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x27},
		expected: [][]byte{{0x31}, {0x27}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x27}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x20},
		expected: [][]byte{{0x31}, {0x27}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x0},
		expected: [][]byte{{0x31}, {0x27}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xd},
		expected: [][]byte{{0x31}, {0x2c}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xa},
		expected: [][]byte{{0x31}, {0x2c}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xb},
		expected: [][]byte{{0x31}, {0x2c}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x2c}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x41},
		expected: [][]byte{{0x31}, {0x2c}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x30},
		expected: [][]byte{{0x31, 0x2c, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x5f},
		expected: [][]byte{{0x31}, {0x2c}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x22},
		expected: [][]byte{{0x31}, {0x2c}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x27},
		expected: [][]byte{{0x31}, {0x2c}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x2c}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x20},
		expected: [][]byte{{0x31}, {0x2c}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x0},
		expected: [][]byte{{0x31}, {0x2c}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x93, 0x82},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe2, 0x93, 0x82}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] CIRCLED LATIN CAPITAL LETTER M (ALetter_ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xa9},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xc2, 0xa9}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] COPYRIGHT SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <NULL> (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) × [4.0] COMBINING DIAERESIS (Extend) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa, 0x61, 0xa, 0xcc, 0x88},
		expected: [][]byte{{0xd, 0xa}, {0x61}, {0xa}, {0xcc, 0x88}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALettermExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88},
		expected: [][]byte{{0x61, 0xcc, 0x88}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}, {0xd9, 0x86}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] ARABIC LETTER NOON (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xd9, 0x86, 0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ARABIC LETTER NOON (ALettermExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0xb1, 0xd9, 0x84, 0xd8, 0xb1, 0xd9, 0x8e, 0xd9, 0x91, 0xd8, 0xad, 0xd9, 0x90, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x90, 0x20, 0xdb, 0x9d, 0xd9, 0xa1},
		expected: [][]byte{{0xd9, 0xb1, 0xd9, 0x84, 0xd8, 0xb1, 0xd9, 0x8e, 0xd9, 0x91, 0xd8, 0xad, 0xd9, 0x90, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x90}, {0x20}, {0xdb, 0x9d, 0xd9, 0xa1}},
		comment:  "÷ [0.2] ARABIC LETTER ALEF WASLA (ALettermExtPict) × [5.0] ARABIC LETTER LAM (ALettermExtPict) × [5.0] ARABIC LETTER REH (ALettermExtPict) × [4.0] ARABIC FATHA (Extend) × [4.0] ARABIC SHADDA (Extend) × [5.0] ARABIC LETTER HAH (ALettermExtPict) × [4.0] ARABIC KASRA (Extend) × [5.0] ARABIC LETTER YEH (ALettermExtPict) × [5.0] ARABIC LETTER MEEM (ALettermExtPict) × [4.0] ARABIC KASRA (Extend) ÷ [999.0] SPACE (WSegSpace) ÷ [999.0] ARABIC END OF AYAH (Numeric) × [8.0] ARABIC-INDIC DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xdc, 0xa1, 0xdc, 0x99, 0xdc, 0xa1, 0xdc, 0x98, 0xdc, 0xaa, 0xdc, 0x90, 0x20, 0xdc, 0x8f, 0xdc, 0x9d, 0xdc, 0x97},
		expected: [][]byte{{0xdc, 0xa1, 0xdc, 0x99, 0xdc, 0xa1, 0xdc, 0x98, 0xdc, 0xaa, 0xdc, 0x90}, {0x20}, {0xdc, 0x8f, 0xdc, 0x9d, 0xdc, 0x97}},
		comment:  "÷ [0.2] SYRIAC LETTER MIM (ALettermExtPict) × [5.0] SYRIAC LETTER ZAIN (ALettermExtPict) × [5.0] SYRIAC LETTER MIM (ALettermExtPict) × [5.0] SYRIAC LETTER WAW (ALettermExtPict) × [5.0] SYRIAC LETTER RISH (ALettermExtPict) × [5.0] SYRIAC LETTER ALAPH (ALettermExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [999.0] SYRIAC ABBREVIATION MARK (ALettermExtPict) × [5.0] SYRIAC LETTER YUDH (ALettermExtPict) × [5.0] SYRIAC LETTER HE (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xdc, 0xac, 0xdc, 0x8f, 0xdc, 0xab, 0xdc, 0x92, 0xdc, 0x98},
		expected: [][]byte{{0xdc, 0xac, 0xdc, 0x8f, 0xdc, 0xab, 0xdc, 0x92, 0xdc, 0x98}},
		comment:  "÷ [0.2] SYRIAC LETTER TAW (ALettermExtPict) × [5.0] SYRIAC ABBREVIATION MARK (ALettermExtPict) × [5.0] SYRIAC LETTER SHIN (ALettermExtPict) × [5.0] SYRIAC LETTER BETH (ALettermExtPict) × [5.0] SYRIAC LETTER WAW (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x41, 0x41},
		expected: [][]byte{{0x41, 0x41, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) × [5.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a, 0x41},
		expected: [][]byte{{0x41, 0x3a, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a, 0x3a, 0x41},
		expected: [][]byte{{0x41}, {0x3a}, {0x3a}, {0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x22, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0x22, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.2] QUOTATION MARK (Double_Quote) × [7.3] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x30, 0x30, 0x41},
		expected: [][]byte{{0x41, 0x30, 0x30, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [9.0] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c, 0x30},
		expected: [][]byte{{0x30, 0x2c, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c, 0x2c, 0x30},
		expected: [][]byte{{0x30}, {0x2c}, {0x2c}, {0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f, 0x30, 0x5f, 0xe3, 0x80, 0xb1, 0x5f},
		expected: [][]byte{{0x41, 0x5f, 0x30, 0x5f, 0xe3, 0x80, 0xb1, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f, 0x5f, 0x41},
		expected: [][]byte{{0x41, 0x5f, 0x5f, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] BABY (ExtPictmALetter) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPictmALetter) × [4.0] ZERO WIDTH JOINER (ZWJ) × [3.3] OCTAGONAL SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) × [3.3] OCTAGONAL SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d}, {0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] UPPER BLADE SCISSORS (XXmExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}, {0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ) ÷ [999.0] UPPER BLADE SCISSORS (XXmExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] BABY (ExtPictmALetter) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) × [3.3] BABY (ExtPictmALetter) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPictmALetter) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [3.3] OCTAGONAL SIGN (ExtPictmALetter) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [3.3] OCTAGONAL SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ) × [3.3] OCTAGONAL SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91}, {0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPictmALetter) ÷ [999.0] OCTAGONAL SIGN (ExtPictmALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x62},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [4.0] COMBINING DIAERESIS (Extend) × [4.0] ZERO WIDTH JOINER (ZWJ) × [4.0] COMBINING DIAERESIS (Extend) × [5.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x20, 0x20, 0x62},
		expected: [][]byte{{0x61}, {0x20, 0x20}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER B (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALettermExtPict) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALettermExtPict) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALettermExtPict) ÷ [0.3]",
	},
}
