//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtimeseriesinsights

import "encoding/json"

func unmarshalEnvironmentResourceClassification(rawMsg json.RawMessage) (EnvironmentResourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EnvironmentResourceClassification
	switch m["kind"] {
	case string(EnvironmentResourceKindGen1):
		b = &Gen1EnvironmentResource{}
	case string(EnvironmentResourceKindGen2):
		b = &Gen2EnvironmentResource{}
	default:
		b = &EnvironmentResource{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalEnvironmentResourceClassificationArray(rawMsg json.RawMessage) ([]EnvironmentResourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EnvironmentResourceClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEnvironmentResourceClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEventSourceResourceClassification(rawMsg json.RawMessage) (EventSourceResourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EventSourceResourceClassification
	switch m["kind"] {
	case string(EventSourceResourceKindMicrosoftEventHub):
		b = &EventHubEventSourceResource{}
	case string(EventSourceResourceKindMicrosoftIoTHub):
		b = &IoTHubEventSourceResource{}
	default:
		b = &EventSourceResource{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalEventSourceResourceClassificationArray(rawMsg json.RawMessage) ([]EventSourceResourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EventSourceResourceClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEventSourceResourceClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
