//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mariadb/armmariadb"
	"net/http"
	"net/url"
	"regexp"
)

// QueryTextsServer is a fake server for instances of the armmariadb.QueryTextsClient type.
type QueryTextsServer struct {
	// Get is the fake for method QueryTextsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, queryID string, options *armmariadb.QueryTextsClientGetOptions) (resp azfake.Responder[armmariadb.QueryTextsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method QueryTextsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, queryIDs []string, options *armmariadb.QueryTextsClientListByServerOptions) (resp azfake.PagerResponder[armmariadb.QueryTextsClientListByServerResponse])
}

// NewQueryTextsServerTransport creates a new instance of QueryTextsServerTransport with the provided implementation.
// The returned QueryTextsServerTransport instance is connected to an instance of armmariadb.QueryTextsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewQueryTextsServerTransport(srv *QueryTextsServer) *QueryTextsServerTransport {
	return &QueryTextsServerTransport{
		srv:                  srv,
		newListByServerPager: newTracker[azfake.PagerResponder[armmariadb.QueryTextsClientListByServerResponse]](),
	}
}

// QueryTextsServerTransport connects instances of armmariadb.QueryTextsClient to instances of QueryTextsServer.
// Don't use this type directly, use NewQueryTextsServerTransport instead.
type QueryTextsServerTransport struct {
	srv                  *QueryTextsServer
	newListByServerPager *tracker[azfake.PagerResponder[armmariadb.QueryTextsClientListByServerResponse]]
}

// Do implements the policy.Transporter interface for QueryTextsServerTransport.
func (q *QueryTextsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "QueryTextsClient.Get":
		resp, err = q.dispatchGet(req)
	case "QueryTextsClient.NewListByServerPager":
		resp, err = q.dispatchNewListByServerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (q *QueryTextsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if q.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMariaDB/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryTexts/(?P<queryId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	queryIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("queryId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := q.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, queryIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryText, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (q *QueryTextsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if q.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := q.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMariaDB/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryTexts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		queryIDsEscaped := qp["queryIds"]
		queryIDsParam := make([]string, len(queryIDsEscaped))
		for i, v := range queryIDsEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			queryIDsParam[i] = u
		}
		resp := q.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, queryIDsParam, nil)
		newListByServerPager = &resp
		q.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armmariadb.QueryTextsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		q.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		q.newListByServerPager.remove(req)
	}
	return resp, nil
}
