//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapplicationinsights

import "time"

// APIKeyRequest - An Application Insights component API Key creation request definition.
type APIKeyRequest struct {
	// The read access rights of this API Key.
	LinkedReadProperties []*string

	// The write access rights of this API Key.
	LinkedWriteProperties []*string

	// The name of the API Key.
	Name *string
}

// Annotation associated with an application insights resource.
type Annotation struct {
	// Name of annotation
	AnnotationName *string

	// Category of annotation, free form
	Category *string

	// Time when event occurred
	EventTime *time.Time

	// Unique Id for annotation
	ID *string

	// Serialized JSON object for detailed properties
	Properties *string

	// Related parent annotation if any
	RelatedAnnotation *string
}

// AnnotationError - Error associated with trying to create annotation with Id that already exist
type AnnotationError struct {
	// Error detail code and explanation
	Code *string

	// Inner error
	Innererror *InnerError

	// Error message
	Message *string
}

// AnnotationsListResult - Annotations list result.
type AnnotationsListResult struct {
	// READ-ONLY; An array of annotations.
	Value []*Annotation
}

// Component - An Application Insights component definition.
type Component struct {
	// REQUIRED; The kind of application that this component refers to, used to customize UI. This value is a freeform string,
	// values should typically be one of the following: web, ios, other, store, java, phone.
	Kind *string

	// REQUIRED; Resource location
	Location *string

	// Resource etag
	Etag *string

	// Properties that define an Application Insights component resource.
	Properties *ComponentProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// ComponentAPIKey - Properties that define an API key of an Application Insights Component.
type ComponentAPIKey struct {
	// The create date of this API key.
	CreatedDate *string

	// The read access rights of this API Key.
	LinkedReadProperties []*string

	// The write access rights of this API Key.
	LinkedWriteProperties []*string

	// The name of the API key.
	Name *string

	// READ-ONLY; The API key value. It will be only return once when the API Key was created.
	APIKey *string

	// READ-ONLY; The unique ID of the API key inside an Application Insights component. It is auto generated when the API key
	// is created.
	ID *string
}

// ComponentAPIKeyListResult - Describes the list of API Keys of an Application Insights Component.
type ComponentAPIKeyListResult struct {
	// REQUIRED; List of API Key definitions.
	Value []*ComponentAPIKey
}

// ComponentAnalyticsItem - Properties that define an Analytics item that is associated to an Application Insights component.
type ComponentAnalyticsItem struct {
	// The content of this item
	Content *string

	// Internally assigned unique id of the item definition.
	ID *string

	// The user-defined name of the item.
	Name *string

	// A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
	Properties *ComponentAnalyticsItemProperties

	// Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application
	// Insights component.
	Scope *ItemScope

	// Enum indicating the type of the Analytics item.
	Type *ItemType

	// READ-ONLY; Date and time in UTC when this item was created.
	TimeCreated *string

	// READ-ONLY; Date and time in UTC of the last modification that was made to this item.
	TimeModified *string

	// READ-ONLY; This instance's version of the data model. This can change as new features are added.
	Version *string
}

// ComponentAnalyticsItemProperties - A set of properties that can be defined in the context of a specific item type. Each
// type may have its own properties.
type ComponentAnalyticsItemProperties struct {
	// A function alias, used when the type of the item is Function
	FunctionAlias *string
}

// ComponentAvailableFeatures - An Application Insights component available features.
type ComponentAvailableFeatures struct {
	// READ-ONLY; A list of Application Insights component feature.
	Result []*ComponentFeature
}

// ComponentBillingFeatures - An Application Insights component billing features
type ComponentBillingFeatures struct {
	// Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application
	// Insights Enterprise'.
	CurrentBillingFeatures []*string

	// An Application Insights component daily data volume cap
	DataVolumeCap *ComponentDataVolumeCap
}

// ComponentDataVolumeCap - An Application Insights component daily data volume cap
type ComponentDataVolumeCap struct {
	// Daily data volume cap in GB.
	Cap *float32

	// Do not send a notification email when the daily data volume cap is met.
	StopSendNotificationWhenHitCap *bool

	// Reserved, not used for now.
	StopSendNotificationWhenHitThreshold *bool

	// Reserved, not used for now.
	WarningThreshold *int32

	// READ-ONLY; Maximum daily data volume cap that the user can set for this component.
	MaxHistoryCap *float32

	// READ-ONLY; Daily data volume cap UTC reset hour.
	ResetTime *int32
}

// ComponentExportConfiguration - Properties that define a Continuous Export configuration.
type ComponentExportConfiguration struct {
	// Deprecated
	NotificationQueueEnabled *string

	// This comma separated list of document types that will be exported. The possible values include 'Requests', 'Event', 'Exceptions',
	// 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd',
	// 'PerformanceCounters', 'Availability', 'Messages'.
	RecordTypes *string

	// READ-ONLY; The name of the Application Insights component.
	ApplicationName *string

	// READ-ONLY; The name of the destination storage container.
	ContainerName *string

	// READ-ONLY; The name of destination account.
	DestinationAccountID *string

	// READ-ONLY; The destination account location ID.
	DestinationStorageLocationID *string

	// READ-ONLY; The destination storage account subscription ID.
	DestinationStorageSubscriptionID *string

	// READ-ONLY; The destination type.
	DestinationType *string

	// READ-ONLY; The unique ID of the export configuration inside an Application Insights component. It is auto generated when
	// the Continuous Export configuration is created.
	ExportID *string

	// READ-ONLY; This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success',
	// 'Failure'.
	ExportStatus *string

	// READ-ONLY; The instrumentation key of the Application Insights component.
	InstrumentationKey *string

	// READ-ONLY; This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
	IsUserEnabled *string

	// READ-ONLY; The last time the Continuous Export configuration started failing.
	LastGapTime *string

	// READ-ONLY; The last time data was successfully delivered to the destination storage container for this Continuous Export
	// configuration.
	LastSuccessTime *string

	// READ-ONLY; Last time the Continuous Export configuration was updated.
	LastUserUpdate *string

	// READ-ONLY; This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or
	// 'AzureStorageAccessDenied'.
	PermanentErrorReason *string

	// READ-ONLY; The resource group of the Application Insights component.
	ResourceGroup *string

	// READ-ONLY; The name of the destination storage account.
	StorageName *string

	// READ-ONLY; The subscription of the Application Insights component.
	SubscriptionID *string
}

// ComponentExportRequest - An Application Insights component Continuous Export configuration request definition.
type ComponentExportRequest struct {
	// The name of destination storage account.
	DestinationAccountID *string

	// The SAS URL for the destination storage container. It must grant write permission.
	DestinationAddress *string

	// The location ID of the destination storage container.
	DestinationStorageLocationID *string

	// The subscription ID of the destination storage container.
	DestinationStorageSubscriptionID *string

	// The Continuous Export destination type. This has to be 'Blob'.
	DestinationType *string

	// Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
	IsEnabled *string

	// Deprecated
	NotificationQueueEnabled *string

	// Deprecated
	NotificationQueueURI *string

	// The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions',
	// 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters',
	// 'Availability', 'Messages'.
	RecordTypes *string
}

// ComponentFavorite - Properties that define a favorite that is associated to an Application Insights component.
type ComponentFavorite struct {
	// Favorite category, as defined by the user at creation time.
	Category *string

	// Configuration of this particular favorite, which are driven by the Azure portal UX. Configuration data is a string containing
	// valid JSON
	Config *string

	// Enum indicating if this favorite definition is owned by a specific user or is shared between all users with access to the
	// Application Insights component.
	FavoriteType *FavoriteType

	// Flag denoting wether or not this favorite was generated from a template.
	IsGeneratedFromTemplate *bool

	// The user-defined name of the favorite.
	Name *string

	// The source of the favorite definition.
	SourceType *string

	// A list of 0 or more tags that are associated with this favorite definition
	Tags []*string

	// This instance's version of the data model. This can change as new features are added that can be marked favorite. Current
	// examples include MetricsExplorer (ME) and Search.
	Version *string

	// READ-ONLY; Internally assigned unique id of the favorite definition.
	FavoriteID *string

	// READ-ONLY; Date and time in UTC of the last modification that was made to this favorite definition.
	TimeModified *string

	// READ-ONLY; Unique user id of the specific user that owns this favorite.
	UserID *string
}

// ComponentFeature - An Application Insights component daily data volume cap status
type ComponentFeature struct {
	// READ-ONLY; A list of Application Insights component feature capability.
	Capabilities []*ComponentFeatureCapability

	// READ-ONLY; The pricing feature name.
	FeatureName *string

	// READ-ONLY; Reserved, not used now.
	IsHidden *bool

	// READ-ONLY; Whether can apply addon feature on to it.
	IsMainFeature *bool

	// READ-ONLY; The meter id used for the feature.
	MeterID *string

	// READ-ONLY; The meter rate for the feature's meter.
	MeterRateFrequency *string

	// READ-ONLY; Reserved, not used now.
	ResouceID *string

	// READ-ONLY; The add on features on main feature.
	SupportedAddonFeatures *string

	// READ-ONLY; Display name of the feature.
	Title *string
}

// ComponentFeatureCapabilities - An Application Insights component feature capabilities
type ComponentFeatureCapabilities struct {
	// READ-ONLY; Reserved, not used now.
	APIAccessLevel *string

	// READ-ONLY; Reserved, not used now.
	AnalyticsIntegration *bool

	// READ-ONLY; Reserved, not used now.
	ApplicationMap *bool

	// READ-ONLY; Reserved, not used now.
	BurstThrottlePolicy *string

	// READ-ONLY; Daily data volume cap in GB.
	DailyCap *float32

	// READ-ONLY; Daily data volume cap UTC reset hour.
	DailyCapResetTime *float32

	// READ-ONLY; Reserved, not used now.
	LiveStreamMetrics *bool

	// READ-ONLY; Reserved, not used now.
	MetadataClass *string

	// READ-ONLY; Whether allow to use multiple steps web test feature.
	MultipleStepWebTest *bool

	// READ-ONLY; Reserved, not used now.
	OpenSchema *bool

	// READ-ONLY; Reserved, not used now.
	PowerBIIntegration *bool

	// READ-ONLY; Reserved, not used now.
	ProactiveDetection *bool

	// READ-ONLY; Whether allow to use continuous export feature.
	SupportExportData *bool

	// READ-ONLY; Reserved, not used now.
	ThrottleRate *float32

	// READ-ONLY; The application insights component used tracking type.
	TrackingType *string

	// READ-ONLY; Whether allow to use work item integration feature.
	WorkItemIntegration *bool
}

// ComponentFeatureCapability - An Application Insights component feature capability
type ComponentFeatureCapability struct {
	// READ-ONLY; The description of the capability.
	Description *string

	// READ-ONLY; The meter used for the capability.
	MeterID *string

	// READ-ONLY; The meter rate of the meter.
	MeterRateFrequency *string

	// READ-ONLY; The name of the capability.
	Name *string

	// READ-ONLY; The unit of the capability.
	Unit *string

	// READ-ONLY; The value of the capability.
	Value *string
}

// ComponentListResult - Describes the list of Application Insights Resources.
type ComponentListResult struct {
	// REQUIRED; List of Application Insights component definitions.
	Value []*Component

	// The URI to get the next set of Application Insights component definitions if too many components where returned in the
	// result set.
	NextLink *string
}

// ComponentProactiveDetectionConfiguration - Properties that define a ProactiveDetection configuration.
type ComponentProactiveDetectionConfiguration struct {
	// Custom email addresses for this rule notifications
	CustomEmails []*string

	// A flag that indicates whether this rule is enabled by the user
	Enabled *bool

	// The last time this rule was updated
	LastUpdatedTime *string

	// The rule name
	Name *string

	// Static definitions of the ProactiveDetection configuration rule (same values for all components).
	RuleDefinitions *ComponentProactiveDetectionConfigurationRuleDefinitions

	// A flag that indicated whether notifications on this rule should be sent to subscription owners
	SendEmailsToSubscriptionOwners *bool
}

// ComponentProactiveDetectionConfigurationRuleDefinitions - Static definitions of the ProactiveDetection configuration rule
// (same values for all components).
type ComponentProactiveDetectionConfigurationRuleDefinitions struct {
	// The rule description
	Description *string

	// The rule name as it is displayed in UI
	DisplayName *string

	// URL which displays additional info about the proactive detection rule
	HelpURL *string

	// A flag indicating whether the rule is enabled by default
	IsEnabledByDefault *bool

	// A flag indicating whether the rule is hidden (from the UI)
	IsHidden *bool

	// A flag indicating whether the rule is in preview
	IsInPreview *bool

	// The rule name
	Name *string

	// A flag indicating whether email notifications are supported for detections for this rule
	SupportsEmailNotifications *bool
}

// ComponentProperties - Properties that define an Application Insights component resource.
type ComponentProperties struct {
	// REQUIRED; Type of application being monitored.
	ApplicationType *ApplicationType

	// Disable IP masking.
	DisableIPMasking *bool

	// Disable Non-AAD based Auth.
	DisableLocalAuth *bool

	// Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set
	// to 'Bluefield' when creating/updating a component via the REST API.
	FlowType *FlowType

	// Force users to create their own storage account for profiler and debugger.
	ForceCustomerStorageForProfiler *bool

	// The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
	HockeyAppID *string

	// Purge data immediately after 30 days.
	ImmediatePurgeDataOn30Days *bool

	// Indicates the flow of the ingestion.
	IngestionMode *IngestionMode

	// The network access type for accessing Application Insights ingestion.
	PublicNetworkAccessForIngestion *PublicNetworkAccessType

	// The network access type for accessing Application Insights query.
	PublicNetworkAccessForQuery *PublicNetworkAccessType

	// Describes what tool created this Application Insights component. Customers using this API should set this to the default
	// 'rest'.
	RequestSource *RequestSource

	// Retention period in days.
	RetentionInDays *int32

	// Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
	SamplingPercentage *float64

	// Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application
	// with this API version. Applications from older versions will not have
	// this property.
	WorkspaceResourceID *string

	// READ-ONLY; Application Insights Unique ID for your Application.
	AppID *string

	// READ-ONLY; The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
	ApplicationID *string

	// READ-ONLY; Application Insights component connection string.
	ConnectionString *string

	// READ-ONLY; Creation Date for the Application Insights component, in ISO 8601 format.
	CreationDate *time.Time

	// READ-ONLY; Token used to authenticate communications with between Application Insights and HockeyApp.
	HockeyAppToken *string

	// READ-ONLY; Application Insights Instrumentation key. A read-only value that applications can use to identify the destination
	// for all telemetry sent to Azure Application Insights. This value will be supplied upon
	// construction of each new Application Insights component.
	InstrumentationKey *string

	// READ-ONLY; The date which the component got migrated to LA, in ISO 8601 format.
	LaMigrationDate *time.Time

	// READ-ONLY; Application name.
	Name *string

	// READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources []*PrivateLinkScopedResource

	// READ-ONLY; Current state of this component: whether or not is has been provisioned within the resource group it is defined.
	// Users cannot change this value but are able to read from it. Values will include
	// Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string

	// READ-ONLY; Azure Tenant Id.
	TenantID *string
}

// ComponentPurgeBody - Describes the body of a purge request for an App Insights component
type ComponentPurgeBody struct {
	// REQUIRED; The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters []*ComponentPurgeBodyFilters

	// REQUIRED; Table from which to purge data.
	Table *string
}

// ComponentPurgeBodyFilters - User-defined filters to return data which will be purged from the table.
type ComponentPurgeBodyFilters struct {
	// The column of the table over which the given query should run
	Column *string

	// When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string

	// A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <,
	// <=, between, and have the same behavior as they would in a KQL query.
	Operator *string

	// the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or
	// array of values.
	Value any
}

// ComponentPurgeResponse - Response containing operationId for a specific purge action.
type ComponentPurgeResponse struct {
	// REQUIRED; Id to use when querying for status for a particular purge operation.
	OperationID *string
}

// ComponentPurgeStatusResponse - Response containing status for a specific purge operation.
type ComponentPurgeStatusResponse struct {
	// REQUIRED; Status of the operation represented by the requested Id.
	Status *PurgeState
}

// ComponentQuotaStatus - An Application Insights component daily data volume cap status
type ComponentQuotaStatus struct {
	// READ-ONLY; The Application ID for the Application Insights component.
	AppID *string

	// READ-ONLY; Date and time when the daily data volume cap will be reset, and data ingestion will resume.
	ExpirationTime *string

	// READ-ONLY; The daily data volume cap is met, and data ingestion will be stopped.
	ShouldBeThrottled *bool
}

// ComponentWebTestLocation - Properties that define a web test location available to an Application Insights Component.
type ComponentWebTestLocation struct {
	// READ-ONLY; The display name of the web test location.
	DisplayName *string

	// READ-ONLY; Internally defined geographic location tag.
	Tag *string
}

// ComponentsResource - An azure resource object
type ComponentsResource struct {
	// REQUIRED; Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// ErrorFieldContract - Error Field contract.
type ErrorFieldContract struct {
	// Property level error code.
	Code *string

	// Human-readable representation of property-level error.
	Message *string

	// Property name.
	Target *string
}

// ErrorResponse - Error response indicates Insights service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// Error code.
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

type ErrorResponseComponents struct {
	// Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error
	// message.
	Error *ErrorResponseComponentsError
}

// ErrorResponseComponentsError - Error response indicates Insights service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponseComponentsError struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// InnerError - Inner error
type InnerError struct {
	// Provides correlation for request
	Diagnosticcontext *string

	// Request time
	Time *time.Time
}

// LinkProperties - Contains a sourceId and workbook resource id to link two resources.
type LinkProperties struct {
	// The category of workbook
	Category *string

	// The source Azure resource id
	SourceID *string

	// The workbook Azure resource id
	TargetID *string
}

// MyWorkbook - An Application Insights private workbook definition.
type MyWorkbook struct {
	// Azure resource Id
	ID *string

	// The kind of workbook. Choices are user and shared.
	Kind *SharedTypeKind

	// Resource location
	Location *string

	// Azure resource name
	Name *string

	// Metadata describing a workbook for an Azure resource.
	Properties *MyWorkbookProperties

	// Resource tags
	Tags map[string]*string

	// Azure resource type
	Type *string
}

// MyWorkbookError - Error message body that will indicate why the operation failed.
type MyWorkbookError struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string

	// The list of invalid fields send in request, in case of validation error.
	Details []*ErrorFieldContract

	// Human-readable representation of the error.
	Message *string
}

// MyWorkbookProperties - Properties that contain a private workbook.
type MyWorkbookProperties struct {
	// REQUIRED; Workbook category, as defined by the user at creation time.
	Category *string

	// REQUIRED; The user-defined name of the private workbook.
	DisplayName *string

	// REQUIRED; Configuration of this particular private workbook. Configuration data is a string containing valid JSON
	SerializedData *string

	// Optional resourceId for a source resource.
	SourceID *string

	// A list of 0 or more tags that are associated with this private workbook definition
	Tags []*string

	// This instance's version of the data model. This can change as new features are added that can be marked private workbook.
	Version *string

	// READ-ONLY; Date and time in UTC of the last modification that was made to this private workbook definition.
	TimeModified *string

	// READ-ONLY; Unique user id of the specific user that owns this private workbook.
	UserID *string
}

// MyWorkbookResource - An azure resource object
type MyWorkbookResource struct {
	// Azure resource Id
	ID *string

	// Resource location
	Location *string

	// Azure resource name
	Name *string

	// Resource tags
	Tags map[string]*string

	// Azure resource type
	Type *string
}

// MyWorkbooksListResult - Workbook list result.
type MyWorkbooksListResult struct {
	// READ-ONLY; An array of private workbooks.
	Value []*MyWorkbook
}

// Operation - CDN REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Cdn
	Provider *string

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationListResult - Result of the request to list CDN operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of CDN operations supported by the CDN resource provider.
	Value []*Operation
}

// PrivateLinkScopedResource - The private link scope resource reference.
type PrivateLinkScopedResource struct {
	// The full resource Id of the private link scope resource.
	ResourceID *string

	// The private link scope unique Identifier.
	ScopeID *string
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a WebTest instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string
}

// WebTest - An Application Insights web test definition.
type WebTest struct {
	// REQUIRED; Resource location
	Location *string

	// The kind of web test that this web test watches. Choices are ping and multistep.
	Kind *WebTestKind

	// Metadata describing a web test for an Azure resource.
	Properties *WebTestProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// WebTestGeolocation - Geo-physical location to run a web test from. You must specify one or more locations for the test
// to run from.
type WebTestGeolocation struct {
	// Location ID for the webtest to run from.
	Location *string
}

// WebTestListResult - A list of 0 or more Application Insights web test definitions.
type WebTestListResult struct {
	// REQUIRED; Set of Application Insights web test definitions.
	Value []*WebTest

	// The link to get the next part of the returned list of web tests, should the return set be too large for a single request.
	// May be null.
	NextLink *string
}

// WebTestLocationsListResult - Describes the list of web test locations available to an Application Insights Component.
type WebTestLocationsListResult struct {
	// REQUIRED; List of web test locations.
	Value []*ComponentWebTestLocation
}

// WebTestProperties - Metadata describing a web test for an Azure resource.
type WebTestProperties struct {
	// REQUIRED; A list of where to physically run the tests from to give global coverage for accessibility of your application.
	Locations []*WebTestGeolocation

	// REQUIRED; Unique ID of this WebTest. This is typically the same value as the Name field.
	SyntheticMonitorID *string

	// REQUIRED; The kind of web test this is, valid choices are ping and multistep.
	WebTestKind *WebTestKind

	// REQUIRED; User defined name if this WebTest.
	WebTestName *string

	// An XML configuration specification for a WebTest.
	Configuration *WebTestPropertiesConfiguration

	// Purpose/user defined descriptive test for this WebTest.
	Description *string

	// Is the test actively being monitored.
	Enabled *bool

	// Interval in seconds between test runs for this WebTest. Default value is 300.
	Frequency *int32

	// Allow for retries should this WebTest fail.
	RetryEnabled *bool

	// Seconds until this WebTest will timeout and fail. Default value is 30.
	Timeout *int32

	// READ-ONLY; Current state of this component, whether or not is has been provisioned within the resource group it is defined.
	// Users cannot change this value but are able to read from it. Values will include
	// Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string
}

// WebTestPropertiesConfiguration - An XML configuration specification for a WebTest.
type WebTestPropertiesConfiguration struct {
	// The XML specification of a WebTest to run against an application.
	WebTest *string
}

// WebtestsResource - An azure resource object
type WebtestsResource struct {
	// REQUIRED; Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// WorkItemConfiguration - Work item configuration associated with an application insights resource.
type WorkItemConfiguration struct {
	// Configuration friendly name
	ConfigDisplayName *string

	// Serialized JSON object for detailed properties
	ConfigProperties *string

	// Connector identifier where work item is created
	ConnectorID *string

	// Unique Id for work item
	ID *string

	// Boolean value indicating whether configuration is default
	IsDefault *bool
}

// WorkItemConfigurationError - Error associated with trying to get work item configuration or configurations
type WorkItemConfigurationError struct {
	// Error detail code and explanation
	Code *string

	// Inner error
	Innererror *InnerError

	// Error message
	Message *string
}

// WorkItemConfigurationsListResult - Work item configuration list result.
type WorkItemConfigurationsListResult struct {
	// READ-ONLY; An array of work item configurations.
	Value []*WorkItemConfiguration
}

// WorkItemCreateConfiguration - Work item configuration creation payload
type WorkItemCreateConfiguration struct {
	// Serialized JSON object for detailed properties
	ConnectorDataConfiguration *string

	// Unique connector id
	ConnectorID *string

	// Boolean indicating validate only
	ValidateOnly *bool

	// Custom work item properties
	WorkItemProperties map[string]*string
}

// Workbook - An Application Insights workbook definition.
type Workbook struct {
	// The kind of workbook. Choices are user and shared.
	Kind *SharedTypeKind

	// Resource location
	Location *string

	// Metadata describing a web test for an Azure resource.
	Properties *WorkbookProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// WorkbookError - Error message body that will indicate why the operation failed.
type WorkbookError struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string

	// The list of invalid fields send in request, in case of validation error.
	Details []*ErrorFieldContract

	// Human-readable representation of the error.
	Message *string
}

// WorkbookProperties - Properties that contain a workbook.
type WorkbookProperties struct {
	// REQUIRED; Workbook category, as defined by the user at creation time.
	Category *string

	// REQUIRED; The user-defined name of the workbook.
	Name *string

	// REQUIRED; Configuration of this particular workbook. Configuration data is a string containing valid JSON
	SerializedData *string

	// REQUIRED; Enum indicating if this workbook definition is owned by a specific user or is shared between all users with access
	// to the Application Insights component.
	SharedTypeKind *SharedTypeKind

	// REQUIRED; Unique user id of the specific user that owns this workbook.
	UserID *string

	// REQUIRED; Internally assigned unique id of the workbook definition.
	WorkbookID *string

	// Optional resourceId for a source resource.
	SourceResourceID *string

	// A list of 0 or more tags that are associated with this workbook definition
	Tags []*string

	// This instance's version of the data model. This can change as new features are added that can be marked workbook.
	Version *string

	// READ-ONLY; Date and time in UTC of the last modification that was made to this workbook definition.
	TimeModified *string
}

// WorkbookResource - An azure resource object
type WorkbookResource struct {
	// Resource location
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// WorkbooksListResult - Workbook list result.
type WorkbooksListResult struct {
	// READ-ONLY; An array of workbooks.
	Value []*Workbook
}
