//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServiceSKUsClient contains the methods for the APIManagementServiceSKUs group.
// Don't use this type directly, use NewServiceSKUsClient() instead.
type ServiceSKUsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewServiceSKUsClient creates a new instance of ServiceSKUsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewServiceSKUsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServiceSKUsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ServiceSKUsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListAvailableServiceSKUsPager - Gets all available SKU for a given API Management service
//
// Generated from API version 2022-08-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serviceName - The name of the API Management service.
//   - options - ServiceSKUsClientListAvailableServiceSKUsOptions contains the optional parameters for the ServiceSKUsClient.NewListAvailableServiceSKUsPager
//     method.
func (client *ServiceSKUsClient) NewListAvailableServiceSKUsPager(resourceGroupName string, serviceName string, options *ServiceSKUsClientListAvailableServiceSKUsOptions) *runtime.Pager[ServiceSKUsClientListAvailableServiceSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServiceSKUsClientListAvailableServiceSKUsResponse]{
		More: func(page ServiceSKUsClientListAvailableServiceSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServiceSKUsClientListAvailableServiceSKUsResponse) (ServiceSKUsClientListAvailableServiceSKUsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ServiceSKUsClient.NewListAvailableServiceSKUsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAvailableServiceSKUsCreateRequest(ctx, resourceGroupName, serviceName, options)
			}, nil)
			if err != nil {
				return ServiceSKUsClientListAvailableServiceSKUsResponse{}, err
			}
			return client.listAvailableServiceSKUsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAvailableServiceSKUsCreateRequest creates the ListAvailableServiceSKUs request.
func (client *ServiceSKUsClient) listAvailableServiceSKUsCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, options *ServiceSKUsClientListAvailableServiceSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAvailableServiceSKUsHandleResponse handles the ListAvailableServiceSKUs response.
func (client *ServiceSKUsClient) listAvailableServiceSKUsHandleResponse(resp *http.Response) (ServiceSKUsClientListAvailableServiceSKUsResponse, error) {
	result := ServiceSKUsClientListAvailableServiceSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceSKUResults); err != nil {
		return ServiceSKUsClientListAvailableServiceSKUsResponse{}, err
	}
	return result, nil
}
