"""git-changelog package.

Automatic Changelog generator using Jinja2 templates.
"""

from __future__ import annotations

from git_changelog._internal.build import Changelog, ConventionType, Section, Version, bump, parse_version
from git_changelog._internal.cli import (
    CONVENTIONS,
    DEFAULT_CHANGELOG_FILE,
    DEFAULT_CONFIG_FILES,
    DEFAULT_MARKER_LINE,
    DEFAULT_SETTINGS,
    DEFAULT_VERSION_REGEX,
    DEFAULT_VERSIONING,
    Templates,
    build,
    build_and_render,
    get_parser,
    get_release_notes,
    get_version,
    main,
    output_release_notes,
    parse_settings,
    providers,
    read_config,
    render,
)
from git_changelog._internal.commit import (
    AngularConvention,
    BasicConvention,
    Commit,
    CommitConvention,
    ConventionalCommitConvention,
)
from git_changelog._internal.providers import Bitbucket, GitHub, GitLab, ProviderRefParser, Ref, RefDef, RefRe
from git_changelog._internal.templates import (
    JINJA_ENV,
    TEMPLATES_PATH,
    configure_env,
    get_custom_template,
    get_template,
)
from git_changelog._internal.versioning import (
    ParsedVersion,
    PEP440Bumper,
    PEP440Strategy,
    PEP440Version,
    SemVerBumper,
    SemVerStrategy,
    SemVerVersion,
    VersionBumper,
    bump_pep440,
    bump_semver,
    parse_pep440,
    parse_semver,
    version_prefix,
)

__all__: list[str] = [
    "CONVENTIONS",
    "DEFAULT_CHANGELOG_FILE",
    "DEFAULT_CONFIG_FILES",
    "DEFAULT_MARKER_LINE",
    "DEFAULT_SETTINGS",
    "DEFAULT_VERSIONING",
    "DEFAULT_VERSION_REGEX",
    "JINJA_ENV",
    "TEMPLATES_PATH",
    "AngularConvention",
    "BasicConvention",
    "Bitbucket",
    "Changelog",
    "Commit",
    "CommitConvention",
    "ConventionType",
    "ConventionalCommitConvention",
    "GitHub",
    "GitLab",
    "PEP440Bumper",
    "PEP440Strategy",
    "PEP440Version",
    "ParsedVersion",
    "ProviderRefParser",
    "Ref",
    "RefDef",
    "RefRe",
    "Section",
    "SemVerBumper",
    "SemVerStrategy",
    "SemVerVersion",
    "Templates",
    "Version",
    "VersionBumper",
    "build",
    "build_and_render",
    "bump",
    "bump_pep440",
    "bump_semver",
    "configure_env",
    "get_custom_template",
    "get_parser",
    "get_release_notes",
    "get_template",
    "get_version",
    "main",
    "output_release_notes",
    "parse_pep440",
    "parse_semver",
    "parse_settings",
    "parse_version",
    "providers",
    "read_config",
    "render",
    "version_prefix",
]
