%%
%% The purpose of this module is to ensure that BEAM can
%% correctly load and execute type tests with literal
%% arguments.
%%
%% This module has been compiled from the generated module
%% in the test case guard_SUITE:literal_type_tests/1 in the
%% compiler test suite.
%%
%% The following compiler options were used:
%%
%%     [no_copt,no_bool_opt,no_ssa_opt,no_postopt]
%%
%% In addition, the following patch was applied to the compiler
%% to ensure that BIFs or tests with literal arguments were
%% not evaluated at compile time:
%%
%% diff --git a/lib/compiler/src/beam_ssa_pre_codegen.erl b/lib/compiler/src/beam_ssa_pre_codegen.erl
%% index 9a52399b3b..78f5472315 100644
%% --- a/lib/compiler/src/beam_ssa_pre_codegen.erl
%% +++ b/lib/compiler/src/beam_ssa_pre_codegen.erl
%% @@ -901,26 +901,6 @@ sanitize_instr(phi, PhiArgs, _I) ->
%%          false ->
%%              ok
%%      end;
%% -sanitize_instr({bif,Bif}, [#b_literal{val=Lit}], _I) ->
%% -    case erl_bifs:is_pure(erlang, Bif, 1) of
%% -        false ->
%% -            ok;
%% -        true ->
%% -            try
%% -                {value,erlang:Bif(Lit)}
%% -            catch
%% -                error:_ ->
%% -                    ok
%% -            end
%% -    end;
%% -sanitize_instr({bif,Bif}, [#b_literal{val=Lit1},#b_literal{val=Lit2}], _I) ->
%% -    true = erl_bifs:is_pure(erlang, Bif, 2),    %Assertion.
%% -    try
%% -        {value,erlang:Bif(Lit1, Lit2)}
%% -    catch
%% -        error:_ ->
%% -            ok
%% -    end;
%%  sanitize_instr(get_hd, [#b_literal{val=[Hd|_]}], _I) ->
%%      {value,Hd};
%%  sanitize_instr(get_tl, [#b_literal{val=[_|Tl]}], _I) ->
%%

{module, unoptimized_literal_tests}.  %% version = 0

{exports, [{module_info,0},{module_info,1},{test,0}]}.

{attributes, []}.

{labels, 727}.


{function, test, 0, 2}.
  {label,1}.
    {line,[{location,"unoptimized_literal_tests.erl",7}]}.
    {func_info,{atom,unoptimized_literal_tests},{atom,test},0}.
  {label,2}.
    {allocate,0,0}.
    {move,{literal,[{is_boolean,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",10}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,3},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,4}}.
  {label,3}.
    {move,{atom,false},{x,0}}.
  {label,4}.
    {test,is_eq_exact,{f,722},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",20}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,5},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,6}}.
  {label,5}.
    {move,{atom,false},{x,0}}.
  {label,6}.
    {test,is_eq_exact,{f,721},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",30}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_boolean},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",30}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,7},0,[{integer,3}],{x,0}}.
    {test,is_boolean,{f,7},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,8}}.
  {label,7}.
    {move,{atom,false},{x,0}}.
  {label,8}.
    {test,is_eq_exact,{f,720},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",40}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,9},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,10}}.
  {label,9}.
    {move,{atom,false},{x,0}}.
  {label,10}.
    {test,is_eq_exact,{f,719},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",51}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,11},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,12}}.
  {label,11}.
    {move,{atom,false},{x,0}}.
  {label,12}.
    {test,is_eq_exact,{f,718},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",61}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,13},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,14}}.
  {label,13}.
    {move,{atom,false},{x,0}}.
  {label,14}.
    {test,is_eq_exact,{f,717},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",71}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,15},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,16}}.
  {label,15}.
    {move,{atom,false},{x,0}}.
  {label,16}.
    {test,is_eq_exact,{f,716},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",81}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,17},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,18}}.
  {label,17}.
    {move,{atom,false},{x,0}}.
  {label,18}.
    {test,is_eq_exact,{f,715},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",91}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,19},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,20}}.
  {label,19}.
    {move,{atom,false},{x,0}}.
  {label,20}.
    {test,is_eq_exact,{f,714},[{x,0},{atom,false}]}.
    {move,{literal,[{is_boolean,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",101}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_boolean,{f,21},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,22}}.
  {label,21}.
    {move,{atom,false},{x,0}}.
  {label,22}.
    {test,is_eq_exact,{f,713},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",111}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,23},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,24}}.
  {label,23}.
    {move,{atom,false},{x,0}}.
  {label,24}.
    {test,is_eq_exact,{f,712},[{x,0},{atom,true}]}.
    {move,{literal,[{is_integer,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",121}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,25},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,26}}.
  {label,25}.
    {move,{atom,false},{x,0}}.
  {label,26}.
    {test,is_eq_exact,{f,711},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",131}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_integer},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",131}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,27},0,[{integer,3}],{x,0}}.
    {test,is_integer,{f,27},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,28}}.
  {label,27}.
    {move,{atom,false},{x,0}}.
  {label,28}.
    {test,is_eq_exact,{f,710},[{x,0},{atom,true}]}.
    {move,{literal,[{is_integer,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",141}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,29},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,30}}.
  {label,29}.
    {move,{atom,false},{x,0}}.
  {label,30}.
    {test,is_eq_exact,{f,709},[{x,0},{atom,true}]}.
    {move,{literal,[{is_integer,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",152}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,31},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,32}}.
  {label,31}.
    {move,{atom,false},{x,0}}.
  {label,32}.
    {test,is_eq_exact,{f,708},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",162}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,33},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,34}}.
  {label,33}.
    {move,{atom,false},{x,0}}.
  {label,34}.
    {test,is_eq_exact,{f,707},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",172}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,35},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,36}}.
  {label,35}.
    {move,{atom,false},{x,0}}.
  {label,36}.
    {test,is_eq_exact,{f,706},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",182}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,37},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,38}}.
  {label,37}.
    {move,{atom,false},{x,0}}.
  {label,38}.
    {test,is_eq_exact,{f,705},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",192}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,39},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,40}}.
  {label,39}.
    {move,{atom,false},{x,0}}.
  {label,40}.
    {test,is_eq_exact,{f,704},[{x,0},{atom,false}]}.
    {move,{literal,[{is_integer,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",202}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_integer,{f,41},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,42}}.
  {label,41}.
    {move,{atom,false},{x,0}}.
  {label,42}.
    {test,is_eq_exact,{f,703},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",212}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,43},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,44}}.
  {label,43}.
    {move,{atom,false},{x,0}}.
  {label,44}.
    {test,is_eq_exact,{f,702},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",222}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,45},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,46}}.
  {label,45}.
    {move,{atom,false},{x,0}}.
  {label,46}.
    {test,is_eq_exact,{f,701},[{x,0},{atom,true}]}.
    {line,[{location,"unoptimized_literal_tests.erl",232}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_float},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",232}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,47},0,[{integer,3}],{x,0}}.
    {test,is_float,{f,47},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,48}}.
  {label,47}.
    {move,{atom,false},{x,0}}.
  {label,48}.
    {test,is_eq_exact,{f,700},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",242}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,49},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,50}}.
  {label,49}.
    {move,{atom,false},{x,0}}.
  {label,50}.
    {test,is_eq_exact,{f,699},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",253}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,51},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,52}}.
  {label,51}.
    {move,{atom,false},{x,0}}.
  {label,52}.
    {test,is_eq_exact,{f,698},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",263}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,53},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,54}}.
  {label,53}.
    {move,{atom,false},{x,0}}.
  {label,54}.
    {test,is_eq_exact,{f,697},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",273}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,55},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,56}}.
  {label,55}.
    {move,{atom,false},{x,0}}.
  {label,56}.
    {test,is_eq_exact,{f,696},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",283}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,57},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,58}}.
  {label,57}.
    {move,{atom,false},{x,0}}.
  {label,58}.
    {test,is_eq_exact,{f,695},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",293}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,59},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,60}}.
  {label,59}.
    {move,{atom,false},{x,0}}.
  {label,60}.
    {test,is_eq_exact,{f,694},[{x,0},{atom,false}]}.
    {move,{literal,[{is_float,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",303}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_float,{f,61},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,62}}.
  {label,61}.
    {move,{atom,false},{x,0}}.
  {label,62}.
    {test,is_eq_exact,{f,693},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",313}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,63},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,64}}.
  {label,63}.
    {move,{atom,false},{x,0}}.
  {label,64}.
    {test,is_eq_exact,{f,692},[{x,0},{atom,true}]}.
    {move,{literal,[{is_number,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",323}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,65},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,66}}.
  {label,65}.
    {move,{atom,false},{x,0}}.
  {label,66}.
    {test,is_eq_exact,{f,691},[{x,0},{atom,true}]}.
    {line,[{location,"unoptimized_literal_tests.erl",333}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_number},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",333}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,67},0,[{integer,3}],{x,0}}.
    {test,is_number,{f,67},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,68}}.
  {label,67}.
    {move,{atom,false},{x,0}}.
  {label,68}.
    {test,is_eq_exact,{f,690},[{x,0},{atom,true}]}.
    {move,{literal,[{is_number,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",343}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,69},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,70}}.
  {label,69}.
    {move,{atom,false},{x,0}}.
  {label,70}.
    {test,is_eq_exact,{f,689},[{x,0},{atom,true}]}.
    {move,{literal,[{is_number,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",354}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,71},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,72}}.
  {label,71}.
    {move,{atom,false},{x,0}}.
  {label,72}.
    {test,is_eq_exact,{f,688},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",364}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,73},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,74}}.
  {label,73}.
    {move,{atom,false},{x,0}}.
  {label,74}.
    {test,is_eq_exact,{f,687},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",374}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,75},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,76}}.
  {label,75}.
    {move,{atom,false},{x,0}}.
  {label,76}.
    {test,is_eq_exact,{f,686},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",384}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,77},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,78}}.
  {label,77}.
    {move,{atom,false},{x,0}}.
  {label,78}.
    {test,is_eq_exact,{f,685},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",394}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,79},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,80}}.
  {label,79}.
    {move,{atom,false},{x,0}}.
  {label,80}.
    {test,is_eq_exact,{f,684},[{x,0},{atom,false}]}.
    {move,{literal,[{is_number,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",404}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_number,{f,81},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,82}}.
  {label,81}.
    {move,{atom,false},{x,0}}.
  {label,82}.
    {test,is_eq_exact,{f,683},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",414}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,83},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,84}}.
  {label,83}.
    {move,{atom,false},{x,0}}.
  {label,84}.
    {test,is_eq_exact,{f,682},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",424}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,85},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,86}}.
  {label,85}.
    {move,{atom,false},{x,0}}.
  {label,86}.
    {test,is_eq_exact,{f,681},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",434}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_atom},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",434}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,87},0,[{integer,3}],{x,0}}.
    {test,is_atom,{f,87},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,88}}.
  {label,87}.
    {move,{atom,false},{x,0}}.
  {label,88}.
    {test,is_eq_exact,{f,680},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",444}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,89},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,90}}.
  {label,89}.
    {move,{atom,false},{x,0}}.
  {label,90}.
    {test,is_eq_exact,{f,679},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",455}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,91},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,92}}.
  {label,91}.
    {move,{atom,false},{x,0}}.
  {label,92}.
    {test,is_eq_exact,{f,678},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",465}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,93},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,94}}.
  {label,93}.
    {move,{atom,false},{x,0}}.
  {label,94}.
    {test,is_eq_exact,{f,677},[{x,0},{atom,true}]}.
    {move,{literal,[{is_atom,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",475}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,95},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,96}}.
  {label,95}.
    {move,{atom,false},{x,0}}.
  {label,96}.
    {test,is_eq_exact,{f,676},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",485}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,97},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,98}}.
  {label,97}.
    {move,{atom,false},{x,0}}.
  {label,98}.
    {test,is_eq_exact,{f,675},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",495}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,99},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,100}}.
  {label,99}.
    {move,{atom,false},{x,0}}.
  {label,100}.
    {test,is_eq_exact,{f,674},[{x,0},{atom,false}]}.
    {move,{literal,[{is_atom,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",505}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_atom,{f,101},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,102}}.
  {label,101}.
    {move,{atom,false},{x,0}}.
  {label,102}.
    {test,is_eq_exact,{f,673},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",515}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,103},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,104}}.
  {label,103}.
    {move,{atom,false},{x,0}}.
  {label,104}.
    {test,is_eq_exact,{f,672},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",525}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,105},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,106}}.
  {label,105}.
    {move,{atom,false},{x,0}}.
  {label,106}.
    {test,is_eq_exact,{f,671},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",535}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_list},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",535}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,107},0,[{integer,3}],{x,0}}.
    {test,is_list,{f,107},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,108}}.
  {label,107}.
    {move,{atom,false},{x,0}}.
  {label,108}.
    {test,is_eq_exact,{f,670},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",545}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,109},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,110}}.
  {label,109}.
    {move,{atom,false},{x,0}}.
  {label,110}.
    {test,is_eq_exact,{f,669},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",556}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,111},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,112}}.
  {label,111}.
    {move,{atom,false},{x,0}}.
  {label,112}.
    {test,is_eq_exact,{f,668},[{x,0},{atom,true}]}.
    {move,{literal,[{is_list,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",566}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,113},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,114}}.
  {label,113}.
    {move,{atom,false},{x,0}}.
  {label,114}.
    {test,is_eq_exact,{f,667},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",576}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,115},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,116}}.
  {label,115}.
    {move,{atom,false},{x,0}}.
  {label,116}.
    {test,is_eq_exact,{f,666},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",586}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,117},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,118}}.
  {label,117}.
    {move,{atom,false},{x,0}}.
  {label,118}.
    {test,is_eq_exact,{f,665},[{x,0},{atom,true}]}.
    {move,{literal,[{is_list,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",596}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,119},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,120}}.
  {label,119}.
    {move,{atom,false},{x,0}}.
  {label,120}.
    {test,is_eq_exact,{f,664},[{x,0},{atom,false}]}.
    {move,{literal,[{is_list,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",606}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_list,{f,121},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,122}}.
  {label,121}.
    {move,{atom,false},{x,0}}.
  {label,122}.
    {test,is_eq_exact,{f,663},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",616}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,123},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,124}}.
  {label,123}.
    {move,{atom,false},{x,0}}.
  {label,124}.
    {test,is_eq_exact,{f,662},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",626}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,125},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,126}}.
  {label,125}.
    {move,{atom,false},{x,0}}.
  {label,126}.
    {test,is_eq_exact,{f,661},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",636}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_tuple},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",636}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,127},0,[{integer,3}],{x,0}}.
    {test,is_tuple,{f,127},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,128}}.
  {label,127}.
    {move,{atom,false},{x,0}}.
  {label,128}.
    {test,is_eq_exact,{f,660},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",646}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,129},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,130}}.
  {label,129}.
    {move,{atom,false},{x,0}}.
  {label,130}.
    {test,is_eq_exact,{f,659},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",657}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,131},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,132}}.
  {label,131}.
    {move,{atom,false},{x,0}}.
  {label,132}.
    {test,is_eq_exact,{f,658},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",667}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,133},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,134}}.
  {label,133}.
    {move,{atom,false},{x,0}}.
  {label,134}.
    {test,is_eq_exact,{f,657},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",677}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,135},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,136}}.
  {label,135}.
    {move,{atom,false},{x,0}}.
  {label,136}.
    {test,is_eq_exact,{f,656},[{x,0},{atom,true}]}.
    {move,{literal,[{is_tuple,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",687}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,137},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,138}}.
  {label,137}.
    {move,{atom,false},{x,0}}.
  {label,138}.
    {test,is_eq_exact,{f,655},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",697}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,139},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,140}}.
  {label,139}.
    {move,{atom,false},{x,0}}.
  {label,140}.
    {test,is_eq_exact,{f,654},[{x,0},{atom,false}]}.
    {move,{literal,[{is_tuple,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",707}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_tuple,{f,141},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,142}}.
  {label,141}.
    {move,{atom,false},{x,0}}.
  {label,142}.
    {test,is_eq_exact,{f,653},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",717}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,143},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,144}}.
  {label,143}.
    {move,{atom,false},{x,0}}.
  {label,144}.
    {test,is_eq_exact,{f,652},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",727}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,145},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,146}}.
  {label,145}.
    {move,{atom,false},{x,0}}.
  {label,146}.
    {test,is_eq_exact,{f,651},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",737}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_pid},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",737}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,147},0,[{integer,3}],{x,0}}.
    {test,is_pid,{f,147},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,148}}.
  {label,147}.
    {move,{atom,false},{x,0}}.
  {label,148}.
    {test,is_eq_exact,{f,650},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",747}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,149},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,150}}.
  {label,149}.
    {move,{atom,false},{x,0}}.
  {label,150}.
    {test,is_eq_exact,{f,649},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",757}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,151},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,152}}.
  {label,151}.
    {move,{atom,false},{x,0}}.
  {label,152}.
    {test,is_eq_exact,{f,648},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",767}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,153},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,154}}.
  {label,153}.
    {move,{atom,false},{x,0}}.
  {label,154}.
    {test,is_eq_exact,{f,647},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",777}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,155},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,156}}.
  {label,155}.
    {move,{atom,false},{x,0}}.
  {label,156}.
    {test,is_eq_exact,{f,646},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",787}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,157},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,158}}.
  {label,157}.
    {move,{atom,false},{x,0}}.
  {label,158}.
    {test,is_eq_exact,{f,645},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",797}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,159},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,160}}.
  {label,159}.
    {move,{atom,false},{x,0}}.
  {label,160}.
    {test,is_eq_exact,{f,644},[{x,0},{atom,false}]}.
    {move,{literal,[{is_pid,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",807}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_pid,{f,161},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,162}}.
  {label,161}.
    {move,{atom,false},{x,0}}.
  {label,162}.
    {test,is_eq_exact,{f,643},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",817}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,163},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,164}}.
  {label,163}.
    {move,{atom,false},{x,0}}.
  {label,164}.
    {test,is_eq_exact,{f,642},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",827}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,165},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,166}}.
  {label,165}.
    {move,{atom,false},{x,0}}.
  {label,166}.
    {test,is_eq_exact,{f,641},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",837}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_reference},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",837}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,167},0,[{integer,3}],{x,0}}.
    {test,is_reference,{f,167},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,168}}.
  {label,167}.
    {move,{atom,false},{x,0}}.
  {label,168}.
    {test,is_eq_exact,{f,640},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",847}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,169},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,170}}.
  {label,169}.
    {move,{atom,false},{x,0}}.
  {label,170}.
    {test,is_eq_exact,{f,639},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",858}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,171},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,172}}.
  {label,171}.
    {move,{atom,false},{x,0}}.
  {label,172}.
    {test,is_eq_exact,{f,638},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",868}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,173},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,174}}.
  {label,173}.
    {move,{atom,false},{x,0}}.
  {label,174}.
    {test,is_eq_exact,{f,637},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",878}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,175},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,176}}.
  {label,175}.
    {move,{atom,false},{x,0}}.
  {label,176}.
    {test,is_eq_exact,{f,636},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",888}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,177},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,178}}.
  {label,177}.
    {move,{atom,false},{x,0}}.
  {label,178}.
    {test,is_eq_exact,{f,635},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",898}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,179},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,180}}.
  {label,179}.
    {move,{atom,false},{x,0}}.
  {label,180}.
    {test,is_eq_exact,{f,634},[{x,0},{atom,false}]}.
    {move,{literal,[{is_reference,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",908}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_reference,{f,181},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,182}}.
  {label,181}.
    {move,{atom,false},{x,0}}.
  {label,182}.
    {test,is_eq_exact,{f,633},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",918}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,183},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,184}}.
  {label,183}.
    {move,{atom,false},{x,0}}.
  {label,184}.
    {test,is_eq_exact,{f,632},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",928}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,185},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,186}}.
  {label,185}.
    {move,{atom,false},{x,0}}.
  {label,186}.
    {test,is_eq_exact,{f,631},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",938}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_port},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",938}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,187},0,[{integer,3}],{x,0}}.
    {test,is_port,{f,187},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,188}}.
  {label,187}.
    {move,{atom,false},{x,0}}.
  {label,188}.
    {test,is_eq_exact,{f,630},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",948}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,189},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,190}}.
  {label,189}.
    {move,{atom,false},{x,0}}.
  {label,190}.
    {test,is_eq_exact,{f,629},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",959}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,191},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,192}}.
  {label,191}.
    {move,{atom,false},{x,0}}.
  {label,192}.
    {test,is_eq_exact,{f,628},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",969}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,193},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,194}}.
  {label,193}.
    {move,{atom,false},{x,0}}.
  {label,194}.
    {test,is_eq_exact,{f,627},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",979}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,195},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,196}}.
  {label,195}.
    {move,{atom,false},{x,0}}.
  {label,196}.
    {test,is_eq_exact,{f,626},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",989}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,197},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,198}}.
  {label,197}.
    {move,{atom,false},{x,0}}.
  {label,198}.
    {test,is_eq_exact,{f,625},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",999}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,199},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,200}}.
  {label,199}.
    {move,{atom,false},{x,0}}.
  {label,200}.
    {test,is_eq_exact,{f,624},[{x,0},{atom,false}]}.
    {move,{literal,[{is_port,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1009}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_port,{f,201},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,202}}.
  {label,201}.
    {move,{atom,false},{x,0}}.
  {label,202}.
    {test,is_eq_exact,{f,623},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1019}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,203},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,204}}.
  {label,203}.
    {move,{atom,false},{x,0}}.
  {label,204}.
    {test,is_eq_exact,{f,622},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1029}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,205},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,206}}.
  {label,205}.
    {move,{atom,false},{x,0}}.
  {label,206}.
    {test,is_eq_exact,{f,621},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1039}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_binary},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1039}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,207},0,[{integer,3}],{x,0}}.
    {test,is_binary,{f,207},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,208}}.
  {label,207}.
    {move,{atom,false},{x,0}}.
  {label,208}.
    {test,is_eq_exact,{f,620},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1049}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,209},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,210}}.
  {label,209}.
    {move,{atom,false},{x,0}}.
  {label,210}.
    {test,is_eq_exact,{f,619},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1060}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,211},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,212}}.
  {label,211}.
    {move,{atom,false},{x,0}}.
  {label,212}.
    {test,is_eq_exact,{f,618},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1070}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,213},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,214}}.
  {label,213}.
    {move,{atom,false},{x,0}}.
  {label,214}.
    {test,is_eq_exact,{f,617},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1080}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,215},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,216}}.
  {label,215}.
    {move,{atom,false},{x,0}}.
  {label,216}.
    {test,is_eq_exact,{f,616},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1090}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,217},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,218}}.
  {label,217}.
    {move,{atom,false},{x,0}}.
  {label,218}.
    {test,is_eq_exact,{f,615},[{x,0},{atom,false}]}.
    {move,{literal,[{is_binary,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1100}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,219},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,220}}.
  {label,219}.
    {move,{atom,false},{x,0}}.
  {label,220}.
    {test,is_eq_exact,{f,614},[{x,0},{atom,true}]}.
    {move,{literal,[{is_binary,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1110}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_binary,{f,221},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,222}}.
  {label,221}.
    {move,{atom,false},{x,0}}.
  {label,222}.
    {test,is_eq_exact,{f,613},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1120}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,223},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,224}}.
  {label,223}.
    {move,{atom,false},{x,0}}.
  {label,224}.
    {test,is_eq_exact,{f,612},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1130}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,225},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,226}}.
  {label,225}.
    {move,{atom,false},{x,0}}.
  {label,226}.
    {test,is_eq_exact,{f,611},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1140}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_bitstring},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1140}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,227},0,[{integer,3}],{x,0}}.
    {test,is_bitstr,{f,227},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,228}}.
  {label,227}.
    {move,{atom,false},{x,0}}.
  {label,228}.
    {test,is_eq_exact,{f,610},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1150}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,229},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,230}}.
  {label,229}.
    {move,{atom,false},{x,0}}.
  {label,230}.
    {test,is_eq_exact,{f,609},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1161}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,231},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,232}}.
  {label,231}.
    {move,{atom,false},{x,0}}.
  {label,232}.
    {test,is_eq_exact,{f,608},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1171}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,233},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,234}}.
  {label,233}.
    {move,{atom,false},{x,0}}.
  {label,234}.
    {test,is_eq_exact,{f,607},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1181}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,235},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,236}}.
  {label,235}.
    {move,{atom,false},{x,0}}.
  {label,236}.
    {test,is_eq_exact,{f,606},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1191}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,237},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,238}}.
  {label,237}.
    {move,{atom,false},{x,0}}.
  {label,238}.
    {test,is_eq_exact,{f,605},[{x,0},{atom,false}]}.
    {move,{literal,[{is_bitstring,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1201}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,239},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,240}}.
  {label,239}.
    {move,{atom,false},{x,0}}.
  {label,240}.
    {test,is_eq_exact,{f,604},[{x,0},{atom,true}]}.
    {move,{literal,[{is_bitstring,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1211}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_bitstr,{f,241},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,242}}.
  {label,241}.
    {move,{atom,false},{x,0}}.
  {label,242}.
    {test,is_eq_exact,{f,603},[{x,0},{atom,true}]}.
    {move,{literal,[{is_function,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1221}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,243},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,244}}.
  {label,243}.
    {move,{atom,false},{x,0}}.
  {label,244}.
    {test,is_eq_exact,{f,602},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1231}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,245},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,246}}.
  {label,245}.
    {move,{atom,false},{x,0}}.
  {label,246}.
    {test,is_eq_exact,{f,601},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1241}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1241}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,247},0,[{integer,3}],{x,0}}.
    {test,is_function,{f,247},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,248}}.
  {label,247}.
    {move,{atom,false},{x,0}}.
  {label,248}.
    {test,is_eq_exact,{f,600},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1251}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,249},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,250}}.
  {label,249}.
    {move,{atom,false},{x,0}}.
  {label,250}.
    {test,is_eq_exact,{f,599},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1262}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,251},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,252}}.
  {label,251}.
    {move,{atom,false},{x,0}}.
  {label,252}.
    {test,is_eq_exact,{f,598},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1272}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,253},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,254}}.
  {label,253}.
    {move,{atom,false},{x,0}}.
  {label,254}.
    {test,is_eq_exact,{f,597},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1282}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,255},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,256}}.
  {label,255}.
    {move,{atom,false},{x,0}}.
  {label,256}.
    {test,is_eq_exact,{f,596},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1292}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,257},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,258}}.
  {label,257}.
    {move,{atom,false},{x,0}}.
  {label,258}.
    {test,is_eq_exact,{f,595},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1302}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,259},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,260}}.
  {label,259}.
    {move,{atom,false},{x,0}}.
  {label,260}.
    {test,is_eq_exact,{f,594},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1312}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_function,{f,261},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,262}}.
  {label,261}.
    {move,{atom,false},{x,0}}.
  {label,262}.
    {test,is_eq_exact,{f,593},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1322}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,263},[{integer,42}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,264}}.
  {label,263}.
    {move,{atom,false},{x,0}}.
  {label,264}.
    {test,is_eq_exact,{f,592},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1332}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,265},[{float,3.14}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,266}}.
  {label,265}.
    {move,{atom,false},{x,0}}.
  {label,266}.
    {test,is_eq_exact,{f,591},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1342}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,5,1}.
    {put_tuple2,{x,0},{list,[{atom,is_map},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1342}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,267},0,[{integer,3}],{x,0}}.
    {test,is_map,{f,267},[{x,0}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,268}}.
  {label,267}.
    {move,{atom,false},{x,0}}.
  {label,268}.
    {test,is_eq_exact,{f,590},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1352}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,269},[{integer,32982724987789283473473838474}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,270}}.
  {label,269}.
    {move,{atom,false},{x,0}}.
  {label,270}.
    {test,is_eq_exact,{f,589},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1362}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,271},[nil]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,272}}.
  {label,271}.
    {move,{atom,false},{x,0}}.
  {label,272}.
    {test,is_eq_exact,{f,588},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1372}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,273},[{atom,xxxx}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,274}}.
  {label,273}.
    {move,{atom,false},{x,0}}.
  {label,274}.
    {test,is_eq_exact,{f,587},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1382}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,275},[{literal,{a,b,c}}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,276}}.
  {label,275}.
    {move,{atom,false},{x,0}}.
  {label,276}.
    {test,is_eq_exact,{f,586},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1392}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,277},[{literal,[a,list]}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,278}}.
  {label,277}.
    {move,{atom,false},{x,0}}.
  {label,278}.
    {test,is_eq_exact,{f,585},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1402}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,279},[{literal,<<1,2,3>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,280}}.
  {label,279}.
    {move,{atom,false},{x,0}}.
  {label,280}.
    {test,is_eq_exact,{f,584},[{x,0},{atom,false}]}.
    {move,{literal,[{is_map,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1412}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {test,is_map,{f,281},[{literal,<<0,21,0:1>>}]}.
    {move,{atom,true},{x,0}}.
    {jump,{f,282}}.
  {label,281}.
    {move,{atom,false},{x,0}}.
  {label,282}.
    {test,is_eq_exact,{f,583},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1422}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,283},[{integer,42},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,283},[{x,0},{atom,true}]}.
    {jump,{f,284}}.
  {label,283}.
    {move,{atom,false},{x,0}}.
  {label,284}.
    {test,is_eq_exact,{f,582},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1432}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,285},[{integer,42},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,285},[{x,0},{atom,true}]}.
    {jump,{f,286}}.
  {label,285}.
    {move,{atom,false},{x,0}}.
  {label,286}.
    {test,is_eq_exact,{f,581},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1442}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{integer,42},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1442}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,287},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,287},[{integer,42},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,287},[{x,0},{atom,true}]}.
    {jump,{f,288}}.
  {label,287}.
    {move,{atom,false},{x,0}}.
  {label,288}.
    {test,is_eq_exact,{f,580},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1452}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,289},
         [{integer,42},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,289},[{x,0},{atom,true}]}.
    {jump,{f,290}}.
  {label,289}.
    {move,{atom,false},{x,0}}.
  {label,290}.
    {test,is_eq_exact,{f,579},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1463}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,291},[{integer,42},nil],{x,0}}.
    {test,is_eq_exact,{f,291},[{x,0},{atom,true}]}.
    {jump,{f,292}}.
  {label,291}.
    {move,{atom,false},{x,0}}.
  {label,292}.
    {test,is_eq_exact,{f,578},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1473}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,293},[{integer,42},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,293},[{x,0},{atom,true}]}.
    {jump,{f,294}}.
  {label,293}.
    {move,{atom,false},{x,0}}.
  {label,294}.
    {test,is_eq_exact,{f,577},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1483}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,295},[{integer,42},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,295},[{x,0},{atom,true}]}.
    {jump,{f,296}}.
  {label,295}.
    {move,{atom,false},{x,0}}.
  {label,296}.
    {test,is_eq_exact,{f,576},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1493}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,297},[{integer,42},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,297},[{x,0},{atom,true}]}.
    {jump,{f,298}}.
  {label,297}.
    {move,{atom,false},{x,0}}.
  {label,298}.
    {test,is_eq_exact,{f,575},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1503}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,299},[{integer,42},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,299},[{x,0},{atom,true}]}.
    {jump,{f,300}}.
  {label,299}.
    {move,{atom,false},{x,0}}.
  {label,300}.
    {test,is_eq_exact,{f,574},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,42,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1513}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,301},[{integer,42},{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,301},[{x,0},{atom,true}]}.
    {jump,{f,302}}.
  {label,301}.
    {move,{atom,false},{x,0}}.
  {label,302}.
    {test,is_eq_exact,{f,573},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1523}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,303},[{float,3.14},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,303},[{x,0},{atom,true}]}.
    {jump,{f,304}}.
  {label,303}.
    {move,{atom,false},{x,0}}.
  {label,304}.
    {test,is_eq_exact,{f,572},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1533}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,305},[{float,3.14},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,305},[{x,0},{atom,true}]}.
    {jump,{f,306}}.
  {label,305}.
    {move,{atom,false},{x,0}}.
  {label,306}.
    {test,is_eq_exact,{f,571},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1543}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{float,3.14},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1543}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,307},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,307},[{float,3.14},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,307},[{x,0},{atom,true}]}.
    {jump,{f,308}}.
  {label,307}.
    {move,{atom,false},{x,0}}.
  {label,308}.
    {test,is_eq_exact,{f,570},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1553}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,309},
         [{float,3.14},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,309},[{x,0},{atom,true}]}.
    {jump,{f,310}}.
  {label,309}.
    {move,{atom,false},{x,0}}.
  {label,310}.
    {test,is_eq_exact,{f,569},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1565}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,311},[{float,3.14},nil],{x,0}}.
    {test,is_eq_exact,{f,311},[{x,0},{atom,true}]}.
    {jump,{f,312}}.
  {label,311}.
    {move,{atom,false},{x,0}}.
  {label,312}.
    {test,is_eq_exact,{f,568},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1575}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,313},[{float,3.14},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,313},[{x,0},{atom,true}]}.
    {jump,{f,314}}.
  {label,313}.
    {move,{atom,false},{x,0}}.
  {label,314}.
    {test,is_eq_exact,{f,567},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1585}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,315},[{float,3.14},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,315},[{x,0},{atom,true}]}.
    {jump,{f,316}}.
  {label,315}.
    {move,{atom,false},{x,0}}.
  {label,316}.
    {test,is_eq_exact,{f,566},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1595}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,317},[{float,3.14},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,317},[{x,0},{atom,true}]}.
    {jump,{f,318}}.
  {label,317}.
    {move,{atom,false},{x,0}}.
  {label,318}.
    {test,is_eq_exact,{f,565},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1605}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,319},[{float,3.14},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,319},[{x,0},{atom,true}]}.
    {jump,{f,320}}.
  {label,319}.
    {move,{atom,false},{x,0}}.
  {label,320}.
    {test,is_eq_exact,{f,564},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,3.14,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1615}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,321},[{float,3.14},{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,321},[{x,0},{atom,true}]}.
    {jump,{f,322}}.
  {label,321}.
    {move,{atom,false},{x,0}}.
  {label,322}.
    {test,is_eq_exact,{f,563},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1625}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{integer,42}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1625}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,323},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,323},[{x,0},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,323},[{x,0},{atom,true}]}.
    {jump,{f,324}}.
  {label,323}.
    {move,{atom,false},{x,0}}.
  {label,324}.
    {test,is_eq_exact,{f,562},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1635}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{float,3.14}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1635}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,325},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,325},[{x,0},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,325},[{x,0},{atom,true}]}.
    {jump,{f,326}}.
  {label,325}.
    {move,{atom,false},{x,0}}.
  {label,326}.
    {test,is_eq_exact,{f,561},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1645}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1645}]}.
    {gc_bif,'-',{f,0},1,[{integer,3}],{x,1}}.
    {test_heap,6,2}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{x,1}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1645}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,327},0,[{integer,3}],{x,0}}.
    {gc_bif,'-',{f,327},1,[{integer,3}],{x,1}}.
    {bif,is_function,{f,327},[{x,0},{x,1}],{x,0}}.
    {test,is_eq_exact,{f,327},[{x,0},{atom,true}]}.
    {jump,{f,328}}.
  {label,327}.
    {move,{atom,false},{x,0}}.
  {label,328}.
    {test,is_eq_exact,{f,560},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1656}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},
                {list,[{atom,is_function},
                       {x,0},
                       {integer,32982724987789283473473838474}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1655}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,329},0,[{integer,3}],{x,0}}.
    {bif,is_function,
         {f,329},
         [{x,0},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,329},[{x,0},{atom,true}]}.
    {jump,{f,330}}.
  {label,329}.
    {move,{atom,false},{x,0}}.
  {label,330}.
    {test,is_eq_exact,{f,559},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1666}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},nil]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1666}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,331},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,331},[{x,0},nil],{x,0}}.
    {test,is_eq_exact,{f,331},[{x,0},{atom,true}]}.
    {jump,{f,332}}.
  {label,331}.
    {move,{atom,false},{x,0}}.
  {label,332}.
    {test,is_eq_exact,{f,558},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1676}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{atom,xxxx}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1676}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,333},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,333},[{x,0},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,333},[{x,0},{atom,true}]}.
    {jump,{f,334}}.
  {label,333}.
    {move,{atom,false},{x,0}}.
  {label,334}.
    {test,is_eq_exact,{f,557},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1686}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{literal,{a,b,c}}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1686}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,335},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,335},[{x,0},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,335},[{x,0},{atom,true}]}.
    {jump,{f,336}}.
  {label,335}.
    {move,{atom,false},{x,0}}.
  {label,336}.
    {test,is_eq_exact,{f,556},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1696}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{literal,[a,list]}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1696}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,337},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,337},[{x,0},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,337},[{x,0},{atom,true}]}.
    {jump,{f,338}}.
  {label,337}.
    {move,{atom,false},{x,0}}.
  {label,338}.
    {test,is_eq_exact,{f,555},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1706}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{x,0},{literal,<<1,2,3>>}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1706}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,339},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,339},[{x,0},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,339},[{x,0},{atom,true}]}.
    {jump,{f,340}}.
  {label,339}.
    {move,{atom,false},{x,0}}.
  {label,340}.
    {test,is_eq_exact,{f,554},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1716}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},
                {list,[{atom,is_function},{x,0},{literal,<<0,21,0:1>>}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1716}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,341},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,341},[{x,0},{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,341},[{x,0},{atom,true}]}.
    {jump,{f,342}}.
  {label,341}.
    {move,{atom,false},{x,0}}.
  {label,342}.
    {test,is_eq_exact,{f,553},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1726}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,343},
         [{integer,32982724987789283473473838474},{integer,42}],
         {x,0}}.
    {test,is_eq_exact,{f,343},[{x,0},{atom,true}]}.
    {jump,{f,344}}.
  {label,343}.
    {move,{atom,false},{x,0}}.
  {label,344}.
    {test,is_eq_exact,{f,552},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1737}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,345},
         [{integer,32982724987789283473473838474},{float,3.14}],
         {x,0}}.
    {test,is_eq_exact,{f,345},[{x,0},{atom,true}]}.
    {jump,{f,346}}.
  {label,345}.
    {move,{atom,false},{x,0}}.
  {label,346}.
    {test,is_eq_exact,{f,551},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1750}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},
                {list,[{atom,is_function},
                       {integer,32982724987789283473473838474},
                       {x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1749}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,347},0,[{integer,3}],{x,0}}.
    {bif,is_function,
         {f,347},
         [{integer,32982724987789283473473838474},{x,0}],
         {x,0}}.
    {test,is_eq_exact,{f,347},[{x,0},{atom,true}]}.
    {jump,{f,348}}.
  {label,347}.
    {move,{atom,false},{x,0}}.
  {label,348}.
    {test,is_eq_exact,{f,550},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,
                                 32982724987789283473473838474}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1760}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,349},
         [{integer,32982724987789283473473838474},
          {integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,349},[{x,0},{atom,true}]}.
    {jump,{f,350}}.
  {label,349}.
    {move,{atom,false},{x,0}}.
  {label,350}.
    {test,is_eq_exact,{f,549},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1773}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,351},
         [{integer,32982724987789283473473838474},nil],
         {x,0}}.
    {test,is_eq_exact,{f,351},[{x,0},{atom,true}]}.
    {jump,{f,352}}.
  {label,351}.
    {move,{atom,false},{x,0}}.
  {label,352}.
    {test,is_eq_exact,{f,548},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1784}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,353},
         [{integer,32982724987789283473473838474},{atom,xxxx}],
         {x,0}}.
    {test,is_eq_exact,{f,353},[{x,0},{atom,true}]}.
    {jump,{f,354}}.
  {label,353}.
    {move,{atom,false},{x,0}}.
  {label,354}.
    {test,is_eq_exact,{f,547},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,{a,b,c}}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1796}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,355},
         [{integer,32982724987789283473473838474},{literal,{a,b,c}}],
         {x,0}}.
    {test,is_eq_exact,{f,355},[{x,0},{atom,true}]}.
    {jump,{f,356}}.
  {label,355}.
    {move,{atom,false},{x,0}}.
  {label,356}.
    {test,is_eq_exact,{f,546},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,[a,list]}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1808}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,357},
         [{integer,32982724987789283473473838474},{literal,[a,list]}],
         {x,0}}.
    {test,is_eq_exact,{f,357},[{x,0},{atom,true}]}.
    {jump,{f,358}}.
  {label,357}.
    {move,{atom,false},{x,0}}.
  {label,358}.
    {test,is_eq_exact,{f,545},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,<<1,2,3>>}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1820}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,359},
         [{integer,32982724987789283473473838474},{literal,<<1,2,3>>}],
         {x,0}}.
    {test,is_eq_exact,{f,359},[{x,0},{atom,true}]}.
    {jump,{f,360}}.
  {label,359}.
    {move,{atom,false},{x,0}}.
  {label,360}.
    {test,is_eq_exact,{f,544},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,32982724987789283473473838474,<<0,21,0:1>>}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1832}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,361},
         [{integer,32982724987789283473473838474},{literal,<<0,21,0:1>>}],
         {x,0}}.
    {test,is_eq_exact,{f,361},[{x,0},{atom,true}]}.
    {jump,{f,362}}.
  {label,361}.
    {move,{atom,false},{x,0}}.
  {label,362}.
    {test,is_eq_exact,{f,543},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1844}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,363},[nil,{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,363},[{x,0},{atom,true}]}.
    {jump,{f,364}}.
  {label,363}.
    {move,{atom,false},{x,0}}.
  {label,364}.
    {test,is_eq_exact,{f,542},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1854}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,365},[nil,{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,365},[{x,0},{atom,true}]}.
    {jump,{f,366}}.
  {label,365}.
    {move,{atom,false},{x,0}}.
  {label,366}.
    {test,is_eq_exact,{f,541},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1864}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},nil,{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1864}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,367},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,367},[nil,{x,0}],{x,0}}.
    {test,is_eq_exact,{f,367},[{x,0},{atom,true}]}.
    {jump,{f,368}}.
  {label,367}.
    {move,{atom,false},{x,0}}.
  {label,368}.
    {test,is_eq_exact,{f,540},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1874}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,369},
         [nil,{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,369},[{x,0},{atom,true}]}.
    {jump,{f,370}}.
  {label,369}.
    {move,{atom,false},{x,0}}.
  {label,370}.
    {test,is_eq_exact,{f,539},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1885}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,371},[nil,nil],{x,0}}.
    {test,is_eq_exact,{f,371},[{x,0},{atom,true}]}.
    {jump,{f,372}}.
  {label,371}.
    {move,{atom,false},{x,0}}.
  {label,372}.
    {test,is_eq_exact,{f,538},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1895}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,373},[nil,{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,373},[{x,0},{atom,true}]}.
    {jump,{f,374}}.
  {label,373}.
    {move,{atom,false},{x,0}}.
  {label,374}.
    {test,is_eq_exact,{f,537},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1905}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,375},[nil,{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,375},[{x,0},{atom,true}]}.
    {jump,{f,376}}.
  {label,375}.
    {move,{atom,false},{x,0}}.
  {label,376}.
    {test,is_eq_exact,{f,536},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1915}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,377},[nil,{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,377},[{x,0},{atom,true}]}.
    {jump,{f,378}}.
  {label,377}.
    {move,{atom,false},{x,0}}.
  {label,378}.
    {test,is_eq_exact,{f,535},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1925}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,379},[nil,{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,379},[{x,0},{atom,true}]}.
    {jump,{f,380}}.
  {label,379}.
    {move,{atom,false},{x,0}}.
  {label,380}.
    {test,is_eq_exact,{f,534},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[],<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1935}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,381},[nil,{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,381},[{x,0},{atom,true}]}.
    {jump,{f,382}}.
  {label,381}.
    {move,{atom,false},{x,0}}.
  {label,382}.
    {test,is_eq_exact,{f,533},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1945}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,383},[{atom,xxxx},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,383},[{x,0},{atom,true}]}.
    {jump,{f,384}}.
  {label,383}.
    {move,{atom,false},{x,0}}.
  {label,384}.
    {test,is_eq_exact,{f,532},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1955}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,385},[{atom,xxxx},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,385},[{x,0},{atom,true}]}.
    {jump,{f,386}}.
  {label,385}.
    {move,{atom,false},{x,0}}.
  {label,386}.
    {test,is_eq_exact,{f,531},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",1965}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{atom,xxxx},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1965}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,387},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,387},[{atom,xxxx},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,387},[{x,0},{atom,true}]}.
    {jump,{f,388}}.
  {label,387}.
    {move,{atom,false},{x,0}}.
  {label,388}.
    {test,is_eq_exact,{f,530},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,32982724987789283473473838474}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1975}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,389},
         [{atom,xxxx},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,389},[{x,0},{atom,true}]}.
    {jump,{f,390}}.
  {label,389}.
    {move,{atom,false},{x,0}}.
  {label,390}.
    {test,is_eq_exact,{f,529},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1987}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,391},[{atom,xxxx},nil],{x,0}}.
    {test,is_eq_exact,{f,391},[{x,0},{atom,true}]}.
    {jump,{f,392}}.
  {label,391}.
    {move,{atom,false},{x,0}}.
  {label,392}.
    {test,is_eq_exact,{f,528},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",1997}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,393},[{atom,xxxx},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,393},[{x,0},{atom,true}]}.
    {jump,{f,394}}.
  {label,393}.
    {move,{atom,false},{x,0}}.
  {label,394}.
    {test,is_eq_exact,{f,527},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2007}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,395},[{atom,xxxx},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,395},[{x,0},{atom,true}]}.
    {jump,{f,396}}.
  {label,395}.
    {move,{atom,false},{x,0}}.
  {label,396}.
    {test,is_eq_exact,{f,526},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2017}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,397},[{atom,xxxx},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,397},[{x,0},{atom,true}]}.
    {jump,{f,398}}.
  {label,397}.
    {move,{atom,false},{x,0}}.
  {label,398}.
    {test,is_eq_exact,{f,525},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2027}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,399},[{atom,xxxx},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,399},[{x,0},{atom,true}]}.
    {jump,{f,400}}.
  {label,399}.
    {move,{atom,false},{x,0}}.
  {label,400}.
    {test,is_eq_exact,{f,524},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,xxxx,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2037}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,401},[{atom,xxxx},{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,401},[{x,0},{atom,true}]}.
    {jump,{f,402}}.
  {label,401}.
    {move,{atom,false},{x,0}}.
  {label,402}.
    {test,is_eq_exact,{f,523},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2047}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,403},[{literal,{a,b,c}},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,403},[{x,0},{atom,true}]}.
    {jump,{f,404}}.
  {label,403}.
    {move,{atom,false},{x,0}}.
  {label,404}.
    {test,is_eq_exact,{f,522},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2057}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,405},[{literal,{a,b,c}},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,405},[{x,0},{atom,true}]}.
    {jump,{f,406}}.
  {label,405}.
    {move,{atom,false},{x,0}}.
  {label,406}.
    {test,is_eq_exact,{f,521},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",2067}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{literal,{a,b,c}},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2067}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,407},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,407},[{literal,{a,b,c}},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,407},[{x,0},{atom,true}]}.
    {jump,{f,408}}.
  {label,407}.
    {move,{atom,false},{x,0}}.
  {label,408}.
    {test,is_eq_exact,{f,520},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},32982724987789283473473838474}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2077}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,409},
         [{literal,{a,b,c}},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,409},[{x,0},{atom,true}]}.
    {jump,{f,410}}.
  {label,409}.
    {move,{atom,false},{x,0}}.
  {label,410}.
    {test,is_eq_exact,{f,519},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2090}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,411},[{literal,{a,b,c}},nil],{x,0}}.
    {test,is_eq_exact,{f,411},[{x,0},{atom,true}]}.
    {jump,{f,412}}.
  {label,411}.
    {move,{atom,false},{x,0}}.
  {label,412}.
    {test,is_eq_exact,{f,518},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2100}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,413},[{literal,{a,b,c}},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,413},[{x,0},{atom,true}]}.
    {jump,{f,414}}.
  {label,413}.
    {move,{atom,false},{x,0}}.
  {label,414}.
    {test,is_eq_exact,{f,517},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2110}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,415},[{literal,{a,b,c}},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,415},[{x,0},{atom,true}]}.
    {jump,{f,416}}.
  {label,415}.
    {move,{atom,false},{x,0}}.
  {label,416}.
    {test,is_eq_exact,{f,516},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2120}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,417},[{literal,{a,b,c}},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,417},[{x,0},{atom,true}]}.
    {jump,{f,418}}.
  {label,417}.
    {move,{atom,false},{x,0}}.
  {label,418}.
    {test,is_eq_exact,{f,515},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2130}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,419},[{literal,{a,b,c}},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,419},[{x,0},{atom,true}]}.
    {jump,{f,420}}.
  {label,419}.
    {move,{atom,false},{x,0}}.
  {label,420}.
    {test,is_eq_exact,{f,514},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,{a,b,c},<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2140}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,421},[{literal,{a,b,c}},{literal,<<0,21,0:1>>}],{x,0}}.
    {test,is_eq_exact,{f,421},[{x,0},{atom,true}]}.
    {jump,{f,422}}.
  {label,421}.
    {move,{atom,false},{x,0}}.
  {label,422}.
    {test,is_eq_exact,{f,513},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2150}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,423},[{literal,[a,list]},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,423},[{x,0},{atom,true}]}.
    {jump,{f,424}}.
  {label,423}.
    {move,{atom,false},{x,0}}.
  {label,424}.
    {test,is_eq_exact,{f,512},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2160}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,425},[{literal,[a,list]},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,425},[{x,0},{atom,true}]}.
    {jump,{f,426}}.
  {label,425}.
    {move,{atom,false},{x,0}}.
  {label,426}.
    {test,is_eq_exact,{f,511},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",2170}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{literal,[a,list]},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2170}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,427},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,427},[{literal,[a,list]},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,427},[{x,0},{atom,true}]}.
    {jump,{f,428}}.
  {label,427}.
    {move,{atom,false},{x,0}}.
  {label,428}.
    {test,is_eq_exact,{f,510},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],32982724987789283473473838474}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2180}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,429},
         [{literal,[a,list]},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,429},[{x,0},{atom,true}]}.
    {jump,{f,430}}.
  {label,429}.
    {move,{atom,false},{x,0}}.
  {label,430}.
    {test,is_eq_exact,{f,509},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2193}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,431},[{literal,[a,list]},nil],{x,0}}.
    {test,is_eq_exact,{f,431},[{x,0},{atom,true}]}.
    {jump,{f,432}}.
  {label,431}.
    {move,{atom,false},{x,0}}.
  {label,432}.
    {test,is_eq_exact,{f,508},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2203}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,433},[{literal,[a,list]},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,433},[{x,0},{atom,true}]}.
    {jump,{f,434}}.
  {label,433}.
    {move,{atom,false},{x,0}}.
  {label,434}.
    {test,is_eq_exact,{f,507},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2213}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,435},[{literal,[a,list]},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,435},[{x,0},{atom,true}]}.
    {jump,{f,436}}.
  {label,435}.
    {move,{atom,false},{x,0}}.
  {label,436}.
    {test,is_eq_exact,{f,506},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2223}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,437},[{literal,[a,list]},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,437},[{x,0},{atom,true}]}.
    {jump,{f,438}}.
  {label,437}.
    {move,{atom,false},{x,0}}.
  {label,438}.
    {test,is_eq_exact,{f,505},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2233}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,439},[{literal,[a,list]},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,439},[{x,0},{atom,true}]}.
    {jump,{f,440}}.
  {label,439}.
    {move,{atom,false},{x,0}}.
  {label,440}.
    {test,is_eq_exact,{f,504},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,[a,list],<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2243}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,441},
         [{literal,[a,list]},{literal,<<0,21,0:1>>}],
         {x,0}}.
    {test,is_eq_exact,{f,441},[{x,0},{atom,true}]}.
    {jump,{f,442}}.
  {label,441}.
    {move,{atom,false},{x,0}}.
  {label,442}.
    {test,is_eq_exact,{f,503},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2253}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,443},[{literal,<<1,2,3>>},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,443},[{x,0},{atom,true}]}.
    {jump,{f,444}}.
  {label,443}.
    {move,{atom,false},{x,0}}.
  {label,444}.
    {test,is_eq_exact,{f,502},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2263}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,445},[{literal,<<1,2,3>>},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,445},[{x,0},{atom,true}]}.
    {jump,{f,446}}.
  {label,445}.
    {move,{atom,false},{x,0}}.
  {label,446}.
    {test,is_eq_exact,{f,501},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",2273}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},{list,[{atom,is_function},{literal,<<1,2,3>>},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2273}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,447},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,447},[{literal,<<1,2,3>>},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,447},[{x,0},{atom,true}]}.
    {jump,{f,448}}.
  {label,447}.
    {move,{atom,false},{x,0}}.
  {label,448}.
    {test,is_eq_exact,{f,500},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,32982724987789283473473838474}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2283}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,449},
         [{literal,<<1,2,3>>},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,449},[{x,0},{atom,true}]}.
    {jump,{f,450}}.
  {label,449}.
    {move,{atom,false},{x,0}}.
  {label,450}.
    {test,is_eq_exact,{f,499},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2296}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,451},[{literal,<<1,2,3>>},nil],{x,0}}.
    {test,is_eq_exact,{f,451},[{x,0},{atom,true}]}.
    {jump,{f,452}}.
  {label,451}.
    {move,{atom,false},{x,0}}.
  {label,452}.
    {test,is_eq_exact,{f,498},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2306}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,453},[{literal,<<1,2,3>>},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,453},[{x,0},{atom,true}]}.
    {jump,{f,454}}.
  {label,453}.
    {move,{atom,false},{x,0}}.
  {label,454}.
    {test,is_eq_exact,{f,497},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2316}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,455},[{literal,<<1,2,3>>},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,455},[{x,0},{atom,true}]}.
    {jump,{f,456}}.
  {label,455}.
    {move,{atom,false},{x,0}}.
  {label,456}.
    {test,is_eq_exact,{f,496},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2326}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,457},[{literal,<<1,2,3>>},{literal,[a,list]}],{x,0}}.
    {test,is_eq_exact,{f,457},[{x,0},{atom,true}]}.
    {jump,{f,458}}.
  {label,457}.
    {move,{atom,false},{x,0}}.
  {label,458}.
    {test,is_eq_exact,{f,495},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2336}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,459},[{literal,<<1,2,3>>},{literal,<<1,2,3>>}],{x,0}}.
    {test,is_eq_exact,{f,459},[{x,0},{atom,true}]}.
    {jump,{f,460}}.
  {label,459}.
    {move,{atom,false},{x,0}}.
  {label,460}.
    {test,is_eq_exact,{f,494},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<1,2,3>>,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2346}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,461},
         [{literal,<<1,2,3>>},{literal,<<0,21,0:1>>}],
         {x,0}}.
    {test,is_eq_exact,{f,461},[{x,0},{atom,true}]}.
    {jump,{f,462}}.
  {label,461}.
    {move,{atom,false},{x,0}}.
  {label,462}.
    {test,is_eq_exact,{f,493},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,42}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2356}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,463},[{literal,<<0,21,0:1>>},{integer,42}],{x,0}}.
    {test,is_eq_exact,{f,463},[{x,0},{atom,true}]}.
    {jump,{f,464}}.
  {label,463}.
    {move,{atom,false},{x,0}}.
  {label,464}.
    {test,is_eq_exact,{f,492},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,3.14}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2366}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,465},[{literal,<<0,21,0:1>>},{float,3.14}],{x,0}}.
    {test,is_eq_exact,{f,465},[{x,0},{atom,true}]}.
    {jump,{f,466}}.
  {label,465}.
    {move,{atom,false},{x,0}}.
  {label,466}.
    {test,is_eq_exact,{f,491},[{x,0},{atom,false}]}.
    {line,[{location,"unoptimized_literal_tests.erl",2376}]}.
    {gc_bif,'-',{f,0},0,[{integer,3}],{x,0}}.
    {test_heap,6,1}.
    {put_tuple2,{x,0},
                {list,[{atom,is_function},{literal,<<0,21,0:1>>},{x,0}]}}.
    {put_list,{x,0},nil,{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2376}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {gc_bif,'-',{f,467},0,[{integer,3}],{x,0}}.
    {bif,is_function,{f,467},[{literal,<<0,21,0:1>>},{x,0}],{x,0}}.
    {test,is_eq_exact,{f,467},[{x,0},{atom,true}]}.
    {jump,{f,468}}.
  {label,467}.
    {move,{atom,false},{x,0}}.
  {label,468}.
    {test,is_eq_exact,{f,490},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,32982724987789283473473838474}]},
          {x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2386}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,469},
         [{literal,<<0,21,0:1>>},{integer,32982724987789283473473838474}],
         {x,0}}.
    {test,is_eq_exact,{f,469},[{x,0},{atom,true}]}.
    {jump,{f,470}}.
  {label,469}.
    {move,{atom,false},{x,0}}.
  {label,470}.
    {test,is_eq_exact,{f,489},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,[]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2399}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,471},[{literal,<<0,21,0:1>>},nil],{x,0}}.
    {test,is_eq_exact,{f,471},[{x,0},{atom,true}]}.
    {jump,{f,472}}.
  {label,471}.
    {move,{atom,false},{x,0}}.
  {label,472}.
    {test,is_eq_exact,{f,488},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,xxxx}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2409}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,473},[{literal,<<0,21,0:1>>},{atom,xxxx}],{x,0}}.
    {test,is_eq_exact,{f,473},[{x,0},{atom,true}]}.
    {jump,{f,474}}.
  {label,473}.
    {move,{atom,false},{x,0}}.
  {label,474}.
    {test,is_eq_exact,{f,487},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,{a,b,c}}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2419}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,{f,475},[{literal,<<0,21,0:1>>},{literal,{a,b,c}}],{x,0}}.
    {test,is_eq_exact,{f,475},[{x,0},{atom,true}]}.
    {jump,{f,476}}.
  {label,475}.
    {move,{atom,false},{x,0}}.
  {label,476}.
    {test,is_eq_exact,{f,486},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,[a,list]}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2429}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,477},
         [{literal,<<0,21,0:1>>},{literal,[a,list]}],
         {x,0}}.
    {test,is_eq_exact,{f,477},[{x,0},{atom,true}]}.
    {jump,{f,478}}.
  {label,477}.
    {move,{atom,false},{x,0}}.
  {label,478}.
    {test,is_eq_exact,{f,485},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,<<1,2,3>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2439}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,479},
         [{literal,<<0,21,0:1>>},{literal,<<1,2,3>>}],
         {x,0}}.
    {test,is_eq_exact,{f,479},[{x,0},{atom,true}]}.
    {jump,{f,480}}.
  {label,479}.
    {move,{atom,false},{x,0}}.
  {label,480}.
    {test,is_eq_exact,{f,484},[{x,0},{atom,false}]}.
    {move,{literal,[{is_function,<<0,21,0:1>>,<<0,21,0:1>>}]},{x,1}}.
    {move,{literal,"~p\n"},{x,0}}.
    {line,[{location,"unoptimized_literal_tests.erl",2449}]}.
    {call_ext,2,{extfunc,io,format,2}}.
    {bif,is_function,
         {f,481},
         [{literal,<<0,21,0:1>>},{literal,<<0,21,0:1>>}],
         {x,0}}.
    {test,is_eq_exact,{f,481},[{x,0},{atom,true}]}.
    {jump,{f,482}}.
  {label,481}.
    {move,{atom,false},{x,0}}.
  {label,482}.
    {test,is_eq_exact,{f,483},[{x,0},{atom,false}]}.
    {deallocate,0}.
    return.
  {label,483}.
    {line,[{location,"unoptimized_literal_tests.erl",2447}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,484}.
    {line,[{location,"unoptimized_literal_tests.erl",2437}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,485}.
    {line,[{location,"unoptimized_literal_tests.erl",2427}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,486}.
    {line,[{location,"unoptimized_literal_tests.erl",2417}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,487}.
    {line,[{location,"unoptimized_literal_tests.erl",2407}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,488}.
    {line,[{location,"unoptimized_literal_tests.erl",2397}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,489}.
    {line,[{location,"unoptimized_literal_tests.erl",2384}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,490}.
    {line,[{location,"unoptimized_literal_tests.erl",2374}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,491}.
    {line,[{location,"unoptimized_literal_tests.erl",2364}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,492}.
    {line,[{location,"unoptimized_literal_tests.erl",2354}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,493}.
    {line,[{location,"unoptimized_literal_tests.erl",2344}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,494}.
    {line,[{location,"unoptimized_literal_tests.erl",2334}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,495}.
    {line,[{location,"unoptimized_literal_tests.erl",2324}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,496}.
    {line,[{location,"unoptimized_literal_tests.erl",2314}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,497}.
    {line,[{location,"unoptimized_literal_tests.erl",2304}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,498}.
    {line,[{location,"unoptimized_literal_tests.erl",2294}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,499}.
    {line,[{location,"unoptimized_literal_tests.erl",2281}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,500}.
    {line,[{location,"unoptimized_literal_tests.erl",2271}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,501}.
    {line,[{location,"unoptimized_literal_tests.erl",2261}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,502}.
    {line,[{location,"unoptimized_literal_tests.erl",2251}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,503}.
    {line,[{location,"unoptimized_literal_tests.erl",2241}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,504}.
    {line,[{location,"unoptimized_literal_tests.erl",2231}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,505}.
    {line,[{location,"unoptimized_literal_tests.erl",2221}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,506}.
    {line,[{location,"unoptimized_literal_tests.erl",2211}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,507}.
    {line,[{location,"unoptimized_literal_tests.erl",2201}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,508}.
    {line,[{location,"unoptimized_literal_tests.erl",2191}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,509}.
    {line,[{location,"unoptimized_literal_tests.erl",2178}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,510}.
    {line,[{location,"unoptimized_literal_tests.erl",2168}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,511}.
    {line,[{location,"unoptimized_literal_tests.erl",2158}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,512}.
    {line,[{location,"unoptimized_literal_tests.erl",2148}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,513}.
    {line,[{location,"unoptimized_literal_tests.erl",2138}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,514}.
    {line,[{location,"unoptimized_literal_tests.erl",2128}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,515}.
    {line,[{location,"unoptimized_literal_tests.erl",2118}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,516}.
    {line,[{location,"unoptimized_literal_tests.erl",2108}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,517}.
    {line,[{location,"unoptimized_literal_tests.erl",2098}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,518}.
    {line,[{location,"unoptimized_literal_tests.erl",2088}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,519}.
    {line,[{location,"unoptimized_literal_tests.erl",2075}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,520}.
    {line,[{location,"unoptimized_literal_tests.erl",2065}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,521}.
    {line,[{location,"unoptimized_literal_tests.erl",2055}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,522}.
    {line,[{location,"unoptimized_literal_tests.erl",2045}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,523}.
    {line,[{location,"unoptimized_literal_tests.erl",2035}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,524}.
    {line,[{location,"unoptimized_literal_tests.erl",2025}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,525}.
    {line,[{location,"unoptimized_literal_tests.erl",2015}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,526}.
    {line,[{location,"unoptimized_literal_tests.erl",2005}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,527}.
    {line,[{location,"unoptimized_literal_tests.erl",1995}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,528}.
    {line,[{location,"unoptimized_literal_tests.erl",1985}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,529}.
    {line,[{location,"unoptimized_literal_tests.erl",1973}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,530}.
    {line,[{location,"unoptimized_literal_tests.erl",1963}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,531}.
    {line,[{location,"unoptimized_literal_tests.erl",1953}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,532}.
    {line,[{location,"unoptimized_literal_tests.erl",1943}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,533}.
    {line,[{location,"unoptimized_literal_tests.erl",1933}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,534}.
    {line,[{location,"unoptimized_literal_tests.erl",1923}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,535}.
    {line,[{location,"unoptimized_literal_tests.erl",1913}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,536}.
    {line,[{location,"unoptimized_literal_tests.erl",1903}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,537}.
    {line,[{location,"unoptimized_literal_tests.erl",1893}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,538}.
    {line,[{location,"unoptimized_literal_tests.erl",1883}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,539}.
    {line,[{location,"unoptimized_literal_tests.erl",1872}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,540}.
    {line,[{location,"unoptimized_literal_tests.erl",1862}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,541}.
    {line,[{location,"unoptimized_literal_tests.erl",1852}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,542}.
    {line,[{location,"unoptimized_literal_tests.erl",1842}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,543}.
    {line,[{location,"unoptimized_literal_tests.erl",1830}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,544}.
    {line,[{location,"unoptimized_literal_tests.erl",1818}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,545}.
    {line,[{location,"unoptimized_literal_tests.erl",1806}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,546}.
    {line,[{location,"unoptimized_literal_tests.erl",1794}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,547}.
    {line,[{location,"unoptimized_literal_tests.erl",1782}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,548}.
    {line,[{location,"unoptimized_literal_tests.erl",1771}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,549}.
    {line,[{location,"unoptimized_literal_tests.erl",1758}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,550}.
    {line,[{location,"unoptimized_literal_tests.erl",1747}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,551}.
    {line,[{location,"unoptimized_literal_tests.erl",1735}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,552}.
    {line,[{location,"unoptimized_literal_tests.erl",1724}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,553}.
    {line,[{location,"unoptimized_literal_tests.erl",1714}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,554}.
    {line,[{location,"unoptimized_literal_tests.erl",1704}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,555}.
    {line,[{location,"unoptimized_literal_tests.erl",1694}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,556}.
    {line,[{location,"unoptimized_literal_tests.erl",1684}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,557}.
    {line,[{location,"unoptimized_literal_tests.erl",1674}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,558}.
    {line,[{location,"unoptimized_literal_tests.erl",1664}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,559}.
    {line,[{location,"unoptimized_literal_tests.erl",1653}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,560}.
    {line,[{location,"unoptimized_literal_tests.erl",1643}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,561}.
    {line,[{location,"unoptimized_literal_tests.erl",1633}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,562}.
    {line,[{location,"unoptimized_literal_tests.erl",1623}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,563}.
    {line,[{location,"unoptimized_literal_tests.erl",1613}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,564}.
    {line,[{location,"unoptimized_literal_tests.erl",1603}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,565}.
    {line,[{location,"unoptimized_literal_tests.erl",1593}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,566}.
    {line,[{location,"unoptimized_literal_tests.erl",1583}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,567}.
    {line,[{location,"unoptimized_literal_tests.erl",1573}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,568}.
    {line,[{location,"unoptimized_literal_tests.erl",1563}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,569}.
    {line,[{location,"unoptimized_literal_tests.erl",1551}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,570}.
    {line,[{location,"unoptimized_literal_tests.erl",1541}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,571}.
    {line,[{location,"unoptimized_literal_tests.erl",1531}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,572}.
    {line,[{location,"unoptimized_literal_tests.erl",1521}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,573}.
    {line,[{location,"unoptimized_literal_tests.erl",1511}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,574}.
    {line,[{location,"unoptimized_literal_tests.erl",1501}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,575}.
    {line,[{location,"unoptimized_literal_tests.erl",1491}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,576}.
    {line,[{location,"unoptimized_literal_tests.erl",1481}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,577}.
    {line,[{location,"unoptimized_literal_tests.erl",1471}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,578}.
    {line,[{location,"unoptimized_literal_tests.erl",1461}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,579}.
    {line,[{location,"unoptimized_literal_tests.erl",1450}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,580}.
    {line,[{location,"unoptimized_literal_tests.erl",1440}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,581}.
    {line,[{location,"unoptimized_literal_tests.erl",1430}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,582}.
    {line,[{location,"unoptimized_literal_tests.erl",1420}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,583}.
    {line,[{location,"unoptimized_literal_tests.erl",1410}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,584}.
    {line,[{location,"unoptimized_literal_tests.erl",1400}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,585}.
    {line,[{location,"unoptimized_literal_tests.erl",1390}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,586}.
    {line,[{location,"unoptimized_literal_tests.erl",1380}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,587}.
    {line,[{location,"unoptimized_literal_tests.erl",1370}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,588}.
    {line,[{location,"unoptimized_literal_tests.erl",1360}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,589}.
    {line,[{location,"unoptimized_literal_tests.erl",1350}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,590}.
    {line,[{location,"unoptimized_literal_tests.erl",1340}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,591}.
    {line,[{location,"unoptimized_literal_tests.erl",1330}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,592}.
    {line,[{location,"unoptimized_literal_tests.erl",1320}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,593}.
    {line,[{location,"unoptimized_literal_tests.erl",1310}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,594}.
    {line,[{location,"unoptimized_literal_tests.erl",1300}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,595}.
    {line,[{location,"unoptimized_literal_tests.erl",1290}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,596}.
    {line,[{location,"unoptimized_literal_tests.erl",1280}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,597}.
    {line,[{location,"unoptimized_literal_tests.erl",1270}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,598}.
    {line,[{location,"unoptimized_literal_tests.erl",1260}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,599}.
    {line,[{location,"unoptimized_literal_tests.erl",1249}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,600}.
    {line,[{location,"unoptimized_literal_tests.erl",1239}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,601}.
    {line,[{location,"unoptimized_literal_tests.erl",1229}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,602}.
    {line,[{location,"unoptimized_literal_tests.erl",1219}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,603}.
    {line,[{location,"unoptimized_literal_tests.erl",1209}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,604}.
    {line,[{location,"unoptimized_literal_tests.erl",1199}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,605}.
    {line,[{location,"unoptimized_literal_tests.erl",1189}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,606}.
    {line,[{location,"unoptimized_literal_tests.erl",1179}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,607}.
    {line,[{location,"unoptimized_literal_tests.erl",1169}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,608}.
    {line,[{location,"unoptimized_literal_tests.erl",1159}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,609}.
    {line,[{location,"unoptimized_literal_tests.erl",1148}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,610}.
    {line,[{location,"unoptimized_literal_tests.erl",1138}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,611}.
    {line,[{location,"unoptimized_literal_tests.erl",1128}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,612}.
    {line,[{location,"unoptimized_literal_tests.erl",1118}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,613}.
    {line,[{location,"unoptimized_literal_tests.erl",1108}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,614}.
    {line,[{location,"unoptimized_literal_tests.erl",1098}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,615}.
    {line,[{location,"unoptimized_literal_tests.erl",1088}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,616}.
    {line,[{location,"unoptimized_literal_tests.erl",1078}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,617}.
    {line,[{location,"unoptimized_literal_tests.erl",1068}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,618}.
    {line,[{location,"unoptimized_literal_tests.erl",1058}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,619}.
    {line,[{location,"unoptimized_literal_tests.erl",1047}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,620}.
    {line,[{location,"unoptimized_literal_tests.erl",1037}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,621}.
    {line,[{location,"unoptimized_literal_tests.erl",1027}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,622}.
    {line,[{location,"unoptimized_literal_tests.erl",1017}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,623}.
    {line,[{location,"unoptimized_literal_tests.erl",1007}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,624}.
    {line,[{location,"unoptimized_literal_tests.erl",997}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,625}.
    {line,[{location,"unoptimized_literal_tests.erl",987}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,626}.
    {line,[{location,"unoptimized_literal_tests.erl",977}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,627}.
    {line,[{location,"unoptimized_literal_tests.erl",967}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,628}.
    {line,[{location,"unoptimized_literal_tests.erl",957}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,629}.
    {line,[{location,"unoptimized_literal_tests.erl",946}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,630}.
    {line,[{location,"unoptimized_literal_tests.erl",936}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,631}.
    {line,[{location,"unoptimized_literal_tests.erl",926}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,632}.
    {line,[{location,"unoptimized_literal_tests.erl",916}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,633}.
    {line,[{location,"unoptimized_literal_tests.erl",906}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,634}.
    {line,[{location,"unoptimized_literal_tests.erl",896}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,635}.
    {line,[{location,"unoptimized_literal_tests.erl",886}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,636}.
    {line,[{location,"unoptimized_literal_tests.erl",876}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,637}.
    {line,[{location,"unoptimized_literal_tests.erl",866}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,638}.
    {line,[{location,"unoptimized_literal_tests.erl",856}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,639}.
    {line,[{location,"unoptimized_literal_tests.erl",845}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,640}.
    {line,[{location,"unoptimized_literal_tests.erl",835}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,641}.
    {line,[{location,"unoptimized_literal_tests.erl",825}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,642}.
    {line,[{location,"unoptimized_literal_tests.erl",815}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,643}.
    {line,[{location,"unoptimized_literal_tests.erl",805}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,644}.
    {line,[{location,"unoptimized_literal_tests.erl",795}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,645}.
    {line,[{location,"unoptimized_literal_tests.erl",785}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,646}.
    {line,[{location,"unoptimized_literal_tests.erl",775}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,647}.
    {line,[{location,"unoptimized_literal_tests.erl",765}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,648}.
    {line,[{location,"unoptimized_literal_tests.erl",755}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,649}.
    {line,[{location,"unoptimized_literal_tests.erl",745}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,650}.
    {line,[{location,"unoptimized_literal_tests.erl",735}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,651}.
    {line,[{location,"unoptimized_literal_tests.erl",725}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,652}.
    {line,[{location,"unoptimized_literal_tests.erl",715}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,653}.
    {line,[{location,"unoptimized_literal_tests.erl",705}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,654}.
    {line,[{location,"unoptimized_literal_tests.erl",695}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,655}.
    {line,[{location,"unoptimized_literal_tests.erl",685}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,656}.
    {line,[{location,"unoptimized_literal_tests.erl",675}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,657}.
    {line,[{location,"unoptimized_literal_tests.erl",665}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,658}.
    {line,[{location,"unoptimized_literal_tests.erl",655}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,659}.
    {line,[{location,"unoptimized_literal_tests.erl",644}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,660}.
    {line,[{location,"unoptimized_literal_tests.erl",634}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,661}.
    {line,[{location,"unoptimized_literal_tests.erl",624}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,662}.
    {line,[{location,"unoptimized_literal_tests.erl",614}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,663}.
    {line,[{location,"unoptimized_literal_tests.erl",604}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,664}.
    {line,[{location,"unoptimized_literal_tests.erl",594}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,665}.
    {line,[{location,"unoptimized_literal_tests.erl",584}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,666}.
    {line,[{location,"unoptimized_literal_tests.erl",574}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,667}.
    {line,[{location,"unoptimized_literal_tests.erl",564}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,668}.
    {line,[{location,"unoptimized_literal_tests.erl",554}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,669}.
    {line,[{location,"unoptimized_literal_tests.erl",543}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,670}.
    {line,[{location,"unoptimized_literal_tests.erl",533}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,671}.
    {line,[{location,"unoptimized_literal_tests.erl",523}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,672}.
    {line,[{location,"unoptimized_literal_tests.erl",513}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,673}.
    {line,[{location,"unoptimized_literal_tests.erl",503}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,674}.
    {line,[{location,"unoptimized_literal_tests.erl",493}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,675}.
    {line,[{location,"unoptimized_literal_tests.erl",483}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,676}.
    {line,[{location,"unoptimized_literal_tests.erl",473}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,677}.
    {line,[{location,"unoptimized_literal_tests.erl",463}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,678}.
    {line,[{location,"unoptimized_literal_tests.erl",453}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,679}.
    {line,[{location,"unoptimized_literal_tests.erl",442}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,680}.
    {line,[{location,"unoptimized_literal_tests.erl",432}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,681}.
    {line,[{location,"unoptimized_literal_tests.erl",422}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,682}.
    {line,[{location,"unoptimized_literal_tests.erl",412}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,683}.
    {line,[{location,"unoptimized_literal_tests.erl",402}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,684}.
    {line,[{location,"unoptimized_literal_tests.erl",392}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,685}.
    {line,[{location,"unoptimized_literal_tests.erl",382}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,686}.
    {line,[{location,"unoptimized_literal_tests.erl",372}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,687}.
    {line,[{location,"unoptimized_literal_tests.erl",362}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,688}.
    {line,[{location,"unoptimized_literal_tests.erl",352}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,689}.
    {line,[{location,"unoptimized_literal_tests.erl",341}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,690}.
    {line,[{location,"unoptimized_literal_tests.erl",331}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,691}.
    {line,[{location,"unoptimized_literal_tests.erl",321}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,692}.
    {line,[{location,"unoptimized_literal_tests.erl",311}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,693}.
    {line,[{location,"unoptimized_literal_tests.erl",301}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,694}.
    {line,[{location,"unoptimized_literal_tests.erl",291}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,695}.
    {line,[{location,"unoptimized_literal_tests.erl",281}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,696}.
    {line,[{location,"unoptimized_literal_tests.erl",271}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,697}.
    {line,[{location,"unoptimized_literal_tests.erl",261}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,698}.
    {line,[{location,"unoptimized_literal_tests.erl",251}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,699}.
    {line,[{location,"unoptimized_literal_tests.erl",240}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,700}.
    {line,[{location,"unoptimized_literal_tests.erl",230}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,701}.
    {line,[{location,"unoptimized_literal_tests.erl",220}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,702}.
    {line,[{location,"unoptimized_literal_tests.erl",210}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,703}.
    {line,[{location,"unoptimized_literal_tests.erl",200}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,704}.
    {line,[{location,"unoptimized_literal_tests.erl",190}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,705}.
    {line,[{location,"unoptimized_literal_tests.erl",180}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,706}.
    {line,[{location,"unoptimized_literal_tests.erl",170}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,707}.
    {line,[{location,"unoptimized_literal_tests.erl",160}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,708}.
    {line,[{location,"unoptimized_literal_tests.erl",150}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,709}.
    {line,[{location,"unoptimized_literal_tests.erl",139}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,710}.
    {line,[{location,"unoptimized_literal_tests.erl",129}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,711}.
    {line,[{location,"unoptimized_literal_tests.erl",119}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,712}.
    {line,[{location,"unoptimized_literal_tests.erl",109}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,713}.
    {line,[{location,"unoptimized_literal_tests.erl",99}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,714}.
    {line,[{location,"unoptimized_literal_tests.erl",89}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,715}.
    {line,[{location,"unoptimized_literal_tests.erl",79}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,716}.
    {line,[{location,"unoptimized_literal_tests.erl",69}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,717}.
    {line,[{location,"unoptimized_literal_tests.erl",59}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,718}.
    {line,[{location,"unoptimized_literal_tests.erl",49}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,719}.
    {line,[{location,"unoptimized_literal_tests.erl",38}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,720}.
    {line,[{location,"unoptimized_literal_tests.erl",28}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,721}.
    {line,[{location,"unoptimized_literal_tests.erl",18}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.
  {label,722}.
    {line,[{location,"unoptimized_literal_tests.erl",8}]}.
    {badmatch,{x,0}}.
    {deallocate,0}.
    return.


{function, module_info, 0, 724}.
  {label,723}.
    {line,[]}.
    {func_info,{atom,unoptimized_literal_tests},{atom,module_info},0}.
  {label,724}.
    {move,{atom,unoptimized_literal_tests},{x,0}}.
    {line,[]}.
    {call_ext_only,1,{extfunc,erlang,get_module_info,1}}.


{function, module_info, 1, 726}.
  {label,725}.
    {line,[]}.
    {func_info,{atom,unoptimized_literal_tests},{atom,module_info},1}.
  {label,726}.
    {move,{x,0},{x,1}}.
    {move,{atom,unoptimized_literal_tests},{x,0}}.
    {line,[]}.
    {call_ext_only,2,{extfunc,erlang,get_module_info,2}}.
