# Set the identifier of the current archive
# USAGE: set_current_archive $archive
set_current_archive() {
	local archive
	archive="$1"

	# Check that the identifier uses the expected ARCHIVE_BASE_xxx format.
	local regexp
	regexp='^ARCHIVE_BASE\(_[0-9A-Z]\+\)*_[0-9]\+$'
	if ! printf '%s' "$archive" | grep --quiet --regexp="$regexp"; then
		error_current_archive_format_invalid "$archive"
		## exit is used instead of return to ensure a failure when called from a subshell.
		exit 1
	fi

	export PLAYIT_CONTEXT_ARCHIVE="$archive"
}

# Print the identifier of the current archive
# An empty string is returned if no archive is currently set.
# USAGE: current_archive
current_archive() {
	printf '%s' "${PLAYIT_CONTEXT_ARCHIVE:-}"
}

