/*
 * Copyright (C) 2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(WK_WEB_EXTENSIONS)

namespace WebKit {

enum class WebExtensionMenuItemContextType : uint16_t {
    Action    =  1 << 0,
    Audio     =  1 << 1,
    Editable  =  1 << 2,
    Frame     =  1 << 3,
    Image     =  1 << 4,
    Link      =  1 << 5,
    Page      =  1 << 6,
    Selection =  1 << 7,
    Tab       =  1 << 8,
    Video     =  1 << 9,
};

static constexpr OptionSet<WebExtensionMenuItemContextType> allWebExtensionMenuItemContextTypes()
{
    return {
        WebExtensionMenuItemContextType::Action,
        WebExtensionMenuItemContextType::Audio,
        WebExtensionMenuItemContextType::Editable,
        WebExtensionMenuItemContextType::Frame,
        WebExtensionMenuItemContextType::Image,
        WebExtensionMenuItemContextType::Link,
        WebExtensionMenuItemContextType::Page,
        WebExtensionMenuItemContextType::Selection,
        WebExtensionMenuItemContextType::Tab,
        WebExtensionMenuItemContextType::Video
    };
}

} // namespace WebKit

#endif // ENABLE(WK_WEB_EXTENSIONS)
