use ui;
use layout;
use core:geometry;

use lang:bs:macro;

class BasicWin extends Frame {
	private UiRoot layout;
	private Button[] buttons;

	init() {
		init("My window", Size(400, 400));

		Button a("A");
		Button b("B");
		Button c("C");
		Button d("D");
		Button e("E");
		Button f("F");
		add(a);
		add(b);
		add(c);
		add(d);
		add(e);
		add(f);

		var grid = layout Grid {
			wrapCols: 2;
			expandCol: 0, 1;
			a {}
			b {}
			c {}
			nextLine;
			d {}
			e {}
			f {
				row: 3;
				col: 3;
			}
		};


		layout.add(grid);

		create();
	}

	void resized(Size s) {
		layout.resize(s);
	}
}


void basicMain() {
	BasicWin w;
	w.waitForClose;
}
