/**
 * Common JSON error class, to make error handling easier.
 */
class JsonError extends Exception {
	// Create.
	init(Str message) {
		init { error = message; }
	}

	// Error message.
	Str error;
}

/**
 * Parse error.
 */
class JsonParseError extends JsonError {
	// Create.
	init(Str message) {
		init(message) {}
	}

	// Format.
	void message(StrBuf to) {
		to << "JSON parse error: " << error;
	}
}

/**
 * Error thrown when accessing JSON data.
 */
class JsonAccessError extends JsonError {
	// Create.
	init(Str message, JsonValue value) {
		init(message) { value = value; }
		saveTrace();
	}

	// Json value.
	JsonValue value;

	// Message.
	void message(StrBuf to) {
		to << "JSON access error: " << error << "\nIn value: " << value;
	}
}
