# Maya

## Introduction

Maya culture was one of the most sophisticated civilizations in the pre-columbian american continent. They developed a writing system which let them store and use their knowledge in a variety of forms: e.g. on how to perform rituals or delivering particular messages to an audience (political and sacred facts from rulers to the people, sculpted in monuments and stelae). These records allow us explore, through the laborious work of many researchers, their cosmovision and how they thought the cosmos came to be. Their knowledge was recorded in books (academically known as “codex”), like the Dresden codex (which describes the dates that Venus would pass through each of its visibility phases and also a table of lunar and solar eclipses), the Paris codex (which is believed to describe some of their constellations), the Madrid codex (which relates astronomy and agriculture data) and lately, the Grolier codex (it was thought that it was an abbreviated version of the Dresden codex, but it is not accepted yet as original by some scholars).

## Description

<p><img align="top" src="illustrations/description1030.png"/><br /><em>Page 49 of the Dresden Codex showing a section of the Venus Table.</em></p>

All Mayan codices are thought to have been taken to Europe by the first explorers of the New World, as evidence of their discoveries. The Paris Codex in particular was then long forgotten, until priest Leon Rosny found it in 1859 in a chimney corner of the National Library of Paris. It has suffered substantial damage, as can be seen in page 23 shown below. In spite of this, the Paris codex describes asterisms and constellations seen by the mayas, some of them probably related to a group of zodiacal constellations (Love, 1994)(Freidel et al., 1993)(Aveni, 2005), while others do not (Špoták, 2015).

<p><img src="illustrations/description1028.png" width="150" height="350"/><br />
<em>Page 23 of the Paris Codex showing some Constellations.</em></p>

In this approach to representing the constellations in Stellarium, we assume that are related to the ecliptic, since in the Paris codex they seem to "swallow" the Sun, so they are placed as close as possible to this line while trying to adjust the star patterns to the images of the different animals thought to represent zodiacal constellations. Other constellations are placed according to what ethnographic sources state are their most probable location.  Constellation lines were drawn trying to adjust to the images taken from the above mentioned sources and they appear according to the interpretation of the contributors of this culture.

### Stars and Planets Names

Maya people, just as other ancient cultures, used stars to keep track of time. The stars included in this version of Stellarium are:

- Two brilliant ones: _[kib' chuplinik]_, *Castor and Pollux*, used at the beginning of the dry season to track the time at night.
- Single Star: _[jun ch'umil]_, *Regulus*, used in February to track the time at night.
- Corner Star: _[xukut ch'umil]_, *Alpha Centauri*, called like this because it marked the southern corner of the night sky at the end of the dry season, in April.
- Bright Star: _[Chac 'Ek]_, *Venus*, this planet was the God of War for the maya. In the Dresden Codex there is an almanac that was used to predict this planet's appearances and disappearances during its synodic period.

### Constellations

Some of the identified constellations from the Paris Codex are:

## Constellations

##### Vulture

<table class="layout">
<tr><td><img src="illustrations/Vulture_PC.png" width="59" height="63"/></td><td>Not clearly identified, but some researchers describe _Ch’oom_ as a vulture, since it is not decorated and relates better to some ethnographic descriptions (Špoták, 2015).</td></tr>
</table>

##### Shark

<table class="layout">
<tr><td><img src="illustrations/Shark_PC.png" width="59" height="63"/></td><td>The picture used for this constellation is in fact a combination of the elements of two animals: head of a snake and tail of a fish, so some scholars conclude _Xoc_ is a representation of a shark.</td></tr>
</table>

##### Owl

<table class="layout">
<tr><td><img src="illustrations/Owl_PC.png" width="59" height="63"/></td><td>_Kulte'_, identified as owl by some scholars, specially because of the small body and feathers on the head that it exhibits.</td></tr>
</table>

##### Jaguar

<table class="layout">
<tr><td><img src="illustrations/Jaguar_PC.png" width="59" height="63"/></td><td>_B'alaam_, identified as such because of the typical marks exhibited which are related to the skin of this animal.</td></tr>
</table>

##### Death

<table class="layout">
<tr><td><img src="illustrations/Death_PC.png" width="59" height="63"/></td><td>This constellation, _Kimi_, appears in the Paris Codex as a skeleton, not yet clear whether it's an animal or not.</td></tr>
</table>

##### Scorpion

<table class="layout">
<tr><td><img src="illustrations/Scorpion_PC.png" width="59" height="63"/></td><td>Scholars agree that this maya constellation of _Siina'an_ is in accordance to our Western culture Scorpion constellation, because of the "twisted" body that is suggested by this pattern of stars, however, for the mayas the sting is closer to the star Antares, because it should be next to the path of the Sun, as suggested by its position in the Paris Codex.</td></tr>
</table>

##### Snake

<table class="layout">
<tr><td><img src="illustrations/Rattlesnake_PC.png" width="59" height="63"/></td><td>This animal, _Kaan_, is present through many species in the Central America environment, but the one represented in the Paris codex is thought to be the Rattlesnake, because of the ending of the tail which shows the typical rattling ending of this reptile.</td></tr>
</table>

##### Bat

<table class="layout">
<tr><td><img src="illustrations/Bat_PC.png" width="59" height="63"/></td><td>_Zool_, identified as bat by its wings, as well as by the characteristic nose that this animal displays in the upper lip, typical in maya iconography.</td></tr>
</table>

##### Toad

<table class="layout">
<tr><td><img src="illustrations/Frog_PC.png" width="59" height="63"/></td><td>This animal, _Uo_, is identified as such because of its necklace and the lack of teeth in its mouth (Špoták, 2015).  Freidel et al. (1993) place this animal in the Western culture constellation of Virgo.</td></tr>
</table>

##### Turtle

<table class="layout">
<tr><td><img src="illustrations/Turtle_BM.png" width="59" height="50"/></td><td>The turtle, _Aak_, was present during the creation of the world, located on the Western culture Orion's Belt asterism. This position in the sky is not really deduced from the Paris codex, but from the analysis made on the Bonampak murals, where the picture of the turtle is decorated with three points, very similar in position and orientation to Orion’s Belt, so this turtle representation has been used to place it in the Stellarium sky, instead of the one depicted in the Paris Codex.</td></tr>
</table>

Asterisms and constellations obtained through other archaeological and ethnographic sources (such as murals and manuscripts like the _Popol Vuh_) are described below:

##### Hole-backed Caiman

_Way Paat Ahiin_ is the Milky Way in a vertical position relative to the horizon. This half-crocodile half-deer creature was sacrificed in a mythical time before the present one, an event which caused a storm of blood marking the end of the primordial chaos. On its back, the four trees -that lifted and hold the sky were placed- along with another supernatural being stepping on top of the decapitated body, thus fertilizing, founding or establishing the current order of things.

<img src="illustrations/sdc.png" width="200" height="90"/>

##### Paddler Gods

This picture shows the Maize God being carried by a couple of paddler gods in a canoe to the place of creation: the Three Hearthstones (defined by the stars Alnitak, Saiph and Rigel, in the Western culture constellation Orion, and in Stellarium shown encircling the _Oxib' Xk'ub'_, or Primordial Fire asterism), where he would be self-sacrificed for the creation of the cosmos to take place.

<img src="illustrations/Stellarium_13.png" width="400" height="110"/>

##### Primordial Fire

<table class="layout">
<tr><td><img src="illustrations/Stellarium_11.png" width="70" height="60"/></td><td>This fire, _Oxib'Xk'ub_, was lighted at the moment of creation, and mayas saw its smoke represented as the Orion's nebula (M42), between three bright stars representing the three hearthstones.</td></tr>
</table>

##### Peccaries

<table class="layout">
<tr><td><img src="illustrations/11.png" width="80" height="60"/></td><td>These pig-like animals are represented together just like the stars Castor and Pollux. The picture included in Stellarium was taken from the Bonampak mural.</td></tr>
</table>

## References

 - [#1]: [The Paris Codex: Complex Analysis of an Ancient Maya Manuscript (Dissertation)](https://www.academia.edu/25028815/The_Paris_Codex_Complex_Analysis_of_an_Ancient_Maya_Manuscript_Dissertation_?auto=download) by Jakub Špoták
 - [#2]: Freidel, D., Schele, L., Parker, J.(1993) *Maya Cosmos: Three Thousand Years On The Shaman's Path*, New York: William Morrow and Company Inc.
 - [#3]: Aveni, A.(2005) *Observadores del Cielo en el Mexico Antiguo*, Mexico D.F.: Fondo de Cultura Economica.
 - [#4]: Tedlock, B.(1999) Maya Astronomy: What We Know and How We Know It, *Archaeoastronomy, The Journal of Astronomy in Culture*, XIV(1), pp.: 39-58.
 - [#5]: Garcia Barrios, A. (2015) [El mito del diluvio en las ceremonias de entronización de los gobernantes mayas. Agentes responsables de la decapitación del saurio y nuevas fundaciones](https://www.sciencedirect.com/science/article/pii/S0185257415300010), *Estudios de cultura maya*, 45(45), pp. 9-48.

  <!-- Links of Interest-->

 - [#6]: [Wikipedia: The Paris Codex](https://en.wikipedia.org/wiki/Paris_Codex)
 - [#7]: [Bonampak, Viviendo el tiempo maya](https://maya.nmai.si.edu/es/gallery/bonampak)

## Authors

This sky culture was contributed by *Eduardo Rodas-Quito* and *Javier Mejuto* of the Archaeoastronomy and Cultural Astronomy Department at Space Sciences Faculty, Universidad Nacional Autonoma de Honduras.

## License

CC BY-NC-SA 4.0
