"""A List of Apache Doris SQL keywords.

See:

https://github.com/apache/doris/blob/master/fe/fe-core/src/main/antlr4/org/apache/doris/nereids/DorisParser.g4

https://github.com/apache/doris/blob/master/fe/fe-core/src/main/antlr4/org/apache/doris/nereids/DorisLexer.g4

"""

doris_reserved_keywords = """
ACCOUNT_LOCK
ACCOUNT_UNLOCK
ADD
ADMIN
ALL
ALTER
ANALYZE
ANALYZER
AND
ANTI
APPEND
AS
ASC
AUTO
BACKEND
BETWEEN
BIGINT
BINARY
BINLOG
BY
CANCEL
CASE
CAST
CLEAN
COLLATE
COLUMN
CONSTRAINT
CREATE
CROSS
CUBE
CURRENT
DATABASE
DATABASES
DECOMMISSION
DEFAULT
DELETE
DESC
DESCRIBE
DISK
DISTINCT
DISTRIBUTED
DISTRIBUTION
DIV
DOUBLE
DROP
DROPP
DUMP
DUPLICATE
ELSE
ENTER
EXCEPT
EXECUTE
EXISTS
EXPLAIN
EXPORT
EXTENDED
EXTRACT
FALSE
FLOAT
FOLLOWER
FOLLOWING
FOR
FORCE
FOREIGN
FROM
FRONTEND
FULL
FUNCTIONS
GRANT
GRANTS
GROUP
HAVING
HLL
IF
IN
INDEX
INFILE
INNER
INSERT
INSTALL
INT
INTEGER
INTERMEDIATE
INTERSECT
INTERVAL
INTO
IS
JOIN
KEY
KEYS
KILL
LARGEINT
LATERAL
LAYOUT
LEFT
LIKE
LIMIT
LIST
LOAD
LOW_PRIORITY
MATCH
MAXVALUE
MINUS
NATURAL
NOT
NO_USE_MV
NULL
OBSERVER
ON
OR
ORDER
OUTER
OUTFILE
OVER
OVERWRITE
PARTITION
PLACEHOLDER
PLAY
PRECEDING
PREPARE
PRIMARY
PROCEDURE
RANGE
READ
REAL
REBALANCE
REFERENCES
REGEXP
RELEASE
RENAME
REPAIR
REPLICA
REVOKE
RIGHT
ROLE
ROLES
ROW
ROWS
SCHEMAS
SELECT
SEMI
SET
SETS
SHOW
SIGNED
SMALLINT
SQL_BLOCK_RULE
SUPERUSER
SWITCH
SYNC
SYSTEM
TABLE
TABLESAMPLE
TABLET
TABLETS
TERMINATED
THEN
TINYINT
TO
TOKENIZER
TOKEN_FILTER
TRASH
TRIM
TRUE
TYPECAST
UNBOUNDED
UNINSTALL
UNION
UNIQUE
UNSIGNED
UPDATE
USE
USE_MV
USING
VALUES
WHEN
WHERE
WHITELIST
WITH
WORKLOAD
WRITE
XOR
"""

doris_unreserved_keywords = """
ACTIONS
AFTER
AGGREGATE
AGG_STATE
ALIAS
ALWAYS
ANALYZED
ARRAY
AT
AUTHORS
AUTO_INCREMENT
BACKENDS
BACKUP
BEGIN
BELONG
BIN
BITAND
BITMAP
BITMAP_EMPTY
BITMAP_UNION
BITOR
BITXOR
BLOB
BOOLEAN
BRANCH
BRIEF
BROKER
BUCKETS
BUILD
BUILTIN
BULK
CACHE
CACHED
CALL
CATALOG
CATALOGS
CHAIN
CHAR
CHARSET
CHECK
CLUSTER
CLUSTERS
COLLATION
COLLECT
COLOCATE
COLUMNS
COMMENT
COMMENT_START
COMMIT
COMMITTED
COMPACT
COMPLETE
COMPRESS_TYPE
COMPUTE
CONDITIONS
CONFIG
CONNECTION
CONNECTION_ID
CONSISTENT
CONSTRAINTS
CONVERT
CONVERT_LSC
COPY
COUNT
CREATION
CRON
CURRENT_CATALOG
CURRENT_DATE
CURRENT_TIME
CURRENT_TIMESTAMP
CURRENT_USER
DATA
DATE
DATETIME
DATETIMEV1
DATETIMEV2
DATEV1
DATEV2
DAY
DAYS
DECIMAL
DECIMALV2
DECIMALV3
DEFERRED
DEMAND
DIAGNOSE
DIAGNOSIS
DICTIONARIES
DICTIONARY
DISTINCTPC
DISTINCTPCSA
DO
DORIS_INTERNAL_TABLE_ID
DUAL
DYNAMIC
E
ENABLE
ENCRYPTKEY
ENCRYPTKEYS
END
ENDS
ENGINE
ENGINES
ERRORS
EVENTS
EVERY
EXCLUDE
EXPIRED
EXTERNAL
FAILED_LOGIN_ATTEMPTS
FAST
FEATURE
FIELDS
FILE
FILTER
FIRST
FORMAT
FREE
FRONTENDS
FUNCTION
GENERATED
GENERIC
GLOBAL
GRAPH
GROUPING
GROUPS
HASH
HASH_MAP
HDFS
HELP
HINT_END
HINT_START
HISTOGRAM
HLL_UNION
HOSTNAME
HOTSPOT
HOUR
HOURS
HUB
IDENTIFIED
IGNORE
IMMEDIATE
INCREMENTAL
INDEXES
INVERTED
IPV4
IPV6
IP_TRIE
ISNULL
ISOLATION
IS_NOT_NULL_PRED
IS_NULL_PRED
JOB
JOBS
JSON
JSONB
LABEL
LAST
LDAP
LDAP_ADMIN_PASSWORD
LEFT_BRACE
LESS
LEVEL
LINES
LINK
LOCAL
LOCALTIME
LOCALTIMESTAMP
LOCATION
LOCK
LOGICAL
MANUAL
MAP
MATCH_ALL
MATCH_ANY
MATCH_PHRASE
MATCH_PHRASE_EDGE
MATCH_PHRASE_PREFIX
MATCH_REGEXP
MATERIALIZED
MAX
MEMO
MERGE
MIGRATE
MIGRATIONS
MIN
MINUTE
MINUTES
MODIFY
MONTH
MTMV
NAME
NAMES
NEGATIVE
NEVER
NEXT
NGRAM_BF
NO
NON_NULLABLE
NULLS
OF
OFFSET
ONLY
OPEN
OPTIMIZED
PARAMETER
PARSED
PARTITIONS
PASSWORD
PASSWORD_EXPIRE
PASSWORD_HISTORY
PASSWORD_LOCK_TIME
PASSWORD_REUSE
PATH
PAUSE
PERCENT
PERIOD
PERMISSIVE
PHYSICAL
PI
PLAN
PLUGIN
PLUGINS
POLICY
PRIVILEGES
PROC
PROCESS
PROCESSLIST
PROFILE
PROPERTIES
PROPERTY
QUALIFY
QUANTILE_STATE
QUANTILE_UNION
QUARTER
QUERY
QUEUED
QUOTA
RANDOM
RECENT
RECOVER
RECYCLE
REFRESH
REPEATABLE
REPLACE
REPLACE_IF_NOT_NULL
REPLAYER
REPOSITORIES
REPOSITORY
RESOURCE
RESOURCES
RESTORE
RESTRICTIVE
RESUME
RETAIN
RETENTION
RETURNS
REWRITTEN
RIGHT_BRACE
RLIKE
ROLLBACK
ROLLUP
ROUTINE
S3
SAMPLE
SCHEDULE
SCHEDULER
SCHEMA
SECOND
SERIALIZABLE
SESSION
SESSION_USER
SET_SESSION_VARIABLE
SHAPE
SKEW
SNAPSHOT
SNAPSHOTS
SONAME
SPLIT
SQL
STAGE
STAGES
START
STARTS
STATS
STATUS
STOP
STORAGE
STREAM
STREAMING
STRING
STRUCT
SUM
TABLES
TAG
TASK
TASKS
TEMPORARY
TEXT
THAN
TIME
TIMESTAMP
TRANSACTION
TREE
TRIGGERS
TRUNCATE
TYPE
TYPES
UNCOMMITTED
UNLOCK
UNSET
UP
USER
VALUE
VARCHAR
VARIABLE
VARIABLES
VARIANT
VAULT
VAULTS
VERBOSE
VERSION
VIEW
VIEWS
WARM
WARNINGS
WEEK
WORK
YEAR
"""

# These are not Doris keywords, but MySQL keywords.
# Because Doris dialect is inherit from MySQL
doris_unreserved_keywords += """
BLOOM_FILTER
STORED
VIRTUAL
"""
