#include "stdafx.h"
#include "TestLib.h"
#include "AffineGap.h"
#include "LandauVishkin.h"

// Test fixture for all the affine gap tests
struct AffineGapTest {
    AffineGap<> ag;
    AffineGapTest() : ag(1, 4, 6, 1) { 
        initializeLVProbabilitiesToPhredPlus33(); 
    }
    int editDist;
};

/*
TEST_F(AffineGapTest, "equal strings") {
    ASSERT_EQ(25, ag.computeScore("ACGTA", 5, "ACGTA", NULL, 5, 16, 20));
}

TEST_F(AffineGapTest, "one deletion") {
    ASSERT_EQ(21, ag.computeScore("AACGTACGT", 9, "ACGTACGT", NULL, 8, 16, 20));
}

TEST_F(AffineGapTest, "long deletion") {
    // ASSERT_EQ(21, ag.computeScore("ACGTAAAAACGTACGTACGT", 20, "ACGTACGTACGTACGT", NULL, 16, 3, 20)); // edit distance = 3
    ASSERT_EQ(26, ag.computeScore("ACGTAAAAACGTACGTACGT", 20, "ACGTACGTACGTACGT", NULL, 16, 16, 20, NULL)); // edit distance = 4
}


TEST_F(AffineGapTest, "long insertion") {
    // ASSERT_EQ(104, ag.computeScore("CCGTCTCAACAATAACAACAACAACAACAAAAACCAGTCACTGTGTTAGGGACAGTCAGAACATGGGGGGATGGGAAAGAGGAGTTACAGGGAGACTT", 98, "CCGTCTCAACAATAACAACAACAACAACAACAAAAGCCAGTCACTGTGTTAGGGACAGTCAGAACATGGGGGGATGGGAAAGAGGAGTTACAGGGAGACTT", NULL, 101, 16, 20));
    // ASSERT_EQ(103, ag.computeScore("ACAATTAGGCAAAAAATCAATGGGATTCAGACAAATATGGGACAATTTTCTCTCTCTGTCTCTCTCTCTGTCTCTCTCTCTGACACACACACACA", 95, "ACAATTAGGCAAAAAATCAATGGGATTCAGACAAATATGGGACAATTTTCTCTCTCTGTCTCTCTCTCTGTCTCTGTCTCTCTCTCTGACACACACACACA", NULL, 101, 16, 20)); // 64M6I31M
}
*/

TEST_F(AffineGapTest, "synthetic") {
    //ASSERT_EQ(72, ag.computeScore("CATTGGCCAGGCTGGTCTCGAACTCCTGACCTCATGATCCACACGCCTCGA", 51, "TGTTGGTCAGGCTGGTCTCGAACTCCT", NULL, 27, 16, 60))
    //ASSERT_EQ(80, ag.computeScore("CAAAAATTAGCTGGGCACGGTGGCAGGCGCCTGTAATCCCAGCTACTCAGGAGACTGAGGCAGGAGAA", 68, "GAAAAATTAGCTGTGCACGGTGGCAGGCGCCTGTA", NULL, 35, 16, 55));
    //ASSERT_EQ(-1, ag.computeScore("CAAAAAATTAGCCACGCATGGTGGCATATCCCTGTAGTCCCAGCTACTCGGGGCTGAGGCAGGAG", 65, "GAAAAATTAGCTGTGCACGGTGGCAGGCGCCTGTA", NULL, 35, 16, 40));
    //ASSERT_EQ(95, ag.computeScore("TAACCAATTAGACAGCTTCTTCCCACCCCAGACCCCAGAGACCTGGCCCAAGCCTGGAGAAGACATCCTGTTTCCCCTGAGGAAGTGGCCCAGATTG", 97, "AAACCAATTAGACAGCTTCTTC", NULL, 22, 16, 78));
    ASSERT_EQ(83, ag.computeScore("CTCTGTCTCTCTCTCTGTCTCTCTCTTTTAACAGGGTATAAACAGACTTAGGGTAACTAAAAAACGGATTAACAATAAGTGATACGA", 87, "CTCTGTCTCTGTCTCTCTCTCTGTCTCTCTCTTTTAACAGGGTATAAACAGACTTAGGGTAACTAAAAAACGGATTAACA", NULL, 80, 8, 21));
}


/* Edit distance tests */
/*
TEST_F(AffineGapTest, "edit distance-equal length strings") {
    ag.computeScore("GAGTCCCCTTTTTTTTTTTTTCCTTTATAAAAGGCTTTCGATCAGACTCGGTCCGTCATACTTTCTGTGACTTCTATTTTCTCGTCAGAACTTGAGATGT", 100, "GAGTCCCCTTTTTTTTTTTTTCCTTTATAAAAGGCTTTCGATCAGACTCGGTCCGTCATACTTTCTGTGACTTCAATTAACTCGTCAGAACTTGAGATGT", NULL, 100, 16, 20, NULL, &editDist);
    ASSERT_EQ(editDist, 3);
}

TEST_F(AffineGapTest, "edit distance-ref longer") {
    ASSERT_EQ(8, ag.computeScore("TGAGAGGGACGGACATGAGGGGACAAAGTCAAGTCTTTTGTTCAAACTTTATGTCTTGTATCTTATGGAGGTCAAATCTTTCAGACTACATACGGAGAATCAAGG", 105, "TGAGCGGGACGGACATGACAAAGTCAAGTCTTTTGTACAAACTTTATGTCTTGTATCTTATGGAGGTCAAATCTTTCAGACTACATACGGAGAATCCAGG", NULL, 100, 16, 20))
}

TEST_F(AffineGapTest, "edit distance-ref shorter") {
    ASSERT_EQ(5, ag.computeScore("ATACTGAACGACTTCCAAGTCTACTAGTAATCGTCAAAAATCGTTATTTCGTAAAAAAAAAGAAAAAACTCTGTCCCAGAGTATAACAACGGG", 93, "ATACTGAACGACTTCCAAGTCTACTAGAAATCGTCAAAAATCGTTATTTCGTACAAAAAAAAATAAAAAACTCTGTCCCATAGTATAACAACGGG", NULL, 95, 16, 20))
}
*/

