/* PlaylistGeneratorConfigurator.cpp, (Created on 29.03.2025) */

/* Copyright (C) 2011-2025 Michael Lugmair
 *
 * This file is part of Sayonara Player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "PlaylistGeneratorConfigurator.h"
#include "MinMaxIntegerDialog.h"

struct PlaylistGeneratorConfigurator::Private
{
	SmartPlaylistManager* smartPlaylistManager;
	Library::InfoAccessor* libraryManager;
	QWidget* parent;

	Private(SmartPlaylistManager* smartPlaylistManager,
	        Library::InfoAccessor* libraryManager, QWidget* parent) :
		smartPlaylistManager {smartPlaylistManager},
		libraryManager {libraryManager},
		parent {parent} {}
};

PlaylistGeneratorConfigurator::PlaylistGeneratorConfigurator(
	SmartPlaylistManager* smartPlaylistManager,
	Library::InfoAccessor* libraryManager, QWidget* parent) :
	m {Pimpl::make<Private>(smartPlaylistManager, libraryManager, parent)} {}

PlaylistGeneratorConfigurator::~PlaylistGeneratorConfigurator() = default;

Spid PlaylistGeneratorConfigurator::createGenerator()
{
	auto result = Spid {-1};
	auto* dialog = new MinMaxIntegerDialog(m->libraryManager, m->parent);

	const auto status = dialog->exec();
	if(status == MinMaxIntegerDialog::Accepted)
	{
		auto generator = m->smartPlaylistManager
		                  ->createAndInsert(dialog->type(), -1, dialog->values(), dialog->isRandomized(),
		                                    dialog->libraryId());

		result = Spid {generator->id()};
	}

	dialog->deleteLater();

	return result;
}

void PlaylistGeneratorConfigurator::editGenerator(const Spid id)
{
	auto smartPlaylist = m->smartPlaylistManager->smartPlaylist(id);
	auto* dialog = new MinMaxIntegerDialog(smartPlaylist, m->libraryManager, m->parent);

	const auto status = dialog->exec();
	if(status == MinMaxIntegerDialog::Accepted)
	{
		const auto values = dialog->values();
		for(int i = 0; i < values.count(); i++)
		{
			smartPlaylist->setValue(i, values[i]);
		}

		smartPlaylist->setRandomized(dialog->isRandomized());
		smartPlaylist->setLibraryId(dialog->libraryId());

		m->smartPlaylistManager->updatePlaylist(id, smartPlaylist);
	}

	dialog->deleteLater();
}

void PlaylistGeneratorConfigurator::removeGenerator(const Spid id)
{
	m->smartPlaylistManager->deletePlaylist(id);
}
