/*
   Unix SMB/CIFS implementation.
   test suite for spoolss rpc operations

   Copyright (C) Guenther Deschner 2009

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "testspoolss.h"

const char *errstr(DWORD error)
{
	static char tmp[20];

	switch (error) {
	case ERROR_FILE_NOT_FOUND:
		return "ERROR_FILE_NOT_FOUND";
	case ERROR_ACCESS_DENIED:
		return "ERROR_ACCESS_DENIED";
	case ERROR_INVALID_PARAMETER:
		return "ERROR_INVALID_PARAMETER";
	case ERROR_INVALID_HANDLE:
		return "ERROR_INVALID_HANDLE";
	case ERROR_CALL_NOT_IMPLEMENTED:
		return "ERROR_CALL_NOT_IMPLEMENTED";
	case ERROR_INSUFFICIENT_BUFFER:
		return "ERROR_INSUFFICIENT_BUFFER";
	case ERROR_INVALID_NAME:
		return "ERROR_INVALID_NAME";
	case ERROR_INVALID_LEVEL:
		return "ERROR_INVALID_LEVEL";
	case ERROR_INVALID_DATA:
		return "ERROR_INVALID_DATA";
	case ERROR_MORE_DATA:
		return "ERROR_MORE_DATA";
	case ERROR_NO_MORE_ITEMS:
		return "ERROR_NO_MORE_ITEMS";
#ifdef ERROR_INVALID_DATATYPE
	case ERROR_INVALID_DATATYPE:
		return "ERROR_INVALID_DATATYPE";
#endif
	case ERROR_INVALID_ENVIRONMENT:
		return "ERROR_INVALID_ENVIRONMENT";
	case ERROR_INVALID_PRINTER_COMMAND:
		return "ERROR_INVALID_PRINTER_COMMAND";
	case ERROR_PRINTER_ALREADY_EXISTS:
		return "ERROR_PRINTER_ALREADY_EXISTS";
	case ERROR_INVALID_PRINTER_NAME:
		return "ERROR_INVALID_PRINTER_NAME";
	case ERROR_INVALID_PRIORITY:
		return "ERROR_INVALID_PRIORITY";
	case ERROR_INVALID_SEPARATOR_FILE:
		return "ERROR_INVALID_SEPARATOR_FILE";
	case ERROR_UNKNOWN_PRINTPROCESSOR:
		return "ERROR_UNKNOWN_PRINTPROCESSOR";
	case ERROR_UNKNOWN_PRINTER_DRIVER:
		return "ERROR_UNKNOWN_PRINTER_DRIVER";
	case ERROR_UNKNOWN_PORT:
		return "ERROR_UNKNOWN_PORT";
	case ERROR_PRINTER_DRIVER_ALREADY_INSTALLED:
		return "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED";
	case ERROR_UNKNOWN_PRINT_MONITOR:
		return "ERROR_UNKNOWN_PRINT_MONITOR";
	case ERROR_PRINTER_DRIVER_IN_USE:
		return "ERROR_PRINTER_DRIVER_IN_USE";
	case ERROR_SPOOL_FILE_NOT_FOUND:
		return "ERROR_SPOOL_FILE_NOT_FOUND";
	case ERROR_SPL_NO_STARTDOC:
		return "ERROR_SPL_NO_STARTDOC";
	case ERROR_SPL_NO_ADDJOB:
		return "ERROR_SPL_NO_ADDJOB";
	case ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED:
		return "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED";
	case ERROR_PRINT_MONITOR_ALREADY_INSTALLED:
		return "ERROR_PRINT_MONITOR_ALREADY_INSTALLED";
	case ERROR_INVALID_PRINT_MONITOR:
		return "ERROR_INVALID_PRINT_MONITOR";
	case ERROR_PRINT_MONITOR_IN_USE:
		return "ERROR_PRINT_MONITOR_IN_USE";
	case ERROR_PRINTER_HAS_JOBS_QUEUED:
		return "ERROR_PRINTER_HAS_JOBS_QUEUED";
	case ERROR_PRINTER_NOT_FOUND:
		return "ERROR_PRINTER_NOT_FOUND";
	case ERROR_PRINTER_DRIVER_WARNED:
		return "ERROR_PRINTER_DRIVER_WARNED";
	case ERROR_PRINTER_DRIVER_BLOCKED:
		return "ERROR_PRINTER_DRIVER_BLOCKED";
#ifdef ERROR_PRINTER_DRIVER_PACKAGE_IN_USE
	case ERROR_PRINTER_DRIVER_PACKAGE_IN_USE:
		return "ERROR_PRINTER_DRIVER_PACKAGE_IN_USE";
#endif
#ifdef ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND
	case ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND:
		return "ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND";
#endif
#ifdef ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED
	case ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED:
		return "ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED";
#endif
#ifdef ERROR_PRINT_JOB_RESTART_REQUIRED
	case ERROR_PRINT_JOB_RESTART_REQUIRED:
		return "ERROR_PRINT_JOB_RESTART_REQUIRED";
#endif
	case ERROR_CANCELLED:
		return "ERROR_CANCELLED";
	case ERROR_NOACCESS:
		return "ERROR_NOACCESS";
	case RPC_X_NULL_REF_POINTER:
		return "RPC_X_NULL_REF_POINTER";
	case RPC_S_PROCNUM_OUT_OF_RANGE:
		return "RPC_S_PROCNUM_OUT_OF_RANGE";
	case RPC_S_SERVER_UNAVAILABLE:
		return "RPC_S_SERVER_UNAVAILABLE";
	case RPC_S_INVALID_NET_ADDR:
		return "RPC_S_INVALID_NET_ADDR";
	case RPC_S_CALL_FAILED:
		return "RPC_S_CALL_FAILED";
	default:
		break;
	}

	sprintf(tmp, "0x%08x", error);

	return tmp;
}
