# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import BillingBenefitsRPConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    BillingBenefitsRPOperationsMixin,
    Operations,
    ReservationOrderAliasOperations,
    SavingsPlanOperations,
    SavingsPlanOrderAliasOperations,
    SavingsPlanOrderOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class BillingBenefitsRP(BillingBenefitsRPOperationsMixin):  # pylint: disable=client-accepts-api-version-keyword
    """Azure Benefits RP let users create and manage benefits like savings plan.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.billingbenefits.operations.Operations
    :ivar savings_plan_order_alias: SavingsPlanOrderAliasOperations operations
    :vartype savings_plan_order_alias:
     azure.mgmt.billingbenefits.operations.SavingsPlanOrderAliasOperations
    :ivar savings_plan_order: SavingsPlanOrderOperations operations
    :vartype savings_plan_order: azure.mgmt.billingbenefits.operations.SavingsPlanOrderOperations
    :ivar savings_plan: SavingsPlanOperations operations
    :vartype savings_plan: azure.mgmt.billingbenefits.operations.SavingsPlanOperations
    :ivar reservation_order_alias: ReservationOrderAliasOperations operations
    :vartype reservation_order_alias:
     azure.mgmt.billingbenefits.operations.ReservationOrderAliasOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param expand: May be used to expand the detail information of some properties. Default value
     is None.
    :type expand: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-11-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        expand: Optional[str] = None,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = BillingBenefitsRPConfiguration(credential=credential, expand=expand, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.savings_plan_order_alias = SavingsPlanOrderAliasOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.savings_plan_order = SavingsPlanOrderOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.savings_plan = SavingsPlanOperations(self._client, self._config, self._serialize, self._deserialize)
        self.reservation_order_alias = ReservationOrderAliasOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "BillingBenefitsRP":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details) -> None:
        self._client.__exit__(*exc_details)
