#pragma once

#include "drape/graphics_context_factory.hpp"
#include "qt/qt_common/qtoglcontext.hpp"

#include <QtGui/QOpenGLContext>

#include <latch>
#include <memory>

namespace qt
{
namespace common
{
class QtOGLContextFactory : public dp::GraphicsContextFactory
{
public:
  QtOGLContextFactory(QOpenGLContext * rootContext);
  ~QtOGLContextFactory() override;

  void PrepareToShutdown();

  bool AcquireFrame();
  GLuint GetTextureHandle() const;
  QRectF const & GetTexRect() const;

  // dp::GraphicsContextFactory overrides:
  dp::GraphicsContext * GetDrawContext() override;
  dp::GraphicsContext * GetResourcesUploadContext() override;
  bool IsDrawContextCreated() const override { return m_drawContext != nullptr; }
  bool IsUploadContextCreated() const override { return m_uploadContext != nullptr; }
  void WaitForInitialization(dp::GraphicsContext * context) override;

private:
  std::unique_ptr<QOffscreenSurface> CreateSurface();

  QOpenGLContext * m_rootContext;
  std::unique_ptr<QtRenderOGLContext> m_drawContext;
  std::unique_ptr<QOffscreenSurface> m_drawSurface;
  std::unique_ptr<QtUploadOGLContext> m_uploadContext;
  std::unique_ptr<QOffscreenSurface> m_uploadSurface;
  bool m_preparedToShutdown = false;

  std::latch m_mainThreadReady = std::latch(1);
  std::latch m_contextsCreated = std::latch(2);
};
}  // namespace common
}  // namespace qt
