/* igraph library.
   Copyright (C) 2022  The igraph development team <igraph@igraph.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <igraph.h>
#include "test_utilities.h"

void print_and_destroy(igraph_t *g, igraph_vector_t *res, igraph_bool_t directed) {
    igraph_real_t unconnected;
    igraph_path_length_hist(g, res, &unconnected, directed);

    printf("result: ");
    igraph_vector_print(res);
    printf("unconnected: %g\n\n", unconnected);

    igraph_destroy(g);

}

int main(void) {
    igraph_t g;
    igraph_vector_t res;

    igraph_vector_init(&res, 0);

    printf("Graph with no vertices:\n");
    igraph_small(&g, 0, IGRAPH_UNDIRECTED, -1);
    print_and_destroy(&g, &res, 1);

    printf("Graph with one vertex:\n");
    igraph_small(&g, 1, IGRAPH_UNDIRECTED, -1);
    print_and_destroy(&g, &res, 1);

    printf("Graph with two vertices:\n");
    igraph_small(&g, 2, IGRAPH_UNDIRECTED, -1);
    print_and_destroy(&g, &res, 1);

    printf("Graph with two connected vertices:\n");
    igraph_small(&g, 2, IGRAPH_UNDIRECTED, 0,1, -1);
    print_and_destroy(&g, &res, 1);

    printf("Graph with loops and multiple edges, undirected:\n");
    igraph_small(&g, 6, IGRAPH_DIRECTED, 0,1, 0,2, 1,1, 1,2, 1,3, 2,0, 2,3, 3,4, 3,4, -1);
    print_and_destroy(&g, &res, 0);

    printf("Graph with loops and multiple edges, directed:\n");
    igraph_small(&g, 6, IGRAPH_DIRECTED, 0,1, 0,2, 1,1, 1,2, 1,3, 2,0, 2,3, 3,4, 3,4, -1);
    print_and_destroy(&g, &res, 1);

    igraph_vector_destroy(&res);

    VERIFY_FINALLY_STACK();

    return 0;
}
