// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package securitycentermanagement

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	securitycentermanagementpb "cloud.google.com/go/securitycentermanagement/apiv1/securitycentermanagementpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListEffectiveSecurityHealthAnalyticsCustomModules  []gax.CallOption
	GetEffectiveSecurityHealthAnalyticsCustomModule    []gax.CallOption
	ListSecurityHealthAnalyticsCustomModules           []gax.CallOption
	ListDescendantSecurityHealthAnalyticsCustomModules []gax.CallOption
	GetSecurityHealthAnalyticsCustomModule             []gax.CallOption
	CreateSecurityHealthAnalyticsCustomModule          []gax.CallOption
	UpdateSecurityHealthAnalyticsCustomModule          []gax.CallOption
	DeleteSecurityHealthAnalyticsCustomModule          []gax.CallOption
	SimulateSecurityHealthAnalyticsCustomModule        []gax.CallOption
	ListEffectiveEventThreatDetectionCustomModules     []gax.CallOption
	GetEffectiveEventThreatDetectionCustomModule       []gax.CallOption
	ListEventThreatDetectionCustomModules              []gax.CallOption
	ListDescendantEventThreatDetectionCustomModules    []gax.CallOption
	GetEventThreatDetectionCustomModule                []gax.CallOption
	CreateEventThreatDetectionCustomModule             []gax.CallOption
	UpdateEventThreatDetectionCustomModule             []gax.CallOption
	DeleteEventThreatDetectionCustomModule             []gax.CallOption
	ValidateEventThreatDetectionCustomModule           []gax.CallOption
	GetSecurityCenterService                           []gax.CallOption
	ListSecurityCenterServices                         []gax.CallOption
	UpdateSecurityCenterService                        []gax.CallOption
	GetLocation                                        []gax.CallOption
	ListLocations                                      []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("securitycentermanagement.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("securitycentermanagement.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("securitycentermanagement.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://securitycentermanagement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListEffectiveSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetEffectiveSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListDescendantSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SimulateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListEffectiveEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetEffectiveEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListDescendantEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetSecurityCenterService:    []gax.CallOption{},
		ListSecurityCenterServices:  []gax.CallOption{},
		UpdateSecurityCenterService: []gax.CallOption{},
		GetLocation:                 []gax.CallOption{},
		ListLocations:               []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListEffectiveSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		GetEffectiveSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListDescendantSecurityHealthAnalyticsCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		GetSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		CreateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SimulateSecurityHealthAnalyticsCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListEffectiveEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		GetEffectiveEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		ListDescendantEventThreatDetectionCustomModules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		GetEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		CreateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateEventThreatDetectionCustomModule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusGatewayTimeout)
			}),
		},
		GetSecurityCenterService:    []gax.CallOption{},
		ListSecurityCenterServices:  []gax.CallOption{},
		UpdateSecurityCenterService: []gax.CallOption{},
		GetLocation:                 []gax.CallOption{},
		ListLocations:               []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Security Center Management API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, ...gax.CallOption) *EffectiveSecurityHealthAnalyticsCustomModuleIterator
	GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, error)
	ListSecurityHealthAnalyticsCustomModules(context.Context, *securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest, ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator
	ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest, ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator
	GetSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.GetSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error)
	CreateSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.CreateSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error)
	UpdateSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.UpdateSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error)
	DeleteSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.DeleteSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) error
	SimulateSecurityHealthAnalyticsCustomModule(context.Context, *securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	ListEffectiveEventThreatDetectionCustomModules(context.Context, *securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest, ...gax.CallOption) *EffectiveEventThreatDetectionCustomModuleIterator
	GetEffectiveEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.GetEffectiveEventThreatDetectionCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, error)
	ListEventThreatDetectionCustomModules(context.Context, *securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest, ...gax.CallOption) *EventThreatDetectionCustomModuleIterator
	ListDescendantEventThreatDetectionCustomModules(context.Context, *securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest, ...gax.CallOption) *EventThreatDetectionCustomModuleIterator
	GetEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.GetEventThreatDetectionCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error)
	CreateEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.CreateEventThreatDetectionCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error)
	UpdateEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.UpdateEventThreatDetectionCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error)
	DeleteEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.DeleteEventThreatDetectionCustomModuleRequest, ...gax.CallOption) error
	ValidateEventThreatDetectionCustomModule(context.Context, *securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleRequest, ...gax.CallOption) (*securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse, error)
	GetSecurityCenterService(context.Context, *securitycentermanagementpb.GetSecurityCenterServiceRequest, ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error)
	ListSecurityCenterServices(context.Context, *securitycentermanagementpb.ListSecurityCenterServicesRequest, ...gax.CallOption) *SecurityCenterServiceIterator
	UpdateSecurityCenterService(context.Context, *securitycentermanagementpb.UpdateSecurityCenterServiceRequest, ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error)
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
}

// Client is a client for interacting with Security Center Management API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListEffectiveSecurityHealthAnalyticsCustomModules returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
// given parent. This includes resident modules defined at the scope of the
// parent, and inherited modules, inherited from CRM ancestors (no
// descendants).
func (c *Client) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *EffectiveSecurityHealthAnalyticsCustomModuleIterator {
	return c.internalClient.ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, req, opts...)
}

// GetEffectiveSecurityHealthAnalyticsCustomModule gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
func (c *Client) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, error) {
	return c.internalClient.GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// ListSecurityHealthAnalyticsCustomModules returns a list of all SecurityHealthAnalyticsCustomModules for the given
// parent. This includes resident modules defined at the scope of the parent,
// and inherited modules, inherited from CRM ancestors (no descendants).
func (c *Client) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	return c.internalClient.ListSecurityHealthAnalyticsCustomModules(ctx, req, opts...)
}

// ListDescendantSecurityHealthAnalyticsCustomModules returns a list of all resident SecurityHealthAnalyticsCustomModules under
// the given CRM parent and all of the parent’s CRM descendants.
func (c *Client) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	return c.internalClient.ListDescendantSecurityHealthAnalyticsCustomModules(ctx, req, opts...)
}

// GetSecurityHealthAnalyticsCustomModule retrieves a SecurityHealthAnalyticsCustomModule.
func (c *Client) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	return c.internalClient.GetSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// CreateSecurityHealthAnalyticsCustomModule creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
// given CRM parent, and also creates inherited
// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
// parent. These modules are enabled by default.
func (c *Client) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	return c.internalClient.CreateSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// UpdateSecurityHealthAnalyticsCustomModule updates the SecurityHealthAnalyticsCustomModule under the given name based
// on the given update mask. Updating the enablement state is supported on
// both resident and inherited modules (though resident modules cannot have an
// enablement state of “inherited”). Updating the display name and custom
// config of a module is supported on resident modules only.
func (c *Client) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	return c.internalClient.UpdateSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// DeleteSecurityHealthAnalyticsCustomModule deletes the specified SecurityHealthAnalyticsCustomModule and all of its
// descendants in the CRM hierarchy. This method is only supported for
// resident custom modules.
func (c *Client) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// SimulateSecurityHealthAnalyticsCustomModule simulates a given SecurityHealthAnalyticsCustomModule and Resource.
func (c *Client) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	return c.internalClient.SimulateSecurityHealthAnalyticsCustomModule(ctx, req, opts...)
}

// ListEffectiveEventThreatDetectionCustomModules lists all effective Event Threat Detection custom modules for the
// given parent. This includes resident modules defined at the scope of the
// parent along with modules inherited from its ancestors.
func (c *Client) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EffectiveEventThreatDetectionCustomModuleIterator {
	return c.internalClient.ListEffectiveEventThreatDetectionCustomModules(ctx, req, opts...)
}

// GetEffectiveEventThreatDetectionCustomModule gets an effective ETD custom module. Retrieves the effective module at the
// given level. The difference between an EffectiveCustomModule and a
// CustomModule is that the fields for an EffectiveCustomModule are computed
// from ancestors if needed. For example, the enablement_state for a
// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
// enablement_state for an EffectiveCustomModule is always computed to ENABLED
// or DISABLED (the effective enablement_state).
func (c *Client) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, error) {
	return c.internalClient.GetEffectiveEventThreatDetectionCustomModule(ctx, req, opts...)
}

// ListEventThreatDetectionCustomModules lists all Event Threat Detection custom modules for the given
// Resource Manager parent. This includes resident modules defined at the
// scope of the parent along with modules inherited from ancestors.
func (c *Client) ListEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	return c.internalClient.ListEventThreatDetectionCustomModules(ctx, req, opts...)
}

// ListDescendantEventThreatDetectionCustomModules lists all resident Event Threat Detection custom modules under the
// given Resource Manager parent and its descendants.
func (c *Client) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	return c.internalClient.ListDescendantEventThreatDetectionCustomModules(ctx, req, opts...)
}

// GetEventThreatDetectionCustomModule gets an Event Threat Detection custom module.
func (c *Client) GetEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	return c.internalClient.GetEventThreatDetectionCustomModule(ctx, req, opts...)
}

// CreateEventThreatDetectionCustomModule creates a resident Event Threat Detection custom module at the scope of the
// given Resource Manager parent, and also creates inherited custom modules
// for all descendants of the given parent. These modules are enabled by
// default.
func (c *Client) CreateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	return c.internalClient.CreateEventThreatDetectionCustomModule(ctx, req, opts...)
}

// UpdateEventThreatDetectionCustomModule updates the Event Threat Detection custom module with the given name based
// on the given update mask. Updating the enablement state is supported for
// both resident and inherited modules (though resident modules cannot have an
// enablement state of “inherited”). Updating the display name or
// configuration of a module is supported for resident modules only. The type
// of a module cannot be changed.
func (c *Client) UpdateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	return c.internalClient.UpdateEventThreatDetectionCustomModule(ctx, req, opts...)
}

// DeleteEventThreatDetectionCustomModule deletes the specified Event Threat Detection custom module and all of its
// descendants in the Resource Manager hierarchy. This method is only
// supported for resident custom modules.
func (c *Client) DeleteEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteEventThreatDetectionCustomModule(ctx, req, opts...)
}

// ValidateEventThreatDetectionCustomModule validates the given Event Threat Detection custom module.
func (c *Client) ValidateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse, error) {
	return c.internalClient.ValidateEventThreatDetectionCustomModule(ctx, req, opts...)
}

// GetSecurityCenterService gets service settings for the specified Security Command Center service.
func (c *Client) GetSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.GetSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	return c.internalClient.GetSecurityCenterService(ctx, req, opts...)
}

// ListSecurityCenterServices returns a list of all Security Command Center services for the given
// parent.
func (c *Client) ListSecurityCenterServices(ctx context.Context, req *securitycentermanagementpb.ListSecurityCenterServicesRequest, opts ...gax.CallOption) *SecurityCenterServiceIterator {
	return c.internalClient.ListSecurityCenterServices(ctx, req, opts...)
}

// UpdateSecurityCenterService updates a Security Command Center service using the given update mask.
func (c *Client) UpdateSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	return c.internalClient.UpdateSecurityCenterService(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Security Center Management API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client securitycentermanagementpb.SecurityCenterManagementClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewClient creates a new security center management client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service describing handlers for resources
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:        connPool,
		client:          securitycentermanagementpb.NewSecurityCenterManagementClient(connPool),
		CallOptions:     &client.CallOptions,
		locationsClient: locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new security center management rest client.
//
// Service describing handlers for resources
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://securitycentermanagement.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://securitycentermanagement.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://securitycentermanagement.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://securitycentermanagement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *EffectiveSecurityHealthAnalyticsCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEffectiveSecurityHealthAnalyticsCustomModules[0:len((*c.CallOptions).ListEffectiveSecurityHealthAnalyticsCustomModules):len((*c.CallOptions).ListEffectiveSecurityHealthAnalyticsCustomModules)], opts...)
	it := &EffectiveSecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEffectiveSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule)], opts...)
	var resp *securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSecurityHealthAnalyticsCustomModules[0:len((*c.CallOptions).ListSecurityHealthAnalyticsCustomModules):len((*c.CallOptions).ListSecurityHealthAnalyticsCustomModules)], opts...)
	it := &SecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSecurityHealthAnalyticsCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDescendantSecurityHealthAnalyticsCustomModules[0:len((*c.CallOptions).ListDescendantSecurityHealthAnalyticsCustomModules):len((*c.CallOptions).ListDescendantSecurityHealthAnalyticsCustomModules)], opts...)
	it := &SecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListDescendantSecurityHealthAnalyticsCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule)], opts...)
	var resp *securitycentermanagementpb.SecurityHealthAnalyticsCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule)], opts...)
	var resp *securitycentermanagementpb.SecurityHealthAnalyticsCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "security_health_analytics_custom_module.name", url.QueryEscape(req.GetSecurityHealthAnalyticsCustomModule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule)], opts...)
	var resp *securitycentermanagementpb.SecurityHealthAnalyticsCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).DeleteSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).DeleteSecurityHealthAnalyticsCustomModule)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule)], opts...)
	var resp *securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.SimulateSecurityHealthAnalyticsCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EffectiveEventThreatDetectionCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEffectiveEventThreatDetectionCustomModules[0:len((*c.CallOptions).ListEffectiveEventThreatDetectionCustomModules):len((*c.CallOptions).ListEffectiveEventThreatDetectionCustomModules)], opts...)
	it := &EffectiveEventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListEffectiveEventThreatDetectionCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEffectiveEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule[0:len((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule):len((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule)], opts...)
	var resp *securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetEffectiveEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEventThreatDetectionCustomModules[0:len((*c.CallOptions).ListEventThreatDetectionCustomModules):len((*c.CallOptions).ListEventThreatDetectionCustomModules)], opts...)
	it := &EventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListEventThreatDetectionCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDescendantEventThreatDetectionCustomModules[0:len((*c.CallOptions).ListDescendantEventThreatDetectionCustomModules):len((*c.CallOptions).ListDescendantEventThreatDetectionCustomModules)], opts...)
	it := &EventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListDescendantEventThreatDetectionCustomModules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEventThreatDetectionCustomModule[0:len((*c.CallOptions).GetEventThreatDetectionCustomModule):len((*c.CallOptions).GetEventThreatDetectionCustomModule)], opts...)
	var resp *securitycentermanagementpb.EventThreatDetectionCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEventThreatDetectionCustomModule[0:len((*c.CallOptions).CreateEventThreatDetectionCustomModule):len((*c.CallOptions).CreateEventThreatDetectionCustomModule)], opts...)
	var resp *securitycentermanagementpb.EventThreatDetectionCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "event_threat_detection_custom_module.name", url.QueryEscape(req.GetEventThreatDetectionCustomModule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEventThreatDetectionCustomModule[0:len((*c.CallOptions).UpdateEventThreatDetectionCustomModule):len((*c.CallOptions).UpdateEventThreatDetectionCustomModule)], opts...)
	var resp *securitycentermanagementpb.EventThreatDetectionCustomModule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEventThreatDetectionCustomModule[0:len((*c.CallOptions).DeleteEventThreatDetectionCustomModule):len((*c.CallOptions).DeleteEventThreatDetectionCustomModule)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) ValidateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ValidateEventThreatDetectionCustomModule[0:len((*c.CallOptions).ValidateEventThreatDetectionCustomModule):len((*c.CallOptions).ValidateEventThreatDetectionCustomModule)], opts...)
	var resp *securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ValidateEventThreatDetectionCustomModule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.GetSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSecurityCenterService[0:len((*c.CallOptions).GetSecurityCenterService):len((*c.CallOptions).GetSecurityCenterService)], opts...)
	var resp *securitycentermanagementpb.SecurityCenterService
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSecurityCenterService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListSecurityCenterServices(ctx context.Context, req *securitycentermanagementpb.ListSecurityCenterServicesRequest, opts ...gax.CallOption) *SecurityCenterServiceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSecurityCenterServices[0:len((*c.CallOptions).ListSecurityCenterServices):len((*c.CallOptions).ListSecurityCenterServices)], opts...)
	it := &SecurityCenterServiceIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListSecurityCenterServicesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityCenterService, string, error) {
		resp := &securitycentermanagementpb.ListSecurityCenterServicesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSecurityCenterServices(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSecurityCenterServices(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) UpdateSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "security_center_service.name", url.QueryEscape(req.GetSecurityCenterService().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSecurityCenterService[0:len((*c.CallOptions).UpdateSecurityCenterService):len((*c.CallOptions).UpdateSecurityCenterService)], opts...)
	var resp *securitycentermanagementpb.SecurityCenterService
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSecurityCenterService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListEffectiveSecurityHealthAnalyticsCustomModules returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
// given parent. This includes resident modules defined at the scope of the
// parent, and inherited modules, inherited from CRM ancestors (no
// descendants).
func (c *restClient) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *EffectiveSecurityHealthAnalyticsCustomModuleIterator {
	it := &EffectiveSecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/effectiveSecurityHealthAnalyticsCustomModules", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEffectiveSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEffectiveSecurityHealthAnalyticsCustomModule gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
func (c *restClient) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).GetEffectiveSecurityHealthAnalyticsCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.EffectiveSecurityHealthAnalyticsCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListSecurityHealthAnalyticsCustomModules returns a list of all SecurityHealthAnalyticsCustomModules for the given
// parent. This includes resident modules defined at the scope of the parent,
// and inherited modules, inherited from CRM ancestors (no descendants).
func (c *restClient) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	it := &SecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/securityHealthAnalyticsCustomModules", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDescendantSecurityHealthAnalyticsCustomModules returns a list of all resident SecurityHealthAnalyticsCustomModules under
// the given CRM parent and all of the parent’s CRM descendants.
func (c *restClient) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...gax.CallOption) *SecurityHealthAnalyticsCustomModuleIterator {
	it := &SecurityHealthAnalyticsCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListDescendantSecurityHealthAnalyticsCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/securityHealthAnalyticsCustomModules:listDescendant", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSecurityHealthAnalyticsCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSecurityHealthAnalyticsCustomModule retrieves a SecurityHealthAnalyticsCustomModule.
func (c *restClient) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.GetSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).GetSecurityHealthAnalyticsCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SecurityHealthAnalyticsCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSecurityHealthAnalyticsCustomModule creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
// given CRM parent, and also creates inherited
// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
// parent. These modules are enabled by default.
func (c *restClient) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSecurityHealthAnalyticsCustomModule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/securityHealthAnalyticsCustomModules", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).CreateSecurityHealthAnalyticsCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SecurityHealthAnalyticsCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSecurityHealthAnalyticsCustomModule updates the SecurityHealthAnalyticsCustomModule under the given name based
// on the given update mask. Updating the enablement state is supported on
// both resident and inherited modules (though resident modules cannot have an
// enablement state of “inherited”). Updating the display name and custom
// config of a module is supported on resident modules only.
func (c *restClient) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityHealthAnalyticsCustomModule, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSecurityHealthAnalyticsCustomModule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSecurityHealthAnalyticsCustomModule().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "security_health_analytics_custom_module.name", url.QueryEscape(req.GetSecurityHealthAnalyticsCustomModule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).UpdateSecurityHealthAnalyticsCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SecurityHealthAnalyticsCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteSecurityHealthAnalyticsCustomModule deletes the specified SecurityHealthAnalyticsCustomModule and all of its
// descendants in the CRM hierarchy. This method is only supported for
// resident custom modules.
func (c *restClient) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// SimulateSecurityHealthAnalyticsCustomModule simulates a given SecurityHealthAnalyticsCustomModule and Resource.
func (c *restClient) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, req *securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/securityHealthAnalyticsCustomModules:simulate", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule[0:len((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule):len((*c.CallOptions).SimulateSecurityHealthAnalyticsCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SimulateSecurityHealthAnalyticsCustomModuleResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListEffectiveEventThreatDetectionCustomModules lists all effective Event Threat Detection custom modules for the
// given parent. This includes resident modules defined at the scope of the
// parent along with modules inherited from its ancestors.
func (c *restClient) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EffectiveEventThreatDetectionCustomModuleIterator {
	it := &EffectiveEventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEffectiveEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/effectiveEventThreatDetectionCustomModules", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEffectiveEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEffectiveEventThreatDetectionCustomModule gets an effective ETD custom module. Retrieves the effective module at the
// given level. The difference between an EffectiveCustomModule and a
// CustomModule is that the fields for an EffectiveCustomModule are computed
// from ancestors if needed. For example, the enablement_state for a
// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
// enablement_state for an EffectiveCustomModule is always computed to ENABLED
// or DISABLED (the effective enablement_state).
func (c *restClient) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule[0:len((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule):len((*c.CallOptions).GetEffectiveEventThreatDetectionCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.EffectiveEventThreatDetectionCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListEventThreatDetectionCustomModules lists all Event Threat Detection custom modules for the given
// Resource Manager parent. This includes resident modules defined at the
// scope of the parent along with modules inherited from ancestors.
func (c *restClient) ListEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	it := &EventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListEventThreatDetectionCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/eventThreatDetectionCustomModules", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDescendantEventThreatDetectionCustomModules lists all resident Event Threat Detection custom modules under the
// given Resource Manager parent and its descendants.
func (c *restClient) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, req *securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest, opts ...gax.CallOption) *EventThreatDetectionCustomModuleIterator {
	it := &EventThreatDetectionCustomModuleIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.EventThreatDetectionCustomModule, string, error) {
		resp := &securitycentermanagementpb.ListDescendantEventThreatDetectionCustomModulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/eventThreatDetectionCustomModules:listDescendant", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEventThreatDetectionCustomModules(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEventThreatDetectionCustomModule gets an Event Threat Detection custom module.
func (c *restClient) GetEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.GetEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEventThreatDetectionCustomModule[0:len((*c.CallOptions).GetEventThreatDetectionCustomModule):len((*c.CallOptions).GetEventThreatDetectionCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.EventThreatDetectionCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateEventThreatDetectionCustomModule creates a resident Event Threat Detection custom module at the scope of the
// given Resource Manager parent, and also creates inherited custom modules
// for all descendants of the given parent. These modules are enabled by
// default.
func (c *restClient) CreateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.CreateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEventThreatDetectionCustomModule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/eventThreatDetectionCustomModules", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateEventThreatDetectionCustomModule[0:len((*c.CallOptions).CreateEventThreatDetectionCustomModule):len((*c.CallOptions).CreateEventThreatDetectionCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.EventThreatDetectionCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateEventThreatDetectionCustomModule updates the Event Threat Detection custom module with the given name based
// on the given update mask. Updating the enablement state is supported for
// both resident and inherited modules (though resident modules cannot have an
// enablement state of “inherited”). Updating the display name or
// configuration of a module is supported for resident modules only. The type
// of a module cannot be changed.
func (c *restClient) UpdateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.UpdateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.EventThreatDetectionCustomModule, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEventThreatDetectionCustomModule()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetEventThreatDetectionCustomModule().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "event_threat_detection_custom_module.name", url.QueryEscape(req.GetEventThreatDetectionCustomModule().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEventThreatDetectionCustomModule[0:len((*c.CallOptions).UpdateEventThreatDetectionCustomModule):len((*c.CallOptions).UpdateEventThreatDetectionCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.EventThreatDetectionCustomModule{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteEventThreatDetectionCustomModule deletes the specified Event Threat Detection custom module and all of its
// descendants in the Resource Manager hierarchy. This method is only
// supported for resident custom modules.
func (c *restClient) DeleteEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.DeleteEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// ValidateEventThreatDetectionCustomModule validates the given Event Threat Detection custom module.
func (c *restClient) ValidateEventThreatDetectionCustomModule(ctx context.Context, req *securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleRequest, opts ...gax.CallOption) (*securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/eventThreatDetectionCustomModules:validate", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ValidateEventThreatDetectionCustomModule[0:len((*c.CallOptions).ValidateEventThreatDetectionCustomModule):len((*c.CallOptions).ValidateEventThreatDetectionCustomModule)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.ValidateEventThreatDetectionCustomModuleResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetSecurityCenterService gets service settings for the specified Security Command Center service.
func (c *restClient) GetSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.GetSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSecurityCenterService[0:len((*c.CallOptions).GetSecurityCenterService):len((*c.CallOptions).GetSecurityCenterService)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SecurityCenterService{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListSecurityCenterServices returns a list of all Security Command Center services for the given
// parent.
func (c *restClient) ListSecurityCenterServices(ctx context.Context, req *securitycentermanagementpb.ListSecurityCenterServicesRequest, opts ...gax.CallOption) *SecurityCenterServiceIterator {
	it := &SecurityCenterServiceIterator{}
	req = proto.Clone(req).(*securitycentermanagementpb.ListSecurityCenterServicesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*securitycentermanagementpb.SecurityCenterService, string, error) {
		resp := &securitycentermanagementpb.ListSecurityCenterServicesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/securityCenterServices", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSecurityCenterServices(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateSecurityCenterService updates a Security Command Center service using the given update mask.
func (c *restClient) UpdateSecurityCenterService(ctx context.Context, req *securitycentermanagementpb.UpdateSecurityCenterServiceRequest, opts ...gax.CallOption) (*securitycentermanagementpb.SecurityCenterService, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSecurityCenterService()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSecurityCenterService().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "security_center_service.name", url.QueryEscape(req.GetSecurityCenterService().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSecurityCenterService[0:len((*c.CallOptions).UpdateSecurityCenterService):len((*c.CallOptions).UpdateSecurityCenterService)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &securitycentermanagementpb.SecurityCenterService{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
