// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package cloudprofiler

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	cloudprofilerpb "cloud.google.com/go/cloudprofiler/apiv2/cloudprofilerpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
)

var newProfilerClientHook clientHook

// ProfilerCallOptions contains the retry settings for each method of ProfilerClient.
type ProfilerCallOptions struct {
	CreateProfile        []gax.CallOption
	CreateOfflineProfile []gax.CallOption
	UpdateProfile        []gax.CallOption
}

func defaultProfilerGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("cloudprofiler.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("cloudprofiler.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("cloudprofiler.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudprofiler.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultProfilerCallOptions() *ProfilerCallOptions {
	return &ProfilerCallOptions{
		CreateProfile: []gax.CallOption{
			gax.WithTimeout(3610000 * time.Millisecond),
		},
		CreateOfflineProfile: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		UpdateProfile: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
	}
}

func defaultProfilerRESTCallOptions() *ProfilerCallOptions {
	return &ProfilerCallOptions{
		CreateProfile: []gax.CallOption{
			gax.WithTimeout(3610000 * time.Millisecond),
		},
		CreateOfflineProfile: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		UpdateProfile: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
	}
}

// internalProfilerClient is an interface that defines the methods available from Cloud Profiler API.
type internalProfilerClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateProfile(context.Context, *cloudprofilerpb.CreateProfileRequest, ...gax.CallOption) (*cloudprofilerpb.Profile, error)
	CreateOfflineProfile(context.Context, *cloudprofilerpb.CreateOfflineProfileRequest, ...gax.CallOption) (*cloudprofilerpb.Profile, error)
	UpdateProfile(context.Context, *cloudprofilerpb.UpdateProfileRequest, ...gax.CallOption) (*cloudprofilerpb.Profile, error)
}

// ProfilerClient is a client for interacting with Cloud Profiler API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Manage the collection of continuous profiling data provided by profiling
// agents running in the cloud or by an offline provider of profiling data.
//
// The APIs listed in this service are intended for use within our profiler
// agents only.
type ProfilerClient struct {
	// The internal transport-dependent client.
	internalClient internalProfilerClient

	// The call options for this service.
	CallOptions *ProfilerCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ProfilerClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ProfilerClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *ProfilerClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateProfile createProfile creates a new profile resource in the online mode.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
//
// The server ensures that the new profiles are created at a constant rate per
// deployment, so the creation request may hang for some time until the next
// profile session is available.
//
// The request may fail with ABORTED error if the creation is not available
// within ~1m, the response will indicate the duration of the backoff the
// client should take before attempting creating a profile again. The backoff
// duration is returned in google.rpc.RetryInfo extension on the response
// status. To a gRPC client, the extension will be return as a
// binary-serialized proto in the trailing metadata item named
// “google.rpc.retryinfo-bin”.
func (c *ProfilerClient) CreateProfile(ctx context.Context, req *cloudprofilerpb.CreateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	return c.internalClient.CreateProfile(ctx, req, opts...)
}

// CreateOfflineProfile createOfflineProfile creates a new profile resource in the offline
// mode. The client provides the profile to create along with the profile
// bytes, the server records it.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
func (c *ProfilerClient) CreateOfflineProfile(ctx context.Context, req *cloudprofilerpb.CreateOfflineProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	return c.internalClient.CreateOfflineProfile(ctx, req, opts...)
}

// UpdateProfile updateProfile updates the profile bytes and labels on the profile resource
// created in the online mode. Updating the bytes for profiles created in the
// offline mode is currently not supported: the profile content must be
// provided at the time of the profile creation.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
func (c *ProfilerClient) UpdateProfile(ctx context.Context, req *cloudprofilerpb.UpdateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	return c.internalClient.UpdateProfile(ctx, req, opts...)
}

// profilerGRPCClient is a client for interacting with Cloud Profiler API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type profilerGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing ProfilerClient
	CallOptions **ProfilerCallOptions

	// The gRPC API client.
	profilerClient cloudprofilerpb.ProfilerServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewProfilerClient creates a new profiler service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Manage the collection of continuous profiling data provided by profiling
// agents running in the cloud or by an offline provider of profiling data.
//
// The APIs listed in this service are intended for use within our profiler
// agents only.
func NewProfilerClient(ctx context.Context, opts ...option.ClientOption) (*ProfilerClient, error) {
	clientOpts := defaultProfilerGRPCClientOptions()
	if newProfilerClientHook != nil {
		hookOpts, err := newProfilerClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ProfilerClient{CallOptions: defaultProfilerCallOptions()}

	c := &profilerGRPCClient{
		connPool:       connPool,
		profilerClient: cloudprofilerpb.NewProfilerServiceClient(connPool),
		CallOptions:    &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *profilerGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *profilerGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *profilerGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type profilerRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing ProfilerClient
	CallOptions **ProfilerCallOptions
}

// NewProfilerRESTClient creates a new profiler service rest client.
//
// Manage the collection of continuous profiling data provided by profiling
// agents running in the cloud or by an offline provider of profiling data.
//
// The APIs listed in this service are intended for use within our profiler
// agents only.
func NewProfilerRESTClient(ctx context.Context, opts ...option.ClientOption) (*ProfilerClient, error) {
	clientOpts := append(defaultProfilerRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultProfilerRESTCallOptions()
	c := &profilerRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &ProfilerClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultProfilerRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://cloudprofiler.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://cloudprofiler.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://cloudprofiler.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudprofiler.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *profilerRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *profilerRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *profilerRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *profilerGRPCClient) CreateProfile(ctx context.Context, req *cloudprofilerpb.CreateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateProfile[0:len((*c.CallOptions).CreateProfile):len((*c.CallOptions).CreateProfile)], opts...)
	var resp *cloudprofilerpb.Profile
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.profilerClient.CreateProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *profilerGRPCClient) CreateOfflineProfile(ctx context.Context, req *cloudprofilerpb.CreateOfflineProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateOfflineProfile[0:len((*c.CallOptions).CreateOfflineProfile):len((*c.CallOptions).CreateOfflineProfile)], opts...)
	var resp *cloudprofilerpb.Profile
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.profilerClient.CreateOfflineProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *profilerGRPCClient) UpdateProfile(ctx context.Context, req *cloudprofilerpb.UpdateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "profile.name", url.QueryEscape(req.GetProfile().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProfile[0:len((*c.CallOptions).UpdateProfile):len((*c.CallOptions).UpdateProfile)], opts...)
	var resp *cloudprofilerpb.Profile
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.profilerClient.UpdateProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateProfile createProfile creates a new profile resource in the online mode.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
//
// The server ensures that the new profiles are created at a constant rate per
// deployment, so the creation request may hang for some time until the next
// profile session is available.
//
// The request may fail with ABORTED error if the creation is not available
// within ~1m, the response will indicate the duration of the backoff the
// client should take before attempting creating a profile again. The backoff
// duration is returned in google.rpc.RetryInfo extension on the response
// status. To a gRPC client, the extension will be return as a
// binary-serialized proto in the trailing metadata item named
// “google.rpc.retryinfo-bin”.
func (c *profilerRESTClient) CreateProfile(ctx context.Context, req *cloudprofilerpb.CreateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/profiles", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateProfile[0:len((*c.CallOptions).CreateProfile):len((*c.CallOptions).CreateProfile)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudprofilerpb.Profile{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateOfflineProfile createOfflineProfile creates a new profile resource in the offline
// mode. The client provides the profile to create along with the profile
// bytes, the server records it.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
func (c *profilerRESTClient) CreateOfflineProfile(ctx context.Context, req *cloudprofilerpb.CreateOfflineProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProfile()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v/profiles:createOffline", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateOfflineProfile[0:len((*c.CallOptions).CreateOfflineProfile):len((*c.CallOptions).CreateOfflineProfile)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudprofilerpb.Profile{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateProfile updateProfile updates the profile bytes and labels on the profile resource
// created in the online mode. Updating the bytes for profiles created in the
// offline mode is currently not supported: the profile content must be
// provided at the time of the profile creation.
//
// Direct use of this API is discouraged, please use a supported
// profiler
// agent (at https://cloud.google.com/profiler/docs/about-profiler#profiling_agent)
// instead for profile collection.
func (c *profilerRESTClient) UpdateProfile(ctx context.Context, req *cloudprofilerpb.UpdateProfileRequest, opts ...gax.CallOption) (*cloudprofilerpb.Profile, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetProfile()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/%v", req.GetProfile().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "profile.name", url.QueryEscape(req.GetProfile().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateProfile[0:len((*c.CallOptions).UpdateProfile):len((*c.CallOptions).UpdateProfile)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudprofilerpb.Profile{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
