//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurityinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/CreateThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_CreateIndicator() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewThreatIntelligenceIndicatorClient().CreateIndicator(ctx, "myRg", "myWorkspace", armsecurityinsights.ThreatIntelligenceIndicatorModel{
		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
			Description:        to.Ptr("debugging indicators"),
			Confidence:         to.Ptr[int32](78),
			CreatedByRef:       to.Ptr("contoso@contoso.com"),
			DisplayName:        to.Ptr("new schema"),
			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{},
			GranularMarkings:   []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{},
			KillChainPhases:    []*armsecurityinsights.ThreatIntelligenceKillChainPhase{},
			Labels:             []*string{},
			Modified:           to.Ptr(""),
			Pattern:            to.Ptr("[url:value = 'https://www.contoso.com']"),
			PatternType:        to.Ptr("url"),
			Revoked:            to.Ptr(false),
			Source:             to.Ptr("Azure Sentinel"),
			ThreatIntelligenceTags: []*string{
				to.Ptr("new schema")},
			ThreatTypes: []*string{
				to.Ptr("compromised")},
			ValidFrom:  to.Ptr("2020-04-15T17:44:00.114052Z"),
			ValidUntil: to.Ptr(""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurityinsights.ThreatIntelligenceIndicatorClientCreateIndicatorResponse{
	// 	                            ThreatIntelligenceInformationClassification: &armsecurityinsights.ThreatIntelligenceIndicatorModel{
	// 		Name: to.Ptr("180105c7-a28d-b1a2-4a78-234f6ec80fd6"),
	// 		Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
	// 		ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/180105c7-a28d-b1a2-4a78-234f6ec80fd6"),
	// 		Etag: to.Ptr("\"0000322c-0000-0800-0000-5e976c960000\""),
	// 		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
	// 		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
	// 			Description: to.Ptr("debugging indicators"),
	// 			Confidence: to.Ptr[int32](78),
	// 			Created: to.Ptr("2020-04-15T20:20:38.6160949Z"),
	// 			CreatedByRef: to.Ptr("contoso@contoso.com"),
	// 			DisplayName: to.Ptr("new schema"),
	// 			ExternalID: to.Ptr("indicator--a2b6a95e-2108-4a38-bd49-ef95811bbcd7"),
	// 			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
	// 			},
	// 			GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
	// 			},
	// 			KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
	// 			},
	// 			LastUpdatedTimeUTC: to.Ptr("2020-04-15T20:20:38.6161887Z"),
	// 			Pattern: to.Ptr("[url:value = 'https://www.contoso.com']"),
	// 			PatternType: to.Ptr("url"),
	// 			Revoked: to.Ptr(false),
	// 			Source: to.Ptr("Azure Sentinel"),
	// 			ThreatIntelligenceTags: []*string{
	// 				to.Ptr("new schema")},
	// 				ThreatTypes: []*string{
	// 					to.Ptr("compromised")},
	// 					ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
	// 				},
	// 			},
	// 			                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/GetThreatIntelligenceById.json
func ExampleThreatIntelligenceIndicatorClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewThreatIntelligenceIndicatorClient().Get(ctx, "myRg", "myWorkspace", "e16ef847-962e-d7b6-9c8b-a33e4bd30e47", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurityinsights.ThreatIntelligenceIndicatorClientGetResponse{
	// 	                            ThreatIntelligenceInformationClassification: &armsecurityinsights.ThreatIntelligenceIndicatorModel{
	// 		Name: to.Ptr("e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
	// 		Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
	// 		ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
	// 		Etag: to.Ptr("\"00002a2c-0000-0800-0000-5e97683b0000\""),
	// 		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
	// 		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
	// 			Description: to.Ptr("debugging indicators"),
	// 			Confidence: to.Ptr[int32](78),
	// 			Created: to.Ptr("2020-04-15T19:51:17.1050923Z"),
	// 			CreatedByRef: to.Ptr("aztestConnectors@dataconnector.ccsctp.net"),
	// 			DisplayName: to.Ptr("updated indicator"),
	// 			ExternalID: to.Ptr("indicator--73be1729-babb-4348-a6c4-94621cae2530"),
	// 			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
	// 			},
	// 			GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
	// 			},
	// 			KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
	// 			},
	// 			LastUpdatedTimeUTC: to.Ptr("2020-04-15T20:18:49.2259902Z"),
	// 			Pattern: to.Ptr("[url:value = 'https://abc.com']"),
	// 			PatternType: to.Ptr("url"),
	// 			Revoked: to.Ptr(false),
	// 			Source: to.Ptr("Azure Sentinel"),
	// 			ThreatIntelligenceTags: []*string{
	// 				to.Ptr("patching tags")},
	// 				ThreatTypes: []*string{
	// 					to.Ptr("compromised")},
	// 					ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
	// 				},
	// 			},
	// 			                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/UpdateThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewThreatIntelligenceIndicatorClient().Create(ctx, "myRg", "myWorkspace", "d9cd6f0b-96b9-3984-17cd-a779d1e15a93", armsecurityinsights.ThreatIntelligenceIndicatorModel{
		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
			Description:        to.Ptr("debugging indicators"),
			Confidence:         to.Ptr[int32](78),
			CreatedByRef:       to.Ptr("contoso@contoso.com"),
			DisplayName:        to.Ptr("new schema"),
			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{},
			GranularMarkings:   []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{},
			KillChainPhases:    []*armsecurityinsights.ThreatIntelligenceKillChainPhase{},
			Labels:             []*string{},
			Modified:           to.Ptr(""),
			Pattern:            to.Ptr("[url:value = 'https://www.contoso.com']"),
			PatternType:        to.Ptr("url"),
			Revoked:            to.Ptr(false),
			Source:             to.Ptr("Azure Sentinel"),
			ThreatIntelligenceTags: []*string{
				to.Ptr("new schema")},
			ThreatTypes: []*string{
				to.Ptr("compromised")},
			ValidFrom:  to.Ptr("2020-04-15T17:44:00.114052Z"),
			ValidUntil: to.Ptr(""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurityinsights.ThreatIntelligenceIndicatorClientCreateResponse{
	// 	                            ThreatIntelligenceInformationClassification: &armsecurityinsights.ThreatIntelligenceIndicatorModel{
	// 		Name: to.Ptr("180105c7-a28d-b1a2-4a78-234f6ec80fd6"),
	// 		Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
	// 		ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/180105c7-a28d-b1a2-4a78-234f6ec80fd6"),
	// 		Etag: to.Ptr("\"0000322c-0000-0800-0000-5e976c960000\""),
	// 		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
	// 		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
	// 			Description: to.Ptr("debugging indicators"),
	// 			Confidence: to.Ptr[int32](78),
	// 			Created: to.Ptr("2020-04-15T20:20:38.6160949Z"),
	// 			CreatedByRef: to.Ptr("contoso@contoso.com"),
	// 			DisplayName: to.Ptr("new schema"),
	// 			ExternalID: to.Ptr("indicator--a2b6a95e-2108-4a38-bd49-ef95811bbcd7"),
	// 			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
	// 			},
	// 			GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
	// 			},
	// 			KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
	// 			},
	// 			LastUpdatedTimeUTC: to.Ptr("2020-04-15T20:20:38.6161887Z"),
	// 			Pattern: to.Ptr("[url:value = 'https://www.contoso.com']"),
	// 			PatternType: to.Ptr("url"),
	// 			Revoked: to.Ptr(false),
	// 			Source: to.Ptr("Azure Sentinel"),
	// 			ThreatIntelligenceTags: []*string{
	// 				to.Ptr("new schema")},
	// 				ThreatTypes: []*string{
	// 					to.Ptr("compromised")},
	// 					ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
	// 				},
	// 			},
	// 			                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/DeleteThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewThreatIntelligenceIndicatorClient().Delete(ctx, "myRg", "myWorkspace", "d9cd6f0b-96b9-3984-17cd-a779d1e15a93", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/QueryThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_NewQueryIndicatorsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewThreatIntelligenceIndicatorClient().NewQueryIndicatorsPager("myRg", "myWorkspace", armsecurityinsights.ThreatIntelligenceFilteringCriteria{
		MaxConfidence: to.Ptr[int32](80),
		MaxValidUntil: to.Ptr("2020-04-25T17:44:00.114052Z"),
		MinConfidence: to.Ptr[int32](25),
		MinValidUntil: to.Ptr("2020-04-05T17:44:00.114052Z"),
		PageSize:      to.Ptr[int32](100),
		SortBy: []*armsecurityinsights.ThreatIntelligenceSortingCriteria{
			{
				ItemKey:   to.Ptr("lastUpdatedTimeUtc"),
				SortOrder: to.Ptr(armsecurityinsights.ThreatIntelligenceSortingOrderDescending),
			}},
		Sources: []*string{
			to.Ptr("Azure Sentinel")},
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ThreatIntelligenceInformationList = armsecurityinsights.ThreatIntelligenceInformationList{
		// 	Value: []armsecurityinsights.ThreatIntelligenceInformationClassification{
		// 		&armsecurityinsights.ThreatIntelligenceIndicatorModel{
		// 			Name: to.Ptr("27d963e6-e6e4-e0f9-e9d7-c53985b3bbe8"),
		// 			Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
		// 			ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/27d963e6-e6e4-e0f9-e9d7-c53985b3bbe8"),
		// 			Etag: to.Ptr("\"00002f2c-0000-0800-0000-5e976a8e0000\""),
		// 			Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
		// 			Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
		// 				Description: to.Ptr("debugging indicators 2"),
		// 				Confidence: to.Ptr[int32](90),
		// 				Created: to.Ptr("2020-04-15T20:11:57.9666134Z"),
		// 				CreatedByRef: to.Ptr("contoso@contoso.com"),
		// 				DisplayName: to.Ptr("new schema 2"),
		// 				ExternalID: to.Ptr("indicator--8516d567-0daa-4614-8745-e3591e1b48cf"),
		// 				ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
		// 				},
		// 				GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
		// 				},
		// 				KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
		// 				},
		// 				LastUpdatedTimeUTC: to.Ptr("2020-04-15T20:15:11.0746926Z"),
		// 				ParsedPattern: []*armsecurityinsights.ThreatIntelligenceParsedPattern{
		// 					{
		// 						PatternTypeKey: to.Ptr("network-traffic"),
		// 						PatternTypeValues: []*armsecurityinsights.ThreatIntelligenceParsedPatternTypeValue{
		// 							{
		// 								Value: to.Ptr("SSH-2.0-PuTTY_Release_0.64"),
		// 								ValueType: to.Ptr("0"),
		// 							},
		// 							{
		// 								Value: to.Ptr("194.88.106.146"),
		// 								ValueType: to.Ptr("1"),
		// 						}},
		// 				}},
		// 				Pattern: to.Ptr("[url:value = 'https://www.contoso.com']"),
		// 				PatternType: to.Ptr("url"),
		// 				Revoked: to.Ptr(false),
		// 				Source: to.Ptr("Azure Sentinel"),
		// 				ThreatIntelligenceTags: []*string{
		// 					to.Ptr("new schema")},
		// 					ThreatTypes: []*string{
		// 						to.Ptr("compromised")},
		// 						ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
		// 					},
		// 				},
		// 				&armsecurityinsights.ThreatIntelligenceIndicatorModel{
		// 					Name: to.Ptr("e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
		// 					Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
		// 					ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
		// 					Etag: to.Ptr("\"00002a2c-0000-0800-0000-5e97683b0000\""),
		// 					Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
		// 					Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
		// 						Description: to.Ptr("debugging indicators"),
		// 						Confidence: to.Ptr[int32](78),
		// 						Created: to.Ptr("2020-04-15T19:51:17.1050923Z"),
		// 						CreatedByRef: to.Ptr("contoso@contoso.com"),
		// 						DisplayName: to.Ptr("updated indicator"),
		// 						ExternalID: to.Ptr("indicator--73be1729-babb-4348-a6c4-94621cae2530"),
		// 						ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
		// 						},
		// 						GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
		// 						},
		// 						KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
		// 						},
		// 						LastUpdatedTimeUTC: to.Ptr("2020-04-15T20:15:11.074903Z"),
		// 						Pattern: to.Ptr("[url:value = 'https://www.contoso.com']"),
		// 						PatternType: to.Ptr("url"),
		// 						Revoked: to.Ptr(false),
		// 						Source: to.Ptr("Azure Sentinel"),
		// 						ThreatIntelligenceTags: []*string{
		// 							to.Ptr("patching tags")},
		// 							ThreatTypes: []*string{
		// 								to.Ptr("compromised")},
		// 								ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/AppendTagsThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_AppendTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewThreatIntelligenceIndicatorClient().AppendTags(ctx, "myRg", "myWorkspace", "d9cd6f0b-96b9-3984-17cd-a779d1e15a93", armsecurityinsights.ThreatIntelligenceAppendTags{
		ThreatIntelligenceTags: []*string{
			to.Ptr("tag1"),
			to.Ptr("tag2")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/securityinsights/resource-manager/Microsoft.SecurityInsights/stable/2021-10-01/examples/threatintelligence/ReplaceTagsThreatIntelligence.json
func ExampleThreatIntelligenceIndicatorClient_ReplaceTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurityinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewThreatIntelligenceIndicatorClient().ReplaceTags(ctx, "myRg", "myWorkspace", "d9cd6f0b-96b9-3984-17cd-a779d1e15a93", armsecurityinsights.ThreatIntelligenceIndicatorModel{
		Etag: to.Ptr("\"0000262c-0000-0800-0000-5e9767060000\""),
		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
			ThreatIntelligenceTags: []*string{
				to.Ptr("patching tags")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurityinsights.ThreatIntelligenceIndicatorClientReplaceTagsResponse{
	// 	                            ThreatIntelligenceInformationClassification: &armsecurityinsights.ThreatIntelligenceIndicatorModel{
	// 		Name: to.Ptr("e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
	// 		Type: to.Ptr("Microsoft.SecurityInsights/ThreatIntelligence"),
	// 		ID: to.Ptr("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/ThreatIntelligence/e16ef847-962e-d7b6-9c8b-a33e4bd30e47"),
	// 		Etag: to.Ptr("\"00002a2c-0000-0800-0000-5e97683b0000\""),
	// 		Kind: to.Ptr(armsecurityinsights.ThreatIntelligenceResourceInnerKindIndicator),
	// 		Properties: &armsecurityinsights.ThreatIntelligenceIndicatorProperties{
	// 			Description: to.Ptr("debugging indicators"),
	// 			Confidence: to.Ptr[int32](78),
	// 			Created: to.Ptr("2020-04-15T19:51:17.1050923Z"),
	// 			CreatedByRef: to.Ptr("aztestConnectors@dataconnector.ccsctp.net"),
	// 			DisplayName: to.Ptr("updated indicator"),
	// 			ExternalID: to.Ptr("indicator--73be1729-babb-4348-a6c4-94621cae2530"),
	// 			ExternalReferences: []*armsecurityinsights.ThreatIntelligenceExternalReference{
	// 			},
	// 			GranularMarkings: []*armsecurityinsights.ThreatIntelligenceGranularMarkingModel{
	// 			},
	// 			KillChainPhases: []*armsecurityinsights.ThreatIntelligenceKillChainPhase{
	// 			},
	// 			LastUpdatedTimeUTC: to.Ptr("2020-04-15T19:56:08.828946Z"),
	// 			Pattern: to.Ptr("[url:value = 'https://abc.com']"),
	// 			PatternType: to.Ptr("url"),
	// 			Revoked: to.Ptr(false),
	// 			Source: to.Ptr("Azure Sentinel"),
	// 			ThreatIntelligenceTags: []*string{
	// 				to.Ptr("patching tags")},
	// 				ThreatTypes: []*string{
	// 					to.Ptr("compromised")},
	// 					ValidFrom: to.Ptr("2020-04-15T17:44:00.114052Z"),
	// 				},
	// 			},
	// 			                        }
}
