//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// EmailClient contains the methods for the Email group.
// Don't use this type directly, use NewEmailClient() instead.
type EmailClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewEmailClient creates a new instance of EmailClient with the specified values.
//   - subscriptionID - Azure Subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewEmailClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EmailClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &EmailClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateSignInURL - Creates an email channel sign in url for a Bot Service
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-15
//   - resourceGroupName - The name of the Bot resource group in the user subscription.
//   - resourceName - The name of the Bot resource.
//   - options - EmailClientCreateSignInURLOptions contains the optional parameters for the EmailClient.CreateSignInURL method.
func (client *EmailClient) CreateSignInURL(ctx context.Context, resourceGroupName string, resourceName string, options *EmailClientCreateSignInURLOptions) (EmailClientCreateSignInURLResponse, error) {
	var err error
	const operationName = "EmailClient.CreateSignInURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createSignInURLCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return EmailClientCreateSignInURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EmailClientCreateSignInURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EmailClientCreateSignInURLResponse{}, err
	}
	resp, err := client.createSignInURLHandleResponse(httpResp)
	return resp, err
}

// createSignInURLCreateRequest creates the CreateSignInURL request.
func (client *EmailClient) createSignInURLCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *EmailClientCreateSignInURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/createEmailSignInUrl"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createSignInURLHandleResponse handles the CreateSignInURL response.
func (client *EmailClient) createSignInURLHandleResponse(resp *http.Response) (EmailClientCreateSignInURLResponse, error) {
	result := EmailClientCreateSignInURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CreateEmailSignInURLResponse); err != nil {
		return EmailClientCreateSignInURLResponse{}, err
	}
	return result, nil
}
