//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// Server is a fake server for instances of the armapimanagement.Client type.
type Server struct {
	// BeginPerformConnectivityCheckAsync is the fake for method Client.BeginPerformConnectivityCheckAsync
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPerformConnectivityCheckAsync func(ctx context.Context, resourceGroupName string, serviceName string, connectivityCheckRequestParams armapimanagement.ConnectivityCheckRequest, options *armapimanagement.ClientBeginPerformConnectivityCheckAsyncOptions) (resp azfake.PollerResponder[armapimanagement.ClientPerformConnectivityCheckAsyncResponse], errResp azfake.ErrorResponder)
}

// NewServerTransport creates a new instance of ServerTransport with the provided implementation.
// The returned ServerTransport instance is connected to an instance of armapimanagement.Client via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerTransport(srv *Server) *ServerTransport {
	return &ServerTransport{
		srv:                                srv,
		beginPerformConnectivityCheckAsync: newTracker[azfake.PollerResponder[armapimanagement.ClientPerformConnectivityCheckAsyncResponse]](),
	}
}

// ServerTransport connects instances of armapimanagement.Client to instances of Server.
// Don't use this type directly, use NewServerTransport instead.
type ServerTransport struct {
	srv                                *Server
	beginPerformConnectivityCheckAsync *tracker[azfake.PollerResponder[armapimanagement.ClientPerformConnectivityCheckAsyncResponse]]
}

// Do implements the policy.Transporter interface for ServerTransport.
func (s *ServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "Client.BeginPerformConnectivityCheckAsync":
		resp, err = s.dispatchBeginPerformConnectivityCheckAsync(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginPerformConnectivityCheckAsync(req *http.Request) (*http.Response, error) {
	if s.srv.BeginPerformConnectivityCheckAsync == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPerformConnectivityCheckAsync not implemented")}
	}
	beginPerformConnectivityCheckAsync := s.beginPerformConnectivityCheckAsync.get(req)
	if beginPerformConnectivityCheckAsync == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectivityCheck`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armapimanagement.ConnectivityCheckRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginPerformConnectivityCheckAsync(req.Context(), resourceGroupNameParam, serviceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPerformConnectivityCheckAsync = &respr
		s.beginPerformConnectivityCheckAsync.add(req, beginPerformConnectivityCheckAsync)
	}

	resp, err := server.PollerResponderNext(beginPerformConnectivityCheckAsync, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginPerformConnectivityCheckAsync.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPerformConnectivityCheckAsync) {
		s.beginPerformConnectivityCheckAsync.remove(req)
	}

	return resp, nil
}
